/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.wsdl.extensions.format;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.util.xml.DOMUtils;
import com.ibm.wsdl.util.xml.QNameUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.namespace.QName;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.wsdl.extensions.format.FormatBindingConstants;
import org.apache.wsif.wsdl.extensions.format.TypeMap;
import org.apache.wsif.wsdl.extensions.format.TypeMapping;
import org.w3c.dom.Element;

public class FormatBindingSerializer
implements ExtensionDeserializer,
ExtensionSerializer,
Serializable {
    private static final long serialVersionUID = 1L;
    static /* synthetic */ Class class$javax$wsdl$Binding;

    public FormatBindingSerializer() {
        Trc.entry(this);
        Trc.exit();
    }

    public void marshall(Class parentType, QName elementType, ExtensibilityElement extension, PrintWriter pw, Definition def, ExtensionRegistry extReg) throws WSDLException {
        Trc.entry(this, parentType, elementType, extension, pw, def, extReg);
        if (extension == null) {
            Trc.exit();
            return;
        }
        if (extension instanceof TypeMapping) {
            String encoding;
            TypeMapping typeMapping = (TypeMapping)extension;
            pw.print("         <format:typeMapping");
            String style = typeMapping.getStyle();
            if (style != null) {
                DOMUtils.printAttribute("style", style, pw);
            }
            if ((encoding = typeMapping.getEncoding()) != null) {
                DOMUtils.printAttribute("encoding", encoding, pw);
            }
            pw.println(">");
            List maps = typeMapping.getMaps();
            Iterator iterator = maps.iterator();
            while (iterator.hasNext()) {
                String formatType;
                QName typeName;
                TypeMap typeMap = (TypeMap)iterator.next();
                pw.print("            <format:typeMap");
                QName elementName = typeMap.getElementName();
                if (elementName != null) {
                    String prefix = def.getPrefix(elementName.getNamespaceURI());
                    DOMUtils.printAttribute("elementName", prefix + ":" + elementName.getLocalPart(), pw);
                }
                if ((typeName = typeMap.getTypeName()) != null) {
                    String prefix = def.getPrefix(typeName.getNamespaceURI());
                    DOMUtils.printAttribute("typeName", prefix + ":" + typeName.getLocalPart(), pw);
                }
                if ((formatType = typeMap.getFormatType()) != null) {
                    DOMUtils.printAttribute("formatType", formatType, pw);
                }
                pw.println("/>");
                Boolean required = extension.getRequired();
                if (required == null) continue;
                DOMUtils.printQualifiedAttribute(Constants.Q_ATTR_REQUIRED, required.toString(), def, pw);
            }
            pw.println("         </format:typeMapping>");
        }
        Trc.exit();
    }

    public void registerSerializer(ExtensionRegistry registry) {
        Trc.entry((Object)this, registry);
        registry.registerSerializer(class$javax$wsdl$Binding == null ? (class$javax$wsdl$Binding = FormatBindingSerializer.class$("javax.wsdl.Binding")) : class$javax$wsdl$Binding, FormatBindingConstants.Q_ELEM_FORMAT_BINDING, this);
        registry.registerDeserializer(class$javax$wsdl$Binding == null ? (class$javax$wsdl$Binding = FormatBindingSerializer.class$("javax.wsdl.Binding")) : class$javax$wsdl$Binding, FormatBindingConstants.Q_ELEM_FORMAT_BINDING, this);
        Trc.exit();
    }

    public ExtensibilityElement unmarshall(Class parentPart, QName elementPart, Element el, Definition def, ExtensionRegistry extReg) throws WSDLException {
        Trc.entry(this, parentPart, elementPart, el, def, extReg);
        ExtensibilityElement returnValue = null;
        if (FormatBindingConstants.Q_ELEM_FORMAT_BINDING.equals(elementPart)) {
            TypeMapping typeMapping = new TypeMapping();
            String style = DOMUtils.getAttribute(el, "style");
            String encoding = DOMUtils.getAttribute(el, "encoding");
            String requiredStr = DOMUtils.getAttributeNS(el, "http://schemas.xmlsoap.org/wsdl/", "required");
            if (style != null) {
                typeMapping.setStyle(style);
            }
            if (encoding != null) {
                typeMapping.setEncoding(encoding);
            }
            Element tempEl = DOMUtils.getFirstChildElement(el);
            while (tempEl != null) {
                if (QNameUtils.matches(FormatBindingConstants.Q_ELEM_FORMAT_BINDING_MAP, tempEl)) {
                    TypeMap typeMap = new TypeMap();
                    QName qElementName = DOMUtils.getQualifiedAttributeValue(tempEl, "elementName", "typeMap", false, def);
                    QName qTypeName = DOMUtils.getQualifiedAttributeValue(tempEl, "typeName", "typeMap", false, def);
                    String formatType = DOMUtils.getAttribute(tempEl, "formatType");
                    if (qElementName != null) {
                        typeMap.setElementName(qElementName);
                    }
                    if (qTypeName != null) {
                        typeMap.setTypeName(qTypeName);
                    }
                    if (formatType != null) {
                        typeMap.setFormatType(formatType);
                    }
                    typeMapping.addMap(typeMap);
                }
                tempEl = DOMUtils.getNextSiblingElement(tempEl);
            }
            Trc.exit(typeMapping);
            return typeMapping;
        }
        Trc.exit(returnValue);
        return returnValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

