/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.wlm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.wlm.ClusterData;
import com.ibm.websphere.management.wlm.ClusterMemberData;
import com.ibm.websphere.management.wlm.ClusterWeightTableEntry;
import com.ibm.websphere.wlm.exception.ClusterException;
import com.ibm.websphere.wlm.exception.InvalidParameterException;
import com.ibm.websphere.wlm.exception.InvalidRegistrationKeyException;
import com.ibm.websphere.wlm.exception.WeightTableEntryOutOfRangeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.wlm.ClusterAdmin;
import com.ibm.ws.management.wlm.ClusterCollaborator;
import com.ibm.ws.management.wlm.ClusterMgr;
import java.util.Date;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.ObjectName;

public class Cluster {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$wlm$Cluster == null ? (class$com$ibm$ws$management$wlm$Cluster = Cluster.class$("com.ibm.ws.management.wlm.Cluster")) : class$com$ibm$ws$management$wlm$Cluster), (String)"WLM", (String)"com.ibm.ws.wlm.resources.WLMMessages");
    private int weightChgSeq = 1;
    protected ClusterCollaborator rtc = null;
    protected ClusterAdmin clusterAdmin = null;
    private String wlcID = null;
    private Long wlcKey = null;
    protected ClusterData cluster = null;
    public static final String ClusterMBeanType = "Cluster";
    static /* synthetic */ Class class$com$ibm$ws$management$wlm$Cluster;

    protected void setCollaborator(ClusterCollaborator clusterCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setCollaborator", (Object)((Object)clusterCollaborator));
        }
        this.rtc = clusterCollaborator;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setCollaborator");
        }
    }

    protected synchronized void setClusterObjName(ObjectName objectName) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setClusterObjName", (Object)objectName);
        }
        this.cluster.clusterObjectName = objectName;
        ClusterMemberData[] clusterMemberDataArray = this.cluster.clusterMembers;
        for (int i = 0; i < clusterMemberDataArray.length; ++i) {
            clusterMemberDataArray[i].clusterObjectName = objectName;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setClusterObjName");
        }
    }

    protected synchronized void setMemberObjName(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setMemberObjName", (Object)string);
        }
        for (int i = 0; i < this.cluster.clusterMembers.length; ++i) {
            ObjectName objectName;
            if (!string.equals(this.cluster.clusterMembers[i].memberName) || !string2.equals(this.cluster.clusterMembers[i].nodeName)) continue;
            this.cluster.clusterMembers[i].memberObjectName = objectName = ClusterMgr.getObjName(string, "Server", string2, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setMemberObjName");
        }
    }

    protected synchronized void setMemberObjName(String string, String string2, ObjectName objectName) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setMemberObjName", (Object)new Object[]{string, objectName});
        }
        for (int i = 0; i < this.cluster.clusterMembers.length; ++i) {
            if (!string.equals(this.cluster.clusterMembers[i].memberName) || !string2.equals(this.cluster.clusterMembers[i].nodeName)) continue;
            this.cluster.clusterMembers[i].memberObjectName = objectName;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setMemberObjName");
        }
    }

    protected synchronized void setClusterData(ClusterData clusterData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setClusterData", (Object)clusterData);
        }
        this.cluster = clusterData;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setClusterData");
        }
    }

    protected ClusterData getClusterData() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getClusterData");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getClusterData");
        }
        return this.cluster;
    }

    protected synchronized void removeMember(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeMember", (Object)string);
        }
        if (this.getClusterMember(string, string2) != null) {
            int n;
            ClusterWeightTableEntry[] clusterWeightTableEntryArray = new ClusterWeightTableEntry[this.cluster.weightTable.length - 1];
            ClusterMemberData[] clusterMemberDataArray = new ClusterMemberData[this.cluster.clusterMembers.length - 1];
            int n2 = 0;
            for (n = 0; n < this.cluster.weightTable.length; ++n) {
                if (this.cluster.weightTable[n].memberName.equals(string) && this.cluster.weightTable[n].nodeName.equals(string2)) continue;
                clusterWeightTableEntryArray[n2++] = this.cluster.weightTable[n];
            }
            n2 = 0;
            for (n = 0; n < this.cluster.clusterMembers.length; ++n) {
                if (this.cluster.clusterMembers[n].memberName.equals(string) && this.cluster.clusterMembers[n].nodeName.equals(string2)) continue;
                clusterMemberDataArray[n2++] = this.cluster.clusterMembers[n];
            }
            this.cluster.weightTable = clusterWeightTableEntryArray;
            this.cluster.clusterMembers = clusterMemberDataArray;
        } else if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"No matching member found", (Object)string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeMember");
        }
    }

    public Cluster() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)ClusterMBeanType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)ClusterMBeanType);
        }
    }

    public void activate() {
        block2: {
            try {
                this.clusterAdmin = new ClusterAdmin(this);
                ClusterCollaborator clusterCollaborator = new ClusterCollaborator(this, this.clusterAdmin);
                this.setCollaborator(clusterCollaborator);
                this.clusterAdmin.setCollaborator(clusterCollaborator);
                this.clusterAdmin.setClusterState();
                this.cluster.clusterObjectName = AdminServiceFactory.getMBeanFactory().activateMBean(ClusterMBeanType, (RuntimeCollaborator)clusterCollaborator, this.cluster.clusterName, null);
            }
            catch (AdminException adminException) {
                FFDCFilter.processException((Throwable)adminException, (String)"com.ibm.ws.management.wlm.ClusterMgr.activateCluster", (String)"305", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"WLMKEY_UNABLE_TO_ACTIVATE_CLUSTER_MBEAN", (Object)new Object[]{this.cluster.clusterName, adminException});
                if (!tc.isEventEnabled()) break block2;
                Tr.event((TraceComponent)tc, (String)"unable to activate the Cluster MBean", (Object)((Object)adminException));
            }
        }
    }

    public void deactivate() {
        block2: {
            try {
                AdminServiceFactory.getMBeanFactory().deactivateMBean(this.cluster.clusterObjectName);
            }
            catch (AdminException adminException) {
                FFDCFilter.processException((Throwable)adminException, (String)"com.ibm.ws.management.wlm.ClusterMgr.loadRefreshClusters", (String)"324", (Object)this);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)(this.cluster.clusterObjectName + " MBean Deactivate Failed"), (Object)((Object)adminException));
            }
        }
    }

    public Cluster(ClusterData clusterData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)ClusterMBeanType, (Object)clusterData);
        }
        this.cluster = clusterData;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)ClusterMBeanType);
        }
    }

    public String getClusterName() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getClusterName");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getClusterName");
        }
        return this.cluster.clusterName;
    }

    public synchronized void setPreferLocal(Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setPreferLocal", (Object)bl);
        }
        this.cluster.preferLocal = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setPreferLocal");
        }
    }

    public Boolean getPreferLocal() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPreferLocal");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPreferLocal");
        }
        return this.cluster.preferLocal;
    }

    public String getWLCid() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getWLCid");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getWLCid");
        }
        return this.wlcID;
    }

    public ClusterMemberData[] getClusterMembers() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getClusterMembers");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getClusterMembers");
        }
        return this.cluster.clusterMembers;
    }

    public ClusterMemberData getClusterMember(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getClusterMember", (Object)string);
        }
        ClusterMemberData clusterMemberData = null;
        for (int i = 0; i < this.cluster.clusterMembers.length; ++i) {
            if (!this.cluster.clusterMembers[i].memberName.equals(string) || !this.cluster.clusterMembers[i].nodeName.equals(string2)) continue;
            clusterMemberData = this.cluster.clusterMembers[i];
            break;
        }
        if (clusterMemberData == null && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"No matching member found", (Object)string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getClusterMember");
        }
        return clusterMemberData;
    }

    public ClusterWeightTableEntry[] getWeightTable() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getWeightTable");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getWeightTable", (Object)this.cluster.weightTable);
        }
        return this.cluster.weightTable;
    }

    public ClusterWeightTableEntry getWeightTableEntry(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getWeightTableEntry", (Object)new Object[]{string, string2});
        }
        ClusterWeightTableEntry clusterWeightTableEntry = null;
        for (int i = 0; i < this.cluster.weightTable.length; ++i) {
            if (!this.cluster.weightTable[i].memberName.equals(string) || !this.cluster.weightTable[i].nodeName.equals(string2)) continue;
            clusterWeightTableEntry = this.cluster.weightTable[i];
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getWeightTableEntry", clusterWeightTableEntry);
        }
        return clusterWeightTableEntry;
    }

    public synchronized void setWeightTable(Long l, ClusterWeightTableEntry[] clusterWeightTableEntryArray) throws ClusterException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setWeightTable", (Object)clusterWeightTableEntryArray);
        }
        if (this.wlcKey != null && l.equals(this.wlcKey)) {
            int n;
            if (this.cluster.weightTable.length != clusterWeightTableEntryArray.length) {
                throw new InvalidParameterException("Invalid weight table - length mismatch. \nCluster weight table length = " + this.cluster.weightTable.length + "\nProvided weight table length = " + clusterWeightTableEntryArray.length);
            }
            for (n = 0; n < clusterWeightTableEntryArray.length; ++n) {
                if (this.getClusterMember(clusterWeightTableEntryArray[n].memberName, clusterWeightTableEntryArray[n].nodeName) == null) {
                    throw new InvalidParameterException("Invalid weight table - member mismatch. \nMember name: " + clusterWeightTableEntryArray[n].memberName + ", not found in cluster.");
                }
                Integer n2 = clusterWeightTableEntryArray[n].weight;
                if (n2 == null) {
                    throw new InvalidParameterException("Invalid weight table entry #" + n + ", weight value is NULL");
                }
                if (n2 >= 0) continue;
                throw new WeightTableEntryOutOfRangeException("Invalid weight table entry #" + n + ", " + n2 + " not in range");
            }
            this.cluster.weightTable = clusterWeightTableEntryArray;
            block3: for (n = 0; n < clusterWeightTableEntryArray.length; ++n) {
                ClusterWeightTableEntry clusterWeightTableEntry = clusterWeightTableEntryArray[n];
                for (int i = 0; i < this.cluster.clusterMembers.length; ++i) {
                    if (!clusterWeightTableEntry.memberName.equals(this.cluster.clusterMembers[i].memberName) || !clusterWeightTableEntry.nodeName.equals(this.cluster.clusterMembers[i].nodeName)) continue;
                    this.cluster.clusterMembers[i].weightTableEntry = clusterWeightTableEntry;
                    continue block3;
                }
            }
            try {
                Notification notification = new Notification("websphere.cluster.weight.table.change", this.cluster.clusterObjectName, this.weightChgSeq++);
                notification.setUserData(this.cluster.weightTable);
                this.rtc.sendNotification(notification);
            }
            catch (MBeanException mBeanException) {
                FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.ws.management.wlm.Cluster.setWeightTable", (String)"606", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"weight table change notification failure", (Object)mBeanException);
                }
            }
        } else {
            throw new InvalidRegistrationKeyException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setWeightTable");
        }
    }

    public synchronized void setWeightTableEntry(Long l, ClusterWeightTableEntry clusterWeightTableEntry) throws ClusterException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setWeightTableEntry", (Object)clusterWeightTableEntry);
        }
        if (this.wlcKey != null && l.equals(this.wlcKey)) {
            int n;
            String string = clusterWeightTableEntry.memberName;
            String string2 = clusterWeightTableEntry.nodeName;
            Integer n2 = clusterWeightTableEntry.weight;
            if (this.getWeightTableEntry(string, string2) == null) {
                throw new InvalidParameterException("Invalid weight table entry - member mismatch. \nMember name: " + string + ", not found in weight table.");
            }
            if (this.getClusterMember(string, string2) == null) {
                throw new InvalidParameterException("Invalid weight table entry - member mismatch. \nMember name: " + string + ", not found in cluster.");
            }
            if (n2 == null) {
                throw new InvalidParameterException("Invalid weight table entry, weight value is NULL");
            }
            if (n2 < 0) {
                throw new WeightTableEntryOutOfRangeException("Invalid weight table entry, weight value=" + n2 + " out of valid range");
            }
            for (n = 0; n < this.cluster.weightTable.length; ++n) {
                if (!string.equals(this.cluster.weightTable[n].memberName) || !string2.equals(this.cluster.weightTable[n].nodeName)) continue;
                this.cluster.weightTable[n] = clusterWeightTableEntry;
                break;
            }
            for (n = 0; n < this.cluster.clusterMembers.length; ++n) {
                if (!string.equals(this.cluster.clusterMembers[n].memberName) || !string2.equals(this.cluster.clusterMembers[n].nodeName)) continue;
                this.cluster.clusterMembers[n].weightTableEntry = clusterWeightTableEntry;
                break;
            }
            try {
                Notification notification = new Notification("websphere.cluster.weight.table.entry.change", this.cluster.clusterObjectName, this.weightChgSeq++);
                notification.setUserData(clusterWeightTableEntry);
                this.rtc.sendNotification(notification);
            }
            catch (MBeanException mBeanException) {
                FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.ws.management.wlm.Cluster.setWeightTableEntry", (String)"713", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"weight table entry change notification failure", (Object)mBeanException);
                }
            }
        } else {
            throw new InvalidRegistrationKeyException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setWeightTableEntry");
        }
    }

    public Long register(String string) throws ClusterException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"register", (Object)string);
        }
        if (string == null) {
            throw new InvalidParameterException("Workload Controller name parameter is NULL");
        }
        if (string.equals(this.wlcID)) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"register");
            }
            return this.wlcKey;
        }
        String string2 = this.wlcID;
        this.wlcID = string;
        this.wlcKey = new Long(new Date().getTime());
        if (string2 == null) {
            Tr.audit((TraceComponent)tc, (String)"WLMKEY_WLC_REGISTRATION_NEW", (Object)new Object[]{this.cluster.clusterName, this.wlcID});
        } else {
            Tr.audit((TraceComponent)tc, (String)"WLMKEY_WLC_REGISTRATION_UPDATE", (Object)new Object[]{this.cluster.clusterName, string2, this.wlcID});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"register");
        }
        return this.wlcKey;
    }

    public ClusterData refresh() throws ClusterException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"refresh");
        }
        ClusterData clusterData = this.cluster;
        AdminService adminService = AdminServiceFactory.getAdminService();
        ObjectName objectName = ClusterMgr.getObjName("ClusterMgr", "ClusterMgr", adminService.getNodeName(), adminService.getProcessName());
        if (objectName != null) {
            try {
                clusterData = (ClusterData)adminService.invoke(objectName, "retrieveCluster", new Object[]{this.cluster.clusterName}, new String[]{"java.lang.String"});
            }
            catch (JMException jMException) {
                throw new ClusterException((Throwable)jMException);
            }
        } else {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"could not find ClusterMgr MBean");
            }
            throw new ClusterException("could not find ClusterMgr MBean");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"refresh");
        }
        return clusterData;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

