/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.wlm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.wlm.ClusterMemberData;
import com.ibm.websphere.wlm.exception.ClusterException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.wlm.Cluster;
import com.ibm.ws.management.wlm.ClusterCollaborator;
import com.ibm.ws.management.wlm.ClusterMgr;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.util.Properties;
import java.util.Vector;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class ClusterAdmin {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$wlm$ClusterAdmin == null ? (class$com$ibm$ws$management$wlm$ClusterAdmin = ClusterAdmin.class$("com.ibm.ws.management.wlm.ClusterAdmin")) : class$com$ibm$ws$management$wlm$ClusterAdmin), (String)"WLM", (String)"com.ibm.ws.wlm.resources.WLMMessages");
    private Cluster cluster = null;
    private AdminService adminService = null;
    private ClusterCollaborator rtc = null;
    private long notifySeqNum = 1L;
    private String rippleMember = null;
    private String state = "websphere.cluster.stopped";
    private RippleStarter rippleObject = null;
    private static final int FIVE_MINUTES = 300000;
    private Vector commandQ = new Vector(5);
    private boolean rippleStart = false;
    private static Integer NODE_AGENT_LISTENER = new Integer(1);
    private static Integer DEPLOYMENT_MANAGER_LISTENER = new Integer(2);
    private ContextManager contextManager = null;
    static /* synthetic */ Class class$com$ibm$ws$management$wlm$ClusterAdmin;

    ClusterAdmin(Cluster cluster) {
        this.cluster = cluster;
        try {
            this.contextManager = ContextManagerFactory.getInstance();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.wlm.ClusterAdmin.start", (String)"155", (Object)this);
            Tr.service((TraceComponent)tc, (String)"WLMKEY_NOTIFICATION_ERROR", (Object)exception);
        }
    }

    protected void setCollaborator(ClusterCollaborator clusterCollaborator) {
        this.rtc = clusterCollaborator;
    }

    public String getState() {
        return this.state;
    }

    private synchronized void setState(String string) {
        this.state = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() throws ClusterException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start");
        }
        boolean bl = false;
        try {
            ClusterMemberData[] clusterMemberDataArray = this;
            synchronized (this) {
                block24: {
                    if ("websphere.cluster.starting".equals(this.state) || "websphere.cluster.stopping".equals(this.state)) {
                        bl = true;
                        this.queueRequest("start");
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        Object var11_4 = null;
                        if (!bl) {
                            this.processQueue();
                        }
                        if (!tc.isEntryEnabled()) return;
                        Tr.exit((TraceComponent)tc, (String)"start");
                        return;
                    }
                    this.setStateAndNotify("websphere.cluster.starting");
                    this.rippleStart = false;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    AdminHelper.getInstance().audit("ADMN1012I", "ADMN1013I", (Object)new Object[]{this.cluster.getClusterName(), null});
                    try {
                        this.cluster.refresh();
                    }
                    catch (ClusterException clusterException) {
                        FFDCFilter.processException((Throwable)clusterException, (String)"com.ibm.ws.management.wlm.ClusterAdmin.start", (String)"224", (Object)this);
                        if (!tc.isDebugEnabled()) break block24;
                        Tr.debug((TraceComponent)tc, (String)"Cluster refresh failed during start processing:", (Object)((Object)clusterException));
                    }
                }
                if (this.isAllClusterMembersRunning()) {
                    if (!"websphere.cluster.running".equals(this.getState())) {
                        super.setStateAndNotify("websphere.cluster.running");
                    }
                } else {
                    boolean bl2;
                    clusterMemberDataArray = this.cluster.getClusterMembers();
                    ClusterMemberData clusterMemberData = null;
                    Object var4_8 = null;
                    if (clusterMemberDataArray != null) {
                        bl2 = false;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("cluster members size=" + clusterMemberDataArray.length));
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"The cluster has no members");
                        }
                        super.setStateAndNotify("websphere.cluster.stopped");
                        throw new ClusterException("There are no cluster members to start");
                    }
                    for (int i = 0; i < clusterMemberDataArray.length; ++i) {
                        clusterMemberData = clusterMemberDataArray[i];
                        String string = ClusterMgr.getDomainName() + ":*,type=" + "NodeAgent" + ",node=" + clusterMemberData.nodeName;
                        ObjectName objectName = ClusterMgr.getObjectName(string);
                        if (objectName != null) {
                            bl2 = true;
                            Thread thread = new Thread((ClusterAdmin)this.new MemberLauncher((ClusterAdmin)this, clusterMemberData, objectName));
                            thread.setDaemon(true);
                            thread.start();
                            continue;
                        }
                        Tr.warning((TraceComponent)tc, (String)"WLMKEY_NODEAGENT_NOT_STARTED", (Object)clusterMemberData.memberName);
                    }
                    if (!bl2) {
                        if (!"websphere.cluster.stopped".equals(this.getState())) {
                            super.setStateAndNotify("websphere.cluster.stopped");
                        }
                    } else {
                        super.setStateAndNotify("websphere.cluster.partial.start");
                    }
                }
                Object var11_5 = null;
                if (!bl) {
                    super.processQueue();
                }
                if (!tc.isEntryEnabled()) return;
                Tr.exit((TraceComponent)tc, (String)"start");
                return;
            }
        }
        catch (Throwable throwable) {
            Object var11_6 = null;
            if (!bl) {
                this.processQueue();
            }
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"start");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void launchMember(ClusterMemberData clusterMemberData, ObjectName objectName) throws ClusterException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"launchMember");
        }
        try {
            if (clusterMemberData.memberObjectName == null) {
                try {
                    Object[] objectArray;
                    if (objectName == null) {
                        objectArray = ClusterMgr.getDomainName() + ":*,type=" + "NodeAgent" + ",node=" + clusterMemberData.nodeName;
                        objectName = ClusterMgr.getObjectName((String)objectArray);
                    }
                    if (objectName == null) {
                        Tr.warning((TraceComponent)tc, (String)"WLMKEY_NODEAGENT_NOT_STARTED", (Object)clusterMemberData.memberName);
                        throw new ClusterException("The NodeAgent is not available.");
                    }
                    objectArray = new Object[]{clusterMemberData.memberName};
                    String[] stringArray = new String[]{"java.lang.String"};
                    this.getAdminService().invoke(objectName, "launchProcess", objectArray, stringArray);
                }
                catch (JMException jMException) {
                    FFDCFilter.processException((Throwable)jMException, (String)"com.ibm.ws.management.wlm.ClusterAdmin.start", (String)"349", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"WLMKEY_CLUSTER_MEMBER_START_FAILED", (Object)new Object[]{clusterMemberData.memberName, jMException});
                    throw new ClusterException("The cluster can not be started", (Throwable)jMException);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.wlm.ClusterAdmin.start", (String)"353", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"WLMKEY_CLUSTER_MEMBER_START_FAILED", (Object)new Object[]{clusterMemberData.memberName, exception});
                    throw new ClusterException("The cluster can not be started", (Throwable)exception);
                }
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"launchMember");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"launchMember");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() throws ClusterException {
        block8: {
            block7: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"stop");
                }
                try {
                    ClusterAdmin clusterAdmin = this;
                    synchronized (clusterAdmin) {
                        if ("websphere.cluster.starting".equals(this.state) || "websphere.cluster.stopping".equals(this.state)) {
                            this.queueRequest("stop");
                            // MONITOREXIT @DISABLED, blocks:[0, 3, 6] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
                            Object var4_2 = null;
                            break block7;
                        }
                        this.setStateAndNotify("websphere.cluster.stopping");
                        this.rippleStart = false;
                    }
                    this.stop("stop");
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (!tc.isEntryEnabled()) throw throwable;
                    Tr.exit((TraceComponent)tc, (String)"stop");
                    throw throwable;
                }
            }
            if (!tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)tc, (String)"stop");
            return;
        }
        Object var4_3 = null;
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"stop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopImmediate() {
        block8: {
            block7: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"stopImmediate");
                }
                try {
                    ClusterAdmin clusterAdmin = this;
                    synchronized (clusterAdmin) {
                        if ("websphere.cluster.starting".equals(this.state) || "websphere.cluster.stopping".equals(this.state)) {
                            this.queueRequest("stopImmediate");
                            // MONITOREXIT @DISABLED, blocks:[0, 3, 6] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
                            Object var4_2 = null;
                            break block7;
                        }
                        this.setStateAndNotify("websphere.cluster.stopping");
                        this.rippleStart = false;
                    }
                    this.stop("stopImmediate");
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (!tc.isEntryEnabled()) throw throwable;
                    Tr.exit((TraceComponent)tc, (String)"stopImmediate");
                    throw throwable;
                }
            }
            if (!tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)tc, (String)"stopImmediate");
            return;
        }
        Object var4_3 = null;
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"stopImmediate");
    }

    private void stop(String string) {
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"stop", (Object)string);
            }
            if (string.equals("stop")) {
                AdminHelper.getInstance().audit("ADMN1014I", "ADMN1015I", (Object)new Object[]{this.cluster.getClusterName(), null});
            } else {
                AdminHelper.getInstance().audit("ADMN1016I", "ADMN1017I", (Object)new Object[]{this.cluster.getClusterName(), null});
            }
            try {
                this.cluster.refresh();
            }
            catch (ClusterException clusterException) {
                FFDCFilter.processException((Throwable)clusterException, (String)"com.ibm.ws.management.wlm.ClusterAdmin.start", (String)"457", (Object)this);
                if (!tc.isDebugEnabled()) break block14;
                Tr.debug((TraceComponent)tc, (String)"Cluster refresh failed during stop processing:", (Object)((Object)clusterException));
            }
        }
        if (this.isAllClusterMembersStopped()) {
            if (!"websphere.cluster.stopped".equals(this.getState())) {
                this.setStateAndNotify("websphere.cluster.stopped");
            }
        } else {
            this.setStateAndNotify("websphere.cluster.stopping");
            ClusterMemberData[] clusterMemberDataArray = this.cluster.getClusterMembers();
            ClusterMemberData clusterMemberData = null;
            Object var4_5 = null;
            boolean bl = false;
            for (int i = 0; i < clusterMemberDataArray.length; ++i) {
                clusterMemberData = clusterMemberDataArray[i];
                try {
                    bl |= this.stopMember(clusterMemberData, string);
                    continue;
                }
                catch (ClusterException clusterException) {
                    FFDCFilter.processException((Throwable)clusterException, (String)"com.ibm.ws.management.wlm.ClusterAdmin.stop", (String)"488", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"WLMKEY_CLUSTER_MEMBER_STOP_FAILED", (Object)new Object[]{clusterMemberData.memberName, clusterException});
                }
            }
            if (!bl) {
                this.setStateAndNotify("websphere.cluster.stopped");
            } else {
                this.setStateAndNotify("websphere.cluster.partial.stop");
            }
            this.processQueue();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stop", (Object)string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean stopMember(ClusterMemberData clusterMemberData, String string) throws ClusterException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stopMember", (Object)new Object[]{clusterMemberData, string});
        }
        boolean bl = false;
        try {
            block6: {
                try {
                    if (clusterMemberData.memberObjectName != null) {
                        String string2 = ClusterMgr.getDomainName() + ":*,type=" + "NodeAgent" + ",node=" + clusterMemberData.nodeName;
                        ObjectName objectName = ClusterMgr.getObjectName(string2);
                        this.getAdminService().invoke(clusterMemberData.memberObjectName, string, null, null);
                        bl = true;
                        break block6;
                    }
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug((TraceComponent)tc, (String)"Stop not issued. Object name is not available for the server", (Object)clusterMemberData.memberObjectName);
                }
                catch (JMException jMException) {
                    FFDCFilter.processException((Throwable)jMException, (String)"com.ibm.ws.management.wlm.ClusterAdmin.stop", (String)"537", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"WLMKEY_CLUSTER_MEMBER_STOP_FAILED", (Object)new Object[]{clusterMemberData.memberName, jMException});
                    throw new ClusterException("Member stop failed", (Throwable)jMException);
                }
            }
            Object var7_7 = null;
            if (!tc.isEntryEnabled()) return bl;
            Tr.exit((TraceComponent)tc, (String)"stopMember");
            return bl;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"stopMember");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rippleStart() throws ClusterException {
        boolean bl;
        block15: {
            block14: {
                block13: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)"rippleStart");
                    }
                    bl = false;
                    try {
                        Object object = this;
                        synchronized (object) {
                            if (this.rippleStart) {
                                // MONITOREXIT @DISABLED, blocks:[0, 4, 12] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                                Object var5_3 = null;
                                if (!bl) {
                                    this.processQueue();
                                }
                                break block13;
                            }
                            if ("websphere.cluster.starting".equals(this.state) || "websphere.cluster.stopping".equals(this.state)) {
                                bl = true;
                                this.queueRequest("rippleStart");
                                // MONITOREXIT @DISABLED, blocks:[0, 4, 11] lbl18 : MonitorExitStatement: MONITOREXIT : var2_2
                                break block14;
                            }
                            this.rippleStart = true;
                            this.setStateAndNotify("websphere.cluster.starting");
                        }
                        AdminHelper.getInstance().audit("ADMN1018I", "ADMN1019I", (Object)new Object[]{this.cluster.getClusterName(), null});
                        this.rippleObject = new RippleStarter(this);
                        object = new Thread(this.rippleObject);
                        ((Thread)object).setDaemon(true);
                        ((Thread)object).start();
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        if (!bl) {
                            this.processQueue();
                        }
                        if (!tc.isEntryEnabled()) throw throwable;
                        Tr.exit((TraceComponent)tc, (String)"rippleStart");
                        throw throwable;
                    }
                }
                if (!tc.isEntryEnabled()) return;
                Tr.exit((TraceComponent)tc, (String)"rippleStart");
                return;
            }
            Object var5_4 = null;
            if (!bl) {
                this.processQueue();
            }
            if (!tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)tc, (String)"rippleStart");
            return;
        }
        Object var5_5 = null;
        if (!bl) {
            this.processQueue();
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"rippleStart");
    }

    private AdminService getAdminService() {
        if (this.adminService == null) {
            this.adminService = AdminServiceFactory.getAdminService();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("adminService reference was null. ClusterAdmin=" + this));
            }
        }
        return this.adminService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendStateNotification(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendStateNotification", (Object)string);
        }
        try {
            try {
                this.rtc.sendNotification(new Notification(string, this.rtc.getObjectName(), this.notifySeqNum++));
            }
            catch (MBeanException mBeanException) {
                FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.ws.management.wlm.ClusterAdmin.start", (String)"624", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Unable to send cluster notification: type=[" + string + "] for cluster=[" + this.rtc.getObjectName() + "]. Exception: " + mBeanException.getMessage()));
                }
                Object var4_3 = null;
                if (!tc.isEntryEnabled()) return;
                Tr.exit((TraceComponent)tc, (String)"sendStateNotification");
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"sendStateNotification");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"sendStateNotification");
    }

    public void handleNotification(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleNotification", (Object)("type = " + notification.getType()));
        }
        String string = notification.getType();
        if (object.equals(NODE_AGENT_LISTENER)) {
            if (string.equals("websphere.process.stopping")) {
                this.processStopped(notification, object);
            } else if (string.equals("websphere.process.failed")) {
                this.processFailed(notification, object);
            } else if (string.equals("websphere.process.running")) {
                this.processStarted(notification, object);
            }
        } else if (object.equals(DEPLOYMENT_MANAGER_LISTENER)) {
            if (string.equals("websphere.process.stopping") || string.equals("websphere.process.failed")) {
                this.nodeAgentFailed(notification, object);
            } else if (string.equals("websphere.process.running")) {
                this.nodeAgentStarted(notification, object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleNotification");
        }
    }

    private String getNodeName(Notification notification) {
        return ((ObjectName)notification.getSource()).getKeyProperty("node");
    }

    private void processStarted(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processStarted", (Object)notification);
        }
        Properties properties = null;
        String string = null;
        if (notification.getUserData() instanceof Properties && (properties = (Properties)notification.getUserData()) != null) {
            string = properties.getProperty("processName");
        }
        ClusterMemberData clusterMemberData = null;
        if (string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Received websphere.process.running for member: " + string));
            }
            clusterMemberData = this.cluster.getClusterMember(string, this.getNodeName(notification));
        }
        if (clusterMemberData != null) {
            clusterMemberData.memberObjectName = ClusterMgr.getObjName(clusterMemberData.memberName, "Server", clusterMemberData.nodeName);
            if (!this.rippleStart) {
                if (this.isAllClusterMembersRunning()) {
                    this.setStateAndNotify("websphere.cluster.running");
                } else if (this.state.equals("websphere.cluster.stopped")) {
                    this.setStateAndNotify("websphere.cluster.partial.start");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processStarted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStopped(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processStopping", (Object)notification);
        }
        Properties properties = null;
        String string = null;
        if (notification.getUserData() instanceof Properties && (properties = (Properties)notification.getUserData()) != null) {
            string = properties.getProperty("processName");
        }
        ClusterMemberData clusterMemberData = null;
        if (string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Received websphere.process.stopping for member: " + string));
            }
            clusterMemberData = this.cluster.getClusterMember(string, this.getNodeName(notification));
        }
        if (clusterMemberData != null) {
            clusterMemberData.memberObjectName = null;
            if (this.rippleStart) {
                RippleStarter rippleStarter = this.rippleObject;
                synchronized (rippleStarter) {
                    if (string.equals(this.rippleMember)) {
                        this.rippleObject.notify();
                    }
                }
            } else if (this.isAllClusterMembersStopped()) {
                this.setStateAndNotify("websphere.cluster.stopped");
            } else if (this.state.equals("websphere.cluster.running")) {
                this.setStateAndNotify("websphere.cluster.partial.start");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processStoping");
        }
    }

    private void processFailed(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processFailed", (Object)notification);
        }
        Properties properties = null;
        String string = null;
        if (notification.getUserData() instanceof Properties && (properties = (Properties)notification.getUserData()) != null) {
            string = properties.getProperty("processName");
        }
        ClusterMemberData clusterMemberData = null;
        if (string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Received " + notification.getType() + " for member: " + string));
            }
            clusterMemberData = this.cluster.getClusterMember(string, this.getNodeName(notification));
        }
        if (clusterMemberData != null) {
            clusterMemberData.memberObjectName = ClusterMgr.getObjName(clusterMemberData.memberName, "Server", clusterMemberData.nodeName);
            if (clusterMemberData.memberObjectName == null) {
                this.processStopped(notification, object);
            } else if (!this.rippleStart) {
                if (this.isAllClusterMembersStopped()) {
                    this.setStateAndNotify("websphere.cluster.stopped");
                } else {
                    this.setStateAndNotify("websphere.cluster.partial.start");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processFailed");
        }
    }

    private void nodeAgentStarted(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"nodeAgentStarted", (Object)notification);
        }
        Properties properties = null;
        String string = null;
        if (notification.getUserData() instanceof Properties && (properties = (Properties)notification.getUserData()) != null) {
            string = properties.getProperty("nodeName");
        }
        Object var5_5 = null;
        if (string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Received websphere.process.running for node agent: " + string));
            }
            ClusterMemberData[] clusterMemberDataArray = this.cluster.getClusterMembers();
            for (int i = 0; i < clusterMemberDataArray.length; ++i) {
                if (!clusterMemberDataArray[i].nodeName.equals(string)) continue;
                clusterMemberDataArray[i].memberObjectName = ClusterMgr.getObjName(clusterMemberDataArray[i].memberName, "Server", clusterMemberDataArray[i].nodeName);
            }
            if (!this.rippleStart) {
                if (this.isAllClusterMembersRunning()) {
                    if (!this.state.equals("websphere.cluster.running")) {
                        this.setStateAndNotify("websphere.cluster.running");
                    }
                } else if (this.isAllClusterMembersStopped()) {
                    if (!this.state.equals("websphere.cluster.stopped")) {
                        this.setStateAndNotify("websphere.cluster.stopped");
                    }
                } else if (this.state.equals("websphere.cluster.stopped")) {
                    this.setStateAndNotify("websphere.cluster.partial.stop");
                } else if (this.state.equals("websphere.cluster.running")) {
                    this.setStateAndNotify("websphere.cluster.partial.start");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"nodeAgentStarted");
        }
    }

    private void nodeAgentFailed(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"nodeAgentFailed", (Object)notification);
        }
        Properties properties = null;
        String string = null;
        if (notification.getUserData() instanceof Properties && (properties = (Properties)notification.getUserData()) != null) {
            string = properties.getProperty("nodeName");
        }
        Object var5_5 = null;
        if (string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Received websphere.process.failed for node agent: " + string));
            }
            ClusterMemberData[] clusterMemberDataArray = this.cluster.getClusterMembers();
            for (int i = 0; i < clusterMemberDataArray.length; ++i) {
                if (!clusterMemberDataArray[i].nodeName.equals(string)) continue;
                clusterMemberDataArray[i].memberObjectName = null;
            }
            if (this.isAllClusterMembersStopped()) {
                if (!this.state.equals("websphere.cluster.stopped")) {
                    this.setStateAndNotify("websphere.cluster.stopped");
                }
            } else if (this.isAllClusterMembersRunning()) {
                if (!this.state.equals("websphere.cluster.running")) {
                    this.setStateAndNotify("websphere.cluster.running");
                }
            } else if (this.state.equals("websphere.cluster.stopped")) {
                this.setStateAndNotify("websphere.cluster.partial.stop");
            } else if (this.state.equals("websphere.cluster.running")) {
                this.setStateAndNotify("websphere.cluster.partial.start");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"nodeAgentFailed");
        }
    }

    private boolean isAllClusterMembersRunning() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isAllClusterMembersRunning");
        }
        boolean bl = this.cluster.getClusterMembers().length > 0;
        ClusterMemberData clusterMemberData = null;
        ClusterMemberData[] clusterMemberDataArray = this.cluster.getClusterMembers();
        if (clusterMemberDataArray != null) {
            for (int i = 0; i < clusterMemberDataArray.length && bl; ++i) {
                clusterMemberData = clusterMemberDataArray[i];
                if (clusterMemberData.memberObjectName != null) continue;
                bl = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isAllClusterMembersRunning", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl;
    }

    private boolean isAllClusterMembersStopped() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isAllClusterMembersStopped");
        }
        boolean bl = true;
        ClusterMemberData clusterMemberData = null;
        ClusterMemberData[] clusterMemberDataArray = this.cluster.getClusterMembers();
        if (clusterMemberDataArray != null) {
            for (int i = 0; i < clusterMemberDataArray.length && bl; ++i) {
                clusterMemberData = clusterMemberDataArray[i];
                if (clusterMemberData.memberObjectName == null) continue;
                bl = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isAllClusterMembersStopped", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl;
    }

    private void queueRequest(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"queueRequest", (Object)string);
        }
        this.commandQ.add(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"queueRequest");
        }
    }

    private String dequeueRequest() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"dequeueRequest");
        }
        String string = null;
        if (this.commandQ.size() > 0) {
            string = (String)this.commandQ.firstElement();
            this.commandQ.remove(0);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"dequeueRequest", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processQueue() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processQueue");
        }
        String string = this.dequeueRequest();
        try {
            block8: {
                try {
                    if (string == null) break block8;
                    if (string.equals("start")) {
                        this.start();
                        break block8;
                    }
                    if (string.equals("stop") || string.equals("stopImmediate")) {
                        this.stop(string);
                        break block8;
                    }
                    if (!string.equals("rippleStart")) break block8;
                    this.rippleStart();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.wlm.ClusterAdmin.start", (String)"1101", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("error occurred processing queue for command " + string), (Object)exception);
                    }
                    Object var4_3 = null;
                    if (!tc.isEntryEnabled()) return;
                    Tr.exit((TraceComponent)tc, (String)"processQueue");
                    return;
                }
            }
            Object var4_2 = null;
            if (!tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)tc, (String)"processQueue");
            return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"processQueue");
            throw throwable;
        }
    }

    private void setStateAndNotify(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setStateAndNotify", (Object)new Object[]{string, this.state});
        }
        if (string == null || !this.state.equals(string)) {
            this.setState(string);
            this.sendStateNotification(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setStateAndNotify");
        }
    }

    protected void setClusterState() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setClusterState");
        }
        if (this.isAllClusterMembersRunning()) {
            this.setState("websphere.cluster.running");
        } else if (this.isAllClusterMembersStopped()) {
            this.setState("websphere.cluster.stopped");
        } else {
            this.setState("websphere.cluster.partial.start");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setClusterState", (Object)this.getState());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class RippleStarter
    implements Runnable {
        private ClusterAdmin clusterAdmin = null;
        private Subject subject = null;
        private Subject savedSubject = null;

        RippleStarter(ClusterAdmin clusterAdmin2) {
            this.clusterAdmin = clusterAdmin2;
            try {
                this.subject = ClusterAdmin.this.contextManager.getCallerSubject();
                if (this.subject == null) {
                    this.subject = ClusterAdmin.this.contextManager.getInvocationSubject();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.wlm.ClusterAdmin.start", (String)"1212", (Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block11: {
                try {
                    if (this.subject != null) {
                        this.savedSubject = ClusterAdmin.this.contextManager.pushInvocationSubject(this.subject);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.wlm.ClusterAdmin.start", (String)"1222", (Object)this);
                }
                this.rippleStart();
                Object var3_3 = null;
                try {
                    ClusterAdmin.this.contextManager.popInvocationSubject(this.savedSubject);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.wlm.ClusterAdmin.start", (String)"1239", (Object)this);
                }
                break block11;
                {
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.wlm.ClusterAdmin.start", (String)"1228", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"WLMKEY_CLUSTER_MEMBER_STOP_FAILED", (Object)new Object[]{this.clusterAdmin.cluster.getClusterName(), exception});
                        Object var3_4 = null;
                        try {
                            ClusterAdmin.this.contextManager.popInvocationSubject(this.savedSubject);
                        }
                        catch (Exception exception2) {
                            FFDCFilter.processException((Throwable)exception2, (String)"com.ibm.ws.management.wlm.ClusterAdmin.start", (String)"1239", (Object)this);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    try {
                        ClusterAdmin.this.contextManager.popInvocationSubject(this.savedSubject);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.wlm.ClusterAdmin.start", (String)"1239", (Object)this);
                    }
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void rippleStart() throws ClusterException {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"RippleStarter.rippleStart");
            }
            try {
                block17: {
                    try {
                        ClusterAdmin.this.cluster.refresh();
                    }
                    catch (ClusterException clusterException) {
                        FFDCFilter.processException((Throwable)clusterException, (String)"com.ibm.ws.management.wlm.ClusterAdmin.start", (String)"1254", (Object)this);
                        if (!tc.isDebugEnabled()) break block17;
                        Tr.debug((TraceComponent)tc, (String)"Cluster refresh failed during start processing:", (Object)((Object)clusterException));
                    }
                }
                ClusterMemberData[] clusterMemberDataArray = ClusterAdmin.this.cluster.getClusterMembers();
                ClusterMemberData clusterMemberData = null;
                Object var3_4 = null;
                if (clusterMemberDataArray != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("cluster members size=" + clusterMemberDataArray.length));
                    }
                    for (int i = 0; i < clusterMemberDataArray.length; ++i) {
                        block18: {
                            clusterMemberData = clusterMemberDataArray[i];
                            if (clusterMemberData.memberObjectName != null) {
                                this.clusterAdmin.rippleMember = clusterMemberData.memberName;
                                this.clusterAdmin.stopMember(clusterMemberData, "stop");
                                try {
                                    this.wait(300000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.management.wlm.ClusterAdmin.start", (String)"1282", (Object)this);
                                    if (!tc.isDebugEnabled()) break block18;
                                    Tr.debug((TraceComponent)tc, (String)"wait() was interrupted.");
                                }
                            }
                        }
                        this.clusterAdmin.launchMember(clusterMemberData, null);
                        if (i == 0) {
                            ClusterAdmin.this.setStateAndNotify("websphere.cluster.partial.start");
                            ClusterAdmin.this.processQueue();
                        }
                        if (!this.clusterAdmin.rippleStart) break;
                    }
                    if (this.clusterAdmin.rippleStart && ClusterAdmin.this.isAllClusterMembersRunning()) {
                        ClusterAdmin.this.setStateAndNotify("websphere.cluster.running");
                    }
                } else {
                    ClusterAdmin.this.setStateAndNotify("websphere.cluster.stopped");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The cluster has no members");
                    }
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                ClusterAdmin.this.rippleMember = null;
                this.clusterAdmin.rippleStart = false;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"RippleStarter.rippleStart");
                }
                throw throwable;
            }
            ClusterAdmin.this.rippleMember = null;
            this.clusterAdmin.rippleStart = false;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"RippleStarter.rippleStart");
            }
        }
    }

    private class MemberLauncher
    implements Runnable {
        private ClusterAdmin clusterAdmin = null;
        private ClusterMemberData member = null;
        private ObjectName nodeAgent = null;
        private Subject subject = null;
        private Subject savedSubject = null;

        MemberLauncher(ClusterAdmin clusterAdmin2, ClusterMemberData clusterMemberData, ObjectName objectName) {
            this.clusterAdmin = clusterAdmin2;
            this.member = clusterMemberData;
            this.nodeAgent = objectName;
            try {
                this.subject = ClusterAdmin.this.contextManager.getCallerSubject();
                if (this.subject == null) {
                    this.subject = ClusterAdmin.this.contextManager.getInvocationSubject();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.wlm.ClusterAdmin.start", (String)"1151", (Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block18: {
                try {
                    if (this.subject != null) {
                        this.savedSubject = ClusterAdmin.this.contextManager.pushInvocationSubject(this.subject);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.wlm.ClusterAdmin.start", (String)"1160", (Object)this);
                }
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"MemberLauncher.run");
                }
                this.clusterAdmin.launchMember(this.member, this.nodeAgent);
                Object var3_3 = null;
                try {
                    ClusterAdmin.this.contextManager.popInvocationSubject(this.savedSubject);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.wlm.ClusterAdmin.start", (String)"1181", (Object)this);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"MemberLauncher.run");
                }
                break block18;
                {
                    catch (ClusterException clusterException) {
                        FFDCFilter.processException((Throwable)clusterException, (String)"com.ibm.ws.management.wlm.ClusterAdmin.start", (String)"1170", (Object)this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Launch failed from MemberLauncher. member=" + this.member + ".  Exception: " + clusterException.getMessage()));
                        }
                        Object var3_4 = null;
                        try {
                            ClusterAdmin.this.contextManager.popInvocationSubject(this.savedSubject);
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.wlm.ClusterAdmin.start", (String)"1181", (Object)this);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"MemberLauncher.run");
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    try {
                        ClusterAdmin.this.contextManager.popInvocationSubject(this.savedSubject);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.wlm.ClusterAdmin.start", (String)"1181", (Object)this);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"MemberLauncher.run");
                    }
                    throw throwable;
                }
            }
        }
    }
}

