/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.wlm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.wlm.ClusterData;
import com.ibm.websphere.management.wlm.ClusterMemberData;
import com.ibm.websphere.management.wlm.ClusterWeightTableEntry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.management.wlm.Cluster;
import com.ibm.ws.management.wlm.ClusterMgrNotificationHandler;
import com.ibm.ws.wlm.Factory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.RuntimeOperationsException;

public class ClusterMgr
implements ConfigChangeListener,
NotificationListener {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$management$wlm$ClusterMgr == null ? (class$com$ibm$ws$management$wlm$ClusterMgr = ClusterMgr.class$("com.ibm.ws.management.wlm.ClusterMgr")) : class$com$ibm$ws$management$wlm$ClusterMgr), (String)"WLM", (String)"com.ibm.ws.wlm.resources.WLMMessages");
    public static final String wlmID = "com.ibm.ws.wlm";
    public static final String ClusterMgrMBeanType = "ClusterMgr";
    public static final String ServerMBeanType = "Server";
    public static final String TYPE_ACTIVATE_CLUSTER = "cluster.changed.activate";
    public static final String TYPE_DEACTIVATE_CLUSTER = "cluster.changed.deactivate";
    public static final String TYPE_MEMBER_ADDED = "cluster.member.added";
    public static final String TYPE_MEMBER_REMOVED = "cluster.member.removed";
    public static final String KEY_CLUSTER_NAME = "clusterName";
    protected static HashMap activeClusters;
    protected static HashMap clusterNameHash;
    protected static ObjectName objectName;
    protected static final Integer NODE_AGENT_LISTENER;
    protected static final Integer DEPLOYMENT_MANAGER_LISTENER;
    private AdminService adminService;
    private ConfigService configService;
    private DefaultRuntimeCollaborator rtc;
    static /* synthetic */ Class class$com$ibm$ws$management$wlm$ClusterMgr;
    static /* synthetic */ Class class$com$ibm$ws$management$wlm$Cluster;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize(HashMap hashMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize", (Object)hashMap);
        }
        try {
            try {
                this.adminService = AdminServiceFactory.getAdminService();
                this.configService = ConfigServiceFactory.getConfigService();
                MBeanFactory mBeanFactory = this.adminService.getMBeanFactory();
                this.rtc = new DefaultRuntimeCollaborator((Object)this);
                objectName = mBeanFactory.activateMBean(ClusterMgrMBeanType, (RuntimeCollaborator)this.rtc, ClusterMgrMBeanType, null);
                this.registerNotificationListener();
            }
            catch (AdminException adminException) {
                FFDCFilter.processException((Throwable)adminException, (String)"com.ibm.ws.management.wlm.ClusterMgr.initialize", (String)"184", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"WLMKEY_UNABLE_TO_ACTIVATE_CLUSTERMGR_MBEAN", (Object)new Object[]{adminException});
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"unable to activate the ClusterMgr MBean", (Object)((Object)adminException));
                }
                Object var4_5 = null;
                if (!tc.isEntryEnabled()) return;
                Tr.exit((TraceComponent)tc, (String)"initialize");
                return;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"initialize");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"initialize");
    }

    public void shutdown() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"shutdown");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"shutdown");
        }
    }

    public ClusterData[] retrieveClusters() {
        ClusterData[] clusterDataArray;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"retrieveClusters");
            }
            clusterDataArray = null;
            try {
                this.loadRefreshClusters(null);
                if (!activeClusters.isEmpty()) {
                    clusterDataArray = new ClusterData[activeClusters.size()];
                    Collection collection = activeClusters.values();
                    Iterator iterator = collection.iterator();
                    int n = 0;
                    while (iterator.hasNext()) {
                        Cluster cluster = (Cluster)iterator.next();
                        clusterDataArray[n++] = cluster.getClusterData();
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.wlm.ClusterMgr.retrieveClusters", (String)"245", (Object)this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"Error in ClusterMgr.retrieveClusters()", (Object)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"retrieveClusters");
        }
        return clusterDataArray;
    }

    public ClusterData retrieveCluster(String string) {
        ClusterData clusterData;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"retrieveCluster", (Object)string);
            }
            clusterData = null;
            try {
                Cluster cluster = (Cluster)activeClusters.get(string);
                if (cluster == null) {
                    this.loadRefreshClusters(string);
                    cluster = (Cluster)activeClusters.get(string);
                }
                if (cluster != null) {
                    clusterData = cluster.getClusterData();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.wlm.ClusterMgr.retrieveCluster", (String)"299", (Object)this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"Error in ClusterMgr.retrieveCluster()", (Object)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"retrieveCluster");
        }
        return clusterData;
    }

    public ClusterData retrieveClusterByMember(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"retrieveClusterByMember", (Object)new Object[]{string, string2});
        }
        ClusterData clusterData = null;
        String string3 = (String)clusterNameHash.get(string + ":" + string2);
        if (string3 == null) {
            this.loadRefreshClusters(null);
            string3 = (String)clusterNameHash.get(string + ":" + string2);
        }
        if (string3 != null) {
            clusterData = this.retrieveCluster(string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"retrieveClusterByMember", (Object)clusterData);
        }
        return clusterData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private AttributeList[] loadClusterConfig(String string) {
        AttributeList[] attributeListArray;
        block27: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"loadClusterConfig", (Object)string);
            }
            attributeListArray = new AttributeList[]{};
            AttributeList attributeList = new AttributeList();
            String string2 = null;
            Session session = null;
            session = new Session(wlmID, false);
            ObjectName objectName = ConfigServiceHelper.createObjectName((ConfigDataId)null, (String)"ServerCluster", (String)null);
            ObjectName[] objectNameArray = this.configService.queryConfigObjects(session, (ObjectName)null, objectName, (QueryExp)null);
            if (objectNameArray.length > 0) {
                if (string != null) {
                    for (int i = 0; i < objectNameArray.length; ++i) {
                        attributeList = this.configService.getAttributes(session, objectNameArray[i], (String[])null, true);
                        string2 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"name");
                        if (string2 == null || !string.equals(string2)) continue;
                        attributeListArray = new AttributeList[]{attributeList};
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug((TraceComponent)tc, (String)("clusterArray[0]: " + string2));
                        break;
                    }
                } else {
                    attributeListArray = new AttributeList[objectNameArray.length];
                    for (int i = 0; i < attributeListArray.length; ++i) {
                        attributeListArray[i] = this.configService.getAttributes(session, objectNameArray[i], (String[])null, true);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("clusterArray[" + i + "] added"));
                    }
                }
            }
            this.configService.discard(session);
            session = null;
            Object var10_13 = null;
            try {
                if (session != null) {
                    this.configService.discard(session);
                }
                break block27;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.wlm.ClusterMgr.loadClusterConfig", (String)"445", (Object)this);
            }
            break block27;
            {
                catch (ConfigServiceException configServiceException) {
                    FFDCFilter.processException((Throwable)configServiceException, (String)"com.ibm.ws.management.wlm.ClusterMgr.loadClusterConfig", (String)"412", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Problem with the ConfigService.", (Object)((Object)configServiceException));
                    }
                    Object var10_14 = null;
                    try {
                        if (session != null) {
                            this.configService.discard(session);
                        }
                        break block27;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.wlm.ClusterMgr.loadClusterConfig", (String)"445", (Object)this);
                    }
                    break block27;
                }
                catch (ConnectorException connectorException) {
                    FFDCFilter.processException((Throwable)connectorException, (String)"com.ibm.ws.management.wlm.ClusterMgr.loadClusterConfig", (String)"424", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"ConfigSerice threw a ConnectorException - this can't happen", (Object)((Object)connectorException));
                    }
                    Object var10_15 = null;
                    try {
                        if (session != null) {
                            this.configService.discard(session);
                        }
                        break block27;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.wlm.ClusterMgr.loadClusterConfig", (String)"445", (Object)this);
                    }
                    break block27;
                }
                catch (AttributeNotFoundException attributeNotFoundException) {
                    FFDCFilter.processException((Throwable)attributeNotFoundException, (String)"com.ibm.ws.management.wlm.ClusterMgr.loadClusterConfig", (String)"433", (Object)this);
                    Object var10_16 = null;
                    try {
                        if (session != null) {
                            this.configService.discard(session);
                        }
                        break block27;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.wlm.ClusterMgr.loadClusterConfig", (String)"445", (Object)this);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_17 = null;
                try {
                    if (session != null) {
                        this.configService.discard(session);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.wlm.ClusterMgr.loadClusterConfig", (String)"445", (Object)this);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadClusterConfig");
        }
        return attributeListArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterData convertCluster(AttributeList attributeList) {
        ClusterData clusterData;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"convertCluster", (Object)attributeList);
            }
            clusterData = new ClusterData();
            try {
                clusterData.clusterName = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"name");
                clusterData.clusterObjectName = ClusterMgr.getObjName(clusterData.clusterName, "Cluster", this.adminService.getNodeName(), this.adminService.getProcessName());
                clusterData.preferLocal = (Boolean)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"preferLocal");
                ArrayList arrayList = (ArrayList)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"members");
                clusterData.clusterMembers = new ClusterMemberData[arrayList.size()];
                clusterData.weightTable = new ClusterWeightTableEntry[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    AttributeList attributeList2 = (AttributeList)arrayList.get(i);
                    clusterData.weightTable[i] = new ClusterWeightTableEntry();
                    clusterData.weightTable[i].memberName = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList2, (String)"memberName");
                    clusterData.weightTable[i].nodeName = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList2, (String)"nodeName");
                    clusterData.weightTable[i].weight = (Integer)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList2, (String)"weight");
                    clusterData.clusterMembers[i] = new ClusterMemberData();
                    clusterData.clusterMembers[i].nodeName = clusterData.weightTable[i].nodeName;
                    clusterData.clusterMembers[i].memberName = clusterData.weightTable[i].memberName;
                    clusterData.clusterMembers[i].memberObjectName = ClusterMgr.getObjName(clusterData.clusterMembers[i].memberName, ServerMBeanType, clusterData.clusterMembers[i].nodeName, clusterData.clusterMembers[i].memberName);
                    clusterData.clusterMembers[i].clusterName = clusterData.clusterName;
                    clusterData.clusterMembers[i].clusterObjectName = clusterData.clusterObjectName;
                    clusterData.clusterMembers[i].type = 0;
                    clusterData.clusterMembers[i].weightTableEntry = clusterData.weightTable[i];
                    clusterData.clusterMembers[i].uniqueID = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList2, (String)"uniqueId");
                    String string = clusterData.weightTable[i].memberName;
                    String string2 = clusterData.weightTable[i].nodeName;
                    String string3 = clusterData.clusterName;
                    HashMap hashMap = clusterNameHash;
                    synchronized (hashMap) {
                        clusterNameHash.put(string + ":" + string2, string3);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"added member:node: ", (Object)new Object[]{string + ":" + string2, string3});
                        }
                        continue;
                    }
                }
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                FFDCFilter.processException((Throwable)attributeNotFoundException, (String)"com.ibm.ws.management.wlm.ClusterMgr.convertCluster", (String)"545", (Object)this);
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug((TraceComponent)tc, (String)"Cluster attribute not found", (Object)attributeNotFoundException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"convertCluster");
        }
        return clusterData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateCluster(ClusterData clusterData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"activateCluster", (Object)clusterData);
        }
        Cluster cluster = (Cluster)Factory.loadImpl((Class)(class$com$ibm$ws$management$wlm$Cluster == null ? (class$com$ibm$ws$management$wlm$Cluster = ClusterMgr.class$("com.ibm.ws.management.wlm.Cluster")) : class$com$ibm$ws$management$wlm$Cluster));
        cluster.setClusterData(clusterData);
        cluster.activate();
        HashMap hashMap = activeClusters;
        synchronized (hashMap) {
            activeClusters.put(clusterData.clusterName, cluster);
        }
        this.updateClusterObjName(cluster);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"activateCluster", (Object)clusterData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void loadRefreshClusters(String string) {
        block32: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"loadRefreshClusters", (Object)string);
            }
            try {
                AttributeList[] attributeListArray = this.loadClusterConfig(string);
                if (string == null && attributeListArray != null && attributeListArray.length == activeClusters.size()) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"activeClusters matches the wccmClusters, returning.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"loadRefreshClusters");
                    }
                    return;
                }
                if (attributeListArray != null) {
                    ClusterData[] clusterDataArray = new ClusterData[attributeListArray.length];
                    for (int i = 0; i < attributeListArray.length; ++i) {
                        Object object;
                        Object object2;
                        Serializable serializable;
                        String string2;
                        String string3;
                        Object object3;
                        Serializable serializable2;
                        String string4 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeListArray[i], (String)"name");
                        if (!activeClusters.containsKey(string4)) {
                            clusterDataArray[i] = this.convertCluster(attributeListArray[i]);
                            this.activateCluster(clusterDataArray[i]);
                            serializable2 = new Notification(TYPE_ACTIVATE_CLUSTER, (Object)objectName, -1L, System.currentTimeMillis());
                            object3 = new Properties();
                            ((Properties)object3).setProperty(KEY_CLUSTER_NAME, string4);
                            ((Notification)serializable2).setUserData(object3);
                            try {
                                this.rtc.sendNotification((Notification)serializable2);
                            }
                            catch (RuntimeOperationsException runtimeOperationsException) {
                                FFDCFilter.processException((Throwable)runtimeOperationsException, (String)((class$com$ibm$ws$management$wlm$ClusterMgr == null ? ClusterMgr.class$("com.ibm.ws.management.wlm.ClusterMgr") : class$com$ibm$ws$management$wlm$ClusterMgr).getName() + ".loadRefreshClusters"), (String)"652", (Object)this);
                            }
                            catch (MBeanException mBeanException) {
                                FFDCFilter.processException((Throwable)mBeanException, (String)((class$com$ibm$ws$management$wlm$ClusterMgr == null ? ClusterMgr.class$("com.ibm.ws.management.wlm.ClusterMgr") : class$com$ibm$ws$management$wlm$ClusterMgr).getName() + ".loadRefreshClusters"), (String)"658", (Object)this);
                            }
                            continue;
                        }
                        serializable2 = (ArrayList)ConfigServiceHelper.getAttributeValue((AttributeList)attributeListArray[i], (String)"members");
                        object3 = (Cluster)activeClusters.get(string4);
                        boolean bl = false;
                        for (int j = 0; j < ((ArrayList)serializable2).size(); ++j) {
                            AttributeList attributeList = (AttributeList)((ArrayList)serializable2).get(j);
                            string3 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"memberName");
                            ClusterMemberData clusterMemberData = ((Cluster)object3).getClusterMember(string3, string2 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"nodeName"));
                            if (clusterMemberData == null) {
                                ClusterData clusterData = this.convertCluster(attributeListArray[i]);
                                ((Cluster)object3).setClusterData(clusterData);
                                bl = true;
                                serializable = new Notification(TYPE_MEMBER_ADDED, (Object)objectName, -1L, System.currentTimeMillis());
                                object2 = new Properties();
                                ((Properties)object2).setProperty(KEY_CLUSTER_NAME, ((Cluster)object3).getClusterName());
                                ((Properties)object2).setProperty("nodeName", string2);
                                ((Properties)object2).setProperty("processName", string3);
                                ((Notification)serializable).setUserData(object2);
                                object = clusterNameHash;
                                synchronized (object) {
                                    clusterNameHash.put(string3 + ":" + string2, string4);
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"added member:node: ", (Object)new Object[]{string3 + ":" + string2, string4});
                                }
                                try {
                                    this.rtc.sendNotification((Notification)serializable);
                                }
                                catch (RuntimeOperationsException runtimeOperationsException) {
                                    FFDCFilter.processException((Throwable)runtimeOperationsException, (String)((class$com$ibm$ws$management$wlm$ClusterMgr == null ? ClusterMgr.class$("com.ibm.ws.management.wlm.ClusterMgr") : class$com$ibm$ws$management$wlm$ClusterMgr).getName() + ".loadRefreshClusters"), (String)"712", (Object)this);
                                }
                                catch (MBeanException mBeanException) {
                                    FFDCFilter.processException((Throwable)mBeanException, (String)((class$com$ibm$ws$management$wlm$ClusterMgr == null ? ClusterMgr.class$("com.ibm.ws.management.wlm.ClusterMgr") : class$com$ibm$ws$management$wlm$ClusterMgr).getName() + ".loadRefreshClusters"), (String)"718", (Object)this);
                                }
                                continue;
                            }
                            ((Cluster)object3).setMemberObjName(string3, string2);
                        }
                        if (bl || ((Cluster)object3).getClusterMembers().length == ((ArrayList)serializable2).size()) continue;
                        ClusterMemberData[] clusterMemberDataArray = ((Cluster)object3).getClusterMembers();
                        for (int j = 0; j < clusterMemberDataArray.length; ++j) {
                            string3 = clusterMemberDataArray[j].memberName;
                            string2 = clusterMemberDataArray[j].nodeName;
                            boolean bl2 = false;
                            for (int k = 0; k < ((ArrayList)serializable2).size(); ++k) {
                                serializable = (AttributeList)((ArrayList)serializable2).get(k);
                                object2 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)serializable, (String)"memberName");
                                object = (String)ConfigServiceHelper.getAttributeValue((AttributeList)serializable, (String)"nodeName");
                                if (!string3.equals(object2) || !string2.equals(object)) continue;
                                bl2 = true;
                                break;
                            }
                            if (bl2) continue;
                            ((Cluster)object3).removeMember(string3, string2);
                            Serializable serializable3 = clusterNameHash;
                            synchronized (serializable3) {
                                clusterNameHash.remove(string3 + ":" + string2);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"removed member:node: ", (Object)new Object[]{string3 + ":" + string2, ((Cluster)object3).getClusterName()});
                            }
                            serializable3 = new Notification(TYPE_MEMBER_REMOVED, (Object)objectName, -1L, System.currentTimeMillis());
                            serializable = new Properties();
                            ((Properties)serializable).setProperty(KEY_CLUSTER_NAME, ((Cluster)object3).getClusterName());
                            ((Properties)serializable).setProperty("nodeName", string2);
                            ((Properties)serializable).setProperty("processName", string3);
                            ((Notification)serializable3).setUserData(serializable);
                            try {
                                this.rtc.sendNotification((Notification)serializable3);
                                continue;
                            }
                            catch (RuntimeOperationsException runtimeOperationsException) {
                                FFDCFilter.processException((Throwable)runtimeOperationsException, (String)((class$com$ibm$ws$management$wlm$ClusterMgr == null ? ClusterMgr.class$("com.ibm.ws.management.wlm.ClusterMgr") : class$com$ibm$ws$management$wlm$ClusterMgr).getName() + ".loadRefreshClusters"), (String)"783", (Object)this);
                                continue;
                            }
                            catch (MBeanException mBeanException) {
                                FFDCFilter.processException((Throwable)mBeanException, (String)((class$com$ibm$ws$management$wlm$ClusterMgr == null ? ClusterMgr.class$("com.ibm.ws.management.wlm.ClusterMgr") : class$com$ibm$ws$management$wlm$ClusterMgr).getName() + ".loadRefreshClusters"), (String)"789", (Object)this);
                            }
                        }
                    }
                    break block32;
                }
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"no clusters in the config repository", (Object)attributeListArray);
                }
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                FFDCFilter.processException((Throwable)attributeNotFoundException, (String)"com.ibm.ws.management.wlm.ClusterMgr.loadRefreshClusters", (String)"808", (Object)this);
                if (!tc.isDebugEnabled()) break block32;
                Tr.debug((TraceComponent)tc, (String)"Cluster attribute not found", (Object)attributeNotFoundException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadRefreshClusters");
        }
    }

    private void updateClusterObjName(Cluster cluster) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"updateClusterObjName");
            }
            try {
                ObjectName objectName = new ObjectName(this.adminService.getDomainName() + ":*,mbeanIdentifier=" + cluster.getClusterName() + ",type=Cluster" + ",process=" + this.adminService.getProcessName());
                Set set = this.adminService.queryNames(objectName, null);
                if (!set.isEmpty()) {
                    Iterator iterator = set.iterator();
                    ObjectName objectName2 = (ObjectName)iterator.next();
                    cluster.setClusterObjName(objectName2);
                } else {
                    Tr.warning((TraceComponent)tc, (String)"WLMKEY_ACTIVATED_CLUSTER_MBEAN_NOT_FOUND", (Object)new Object[]{cluster.getClusterName(), objectName});
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Activated cluster MBean not found", (Object)objectName);
                    }
                }
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"com.ibm.ws.management.wlm.ClusterMgr.updateClusterObjName", (String)"867", (Object)this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)"new ObjectName() for query failed", (Object)malformedObjectNameException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateClusterObjName");
        }
    }

    protected static String getDomainName() {
        AdminService adminService = AdminServiceFactory.getAdminService();
        String string = adminService.getDomainName();
        if (string == null) {
            string = "*";
        }
        return string;
    }

    protected static ObjectName getObjName(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getObjName(1)", (Object)string);
        }
        ObjectName objectName = null;
        String string2 = ClusterMgr.getDomainName() + ":*,name=" + string;
        objectName = ClusterMgr.getObjectName(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getObjName(1)", (Object)objectName);
        }
        return objectName;
    }

    protected static ObjectName getObjName(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getObjName(2)", (Object)new Object[]{string, string2});
        }
        ObjectName objectName = null;
        String string3 = ClusterMgr.getDomainName() + ":*,name=" + string + ",type=" + string2;
        objectName = ClusterMgr.getObjectName(string3);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getObjName(2)", (Object)objectName);
        }
        return objectName;
    }

    protected static ObjectName getObjName(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getObjName(3)", (Object)new Object[]{string, string2, string3});
        }
        ObjectName objectName = null;
        String string4 = ClusterMgr.getDomainName() + ":*,name=" + string + ",type=" + string2 + ",node=" + string3;
        objectName = ClusterMgr.getObjectName(string4);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getObjName(3)", (Object)objectName);
        }
        return objectName;
    }

    protected static ObjectName getObjName(String string, String string2, String string3, String string4) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getObjName(4)", (Object)new Object[]{string, string2, string3, string4});
        }
        ObjectName objectName = null;
        String string5 = ClusterMgr.getDomainName() + ":*,name=" + string + ",type=" + string2 + ",node=" + string3 + ",process=" + string4;
        objectName = ClusterMgr.getObjectName(string5);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getObjName(4)", (Object)objectName);
        }
        return objectName;
    }

    protected static ObjectName getObjectName(String string) {
        ObjectName objectName;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getObjectName", (Object)new Object[]{string});
            }
            objectName = null;
            AdminService adminService = AdminServiceFactory.getAdminService();
            try {
                ObjectName objectName2 = new ObjectName(string);
                Set set = adminService.queryNames(objectName2, null);
                if (!set.isEmpty()) {
                    Iterator iterator = set.iterator();
                    objectName = (ObjectName)iterator.next();
                }
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"com.ibm.ws.management.wlm.ClusterMgr.getObjName", (String)"1062");
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"new ObjectName() for query failed", (Object)malformedObjectNameException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getObjectName", objectName);
        }
        return objectName;
    }

    private void registerNotificationListener() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"registerNotificationListener");
            }
            try {
                String string = ClusterMgr.getDomainName() + ":*,type=" + "NodeAgent";
                ObjectName objectName = new ObjectName(string);
                NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
                notificationFilterSupport.enableType("websphere.process.running");
                notificationFilterSupport.enableType("websphere.process.stopping");
                notificationFilterSupport.enableType("websphere.process.failed");
                this.adminService.addNotificationListenerExtended(objectName, (NotificationListener)this, (NotificationFilter)notificationFilterSupport, (Object)NODE_AGENT_LISTENER);
                string = ClusterMgr.getDomainName() + ":*,type=" + "DeploymentManager";
                ObjectName objectName2 = new ObjectName(string);
                notificationFilterSupport = new NotificationFilterSupport();
                notificationFilterSupport.enableType("websphere.process.running");
                notificationFilterSupport.enableType("websphere.process.stopping");
                notificationFilterSupport.enableType("websphere.process.failed");
                this.adminService.addNotificationListenerExtended(objectName2, (NotificationListener)this, (NotificationFilter)notificationFilterSupport, (Object)DEPLOYMENT_MANAGER_LISTENER);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.wlm.ClusterMgr.registerNotificationListener", (String)"1107", (Object)this);
                Tr.service((TraceComponent)tc, (String)"WLMKEY_NOTIFICATION_ERROR", (Object)exception);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("exception: " + exception));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerNotificationListener");
        }
    }

    public void configChanged(ConfigRepositoryEvent configRepositoryEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"configChanged", (Object)configRepositoryEvent);
        }
        this.spawnThread(null, null, configRepositoryEvent);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"configChanged");
        }
    }

    public void handleNotification(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleNotification", (Object)("type = " + notification.getType()));
        }
        if (!activeClusters.isEmpty()) {
            this.spawnThread(notification, object, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleNotification");
        }
    }

    private void spawnThread(Notification notification, Object object, ConfigRepositoryEvent configRepositoryEvent) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"spawnThread");
            }
            try {
                ClusterMgrNotificationHandler clusterMgrNotificationHandler = new ClusterMgrNotificationHandler(notification, object, configRepositoryEvent, this, this.rtc);
                clusterMgrNotificationHandler.start();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.wlm.ClusterMgr.spawnThread", (String)"1170", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"spawnThread", (Object)("Exception thrown from ClusterMgr " + exception));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"spawnThread");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"version : ifix", (Object)"1.42.1.1 : none");
        }
        activeClusters = new HashMap();
        clusterNameHash = new HashMap();
        NODE_AGENT_LISTENER = new Integer(1);
        DEPLOYMENT_MANAGER_LISTENER = new Integer(2);
    }
}

