/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wlm.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.wlm.WLMAppServer;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.ORB;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.WLM;
import com.ibm.ws.wlm.WLMProperties;
import com.ibm.ws.wlm.WLMServiceContextListener;
import com.ibm.ws.wlm.WLMTemplate;
import com.ibm.ws.wlm.configuration.ClusterDescription;
import com.ibm.ws.wlm.configuration.ClusterKey;
import com.ibm.ws.wlm.configuration.LSDAddress;
import com.ibm.ws.wlm.configuration.MemberDescription;
import com.ibm.ws.wlm.server.ServerAffinityManager;
import com.ibm.ws.wlm.server.WLMServerRequestInterceptor;
import com.ibm.ws.wlm.server.WLMTemplateImpl;
import com.ibm.ws.wlm.server.configuration.ServerConfigurationManager;
import com.ibm.ws.wlm.server.configuration.ServerUtils;
import com.ibm.ws.wlm.service.ClusterMemberStartup;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.management.JMException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.rmi.PortableRemoteObject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;

public final class ClusterMemberStartupImpl
extends ComponentImpl
implements ClusterMemberStartup,
WLM {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$wlm$service$ClusterMemberStartup == null ? (class$com$ibm$ws$wlm$service$ClusterMemberStartup = ClusterMemberStartupImpl.class$("com.ibm.ws.wlm.service.ClusterMemberStartup")) : class$com$ibm$ws$wlm$service$ClusterMemberStartup), (String)"WLM", (String)"com.ibm.ws.wlm.resources.WLMMessages");
    private static ClusterMemberStartupImpl instance;
    private String containingClusterName = null;
    private String nodeName = null;
    private String memberName = null;
    private String uid = null;
    private ServerAffinityManager serverAffinityMgr;
    private static String bootStrapString;
    private LSDAddress[] lsdAddresses = null;
    private LSDAddress[] mirroredLsdList = new LSDAddress[0];
    static /* synthetic */ Class class$com$ibm$ws$wlm$service$ClusterMemberStartup;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$WLM;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Server;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Repository;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$ORB;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$EndPointMgr;
    static /* synthetic */ Class class$com$ibm$ws$wlm$WLMTemplate;

    public void initialize(java.lang.Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        Server server;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"initialize", (java.lang.Object)object);
            }
            instance = this;
            if (AdminServiceFactory.getAdminService().getProcessType() == "UnManagedProcess") {
                throw new ComponentDisabledException();
            }
            this.addService(class$com$ibm$ws$runtime$service$WLM == null ? (class$com$ibm$ws$runtime$service$WLM = ClusterMemberStartupImpl.class$("com.ibm.ws.runtime.service.WLM")) : class$com$ibm$ws$runtime$service$WLM);
            this.addService(class$com$ibm$ws$wlm$service$ClusterMemberStartup == null ? (class$com$ibm$ws$wlm$service$ClusterMemberStartup = ClusterMemberStartupImpl.class$("com.ibm.ws.wlm.service.ClusterMemberStartup")) : class$com$ibm$ws$wlm$service$ClusterMemberStartup);
            server = (Server)this.getService(class$com$ibm$ws$runtime$service$Server == null ? (class$com$ibm$ws$runtime$service$Server = ClusterMemberStartupImpl.class$("com.ibm.ws.runtime.service.Server")) : class$com$ibm$ws$runtime$service$Server);
            WLMProperties.setAdminDomainName((String)server.getCellName());
            try {
                this.containingClusterName = server.getClusterName();
                if (this.containingClusterName != null || AdminServiceFactory.getAdminService().getProcessType() == "NodeAgent") {
                    bootStrapString = this.buildAggregationBootstrap();
                }
                if (this.containingClusterName != null) {
                    this.nodeName = server.getNodeName();
                    this.memberName = server.getName();
                    this.initializeContainingCluster();
                    this.initializeServerAffinityManager();
                    Repository repository = (Repository)this.getService(class$com$ibm$ws$runtime$service$Repository == null ? (class$com$ibm$ws$runtime$service$Repository = ClusterMemberStartupImpl.class$("com.ibm.ws.runtime.service.Repository")) : class$com$ibm$ws$runtime$service$Repository);
                    this.loadUID(repository.getConfigRoot().getResource(2, "cluster.xml"));
                    this.releaseService(repository);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.wlm.component.ClusterMemberStartupImpl.initialize", (String)"171", (java.lang.Object)this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)"unexpected exception", (java.lang.Object)exception);
            }
        }
        this.releaseService(server);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        ORB oRB;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start");
        }
        if ((oRB = (ORB)this.getService(class$com$ibm$ws$runtime$service$ORB == null ? (class$com$ibm$ws$runtime$service$ORB = ClusterMemberStartupImpl.class$("com.ibm.ws.runtime.service.ORB")) : class$com$ibm$ws$runtime$service$ORB)) != null) {
            com.ibm.CORBA.iiop.ORB oRB2 = oRB.getORB();
            if (this.containingClusterName != null) {
                WLMTemplateImpl wLMTemplateImpl = new WLMTemplateImpl(oRB2);
                ClusterDescription clusterDescription = ServerConfigurationManager.getLocalClusterDescription();
                MemberDescription memberDescription = new MemberDescription(clusterDescription.getClusterKey(), WLMProperties.getLocalTemplateIOR());
                clusterDescription.update((byte)0, 0L, new MemberDescription[]{memberDescription}, this.lsdAddresses, this.mirroredLsdList);
                try {
                    WLMServerRequestInterceptor wLMServerRequestInterceptor = (WLMServerRequestInterceptor)oRB2.resolve_initial_references("WLMServerRequestInterceptor");
                    wLMServerRequestInterceptor.registerServiceContextListener(oRB2, (WLMServiceContextListener)ServerConfigurationManager.getLocalClusterDescription());
                }
                catch (InvalidName invalidName) {
                    FFDCFilter.processException((Throwable)invalidName, (String)"com.ibm.ws.wlm.component.ClusterMemberStartupImpl.start", (String)"217", (java.lang.Object)this);
                }
                new ClusterMemberProcessListener(oRB2, bootStrapString);
            } else if (AdminServiceFactory.getAdminService().getProcessType() != "ManagedProcess") {
                WLMTemplateImpl wLMTemplateImpl = new WLMTemplateImpl(oRB2);
            }
            new WLMAppServer().initialize(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy");
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stop");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public String getContainingClusterName() {
        return this.containingClusterName;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public String getMemberUID() {
        return this.uid;
    }

    public String getClusterName() {
        return this.containingClusterName;
    }

    public ServerAffinityManager getServerAffinityManager() {
        return this.serverAffinityMgr;
    }

    private void initializeContainingCluster() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeContainingCluster", (java.lang.Object)this.containingClusterName);
        }
        WLMProperties.setServerGroupName((String)this.containingClusterName);
        ClusterKey clusterKey = ClusterKey.getClusterKey((String)WLMProperties.getAdminDomainName(), (String)WLMProperties.getServerGroupName());
        ServerConfigurationManager serverConfigurationManager = new ServerConfigurationManager();
        ClusterDescription clusterDescription = serverConfigurationManager.lookupClusterDescription(clusterKey);
        clusterDescription.update(this.lsdAddresses, this.mirroredLsdList);
        ServerConfigurationManager.setLocalClusterDescription(clusterDescription);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeContainingCluster");
        }
    }

    private void activateClusterParticipation(com.ibm.CORBA.iiop.ORB oRB, String string) {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"activateClusterParticipation", (java.lang.Object)string);
            }
            try {
                WLMTemplate wLMTemplate = ClusterMemberStartupImpl.getCellManagerTemplate(oRB);
                byte[] byArray = null;
                if (wLMTemplate != null) {
                    AdminService adminService = AdminServiceFactory.getAdminService();
                    String string2 = adminService.getNodeName() + ":" + adminService.getProcessName();
                    byArray = wLMTemplate.pushSelf(null, WLMProperties.getServerGroupName(), string2, WLMProperties.getLocalTemplateIOR());
                    ServerConfigurationManager.getLocalClusterDescription().update(byArray);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"cellmgrTemplate was unavailable, get ClusterDescription from Remote Server and update");
                    }
                    if ((byArray = this.getClusterDescriptionFromRemoteServer(oRB, null)) != null) {
                        ServerConfigurationManager.getLocalClusterDescription().update(byArray);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"byte[] of Cluster Description from remote Server was null");
                    }
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug((TraceComponent)tc, (String)"Unexpected", (java.lang.Object)new java.lang.Object[]{string, exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"activateClusterParticipation", (java.lang.Object)ServerConfigurationManager.getLocalClusterDescription());
        }
    }

    public static byte[] getClusterDescriptionFromRemoteServerForReflection(com.ibm.CORBA.iiop.ORB oRB, String string) {
        return instance.getClusterDescriptionFromRemoteServer(oRB, string);
    }

    private byte[] getClusterDescriptionFromRemoteServer(com.ibm.CORBA.iiop.ORB oRB, String string) {
        byte[] byArray;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getClusterDescriptionFromRemoteServer");
            }
            byArray = null;
            String string2 = null;
            String string3 = "corbaloc:";
            String string4 = "/WLMService";
            try {
                Repository repository = (Repository)this.getService(class$com$ibm$ws$runtime$service$Repository == null ? (class$com$ibm$ws$runtime$service$Repository = ClusterMemberStartupImpl.class$("com.ibm.ws.runtime.service.Repository")) : class$com$ibm$ws$runtime$service$Repository);
                Resource resource = string != null ? repository.getConfigRoot().getResource(2, string + "/cluster.xml") : repository.getConfigRoot().getResource(2, "cluster.xml");
                ServerCluster serverCluster = (ServerCluster)resource.getContents().get(0);
                EList eList = serverCluster.getMembers();
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    ClusterMember clusterMember = (ClusterMember)iterator.next();
                    if (!(!clusterMember.getMemberName().equals(this.memberName) & !clusterMember.getNodeName().equals(this.nodeName))) continue;
                    String string5 = null;
                    EndPointMgr endPointMgr = (EndPointMgr)this.getService(class$com$ibm$ws$runtime$service$EndPointMgr == null ? ClusterMemberStartupImpl.class$("com.ibm.ws.runtime.service.EndPointMgr") : class$com$ibm$ws$runtime$service$EndPointMgr);
                    Map map = endPointMgr.getNodeEndPoints();
                    Iterator iterator2 = map.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry entry = iterator2.next();
                        EndPointMgr.NodeEndPoints nodeEndPoints = (EndPointMgr.NodeEndPoints)entry.getValue();
                        EndPointMgr.ServerEndPoints serverEndPoints = nodeEndPoints.getServerEndPoints(clusterMember.getMemberName());
                        Map map2 = nodeEndPoints.getServerEndPoints();
                        Iterator iterator3 = map2.values().iterator();
                        while (iterator3.hasNext()) {
                            EndPointMgr.EndPoints endPoints = (EndPointMgr.EndPoints)iterator3.next();
                            if (serverEndPoints != endPoints) continue;
                            EndPoint endPoint = endPoints.getEndPoint("BOOTSTRAP_ADDRESS");
                            string5 = string5 == null ? "iiop:" : string5 + ",iiop:";
                            string5 = string5 + endPoint.getHost() + ":" + endPoint.getPort();
                            string2 = string3 + string5 + string4;
                            if (tc.isEntryEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("getClusterDescriptionFromServer bootstrapAddress = " + string2));
                            }
                            try {
                                ClusterDescription clusterDescription;
                                Object object = oRB.string_to_object(string2);
                                WLMTemplate wLMTemplate = (WLMTemplate)PortableRemoteObject.narrow((java.lang.Object)object, (Class)(class$com$ibm$ws$wlm$WLMTemplate == null ? (class$com$ibm$ws$wlm$WLMTemplate = ClusterMemberStartupImpl.class$("com.ibm.ws.wlm.WLMTemplate")) : class$com$ibm$ws$wlm$WLMTemplate));
                                byArray = wLMTemplate.pull();
                                if (string == null && (clusterDescription = new ClusterDescription(byArray, ServerConfigurationManager.getLocalClusterDescription().getClusterKey())).getMemento().hasReachableTarget()) {
                                    if (tc.isEntryEnabled()) {
                                        Tr.exit((TraceComponent)tc, (String)"getClusterDescriptionFromServer");
                                    }
                                    return byArray;
                                }
                                return byArray;
                            }
                            catch (RemoteException remoteException) {
                                if (!tc.isEntryEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)"getClusterDescriptionFromServer RemoteException encountered, move on to next remote server");
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.wlm.component.ClusterMemberStartupImpl.getClusterDescriptionFromRemoteServer", (String)"441", (java.lang.Object)this);
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug((TraceComponent)tc, (String)"Unexpected exception", (java.lang.Object)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getClusterDescriptionFromRemoteServer");
        }
        return byArray;
    }

    private void deactivateClusterParticipation(com.ibm.CORBA.iiop.ORB oRB, String string) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"deactivateClusterParticipation", (java.lang.Object)string);
            }
            try {
                WLMTemplate wLMTemplate = ClusterMemberStartupImpl.getCellManagerTemplate(oRB);
                if (wLMTemplate != null) {
                    AdminService adminService = AdminServiceFactory.getAdminService();
                    String string2 = adminService.getNodeName() + ":" + adminService.getProcessName();
                    byte[] byArray = wLMTemplate.pushSelf(WLMProperties.getAdminDomainName(), WLMProperties.getServerGroupName(), string2, null);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"Unexpected", (java.lang.Object)new java.lang.Object[]{string, exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deactivateClusterParticipation");
        }
    }

    private void initializeServerAffinityManager() {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"initializeServerAffinityManager", (java.lang.Object)this.serverAffinityMgr);
        }
    }

    private String buildAggregationBootstrap() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"buildAggregationBootstrap");
        }
        String string = null;
        String string2 = "corbaloc:";
        String string3 = "/WLMService";
        ArrayList<LSDAddress> arrayList = null;
        try {
            String string4 = null;
            EndPointMgr endPointMgr = (EndPointMgr)this.getService(class$com$ibm$ws$runtime$service$EndPointMgr == null ? (class$com$ibm$ws$runtime$service$EndPointMgr = ClusterMemberStartupImpl.class$("com.ibm.ws.runtime.service.EndPointMgr")) : class$com$ibm$ws$runtime$service$EndPointMgr);
            Map map = endPointMgr.getNodeEndPoints();
            arrayList = new ArrayList<LSDAddress>(map.size());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"initial creation size of lsdlist", (java.lang.Object)new Integer(map.size()));
            }
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                EndPointMgr.NodeEndPoints nodeEndPoints = (EndPointMgr.NodeEndPoints)entry.getValue();
                EndPointMgr.ServerEndPoints serverEndPoints = nodeEndPoints.getServerEndPoints(ServerUtils.getNetMgrName(endPointMgr));
                Map map2 = nodeEndPoints.getServerEndPoints();
                Iterator iterator2 = map2.values().iterator();
                while (iterator2.hasNext()) {
                    EndPoint endPoint;
                    EndPointMgr.EndPoints endPoints = (EndPointMgr.EndPoints)iterator2.next();
                    if (serverEndPoints == endPoints) {
                        endPoint = endPoints.getEndPoint("BOOTSTRAP_ADDRESS");
                        string4 = string4 == null ? "iiop:" : string4 + ",iiop:";
                        string4 = string4 + endPoint.getHost() + ":" + endPoint.getPort();
                        continue;
                    }
                    endPoint = endPoints.getEndPoint("ORB_LISTENER_ADDRESS");
                    EndPoint endPoint2 = endPoints.getEndPoint("CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS");
                    EndPoint endPoint3 = endPoints.getEndPoint("CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS");
                    if (endPoint == null || endPoint.getPort() == 0) continue;
                    arrayList.add(new LSDAddress(endPoint.getHost(), (short)endPoint.getPort(), endPoint2 == null ? (short)0 : (short)endPoint2.getPort(), endPoint3 == null ? (short)0 : (short)endPoint3.getPort()));
                }
            }
            if (string4 == null) {
                string4 = "rir:";
            }
            string = string2 + string4 + string3;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.wlm.component.ClusterMemberStartupImpl.buildAggregationBootstrap", (String)"567", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unexpected exception", (java.lang.Object)exception);
            }
            string = string2 + "rir:" + string3;
        }
        this.lsdAddresses = new LSDAddress[arrayList.size()];
        arrayList.toArray(this.lsdAddresses);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"LSDList", (java.lang.Object)this.lsdAddresses);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"buildAggregationBootstrap", (java.lang.Object)string);
        }
        return string;
    }

    private void loadUID(Resource resource) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadUID", (java.lang.Object)resource);
        }
        ServerCluster serverCluster = (ServerCluster)resource.getContents().get(0);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"loading unique id for cluster", (java.lang.Object)serverCluster.getName());
        }
        EList eList = serverCluster.getMembers();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            ClusterMember clusterMember = (ClusterMember)iterator.next();
            if (!(clusterMember.getMemberName().equals(this.memberName) & clusterMember.getNodeName().equals(this.nodeName))) continue;
            this.uid = clusterMember.getUniqueId();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"loadUID", (java.lang.Object)this.uid);
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadUID");
        }
    }

    public static WLMTemplate getCellManagerTemplate(com.ibm.CORBA.iiop.ORB oRB) {
        WLMTemplate wLMTemplate;
        block3: {
            wLMTemplate = null;
            try {
                Object object = oRB.string_to_object(bootStrapString);
                wLMTemplate = (WLMTemplate)PortableRemoteObject.narrow((java.lang.Object)object, (Class)(class$com$ibm$ws$wlm$WLMTemplate == null ? (class$com$ibm$ws$wlm$WLMTemplate = ClusterMemberStartupImpl.class$("com.ibm.ws.wlm.WLMTemplate")) : class$com$ibm$ws$wlm$WLMTemplate));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"cell manager template", (java.lang.Object)wLMTemplate);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"CellManager may not be up", (java.lang.Object)exception);
            }
        }
        return wLMTemplate;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"version : efix", (java.lang.Object)"1.24 : none");
        }
        instance = null;
        bootStrapString = null;
    }

    private class ClusterMemberProcessListener
    implements NotificationListener {
        private Byte handback = new Byte(0);
        private com.ibm.CORBA.iiop.ORB orb;
        private String aggregateAddress;

        ClusterMemberProcessListener(com.ibm.CORBA.iiop.ORB oRB, String string) {
            this.orb = oRB;
            this.aggregateAddress = string;
            this.registerNotificationListener();
        }

        public void handleNotification(Notification notification, java.lang.Object object) {
            String string = notification.getType();
            if (tc.isEventEnabled()) {
                ObjectName objectName = (ObjectName)notification.getSource();
                Tr.event((TraceComponent)tc, (String)"handleNotification", (java.lang.Object)new java.lang.Object[]{"type = " + string, "source = " + objectName});
            }
            if (string.equals("j2ee.state.running")) {
                ClusterMemberStartupImpl.this.activateClusterParticipation(this.orb, this.aggregateAddress);
            } else if (string.equals("j2ee.state.stopping")) {
                ClusterMemberStartupImpl.this.deactivateClusterParticipation(this.orb, this.aggregateAddress);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unexpected notification type, no action taken.");
            }
        }

        private void registerNotificationListener() {
            block2: {
                AdminService adminService = AdminServiceFactory.getAdminService();
                try {
                    NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
                    notificationFilterSupport.enableType("j2ee.state.running");
                    notificationFilterSupport.enableType("j2ee.state.stopping");
                    adminService.addNotificationListener(adminService.getLocalServer(), (NotificationListener)this, (NotificationFilter)notificationFilterSupport, (java.lang.Object)this.handback);
                }
                catch (JMException jMException) {
                    FFDCFilter.processException((Throwable)jMException, (String)"com.ibm.ws.wlm.server.configuration.ConfigurationNotificationThread.registerNotificationListener", (String)"692", (java.lang.Object)this);
                    if (!tc.isDebugEnabled()) break block2;
                    Tr.debug((TraceComponent)tc, (String)"JMX exception registering notification.", (java.lang.Object)jMException);
                }
            }
        }
    }
}

