/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wlm.server.configuration;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.wlm.ClusterData;
import com.ibm.websphere.management.wlm.ClusterMemberData;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.wlm.ClusterMgr;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.wlm.WLMProperties;
import com.ibm.ws.wlm.WLMTemplate;
import com.ibm.ws.wlm.configuration.ClusterDescription;
import com.ibm.ws.wlm.configuration.ClusterKey;
import com.ibm.ws.wlm.configuration.ConfigurationManager;
import com.ibm.ws.wlm.configuration.LSDAddress;
import com.ibm.ws.wlm.configuration.MemberDescription;
import com.ibm.ws.wlm.server.configuration.ClusterMemberListener;
import com.ibm.ws.wlm.server.configuration.ServerUtils;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.ObjectName;
import org.omg.CORBA.Object;

public final class ConfigurationNotificationThread
extends Thread {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$wlm$server$configuration$ConfigurationNotificationThread == null ? (class$com$ibm$ws$wlm$server$configuration$ConfigurationNotificationThread = ConfigurationNotificationThread.class$("com.ibm.ws.wlm.server.configuration.ConfigurationNotificationThread")) : class$com$ibm$ws$wlm$server$configuration$ConfigurationNotificationThread), (String)"WLM", (String)"com.ibm.ws.wlm.resources.WLMMessages");
    static Map activeParticipants;
    static Map pendingParticipants;
    private static Set pendingClusters;
    private static Map clusterListeners;
    private Map resources = null;
    private LSDAddress[] lsdAddresses = null;
    private LSDAddress[] mirroredLsdList = new LSDAddress[0];
    private static ClusterMgr clusterMgr;
    private ContextManager contextMgr = null;
    static /* synthetic */ Class class$com$ibm$ws$wlm$server$configuration$ConfigurationNotificationThread;

    public static WLMTemplate registerListener(ClusterKey clusterKey, String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"registerListener", (java.lang.Object)new java.lang.Object[]{clusterKey, string, string2});
        }
        WLMTemplate wLMTemplate = (WLMTemplate)ConfigurationManager.wlmORB.string_to_object(string2);
        HashMap<String, WLMTemplate> hashMap = (HashMap<String, WLMTemplate>)clusterListeners.get(clusterKey);
        if (hashMap == null) {
            hashMap = new HashMap<String, WLMTemplate>();
            clusterListeners.put(clusterKey, hashMap);
        }
        hashMap.put(string, wLMTemplate);
        return wLMTemplate;
    }

    public static WLMTemplate deregisterListener(ClusterKey clusterKey, String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"deregisterListener", (java.lang.Object)new java.lang.Object[]{clusterKey, string});
        }
        WLMTemplate wLMTemplate = null;
        Map map = (Map)clusterListeners.get(clusterKey);
        if (map != null) {
            wLMTemplate = (WLMTemplate)map.remove(string);
        }
        return wLMTemplate;
    }

    public static void pendingParticipation(String string, String string2) {
        pendingParticipants.put(string, string2);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"pendingParticipation", (java.lang.Object)new java.lang.Object[]{string, pendingParticipants});
        }
    }

    public static void activateParticipation(String string) {
        activeParticipants.put(string, pendingParticipants.remove(string));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"activateParticipation", (java.lang.Object)new java.lang.Object[]{string, activeParticipants});
        }
    }

    public static void deactivateParticipation(String string) {
        activeParticipants.remove(string);
        pendingParticipants.remove(string);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"deactivateParticipation", (java.lang.Object)new java.lang.Object[]{string, pendingParticipants, activeParticipants});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queue(ClusterData clusterData) {
        Set set = pendingClusters;
        synchronized (set) {
            pendingClusters.add(clusterData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispatch() {
        Set set = pendingClusters;
        synchronized (set) {
            pendingClusters.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispatch(String string) {
        ClusterData clusterData = clusterMgr.retrieveCluster(string);
        if (clusterData != null) {
            Set set = pendingClusters;
            synchronized (set) {
                pendingClusters.add(clusterData);
                pendingClusters.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispatch(ClusterData clusterData) {
        if (clusterData != null) {
            Set set = pendingClusters;
            synchronized (set) {
                pendingClusters.add(clusterData);
                pendingClusters.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispatch(String string, String string2) {
        ClusterData clusterData = clusterMgr.retrieveClusterByMember(string, string2);
        if (clusterData != null) {
            Set set = pendingClusters;
            synchronized (set) {
                pendingClusters.add(clusterData);
                pendingClusters.notify();
            }
        }
    }

    public ConfigurationNotificationThread(HashMap hashMap, ClusterMgr clusterMgr) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        this.setName(AdminServiceFactory.getAdminService().getCellName() + ":ConfigurationNotificationThread");
        this.setDaemon(true);
        ConfigurationNotificationThread.clusterMgr = clusterMgr;
        this.resources = hashMap;
        this.contextMgr = ContextManagerFactory.getInstance();
        new ClusterMemberListener();
        this.lsdAddresses = this.buildLSDList(this.resources);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public void run() {
        block2: {
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public java.lang.Object run() throws Exception {
                    block27: {
                        try {
                            if (ConfigurationNotificationThread.access$000().isEventEnabled()) {
                                Tr.event((TraceComponent)ConfigurationNotificationThread.access$000(), (String)"starting ConfigurationNotificationThread");
                            }
                            if (!(var1_1 = AdminServiceFactory.getAdminService()).getAttribute(var1_1.getLocalServer(), "state").equals("STARTED")) {
                                var2_4 = ConfigurationNotificationThread.access$100();
                                synchronized (var2_4) {
                                    try {
                                        ConfigurationNotificationThread.access$100().wait();
                                    }
                                    catch (InterruptedException var3_8) {
                                        // empty catch block
                                    }
                                }
                            }
                            try {
                                var2_4 = ConfigurationNotificationThread.access$200().retrieveClusters();
                                if (var2_4 != null) {
                                    ConfigurationNotificationThread.access$300(var2_4, null);
                                    for (var3_9 = 0; var3_9 < var2_4.length; ++var3_9) {
                                        ConfigurationNotificationThread.queue(var2_4[var3_9]);
                                    }
                                }
                            }
                            catch (JMException var2_5) {
                                FFDCFilter.processException((Throwable)var2_5, (String)"com.ibm.ws.wlm.server.configuration.ConfigurationNotificationThread.handleNotification", (String)"339", (java.lang.Object)this);
                                if (ConfigurationNotificationThread.access$000().isDebugEnabled()) {
                                    Tr.debug((TraceComponent)ConfigurationNotificationThread.access$000(), (String)"unexpected", (java.lang.Object)var2_5);
                                }
                            }
                        }
                        catch (Exception var1_2) {
                            FFDCFilter.processException((Throwable)var1_2, (String)"com.ibm.ws.wlm.server.configuration.ConfigurationNotificationThread.run", (String)"348", (java.lang.Object)this);
                            if (!ConfigurationNotificationThread.access$000().isDebugEnabled()) break block27;
                            Tr.debug((TraceComponent)ConfigurationNotificationThread.access$000(), (String)"Exception", (java.lang.Object)var1_2);
                        }
                    }
                    while (true) {
                        try {
                            block18: while (true) {
                                var1_1 = null;
                                var2_6 = ConfigurationNotificationThread.access$100();
                                synchronized (var2_6) {
                                    if (ConfigurationNotificationThread.access$100().isEmpty()) {
                                        try {
                                            ConfigurationNotificationThread.access$100().wait(60000L);
                                        }
                                        catch (InterruptedException var3_10) {}
                                    } else {
                                        var1_1 = new ClusterData[ConfigurationNotificationThread.access$100().size()];
                                        ConfigurationNotificationThread.access$100().toArray(var1_1);
                                        ConfigurationNotificationThread.access$100().clear();
                                    }
                                }
                                if (var1_1 == null) continue;
                                if (ConfigurationNotificationThread.access$000().isDebugEnabled()) {
                                    Tr.debug((TraceComponent)ConfigurationNotificationThread.access$000(), (String)"refreshing", (java.lang.Object)var1_1);
                                }
                                ConfigurationNotificationThread.access$400(ConfigurationNotificationThread.this, var1_1);
                                var2_7 = 0;
                                while (true) {
                                    if (var2_7 < var1_1.length) ** break;
                                    continue block18;
                                    ConfigurationNotificationThread.access$500(ConfigurationNotificationThread.this, ClusterKey.getClusterKey((String)WLMProperties.getAdminDomainName(), (String)var1_1[var2_7].clusterName));
                                    ++var2_7;
                                }
                                break;
                            }
                        }
                        catch (Exception var1_3) {
                            FFDCFilter.processException((Throwable)var1_3, (String)"com.ibm.ws.wlm.server.configuration.ConfigurationNotificationThread.run", (String)"384", (java.lang.Object)this);
                            if (!ConfigurationNotificationThread.access$000().isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)ConfigurationNotificationThread.access$000(), (String)"Exception", (java.lang.Object)var1_3);
                            continue;
                        }
                        break;
                    }
                }
            };
            try {
                this.contextMgr.runAsSystem(privilegedExceptionAction);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.wlm.server.configuration.ConfigurationNotificationThread.run", (String)"397", (java.lang.Object)this);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"Exception", (java.lang.Object)new java.lang.Object[]{exception});
            }
        }
    }

    private void refreshClusterConfiguration(ClusterData[] clusterDataArray) {
        if (clusterDataArray == null) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"refreshClusterConfiguration", (java.lang.Object)clusterDataArray);
        }
        for (int i = 0; i < clusterDataArray.length; ++i) {
            java.lang.Object object;
            ClusterKey clusterKey = ClusterKey.getClusterKey((String)WLMProperties.getAdminDomainName(), (String)clusterDataArray[i].clusterName);
            byte by = clusterDataArray[i].preferLocal != false ? (byte)1 : 0;
            ClusterMemberData[] clusterMemberDataArray = clusterDataArray[i].clusterMembers;
            ArrayList<MemberDescription> arrayList = new ArrayList<MemberDescription>();
            for (int j = 0; j < clusterMemberDataArray.length; ++j) {
                object = (String)activeParticipants.get(clusterMemberDataArray[j].nodeName + ":" + clusterMemberDataArray[j].memberName);
                if (object == null) continue;
                int n = 0;
                if (clusterMemberDataArray[j].weightTableEntry != null && clusterMemberDataArray[j].weightTableEntry.weight != null) {
                    n = clusterMemberDataArray[j].weightTableEntry.weight;
                }
                arrayList.add(new MemberDescription(clusterKey, clusterMemberDataArray[j].uniqueID, (String)object, 0, n));
            }
            MemberDescription[] memberDescriptionArray = new MemberDescription[arrayList.size()];
            arrayList.toArray(memberDescriptionArray);
            object = ConfigurationManager.getInstance().lookupClusterDescription(clusterKey);
            object.update(by, System.currentTimeMillis(), memberDescriptionArray, this.lsdAddresses, this.mirroredLsdList);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"Cluster updated", (java.lang.Object)object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"refreshClusterConfiguration", (java.lang.Object)ConfigurationManager.getInstance());
        }
    }

    private void notifyListeners(ClusterKey clusterKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"notifyListeners", (java.lang.Object)clusterKey);
        }
        ClusterDescription clusterDescription = ConfigurationManager.getInstance().lookupClusterDescription(clusterKey);
        byte[] byArray = clusterDescription.toStream();
        Map map = (Map)clusterListeners.get(clusterKey);
        if (map != null && map.size() > 0) {
            map = (Map)((HashMap)map).clone();
            WLMTemplate wLMTemplate = null;
            boolean bl = tc.isDebugEnabled();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                wLMTemplate = (WLMTemplate)entry.getValue();
                try {
                    wLMTemplate.push(clusterKey.domainName, clusterKey.clusterName, byArray);
                    if (!bl) continue;
                    Tr.debug((TraceComponent)tc, (String)"push successful", entry.getKey());
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.wlm.server.configuration.ConfigurationNotificationThread.notifyListeners", (String)"488", (java.lang.Object)this);
                    Tr.service((TraceComponent)tc, (String)"WLMKEY_SERVER_UNREACHABLE_FROM_DEPLOYMENTMANAGER", (java.lang.Object)new java.lang.Object[]{entry.getKey(), clusterKey.clusterName, throwable});
                    if (!bl) continue;
                    Tr.debug((TraceComponent)tc, (String)"push failure", (java.lang.Object)new java.lang.Object[]{entry.getKey(), throwable});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"notifyListeners");
        }
    }

    private static Set reconnectMembers(ClusterData[] clusterDataArray, String string) throws JMException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reconnectMembers", (java.lang.Object)new java.lang.Object[]{clusterDataArray, string});
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < clusterDataArray.length; ++i) {
            ClusterMemberData[] clusterMemberDataArray = clusterDataArray[i].clusterMembers;
            for (int j = 0; j < clusterMemberDataArray.length; ++j) {
                String string2 = clusterMemberDataArray[j].nodeName + ":" + clusterMemberDataArray[j].memberName;
                if (activeParticipants.containsKey(string2) || string != null && !clusterMemberDataArray[j].nodeName.equals(string)) continue;
                if (clusterMemberDataArray[j].memberObjectName != null) {
                    ObjectName objectName = clusterMemberDataArray[j].memberObjectName;
                    String string3 = objectName.getDomain();
                    String string4 = "node=" + objectName.getKeyProperty("node");
                    String string5 = "process=" + objectName.getKeyProperty("process");
                    AdminService adminService = AdminServiceFactory.getAdminService();
                    ObjectName objectName2 = new ObjectName(string3 + ":*,type=ORB," + string4 + "," + string5);
                    Set set = adminService.queryNames(objectName2, null);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"ORB ObjectName", (java.lang.Object)set);
                    }
                    if (set == null || set.isEmpty()) continue;
                    hashSet.add(clusterDataArray[i].clusterName);
                    objectName2 = (ObjectName)set.iterator().next();
                    Integer n = (Integer)adminService.invoke(objectName2, "getBootstrapPort", null, null);
                    String string6 = "corbaloc:iiop:" + objectName.getKeyProperty("node") + ":" + n + "/" + "WLMService";
                    WLMTemplate wLMTemplate = ConfigurationNotificationThread.registerListener(ClusterKey.getClusterKey((String)WLMProperties.getAdminDomainName(), (String)clusterDataArray[i].clusterName), string2, string6);
                    ConfigurationNotificationThread.pendingParticipation(string2, ConfigurationManager.wlmORB.object_to_string((Object)wLMTemplate));
                    ConfigurationNotificationThread.activateParticipation(string2);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"ObjectName not available", (java.lang.Object)clusterMemberDataArray[j].memberName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reconnectMembers", hashSet);
        }
        return hashSet;
    }

    static Set reconnectMembers(String string) throws JMException {
        ClusterData[] clusterDataArray = clusterMgr.retrieveClusters();
        if (clusterDataArray != null) {
            return ConfigurationNotificationThread.reconnectMembers(clusterDataArray, string);
        }
        return new HashSet();
    }

    private LSDAddress[] buildLSDList(Map map) {
        LSDAddress[] lSDAddressArray;
        ArrayList<LSDAddress> arrayList;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"buildLSDList", (java.lang.Object)map);
            }
            arrayList = null;
            try {
                lSDAddressArray = (LSDAddress[])map.get("EndPointMgr");
                Map map2 = lSDAddressArray.getNodeEndPoints();
                arrayList = new ArrayList<LSDAddress>(map2.size());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"initial creation size of lsdlist", (java.lang.Object)new Integer(map2.size()));
                }
                Iterator iterator = map2.values().iterator();
                while (iterator.hasNext()) {
                    EndPointMgr.NodeEndPoints nodeEndPoints = (EndPointMgr.NodeEndPoints)iterator.next();
                    EndPointMgr.ServerEndPoints serverEndPoints = nodeEndPoints.getServerEndPoints(ServerUtils.getNetMgrName((EndPointMgr)lSDAddressArray));
                    Map map3 = nodeEndPoints.getServerEndPoints();
                    Iterator iterator2 = map3.values().iterator();
                    while (iterator2.hasNext()) {
                        EndPointMgr.EndPoints endPoints = (EndPointMgr.EndPoints)iterator2.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"EndPoints", (java.lang.Object)endPoints);
                        }
                        if (serverEndPoints == endPoints) continue;
                        EndPoint endPoint = endPoints.getEndPoint("ORB_LISTENER_ADDRESS");
                        EndPoint endPoint2 = endPoints.getEndPoint("CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS");
                        EndPoint endPoint3 = endPoints.getEndPoint("CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS");
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Host and ports for the LSD", (java.lang.Object)new java.lang.Object[]{endPoint == null ? null : endPoint.getHost(), endPoint == null ? null : new Integer(endPoint.getPort()), endPoint2 == null ? null : new Integer(endPoint2.getPort()), endPoint3 == null ? null : new Integer(endPoint3.getPort())});
                        }
                        if (endPoint == null || endPoint.getPort() == 0) continue;
                        arrayList.add(new LSDAddress(endPoint.getHost(), (short)endPoint.getPort(), endPoint2 == null ? (short)0 : (short)endPoint2.getPort(), endPoint3 == null ? (short)0 : (short)endPoint3.getPort()));
                    }
                }
                if (arrayList.size() == 0 && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)" No lsd found on any node in the cell ");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.wlm.server.configuration.ConfigurationNotificationThread.buildLSDList", (String)"651", (java.lang.Object)this);
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug((TraceComponent)tc, (String)"Unexpected exception", (java.lang.Object)exception);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"LSD list", arrayList);
        }
        lSDAddressArray = new LSDAddress[arrayList.size()];
        arrayList.toArray(lSDAddressArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"buildLSDList", (java.lang.Object)lSDAddressArray);
        }
        return lSDAddressArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ TraceComponent access$000() {
        return tc;
    }

    static /* synthetic */ Set access$100() {
        return pendingClusters;
    }

    static /* synthetic */ ClusterMgr access$200() {
        return clusterMgr;
    }

    static /* synthetic */ Set access$300(ClusterData[] clusterDataArray, String string) throws JMException {
        return ConfigurationNotificationThread.reconnectMembers(clusterDataArray, string);
    }

    static /* synthetic */ void access$400(ConfigurationNotificationThread configurationNotificationThread, ClusterData[] clusterDataArray) {
        configurationNotificationThread.refreshClusterConfiguration(clusterDataArray);
    }

    static /* synthetic */ void access$500(ConfigurationNotificationThread configurationNotificationThread, ClusterKey clusterKey) {
        configurationNotificationThread.notifyListeners(clusterKey);
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"version : efix", (java.lang.Object)"1.42 : none");
        }
        activeParticipants = new HashMap();
        pendingParticipants = new HashMap();
        pendingClusters = new HashSet();
        clusterListeners = new HashMap();
        clusterMgr = null;
    }
}

