/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.bootstrap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.repository.ConfigStructureHelper;
import com.ibm.ws.naming.bootstrap.ServerInfo;
import com.ibm.ws.naming.distcos.ConfigInfo;
import com.ibm.ws.naming.distcos.ConfiguredBindingInfo;
import com.ibm.ws.naming.distcos.EndpointGroup;
import com.ibm.ws.naming.distcos.NameSpaceConfigurationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public class ConfigInfoImpl
implements ConfigInfo {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$naming$bootstrap$ConfigInfoImpl == null ? (class$com$ibm$ws$naming$bootstrap$ConfigInfoImpl = ConfigInfoImpl.class$("com.ibm.ws.naming.bootstrap.ConfigInfoImpl")) : class$com$ibm$ws$naming$bootstrap$ConfigInfoImpl), (String)"Naming", (String)"com.ibm.ws.naming.util.WsnMessages");
    private static final String NAME_STORE_XML_NAME = "namestore.xml";
    private static final String STANDALONE_CELL_NAME_STORE_XML_NAME = "namestore-cell.xml";
    private static final String STANDALONE_NODE_NAME_STORE_XML_NAME = "namestore-node.xml";
    private static Properties _nameServerCustomPropertyDefaults;
    private Properties _nameServerCustomProperties = new Properties();
    private String _cellName = "";
    private String _nodeName = "";
    private String _serverName = "";
    private ServerInfo _serverInfo = null;
    private HashMap _bsPorts = new HashMap();
    private HashMap _servers = new HashMap();
    private ServerInfo[] _siArray = null;
    private String[] _nodeNames = null;
    private ArrayList _cbiList = new ArrayList();
    private String _cellNameStoreURI = null;
    private String _nodeNameStoreURI = null;
    private boolean _warningIssued = false;
    static /* synthetic */ Class class$com$ibm$ws$naming$bootstrap$ConfigInfoImpl;

    public void setCellName(String string) {
        this._cellName = string;
    }

    public void setNodeName(String string) {
        this._nodeName = string;
    }

    public void setNodeNames(String[] stringArray) {
        this._nodeNames = stringArray;
    }

    public void setServerName(String string) {
        this._serverName = string;
    }

    public void addServer(String string, String string2, String string3, String string4, String string5) throws NameSpaceConfigurationException {
        ServerKey serverKey = new ServerKey(this._nodeName, this._serverName);
        ServerKey serverKey2 = new ServerKey(string2, string);
        if (this._servers.containsKey(serverKey2)) {
            if (serverKey2.equals(serverKey)) {
                throw new NameSpaceConfigurationException("The name of this server (" + this._serverName + ") is not unique within the configuration for this node.");
            }
            String string6 = "cfDuplicateServerName";
            String[] stringArray = new String[]{string, string2, string3 + ":" + string4};
            this.issueConfigurationWarning(string6, stringArray);
        } else {
            Object object;
            if (string3 == null || string3.length() == 0 || string3.equals("INVALID-HOSTNAME")) {
                if (serverKey2.equals(serverKey)) {
                    throw new NameSpaceConfigurationException("Missing host name info in bootstrap address of server \"" + string + "\" in node \"" + string2 + "\".");
                }
                String string7 = "cfMissingHostName";
                String[] stringArray = new String[]{string, string2};
                this.issueConfigurationWarning(string7, stringArray);
                return;
            }
            if (string4 == null || string4.length() == 0 || string4.equals("INVALID-PORT")) {
                if (serverKey2.equals(serverKey)) {
                    throw new NameSpaceConfigurationException("Missing port number info in bootstrap address of server \"" + string + "\" in node \"" + string2 + "\".");
                }
                String string8 = "cfMissingPortNumber";
                String[] stringArray = new String[]{string, string2};
                this.issueConfigurationWarning(string8, stringArray);
                return;
            }
            if (this._bsPorts.containsKey(string3 + ":" + string4)) {
                if (serverKey2.equals(serverKey)) {
                    object = "cfDupPortReplaceConfig";
                    String[] stringArray = new String[]{string3 + ":" + string4, string, string2};
                    this.issueConfigurationWarning((String)object, stringArray);
                } else {
                    String string9 = "cfDupPortSkipConfig";
                    String[] stringArray = new String[]{string3 + ":" + string4, string, string2};
                    this.issueConfigurationWarning(string9, stringArray);
                    return;
                }
            }
            object = new ServerInfo(string, string2, string3, string4, string5);
            if (serverKey2.equals(serverKey)) {
                this._serverInfo = object;
            }
            this._servers.put(serverKey2, object);
            this._bsPorts.put(string3 + ":" + string4, serverKey2);
            this._siArray = null;
        }
    }

    public void addClusterMember(String string, String string2, String string3) {
        ServerKey serverKey;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Adding server \"" + string3 + "\" in node \"" + string2 + "\" to cluster \"" + string + "\"."));
        }
        if (this._servers.containsKey(serverKey = new ServerKey(string2, string3))) {
            ServerInfo serverInfo = (ServerInfo)this._servers.get(serverKey);
            serverInfo._clusterName = string;
        } else {
            String string4 = "cfClusterMemberNotFound";
            String[] stringArray = new String[]{string3, string2, string};
            this.issueConfigurationWarning(string4, stringArray);
        }
    }

    public void addConfiguredBinding(ConfiguredBindingInfo configuredBindingInfo) {
        this._cbiList.add(configuredBindingInfo);
    }

    private ServerInfo[] getServerArray() {
        if (this._siArray == null) {
            this._siArray = new ServerInfo[this._servers.size()];
            Iterator iterator = this._servers.values().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                this._siArray[n] = (ServerInfo)iterator.next();
                ++n;
            }
        }
        return this._siArray;
    }

    public void setCellNameStoreURI(String string) {
        this._cellNameStoreURI = string.equals("UnManagedProcess") ? ConfigStructureHelper.getURI((String)this.thisCellName(), (String)this.thisNodeName(), (String)this.thisServerName(), (String)STANDALONE_CELL_NAME_STORE_XML_NAME) : ConfigStructureHelper.getURI((String)this.thisCellName(), null, null, (String)NAME_STORE_XML_NAME);
    }

    public String getCellNameStoreURI() {
        return this._cellNameStoreURI;
    }

    public void setNodeNameStoreURI(String string) {
        this._nodeNameStoreURI = string.equals("UnManagedProcess") ? ConfigStructureHelper.getURI((String)this.thisCellName(), (String)this.thisNodeName(), (String)this.thisServerName(), (String)STANDALONE_NODE_NAME_STORE_XML_NAME) : ConfigStructureHelper.getURI((String)this.thisCellName(), (String)this.thisNodeName(), null, (String)NAME_STORE_XML_NAME);
    }

    public String getNodeNameStoreURI() {
        return this._nodeNameStoreURI;
    }

    public String thisCellName() {
        return this._cellName;
    }

    public String thisNodeName() {
        return this._nodeName;
    }

    public String thisServerName() {
        return this._serverName;
    }

    public String thisLogicalServerName() {
        if (this._serverInfo._clusterName.equals("NULL(Non-Clustered Server)")) {
            return this._serverName;
        }
        return this._serverInfo._clusterName;
    }

    public String thisClusterName() {
        if (this._serverInfo._clusterName.equals("NULL(Non-Clustered Server)")) {
            return "";
        }
        return this._serverInfo._clusterName;
    }

    public boolean thisIsCellManager() {
        return this._serverInfo._serverType.equals("CellManager");
    }

    public boolean thisIsNodeAgent() {
        return this._serverInfo._serverType.equals("NodeAgent");
    }

    public boolean thisIsManagedAppServer() {
        return this._serverInfo._serverType.equals("ManagedApplicationServer");
    }

    public boolean thisIsStandaloneAppServer() {
        return this._serverInfo._serverType.equals("StandAloneApplicationServer");
    }

    public EndpointGroup getThisServerEndpoint() {
        return this.getServerEndpoint(this._nodeName, this._serverName);
    }

    public EndpointGroup getThisNodeAgentEndpoint() {
        return this.getNodeAgentEndpoint(this._nodeName);
    }

    public EndpointGroup getThisCellManagerEndpoint() {
        ServerInfo[] serverInfoArray = this.getServerArray();
        EndpointGroup endpointGroup = new EndpointGroup();
        for (int i = 0; i < serverInfoArray.length; ++i) {
            if (!serverInfoArray[i]._serverType.equals("CellManager")) continue;
            endpointGroup.addEndpoint(serverInfoArray[i].getEndpointString());
        }
        if (endpointGroup.size() == 0) {
            endpointGroup.addEndpoint("INVALID-HOSTNAME:INVALID-PORT");
        }
        return endpointGroup;
    }

    public EndpointGroup getServerEndpoint(String string, String string2) {
        ServerKey serverKey = new ServerKey(string, string2);
        ServerInfo serverInfo = (ServerInfo)this._servers.get(serverKey);
        EndpointGroup endpointGroup = null;
        endpointGroup = serverInfo != null ? new EndpointGroup(serverInfo.getEndpointString()) : new EndpointGroup("INVALID-HOSTNAME:INVALID-PORT");
        return endpointGroup;
    }

    public String getCellMgrNodeName() {
        ServerInfo[] serverInfoArray = this.getServerArray();
        for (int i = 0; i < serverInfoArray.length; ++i) {
            if (!serverInfoArray[i]._serverType.equals("CellManager")) continue;
            return serverInfoArray[i]._nodeName;
        }
        return "";
    }

    public String getCellMgrServerName() {
        ServerInfo[] serverInfoArray = this.getServerArray();
        for (int i = 0; i < serverInfoArray.length; ++i) {
            if (!serverInfoArray[i]._serverType.equals("CellManager")) continue;
            return serverInfoArray[i]._serverName;
        }
        return "";
    }

    public EndpointGroup getNodeAgentEndpoint(String string) {
        ServerInfo[] serverInfoArray = this.getServerArray();
        for (int i = 0; i < serverInfoArray.length; ++i) {
            if (!serverInfoArray[i]._serverType.equals("NodeAgent") || !serverInfoArray[i]._nodeName.equals(string)) continue;
            return new EndpointGroup(serverInfoArray[i].getEndpointString());
        }
        return new EndpointGroup("INVALID-HOSTNAME:INVALID-PORT");
    }

    public EndpointGroup getClusterEndpoint(String string) {
        ServerInfo[] serverInfoArray = this.getServerArray();
        EndpointGroup endpointGroup = new EndpointGroup();
        for (int i = 0; i < serverInfoArray.length; ++i) {
            if (!serverInfoArray[i]._clusterName.equals(string)) continue;
            endpointGroup.addEndpoint(serverInfoArray[i].getEndpointString());
        }
        if (endpointGroup.size() == 0) {
            endpointGroup.addEndpoint("INVALID-HOSTNAME:INVALID-PORT");
        }
        return endpointGroup;
    }

    public boolean clusterExists(String string) {
        boolean bl = true;
        EndpointGroup endpointGroup = this.getClusterEndpoint(string);
        if (endpointGroup.size() == 1 && endpointGroup.toString().equals("INVALID-HOSTNAME:INVALID-PORT")) {
            bl = false;
        }
        return bl;
    }

    public boolean serverExists(String string, String string2) {
        boolean bl = true;
        EndpointGroup endpointGroup = this.getServerEndpoint(string, string2);
        if (endpointGroup.size() == 1 && endpointGroup.toString().equals("INVALID-HOSTNAME:INVALID-PORT")) {
            bl = false;
        }
        return bl;
    }

    public boolean validateConfiguration() throws NameSpaceConfigurationException {
        if (this._serverInfo == null) {
            throw new NameSpaceConfigurationException("Server information for this server (servername=" + this._serverName + ") was not found in the serverindex.xml configuration file.");
        }
        return this._warningIssued;
    }

    public EndpointGroup[] getClustersEndpoints() {
        Object object;
        ServerInfo[] serverInfoArray = this.getServerArray();
        HashMap<Object, EndpointGroup> hashMap = new HashMap<Object, EndpointGroup>();
        for (int i = 0; i < serverInfoArray.length; ++i) {
            object = serverInfoArray[i].getLogicalName();
            if (hashMap.containsKey(object)) continue;
            EndpointGroup endpointGroup = null;
            if (!serverInfoArray[i].isClustered()) continue;
            endpointGroup = this.getClusterEndpoint(serverInfoArray[i]._clusterName);
            endpointGroup.setName((String)object);
            hashMap.put(object, endpointGroup);
        }
        EndpointGroup[] endpointGroupArray = new EndpointGroup[hashMap.size()];
        object = hashMap.values().iterator();
        int n = 0;
        while (object.hasNext()) {
            endpointGroupArray[n] = (EndpointGroup)object.next();
            ++n;
        }
        return endpointGroupArray;
    }

    public EndpointGroup[] getServersEndpoint(String string) {
        Object object;
        ServerInfo[] serverInfoArray = this.getServerArray();
        HashMap<Object, EndpointGroup> hashMap = new HashMap<Object, EndpointGroup>();
        for (int i = 0; i < serverInfoArray.length; ++i) {
            object = serverInfoArray[i]._serverName;
            if (hashMap.containsKey(object) || !string.equals(serverInfoArray[i]._nodeName)) continue;
            EndpointGroup endpointGroup = this.getServerEndpoint(string, serverInfoArray[i]._serverName);
            endpointGroup.setName((String)object);
            hashMap.put(object, endpointGroup);
        }
        EndpointGroup[] endpointGroupArray = new EndpointGroup[hashMap.size()];
        object = hashMap.values().iterator();
        int n = 0;
        while (object.hasNext()) {
            endpointGroupArray[n] = (EndpointGroup)object.next();
            ++n;
        }
        return endpointGroupArray;
    }

    public String[] getOtherNodeNames() {
        String[] stringArray = new String[this._nodeNames.length - 1];
        int n = 0;
        for (int i = 0; i < this._nodeNames.length; ++i) {
            if (this._nodeNames[i].equals(this._nodeName)) continue;
            stringArray[n] = this._nodeNames[i];
            ++n;
        }
        return stringArray;
    }

    public ConfiguredBindingInfo[] getConfiguredBindings() {
        ConfiguredBindingInfo[] configuredBindingInfoArray = new ConfiguredBindingInfo[this._cbiList.size()];
        return this._cbiList.toArray(configuredBindingInfoArray);
    }

    public void issueConfigurationWarning(String string) {
        String string2 = "cfWarningsIssued2";
        String[] stringArray = new String[]{string};
        Tr.warning((TraceComponent)tc, (String)string2, (Object)stringArray);
        this._warningIssued = true;
    }

    public void issueConfigurationWarning(String string, String[] stringArray) {
        Tr.warning((TraceComponent)tc, (String)string, (Object)stringArray);
        this._warningIssued = true;
    }

    public String toStringDebug() {
        String string = "\n========= ConfigInfoImpl dump starts ===========\n" + super.toString() + " contains the following config data:" + "\n_cellName=" + this._cellName + "\n_nodeName=" + this._nodeName + "\n_serverName=" + this._serverName + "\n_serverInfo=" + this._serverInfo + "\n\n_servers=(following array of ServerInfo objects)\n" + this._servers.toString() + "\n========= ConfigInfoImpl dump complete ===========\n";
        return string;
    }

    public String getNameServerCustomProperty(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getNameServerCustomProperty", (Object)("propName=" + string));
        }
        String string2 = null;
        string2 = this._nameServerCustomProperties.getProperty(string);
        if (string2 == null) {
            string2 = _nameServerCustomPropertyDefaults.getProperty(string);
            if (tc.isDebugEnabled() && string2 != null) {
                Tr.debug((TraceComponent)tc, (String)"getNameServerCustomProperty: Returning default value.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getNameServerCustomProperty", (Object)("propValue=" + string2));
        }
        return string2;
    }

    public boolean setNameServerCustomProperty(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setNameServerCustomProperty", (Object)("Prop: " + string + " = " + string2));
        }
        boolean bl = false;
        if (string2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setNameServerCustomProperty: Invalid property value of null.");
            }
            return false;
        }
        if (_nameServerCustomPropertyDefaults.getProperty(string) != null) {
            String[] stringArray;
            string2 = string2.toLowerCase();
            if (string.equals("naming.systemNameSpace.scope")) {
                if (string2.equals("cell") || string2.equals("node") || string2.equals("server")) {
                    bl = true;
                }
            } else if (string.equals("BootstrapPortEnabled") && ((stringArray = string2.toLowerCase()).equals("true") || stringArray.equals("false"))) {
                bl = true;
            }
            if (bl) {
                this._nameServerCustomProperties.setProperty(string, string2);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"setNameServerCustomProperty: Property value not valid.");
                }
                stringArray = new String[]{string2, string};
                Tr.warning((TraceComponent)tc, (String)"cfInvalidProperty", (Object)stringArray);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setNameServerCustomProperty: Property name not recognized.");
            }
            String[] stringArray = new String[]{string};
            Tr.warning((TraceComponent)tc, (String)"cfUnrecognizedProperty", (Object)stringArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setNameServerCustomProperty", (Object)("propValid=" + bl));
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SOURCE CODE INFO: ws/code/naming.server/src/com/ibm/ws/naming/bootstrap/ConfigInfoImpl.java, WAS.naming.server, ASV51X, a0425.05, ver. 1.34.1.1");
        }
        _nameServerCustomPropertyDefaults = new Properties();
        _nameServerCustomPropertyDefaults.setProperty("naming.systemNameSpace.scope", "cell");
        _nameServerCustomPropertyDefaults.setProperty("BootstrapPortEnabled", "true");
    }

    public class ServerKey {
        private String _node;
        private String _server;

        public ServerKey(String string, String string2) {
            this._node = string;
            this._server = string2;
        }

        public int hashCode() {
            return 31 * this._node.hashCode() + this._server.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof ServerKey) {
                ServerKey serverKey = (ServerKey)object;
                return serverKey._node.equals(this._node) && serverKey._server.equals(this._server);
            }
            return false;
        }
    }
}

