/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.bootstrap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.management.service.Admin;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.naming.bootstrap.ConfigInfoBuilder;
import com.ibm.ws.naming.bootstrap.ConfigInfoImpl;
import com.ibm.ws.naming.bootstrap.SecurityServiceListenerImpl;
import com.ibm.ws.naming.bootstrap.WsnNameServiceImpl;
import com.ibm.ws.naming.cosbase.ServantManager;
import com.ibm.ws.naming.distcos.ConfigDiff;
import com.ibm.ws.naming.distcos.ConfigInfo;
import com.ibm.ws.naming.distcos.NSBCellManager;
import com.ibm.ws.naming.distcos.NSBManagedAppSvr;
import com.ibm.ws.naming.distcos.NSBNodeAgent;
import com.ibm.ws.naming.distcos.NSBSingleAppSvr;
import com.ibm.ws.naming.distcos.NameSpaceBuilder;
import com.ibm.ws.naming.distcos.NameSpaceConstructionException;
import com.ibm.ws.naming.distcos.ServantManagerImpl;
import com.ibm.ws.naming.distcos.WsnDistributedNC;
import com.ibm.ws.naming.mbean.NameServerMBeanImpl;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.ORB;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.service.SecurityServiceListener;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import javax.management.ObjectName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class NameServerImpl
extends ComponentImpl
implements ConfigChangeListener {
    private static final TraceComponent _tc = Tr.register((Class)(class$com$ibm$ws$naming$bootstrap$NameServerImpl == null ? (class$com$ibm$ws$naming$bootstrap$NameServerImpl = NameServerImpl.class$("com.ibm.ws.naming.bootstrap.NameServerImpl")) : class$com$ibm$ws$naming$bootstrap$NameServerImpl), (String)"Naming", (String)"com.ibm.ws.naming.util.WsnMessages");
    static final String CONFIG_WARNINGS_ISSUED = "WARNING: Name Server Configuration: Due to previous warnings it is possible the name space will not be constructed correctly";
    private static String[] CONFIG_URI_SUFFIXES;
    private static String[] PROPERTY_CONFIG_URI_SUFFIXES;
    private static boolean _restartMessageLogged;
    private ServantManager _adminServantMgr = null;
    private ConfigInfoImpl _ci = null;
    private com.ibm.CORBA.iiop.ORB _orb = null;
    private String _serverProcessType = null;
    private SecurityService _security = null;
    private String _cellName = null;
    private String _nodeName = null;
    private String _serverName = null;
    private String _serverLogRoot = null;
    private NameSpaceBuilder _nameSpaceBuilder;
    private static ObjectName _nameServerMBeanName;
    private static final String METHOD_mbeanInit = "mbeanInit()";
    static /* synthetic */ Class class$com$ibm$ws$naming$bootstrap$NameServerImpl;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Repository;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Server;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$VariableMap;
    static /* synthetic */ Class class$com$ibm$ws$management$service$Admin;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$ORB;
    static /* synthetic */ Class class$com$ibm$ws$security$service$SecurityService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize(java.lang.Object object) throws ConfigurationWarning, ConfigurationError {
        boolean bl;
        Repository repository;
        block18: {
            if (_tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)_tc, (String)"initialize");
            }
            repository = null;
            Server server = null;
            try {
                try {
                    AdminService adminService = AdminServiceFactory.getAdminService();
                    this._serverProcessType = adminService.getProcessType();
                    if (this._serverProcessType == null || this._serverProcessType.length() == 0) {
                        throw new ConfigurationError("Unable to configure Name Service. Server process type not available from AdminService");
                    }
                    repository = (Repository)this.getService(class$com$ibm$ws$runtime$service$Repository == null ? (class$com$ibm$ws$runtime$service$Repository = NameServerImpl.class$("com.ibm.ws.runtime.service.Repository")) : class$com$ibm$ws$runtime$service$Repository);
                    ConfigRoot configRoot = repository.getConfigRoot();
                    server = (Server)this.getService(class$com$ibm$ws$runtime$service$Server == null ? (class$com$ibm$ws$runtime$service$Server = NameServerImpl.class$("com.ibm.ws.runtime.service.Server")) : class$com$ibm$ws$runtime$service$Server);
                    VariableMap variableMap = null;
                    try {
                        variableMap = (VariableMap)this.getService(class$com$ibm$ws$runtime$service$VariableMap == null ? (class$com$ibm$ws$runtime$service$VariableMap = NameServerImpl.class$("com.ibm.ws.runtime.service.VariableMap")) : class$com$ibm$ws$runtime$service$VariableMap);
                        this._serverLogRoot = variableMap.expand("${LOG_ROOT}/" + server.getName());
                    }
                    finally {
                        if (variableMap != null) {
                            this.releaseService(variableMap);
                        }
                    }
                    ConfigInfoBuilder configInfoBuilder = new ConfigInfoBuilder(server, configRoot, this._serverProcessType);
                    this._ci = configInfoBuilder.buildConfigInfo();
                    bl = this._ci.validateConfiguration();
                }
                catch (ConfigurationError configurationError) {
                    FFDCFilter.processException((Throwable)configurationError, (String)"com.ibm.ws.naming.bootstrap.NameServerImpl.initialize", (String)"209", (java.lang.Object)((java.lang.Object)this));
                    Tr.exit((TraceComponent)_tc, (String)"initialize: Configuration error", (java.lang.Object)((java.lang.Object)configurationError));
                    throw configurationError;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.naming.bootstrap.NameServerImpl.initialize", (String)"210", (java.lang.Object)((java.lang.Object)this));
                    Tr.exit((TraceComponent)_tc, (String)"initialize: Unknown error", (java.lang.Object)throwable);
                    throw new ConfigurationError("Exception encountered while extracting configuration information for the Name Space", throwable);
                }
                java.lang.Object var10_12 = null;
                if (server == null) break block18;
            }
            catch (Throwable throwable) {
                java.lang.Object var10_13 = null;
                if (server != null) {
                    this.releaseService(server);
                }
                if (repository != null) {
                    this.releaseService(repository);
                }
                throw throwable;
            }
            this.releaseService(server);
        }
        if (repository != null) {
            this.releaseService(repository);
        }
        if (bl) {
            Tr.warning((TraceComponent)_tc, (String)"cfWarningsIssued1");
            if (_tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)_tc, (String)"initialize: Warnings issued.");
            }
            throw new ConfigurationWarning(CONFIG_WARNINGS_ISSUED);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (_tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"destroy");
        }
        Admin admin = null;
        try {
            admin = (Admin)this.getService(class$com$ibm$ws$management$service$Admin == null ? (class$com$ibm$ws$management$service$Admin = NameServerImpl.class$("com.ibm.ws.management.service.Admin")) : class$com$ibm$ws$management$service$Admin);
            admin.removeConfigChangeListener((ConfigChangeListener)this);
        }
        finally {
            if (admin != null) {
                this.releaseService(admin);
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"destroy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws RuntimeError, RuntimeWarning {
        block28: {
            if (_tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)_tc, (String)"start");
            }
            Admin admin = null;
            try {
                java.lang.Object object;
                ORB oRB = null;
                try {
                    oRB = (ORB)this.getService(class$com$ibm$ws$runtime$service$ORB == null ? (class$com$ibm$ws$runtime$service$ORB = NameServerImpl.class$("com.ibm.ws.runtime.service.ORB")) : class$com$ibm$ws$runtime$service$ORB);
                    if (oRB == null) {
                        throw new RuntimeError("Name Server unable to obtain ORB");
                    }
                    this._orb = oRB.getORB();
                }
                catch (Throwable throwable) {
                    this.releaseService(oRB);
                    throw throwable;
                }
                this.releaseService(oRB);
                Repository repository = null;
                try {
                    repository = (Repository)this.getService(class$com$ibm$ws$runtime$service$Repository == null ? (class$com$ibm$ws$runtime$service$Repository = NameServerImpl.class$("com.ibm.ws.runtime.service.Repository")) : class$com$ibm$ws$runtime$service$Repository);
                    object = repository.getConfigRoot();
                    if (this._serverProcessType.equals("UnManagedProcess")) {
                        this._nameSpaceBuilder = new NSBSingleAppSvr(this._ci, (ConfigRoot)object, this._orb);
                    } else if (this._serverProcessType.equals("ManagedProcess")) {
                        this._nameSpaceBuilder = new NSBManagedAppSvr(this._ci, (ConfigRoot)object, this._orb);
                    } else if (this._serverProcessType.equals("NodeAgent")) {
                        this._nameSpaceBuilder = new NSBNodeAgent(this._ci, (ConfigRoot)object, this._orb);
                    } else if (this._serverProcessType.equals("DeploymentManager")) {
                        this._nameSpaceBuilder = new NSBCellManager(this._ci, (ConfigRoot)object, this._orb);
                    } else {
                        RuntimeError runtimeError = new RuntimeError("Name Server cannot build name space for server process type = " + this._serverProcessType);
                        Tr.exit((TraceComponent)_tc, (String)"start: RuntimeError", (java.lang.Object)runtimeError);
                        throw runtimeError;
                    }
                    this._nameSpaceBuilder.buildNameSpace();
                    this.createAdminNameService();
                    this.mbeanInit();
                    this.startBootstrapService(this._nameSpaceBuilder);
                }
                catch (NameSpaceConstructionException nameSpaceConstructionException) {
                    FFDCFilter.processException((Throwable)((java.lang.Object)nameSpaceConstructionException), (String)"com.ibm.ws.naming.bootstrap.NameServerImpl.start", (String)"290", (java.lang.Object)((java.lang.Object)this));
                    Tr.exit((TraceComponent)_tc, (String)"start: NameSpaceConstructionException.  Mapping to RuntimeError.", (java.lang.Object)((java.lang.Object)nameSpaceConstructionException));
                    throw new RuntimeError("Unable to initialize the Name Service", (Throwable)((java.lang.Object)nameSpaceConstructionException));
                }
                finally {
                    if (repository != null) {
                        this.releaseService(repository);
                    }
                }
                this._security = (SecurityService)this.getService(class$com$ibm$ws$security$service$SecurityService == null ? (class$com$ibm$ws$security$service$SecurityService = NameServerImpl.class$("com.ibm.ws.security.service.SecurityService")) : class$com$ibm$ws$security$service$SecurityService);
                if (this._security != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)"saDoSecListenerReg");
                    }
                    object = new SecurityServiceListenerImpl(this._security);
                    this._security.addListener((SecurityServiceListener)object);
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"saSkipSecListenerReg");
                }
                admin = (Admin)this.getService(class$com$ibm$ws$management$service$Admin == null ? (class$com$ibm$ws$management$service$Admin = NameServerImpl.class$("com.ibm.ws.management.service.Admin")) : class$com$ibm$ws$management$service$Admin);
                admin.addConfigChangeListener((ConfigChangeListener)this);
                super.start();
                java.lang.Object var8_9 = null;
                if (admin == null) break block28;
            }
            catch (Throwable throwable) {
                java.lang.Object var8_10 = null;
                if (admin != null) {
                    this.releaseService(admin);
                }
                if (_tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)_tc, (String)"start");
                }
                throw throwable;
            }
            this.releaseService(admin);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"start");
        }
    }

    private void createAdminNameService() throws NameSpaceConstructionException {
        this._adminServantMgr = new ServantManagerImpl(this._orb, "WsnObjectAdapterAdmin", null);
        WsnDistributedNC wsnDistributedNC = new WsnDistributedNC(this._orb, this._adminServantMgr);
        try {
            this._orb.register_initial_reference("WsnAdminNameService", (Object)wsnDistributedNC);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.naming.bootstrap.NameServerImpl.createAdminNameService", (String)"451", (java.lang.Object)((java.lang.Object)this));
            throw new NameSpaceConstructionException("The initial reference \"WsnAdminNameService\" could not be registered with the ORB", exception);
        }
    }

    private synchronized void updateNameSpace(ConfigDiff configDiff) {
        block8: {
            if (_tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)_tc, (String)"updateNameSpace");
            }
            try {
                try {
                    final NameSpaceBuilder nameSpaceBuilder = this._nameSpaceBuilder;
                    final ConfigDiff configDiff2 = configDiff;
                    PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                        public java.lang.Object run() throws Exception {
                            nameSpaceBuilder.updateNameSpace(configDiff2);
                            return null;
                        }
                    };
                    SecurityContext.runAsSystem(privilegedExceptionAction);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
            }
            catch (NameSpaceConstructionException nameSpaceConstructionException) {
                if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)"updateNameSpace: An error occurred while updating the name space in response to configuration changes.", (java.lang.Object)((java.lang.Object)nameSpaceConstructionException));
                }
            }
            catch (Throwable throwable) {
                if (!_tc.isEventEnabled()) break block8;
                Tr.event((TraceComponent)_tc, (String)"updateNameSpace: An error occurred while updating the name space in response to configuration changes.", (java.lang.Object)throwable);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"updateNameSpace");
        }
    }

    private void startBootstrapService(NameSpaceBuilder nameSpaceBuilder) throws NameSpaceConstructionException {
        String string;
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"startBootstrapService");
        }
        Properties properties = new Properties();
        try {
            WsnNameServiceImpl wsnNameServiceImpl = WsnNameServiceImpl.createInstance(nameSpaceBuilder.getBootObjectProperties(), this._orb);
            string = this._orb.object_to_string((Object)wsnNameServiceImpl);
            properties.put("WsnNameService", string);
            this._orb.register_initial_reference("WsnNameService", (Object)wsnNameServiceImpl);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.naming.bootstrap.NameServerImpl.startBootstrapService", (String)"510", (java.lang.Object)((java.lang.Object)this));
            throw new NameSpaceConstructionException("Initial Service WsnNameService could not be created or could not be registered with the ORB", exception);
        }
        try {
            properties.put("NameService", nameSpaceBuilder.getCellRootIOR());
            this._orb.register_initial_reference("NameService", (Object)nameSpaceBuilder.getCellRootNC());
            properties.put("NameServiceCellRoot", nameSpaceBuilder.getCellRootIOR());
            this._orb.register_initial_reference("NameServiceCellRoot", (Object)nameSpaceBuilder.getCellRootNC());
            if (!this._ci.thisIsCellManager()) {
                properties.put("NameServiceHostRoot", nameSpaceBuilder.getNodeRootIOR());
                this._orb.register_initial_reference("NameServiceHostRoot", (Object)nameSpaceBuilder.getNodeRootNC());
                properties.put("NameServiceNodeRoot", nameSpaceBuilder.getNodeRootIOR());
                this._orb.register_initial_reference("NameServiceNodeRoot", (Object)nameSpaceBuilder.getNodeRootNC());
            } else if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"On cell manager: No node root IORs to register with ORB.");
            }
            properties.put("NameServiceServerRoot", nameSpaceBuilder.getServerRootIOR());
            this._orb.register_initial_reference("NameServiceServerRoot", (Object)nameSpaceBuilder.getServerRootNC());
            properties.put("NameServiceTreeRoot", nameSpaceBuilder.getTreeRootIOR());
            this._orb.register_initial_reference("NameServiceTreeRoot", (Object)nameSpaceBuilder.getTreeRootNC());
            properties.put("NameServiceCellPersistentRoot", nameSpaceBuilder.getCellPersistentRootIOR());
            this._orb.register_initial_reference("NameServiceCellPersistentRoot", (Object)nameSpaceBuilder.getCellPersistentRootNC());
            properties.put("NameServiceLegacyRoot", nameSpaceBuilder.getCellPersistentRootIOR());
            this._orb.register_initial_reference("NameServiceLegacyRoot", (Object)nameSpaceBuilder.getCellPersistentRootNC());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.naming.bootstrap.NameServerImpl.startBootstrapService", (String)"540", (java.lang.Object)((java.lang.Object)this));
            throw new NameSpaceConstructionException("One of the CosNaming NamingContext Initial Services could not be registered with the ORB", exception);
        }
        int n = this._orb.getBootstrapPort();
        string = this._orb.getBootstrapHost();
        try {
            this.createBootstrapServer(string, n, properties);
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.ws.naming.bootstrap.NameServerImpl.startBootstrapService", (String)"560", (java.lang.Object)((java.lang.Object)this));
            String string2 = "nsInitBootSvrErr";
            String[] stringArray = new String[]{"" + n, systemException.toString()};
            Tr.error((TraceComponent)_tc, (String)string2, (java.lang.Object)stringArray);
            NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Unable to start bootstrap server using port " + n + ". " + "Verify that no servers or other processes are already using the bootstrap server " + "port. Also verify that the bootstrap server is being started with a user ID " + "which has sufficient (e.g., root, Administrator) privileges.", systemException);
            throw nameSpaceConstructionException;
        }
        String string3 = "corbaloc:rir:/NameServiceServerRoot";
        System.setProperty("java.naming.provider.url", string3);
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"startBootstrapService");
        }
    }

    private void createBootstrapServer(String string, int n, Properties properties) {
        String string2 = string + ":" + n;
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)("Attempting to start bootstrap server on host:port = " + string2));
        }
        String string3 = this._ci.getNameServerCustomProperty("BootstrapPortEnabled");
        boolean bl = true;
        if (this._serverProcessType.equals("UnManagedProcess")) {
            if (string3.equals("false")) {
                bl = false;
            }
        } else if (string3.equals("false")) {
            String string4 = "cfNoSupportDisableBootstrap";
            Tr.warning((TraceComponent)_tc, (String)string4);
        }
        if (bl) {
            this._orb.createBootstrapServer(n, properties);
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)("Bootstrap server started, listening on host:port = " + string2));
            }
        } else if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)("Bootstrap port " + n + " has been suppressed by the setting of name server property " + "BootstrapPortEnabled" + " to false."));
        }
    }

    public void configChanged(ConfigRepositoryEvent configRepositoryEvent) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"configChanged");
        }
        ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < configChangeNotifierArray.length; ++i) {
            int n;
            String string = configChangeNotifierArray[i].getUri();
            for (n = 0; n < CONFIG_URI_SUFFIXES.length; ++n) {
                if (!string.toLowerCase().endsWith(CONFIG_URI_SUFFIXES[n])) continue;
                Tr.event((TraceComponent)_tc, (String)"Config file has changed, requiring name space update:", (java.lang.Object)string);
                bl = true;
                break;
            }
            for (n = 0; n < PROPERTY_CONFIG_URI_SUFFIXES.length; ++n) {
                if (!string.toLowerCase().endsWith(PROPERTY_CONFIG_URI_SUFFIXES[n])) continue;
                Tr.event((TraceComponent)_tc, (String)"Config file which possibly contains custom properties has changed:", (java.lang.Object)string);
                bl2 = true;
                break;
            }
            if (bl && bl2) break;
        }
        try {
            ConfigDiff configDiff = this.createConfigDiff();
            if (bl2) {
                boolean bl3 = bl = this.updateNameServerCustomProperties(configDiff) || bl;
            }
            if (bl) {
                this.updateNameSpace(configDiff);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"configChanged");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConfigDiff createConfigDiff() throws Throwable {
        ConfigDiff configDiff;
        block11: {
            if (_tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)_tc, (String)"createConfigDiff");
            }
            Repository repository = null;
            configDiff = null;
            try {
                Server server = (Server)this.getService(class$com$ibm$ws$runtime$service$Server == null ? (class$com$ibm$ws$runtime$service$Server = NameServerImpl.class$("com.ibm.ws.runtime.service.Server")) : class$com$ibm$ws$runtime$service$Server);
                repository = (Repository)this.getService(class$com$ibm$ws$runtime$service$Repository == null ? (class$com$ibm$ws$runtime$service$Repository = NameServerImpl.class$("com.ibm.ws.runtime.service.Repository")) : class$com$ibm$ws$runtime$service$Repository);
                ConfigInfoImpl configInfoImpl = null;
                try {
                    final Repository repository2 = repository;
                    final Server server2 = server;
                    PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                        public java.lang.Object run() throws Exception {
                            ConfigRoot configRoot = repository2.getConfigRoot();
                            ConfigInfoBuilder configInfoBuilder = new ConfigInfoBuilder(server2, configRoot, NameServerImpl.this._serverProcessType);
                            return configInfoBuilder.buildConfigInfo();
                        }
                    };
                    configInfoImpl = (ConfigInfoImpl)SecurityContext.runAsSystem(privilegedExceptionAction);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
                boolean bl = configInfoImpl.validateConfiguration();
                configDiff = new ConfigDiff(this._ci, configInfoImpl);
                this._ci = configInfoImpl;
                if (bl) {
                    Tr.warning((TraceComponent)_tc, (String)"cfWarningsIssued1");
                }
                if (repository == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (_tc.isEventEnabled()) {
                        Tr.event((TraceComponent)_tc, (String)"createConfigDiff:  Could not create a ConfigDiff", (java.lang.Object)throwable);
                    }
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    if (repository != null) {
                        this.releaseService(repository);
                    }
                    throw throwable2;
                }
            }
            this.releaseService(repository);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"createConfigDiff");
        }
        return configDiff;
    }

    private void mbeanInit() throws NameSpaceConstructionException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"mbeanInit");
        }
        if (_nameServerMBeanName != null) {
            if (_tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)_tc, (String)"mbeanInit: Already initialized");
            }
            return;
        }
        NameServerMBeanImpl nameServerMBeanImpl = new NameServerMBeanImpl(this._serverLogRoot);
        DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator((java.lang.Object)nameServerMBeanImpl);
        MBeanFactory mBeanFactory = AdminServiceFactory.getAdminService().getMBeanFactory();
        try {
            _nameServerMBeanName = mBeanFactory.activateMBean("NameServer", (RuntimeCollaborator)defaultRuntimeCollaborator, mBeanFactory.getConfigId((java.lang.Object)"NameServer"), "com/ibm/ws/management/descriptor/xml/NameServer.xml");
            if (_nameServerMBeanName == null) {
                NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Received a null object name from MBeanFactory.activateMBean.");
                throw nameSpaceConstructionException;
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Created MBean: ObjectName=" + _nameServerMBeanName.toString()));
            }
        }
        catch (AdminException adminException) {
            NameSpaceConstructionException nameSpaceConstructionException = new NameSpaceConstructionException("Received an error activating MBean.", adminException);
            if (_tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)_tc, (String)"mbeanInit: Throwing NameSpaceConstructionException:", (java.lang.Object)((java.lang.Object)nameSpaceConstructionException));
            }
            throw nameSpaceConstructionException;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"mbeanInit");
        }
    }

    private boolean updateNameServerCustomProperties(ConfigDiff configDiff) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"updateNameServerCustomProperties");
        }
        ConfigInfo configInfo = configDiff.getOldConfig();
        ConfigInfo configInfo2 = configDiff.getNewConfig();
        if (configInfo == null || configInfo2 == null) {
            if (_tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)_tc, (String)"updateNameServerCustomProperties", (java.lang.Object)"updateNameSpace=false");
            }
            return false;
        }
        boolean bl = false;
        String string = "BootstrapPortEnabled";
        if (!configInfo.getNameServerCustomProperty(string).equals(configInfo2.getNameServerCustomProperty(string))) {
            String string2 = "cfPropChangedSvrRestart";
            String string3 = string;
            Tr.warning((TraceComponent)_tc, (String)string2, (java.lang.Object)string3);
        }
        if (!configInfo.getNameServerCustomProperty(string = "naming.systemNameSpace.scope").equals(configInfo2.getNameServerCustomProperty(string))) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"Name space scope changed.  Need to update name space.");
            }
            bl = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"updateNameServerCustomProperties", (java.lang.Object)("updateNameSpace=" + bl));
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)"SOURCE CODE INFO: ws/code/naming.server/src/com/ibm/ws/naming/bootstrap/NameServerImpl.java, WAS.naming.server, ASV51X, a0425.05, ver. 1.78.1.1");
        }
        CONFIG_URI_SUFFIXES = new String[]{"/serverindex.xml", "/cluster.xml", "/namebindings.xml", "/cell.xml"};
        PROPERTY_CONFIG_URI_SUFFIXES = new String[]{"/server.xml", "/node.xml"};
        _restartMessageLogged = false;
        _nameServerMBeanName = null;
    }
}

