/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.bootstrap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.role.RoleBasedAppException;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.service.SecurityServiceEvent;
import com.ibm.ws.security.service.SecurityServiceListener;

public class SecurityServiceListenerImpl
implements SecurityServiceListener {
    private static final TraceComponent _tc = Tr.register((Class)(class$com$ibm$ws$naming$bootstrap$SecurityServiceListenerImpl == null ? (class$com$ibm$ws$naming$bootstrap$SecurityServiceListenerImpl = SecurityServiceListenerImpl.class$("com.ibm.ws.naming.bootstrap.SecurityServiceListenerImpl")) : class$com$ibm$ws$naming$bootstrap$SecurityServiceListenerImpl), (String)"Naming", (String)"com.ibm.ws.naming.util.WsnMessages");
    private static RoleBasedAuthorizer _securityAuthorizer;
    private static SecurityService _secService;
    private static boolean _isInitialized;
    static /* synthetic */ Class class$com$ibm$ws$naming$bootstrap$SecurityServiceListenerImpl;

    protected SecurityServiceListenerImpl(SecurityService securityService) {
        _secService = securityService;
    }

    public void stateChanged(SecurityServiceEvent securityServiceEvent) {
        Tr.entry((TraceComponent)_tc, (String)"stateChanged");
        int n = securityServiceEvent.getState();
        if (n == 1) {
            this.initializeSecurityAuthorizer();
        } else if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("Security service state change to: " + n));
        }
    }

    public static RoleBasedAuthorizer getSecurityAuthorizer() throws RoleBasedAppException {
        if (!_isInitialized) {
            throw new RoleBasedAppException("Naming RoleBasedAuthorizer has no been initialized.");
        }
        return _securityAuthorizer;
    }

    private void initializeSecurityAuthorizer() {
        Object object;
        Tr.entry((TraceComponent)_tc, (String)"initializeSecurityAuthorizer");
        if (_securityAuthorizer != null) {
            Tr.exit((TraceComponent)_tc, (String)"initializeSecurityAuthorizer: already initialized");
            return;
        }
        RoleBasedAuthorizer roleBasedAuthorizer = null;
        try {
            object = _secService.getConfigurator();
            roleBasedAuthorizer = object.loadSecurityPolicy("naming-authz", "/com/ibm/ws/naming/bootstrap/xml/NameServer.xml", "domain");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.naming.bootstrap.SecurityServiceListenerImpl.initializeSecurityAuthorizer", (String)"100");
            String string = "Caught exception trying to get authorizer: " + exception;
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Attempt to get authorizer failed: " + string));
            }
            Tr.exit((TraceComponent)_tc, (String)"initializeSecurityAuthorizer: exception caught");
            return;
        }
        _securityAuthorizer = roleBasedAuthorizer;
        if (roleBasedAuthorizer == null) {
            object = "Failed to initialize RoleBasedAuthorization.";
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Attempt to get authorizer failed: " + (String)object));
            }
            Tr.exit((TraceComponent)_tc, (String)("initializeSecurityAuthorizer: " + (String)object));
            return;
        }
        _isInitialized = true;
        Tr.exit((TraceComponent)_tc, (String)"initializeSecurityAuthorizer: completed successfully");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)"SOURCE CODE INFO: ws/code/naming.server/src/com/ibm/ws/naming/bootstrap/SecurityServiceListenerImpl.java, WAS.naming.server, ASV51X, a0425.05, ver. 1.6");
        }
        _securityAuthorizer = null;
        _secService = null;
        _isInitialized = false;
    }
}

