/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.distcos;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.distcos.PersistentNCOperationInfo;
import com.ibm.ws.naming.distcos.PersistentUpdateServerNotifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.management.ObjectName;

class PersistentUpdateDispatcher {
    private static final TraceComponent _tc = Tr.register((Class)(class$com$ibm$ws$naming$distcos$PersistentUpdateDispatcher == null ? (class$com$ibm$ws$naming$distcos$PersistentUpdateDispatcher = PersistentUpdateDispatcher.class$("com.ibm.ws.naming.distcos.PersistentUpdateDispatcher")) : class$com$ibm$ws$naming$distcos$PersistentUpdateDispatcher), (String)"Naming", (String)"com.ibm.ws.naming.util.WsnMessages");
    private String _processType;
    private HashMap _notifierThreads = new HashMap();
    private boolean _checkForInactiveNotifiers = false;
    static /* synthetic */ Class class$com$ibm$ws$naming$distcos$PersistentUpdateDispatcher;

    PersistentUpdateDispatcher(String string) {
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)"PersistentUpdateDispatcher", (Object)("processType=" + string));
        }
        this._processType = string;
    }

    synchronized void dispatchUpdate(PersistentNCOperationInfo persistentNCOperationInfo, Set set) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"dispatchUpdate", (Object)persistentNCOperationInfo);
        }
        String string = persistentNCOperationInfo.getOriginID();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            PersistentUpdateServerNotifier persistentUpdateServerNotifier;
            ObjectName objectName = (ObjectName)iterator.next();
            String string2 = objectName.getKeyProperty("WsnSlaveProcType");
            if (string2.equals(this._processType)) {
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)_tc, (String)("dispatchUpdate: Skipping MBean (node agent itself): ObjectName=" + objectName.toString()));
                continue;
            }
            String string3 = objectName.getKeyProperty("WsnSlaveID");
            if (string3.equals(string) && !string2.equals("NodeAgent")) {
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)_tc, (String)("dispatchUpdate: Skipping MBean (originator): ObjectName=" + objectName.toString()));
                continue;
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("dispatchUpdate: Invoking MBean: ObjectName=" + objectName.toString()));
            }
            if ((persistentUpdateServerNotifier = this.getNotifier(string3)) == null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"dispatchUpdate: Creating new notifier.");
                }
                persistentUpdateServerNotifier = new PersistentUpdateServerNotifier(this, string3, objectName);
                this._notifierThreads.put(string3, persistentUpdateServerNotifier);
            }
            persistentUpdateServerNotifier.queueUpOperation(persistentNCOperationInfo);
        }
        this.removeInactiveNotifiers();
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"dispatchUpdate");
        }
    }

    private void removeInactiveNotifiers() {
        if (this._checkForInactiveNotifiers) {
            this._checkForInactiveNotifiers = false;
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"Checking for inactive notifiers.");
            }
            Collection collection = this._notifierThreads.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                PersistentUpdateServerNotifier persistentUpdateServerNotifier = (PersistentUpdateServerNotifier)iterator.next();
                String string = persistentUpdateServerNotifier.getNotifierKey();
                if (!persistentUpdateServerNotifier.killIfInactive()) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("Removing notifier: " + string));
                }
                iterator.remove();
            }
        }
    }

    public void signalInactivity(String string) {
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)"Inactivity signaled.", (Object)("destID=" + string));
        }
        this._checkForInactiveNotifiers = true;
    }

    private PersistentUpdateServerNotifier getNotifier(String string) {
        PersistentUpdateServerNotifier persistentUpdateServerNotifier = (PersistentUpdateServerNotifier)this._notifierThreads.get(string);
        return persistentUpdateServerNotifier;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

