/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.mbean;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.naming.DumpNameSpace;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ContainerComponentMetaData;
import com.ibm.ws.runtime.service.MetaDataFactoryMgr;
import com.ibm.ws.runtime.service.MetaDataService;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class NameServerMBeanImpl {
    private static final TraceComponent _tc = Tr.register((Class)(class$com$ibm$ws$naming$mbean$NameServerMBeanImpl == null ? (class$com$ibm$ws$naming$mbean$NameServerMBeanImpl = NameServerMBeanImpl.class$("com.ibm.ws.naming.mbean.NameServerMBeanImpl")) : class$com$ibm$ws$naming$mbean$NameServerMBeanImpl), (String)"Naming", (String)"com.ibm.websphere.naming.DumpNameSpaceMessages");
    private static ResourceBundle _msgs;
    private static final String PARAM_PREFIX = "-";
    private static final String LOCAL_NAMESPACE_ROOT = "local:";
    private static final String DIST_NAMESPACE_ROOT = "";
    private static final String CORBALOC_URL = "corbaloc:rir:/";
    private int _reportForm = 1;
    private String _startAt = null;
    private String _format = "jndi";
    private String _urlKey = "NameServiceCellRoot";
    private String _logFile;
    private static final String METHOD_dumpJavaNameSpace = "dumpJavaNameSpace()";
    private static final String METHOD_dumpLocalNameSpace = "dumpLocalNameSpace()";
    private static final String METHOD_dumpServerNameSpace = "dumpServerNameSpace()";
    private static final String METHOD_dumpNameSpace = "dumpNameSpace()";
    static /* synthetic */ Class class$com$ibm$ws$naming$mbean$NameServerMBeanImpl;

    private NameServerMBeanImpl() {
    }

    public NameServerMBeanImpl(String string) {
        this._logFile = string + "/DumpNameSpace.log";
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("*** NameServerMBeanImpl() log file: " + this._logFile));
        }
        if (_msgs == null) {
            _msgs = ResourceBundle.getBundle("com.ibm.websphere.naming.DumpNameSpaceMessages");
        }
    }

    public synchronized String[] dumpJavaNameSpace(String string, String string2, String string3, String string4) {
        String[] stringArray;
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)METHOD_dumpJavaNameSpace);
        }
        MetaDataService metaDataService = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string5 = DIST_NAMESPACE_ROOT;
        try {
            stringArray = new InitialContext();
            metaDataService = (MetaDataService)stringArray.lookup("services:websphere/MetaData");
        }
        catch (NamingException namingException) {
            string5 = "*** dumpJavaNameSpace() got naming exception during MetaDataService lookup: " + namingException;
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)string5);
            }
            arrayList.add(string5);
        }
        if (metaDataService != null) {
            ComponentMetaData componentMetaData;
            stringArray = (MetaDataFactoryMgr)metaDataService;
            J2EEName j2EEName = stringArray.getJ2EENameFactory().create(string, string2, string3);
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("*** dumpJavaNameSpace() " + j2EEName.toString() + " options=" + string4));
            }
            if ((componentMetaData = metaDataService.getComponentMetaData(j2EEName)) != null) {
                if (componentMetaData instanceof ContainerComponentMetaData) {
                    ContainerComponentMetaData containerComponentMetaData = (ContainerComponentMetaData)componentMetaData;
                    if (this.parseOptions(METHOD_dumpJavaNameSpace, string4, arrayList)) {
                        Context context = null;
                        if (this._startAt != null && this._startAt.length() != 0) {
                            try {
                                context = (Context)containerComponentMetaData.getJavaNameSpaceContext().lookup(this._startAt);
                            }
                            catch (Exception exception) {
                                string5 = "*** dumpJavaNameSpace() got unexpected exception during startAt lookup: " + exception;
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)_tc, (String)string5);
                                }
                                arrayList.add(string5);
                            }
                        } else {
                            context = containerComponentMetaData.getJavaNameSpaceContext();
                        }
                        if (context != null && this.writeResult(METHOD_dumpJavaNameSpace, context, arrayList)) {
                            this.readResult(METHOD_dumpJavaNameSpace, arrayList);
                        }
                    }
                } else {
                    string5 = "*** dumpJavaNameSpace() ComponentMetaData not correct type.";
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)string5);
                    }
                    arrayList.add(string5);
                }
            } else {
                string5 = "*** dumpJavaNameSpace() ComponentMetaData not found.";
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)string5);
                }
                arrayList.add(string5);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"dumpJavaNameSpace()\n");
        }
        if (arrayList.size() > 0) {
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return stringArray;
        }
        return new String[0];
    }

    public synchronized String[] dumpLocalNameSpace(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)METHOD_dumpLocalNameSpace);
        }
        return this.dumpNameSpace(METHOD_dumpLocalNameSpace, LOCAL_NAMESPACE_ROOT, string);
    }

    public synchronized String[] dumpServerNameSpace(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)METHOD_dumpServerNameSpace);
        }
        return this.dumpNameSpace(METHOD_dumpServerNameSpace, DIST_NAMESPACE_ROOT, string);
    }

    private String[] dumpNameSpace(String string, String string2, String string3) {
        String[] stringArray;
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)("dumpNameSpace(), root=" + string2));
        }
        Context context = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string4 = DIST_NAMESPACE_ROOT;
        if (this.parseOptions(string, string3, arrayList)) {
            Context context2;
            stringArray = CORBALOC_URL + this._urlKey;
            String string5 = "com.ibm.websphere.naming.WsnInitialContextFactory";
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("dumpNameSpace(), provider URL=" + (String)stringArray));
            }
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("java.naming.provider.url", stringArray);
            hashtable.put("java.naming.factory.initial", string5);
            hashtable.put("com.ibm.websphere.naming.name.syntax", this._format);
            hashtable.put("com.ibm.websphere.naming.namespace.connection", "eager");
            try {
                context2 = new InitialContext(hashtable);
                context = (Context)context2.lookup(string2);
            }
            catch (Exception exception) {
                string4 = "*** dumpNameSpace() got naming exception during \"" + string + "\" name space lookup: " + exception;
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)string4);
                }
                arrayList.add(string4);
            }
            if (context != null) {
                context2 = null;
                if (this._startAt != null && this._startAt.length() != 0) {
                    try {
                        context2 = (Context)context.lookup(this._startAt);
                    }
                    catch (Exception exception) {
                        string4 = "*** dumpNameSpace() got naming exception during startAt lookup: " + exception;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)string4);
                        }
                        arrayList.add(string4);
                    }
                } else {
                    context2 = context;
                }
                if (context2 != null && this.writeResult(METHOD_dumpNameSpace, context2, arrayList)) {
                    this.readResult(METHOD_dumpNameSpace, arrayList);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"dumpNameSpace()\n");
        }
        if (arrayList.size() > 0) {
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return stringArray;
        }
        return new String[0];
    }

    private boolean parseOptions(String string, String string2, ArrayList arrayList) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)("parseOptions: options=" + string2));
        }
        this._reportForm = 1;
        this._startAt = null;
        this._format = "jndi";
        this._urlKey = "NameServiceCellRoot";
        boolean bl = true;
        boolean bl2 = false;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (bl2 || stringTokenizer.hasMoreTokens()) {
            if (!bl2) {
                string3 = stringTokenizer.nextToken();
            } else {
                bl2 = false;
            }
            if (string3.equals("-report")) {
                if (stringTokenizer.hasMoreTokens()) {
                    string5 = stringTokenizer.nextToken();
                    if (string5.startsWith(PARAM_PREFIX)) {
                        bl2 = true;
                        string3 = string5;
                        continue;
                    }
                    if (string5.toLowerCase().equals("short")) {
                        this._reportForm = 1;
                        continue;
                    }
                    if (string5.toLowerCase().equals("long")) {
                        this._reportForm = 2;
                        continue;
                    }
                    arrayList.add(NameServerMBeanImpl.fmtMsg("reportOptBad"));
                    continue;
                }
                arrayList.add(NameServerMBeanImpl.fmtMsg("reportOptBad"));
                continue;
            }
            if (string3.equals("-startAt")) {
                if (!stringTokenizer.hasMoreTokens()) continue;
                string5 = stringTokenizer.nextToken();
                if (string5.startsWith(PARAM_PREFIX)) {
                    bl2 = true;
                    string3 = string5;
                    continue;
                }
                this._startAt = string5;
                continue;
            }
            if (string3.equals("-root")) {
                if (!string.equals(METHOD_dumpServerNameSpace)) {
                    arrayList.add(NameServerMBeanImpl.fmtMsg("optionBad") + " " + string3);
                    bl = false;
                    break;
                }
                if (!stringTokenizer.hasMoreTokens()) continue;
                string5 = stringTokenizer.nextToken();
                if (string5.startsWith(PARAM_PREFIX)) {
                    bl2 = true;
                    string3 = string5;
                    continue;
                }
                string4 = string5.toLowerCase();
                if (string4.equals("tree")) {
                    this._urlKey = "NameServiceTreeRoot";
                    continue;
                }
                if (string4.equals("host")) {
                    this._urlKey = "NameServiceHostRoot";
                    continue;
                }
                if (string4.equals("legacy")) {
                    this._urlKey = "NameServiceLegacyRoot";
                    continue;
                }
                if (string4.equals("node")) {
                    this._urlKey = "NameServiceNodeRoot";
                    continue;
                }
                if (string4.equals("server")) {
                    this._urlKey = "NameServiceServerRoot";
                    continue;
                }
                if (string4.equals("cell")) {
                    this._urlKey = "NameServiceCellRoot";
                    continue;
                }
                if (string4.equals("default")) {
                    this._urlKey = "NameService";
                    continue;
                }
                arrayList.add(NameServerMBeanImpl.fmtMsg("treeOptBad"));
                bl = false;
                break;
            }
            if (string3.equals("-format")) {
                if (!string.equals(METHOD_dumpServerNameSpace)) {
                    arrayList.add(NameServerMBeanImpl.fmtMsg("optionBad") + " " + string3);
                    bl = false;
                    break;
                }
                if (!stringTokenizer.hasMoreTokens()) continue;
                string5 = stringTokenizer.nextToken();
                if (string5.startsWith(PARAM_PREFIX)) {
                    bl2 = true;
                    string3 = string5;
                    continue;
                }
                if (string5.equals("jndi") || string5.equals("ins")) {
                    this._format = string5;
                    continue;
                }
                arrayList.add(NameServerMBeanImpl.fmtMsg("formatOptBad", new String[]{"jndi", "ins"}));
                bl = false;
                break;
            }
            arrayList.add(NameServerMBeanImpl.fmtMsg("optionBad") + " " + string3);
            bl = false;
            break;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)("parseOptions: returned " + (bl ? "true" : "false") + ", report=" + this._reportForm + ", startAt=" + this._startAt + ", root=" + string4 + ", format=" + this._format));
        }
        return bl;
    }

    private boolean writeResult(String string, Context context, ArrayList arrayList) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)("writeResult: caller=" + string));
        }
        FileOutputStream fileOutputStream = null;
        PrintStream printStream = null;
        boolean bl = true;
        try {
            fileOutputStream = new FileOutputStream(this._logFile);
            printStream = new PrintStream(fileOutputStream);
            DumpNameSpace dumpNameSpace = new DumpNameSpace(printStream, this._reportForm);
            dumpNameSpace.generateDump(context);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            arrayList.add("*** " + string + " - Cannot write to log file \"" + this._logFile + "\".");
            bl = false;
        }
        catch (SecurityException securityException) {
            arrayList.add("*** " + string + " - Access denies when writing to log file \"" + this._logFile + "\".");
            bl = false;
        }
        catch (IOException iOException) {
            arrayList.add("*** " + string + " - Got unexpected IOException: " + iOException);
            bl = false;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)("writeResult: returned " + (bl ? "true" : "false")));
        }
        return bl;
    }

    private boolean readResult(String string, ArrayList arrayList) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)("readResult: caller=" + string));
        }
        BufferedReader bufferedReader = null;
        FileInputStream fileInputStream = null;
        boolean bl = true;
        try {
            String string2;
            fileInputStream = new FileInputStream(this._logFile);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            while ((string2 = bufferedReader.readLine()) != null) {
                arrayList.add(string2);
            }
            fileInputStream.close();
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            arrayList.add("*** " + string + " - Cannot read from log file \"" + this._logFile + "\".");
            bl = false;
        }
        catch (SecurityException securityException) {
            arrayList.add("*** " + string + " - Access denies when reading from log file \"" + this._logFile + "\".");
            bl = false;
        }
        catch (IOException iOException) {
            arrayList.add("*** " + string + " - Got unexpected IOException: " + iOException);
            bl = false;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)("readResult: returned " + (bl ? "true" : "false")));
        }
        return bl;
    }

    private static String fmtMsg(String string) {
        String string2 = null;
        try {
            if (_msgs != null) {
                return MessageFormat.format(_msgs.getString(string), null);
            }
            string2 = "Message table not found.";
        }
        catch (MissingResourceException missingResourceException) {
            string2 = "Message or message table not found.";
        }
        return string2;
    }

    private static String fmtMsg(String string, String[] stringArray) {
        String string2 = null;
        try {
            if (_msgs != null) {
                return MessageFormat.format(_msgs.getString(string), stringArray);
            }
            string2 = "Message table not found.";
        }
        catch (MissingResourceException missingResourceException) {
            string2 = "Message or message table not found.";
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)"SOURCE CODE INFO: ws/code/naming.server/src/com/ibm/ws/naming/mbean/NameServerMBeanImpl.java, WAS.naming.server, ASV51X, a0425.05, ver. 1.10");
        }
        _msgs = null;
    }
}

