/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.math.BigInteger;
import java.security.ProviderException;
import java.security.interfaces.DSAParams;

public final class AlgIdDSA
extends AlgorithmId
implements DSAParams {
    private BigInteger p;
    private BigInteger q;
    private BigInteger g;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.AlgIdDSA";

    public BigInteger getP() {
        if (debug != null) {
            debug.entry(16384L, className, "getP");
            debug.exit(16384L, (Object)className, "getP", this.p);
        }
        return this.p;
    }

    public BigInteger getQ() {
        if (debug != null) {
            debug.entry(16384L, className, "getQ");
            debug.exit(16384L, (Object)className, "getQ", this.q);
        }
        return this.q;
    }

    public BigInteger getG() {
        if (debug != null) {
            debug.entry(16384L, className, "getG");
            debug.exit(16384L, (Object)className, "getG", this.g);
        }
        return this.g;
    }

    AlgIdDSA(DerValue derValue) throws IOException {
        super(derValue.getOID());
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AlgIdDSA", derValue);
            debug.exit(16384L, className, "AlgIdDSA");
        }
    }

    public AlgIdDSA(byte[] byArray) throws IOException {
        super(new DerValue(byArray).getOID());
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AlgIdDSA", (Object)byArray);
            debug.exit(16384L, className, "AlgIdDSA");
        }
    }

    public AlgIdDSA(byte[] byArray, byte[] byArray2, byte[] byArray3) throws IOException {
        this(new BigInteger(1, byArray), new BigInteger(1, byArray2), new BigInteger(1, byArray3));
        if (debug != null) {
            Object[] objectArray = new Object[]{byArray, byArray2, byArray3};
            debug.entry(16384L, (Object)className, "AlgIdDSA", objectArray);
            debug.exit(16384L, className, "AlgIdDSA");
        }
    }

    public AlgIdDSA(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        super(DSA_oid);
        if (debug != null) {
            Object[] objectArray = new Object[]{bigInteger, bigInteger2, bigInteger3};
            debug.entry(16384L, (Object)className, "AlgIdDSA", objectArray);
        }
        try {
            this.p = bigInteger;
            this.q = bigInteger2;
            this.g = bigInteger3;
            this.initializeParams();
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, className, "AlgIdDSA", iOException);
            }
            throw new ProviderException("Construct DSS/DSA Algorithm ID");
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgIdDSA");
        }
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", "DSA");
        }
        return "DSA";
    }

    private void initializeParams() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (debug != null) {
            debug.entry(8192L, className, "initializeParams");
        }
        derOutputStream.putInteger(this.p);
        derOutputStream.putInteger(this.q);
        derOutputStream.putInteger(this.g);
        this.params = new DerValue(48, derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(8192L, className, "initializeParams");
        }
    }

    protected void decodeParams() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "decodeParams");
        }
        if (this.params == null || this.params.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decodeParams", "DSA alg parsing error");
            }
            throw new IOException("DSA alg parsing error");
        }
        this.params.getData().reset();
        this.p = this.params.getData().getInteger();
        this.q = this.params.getData().getInteger();
        this.g = this.params.getData().getInteger();
        if (this.params.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "decodeParams", "AlgIdDSA params, data overrun=" + this.params.getData().available());
            }
            throw new IOException("AlgIdDSA params, data overrun=" + this.params.getData().available());
        }
        if (debug != null) {
            debug.exit(16384L, className, "decodeParams");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", this.paramsToString());
        }
        return this.paramsToString();
    }

    protected String paramsToString() {
        if (debug != null) {
            debug.entry(16384L, className, "paramsToString");
            debug.exit(16384L, (Object)className, "paramsToString", "\n    p:\n" + this.p.toString() + "\n    q:\n" + this.q.toString() + "\n    g:\n" + this.g.toString() + "\n");
        }
        return "\n    p:\n" + this.p.toString() + "\n    q:\n" + this.q.toString() + "\n    g:\n" + this.g.toString() + "\n";
    }
}

