/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X500Name;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.Signer;

class X500Signer
extends Signer {
    private Signature sig;
    private X500Name agent;
    private AlgorithmId algid;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.X500Signer";

    public void update(byte[] byArray, int n, int n2) throws SignatureException {
        if (debug != null) {
            Object[] objectArray = new Object[]{byArray, new Integer(n), new Integer(n2)};
            debug.entry(16384L, (Object)className, "update", objectArray);
        }
        this.sig.update(byArray, n, n2);
        if (debug != null) {
            debug.exit(16384L, className, "update");
        }
    }

    public byte[] sign() throws SignatureException {
        if (debug != null) {
            debug.entry(16384L, className, "sign");
        }
        byte[] byArray = this.sig.sign();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "sign", byArray);
        }
        return byArray;
    }

    public AlgorithmId getAlgorithmId() {
        if (debug != null) {
            debug.entry(16384L, className, "getAlgorithmId");
            debug.exit(16384L, (Object)className, "getAlgorithmId", this.algid);
        }
        return this.algid;
    }

    public X500Name getSigner() {
        if (debug != null) {
            debug.entry(16384L, className, "getSigner");
            debug.exit(16384L, (Object)className, "getSigner", this.agent);
        }
        return this.agent;
    }

    public X500Signer(Signature signature, X500Name x500Name) {
        if (debug != null) {
            debug.entry(16384L, className, "X500Signer", signature, x500Name);
        }
        if (signature == null || x500Name == null) {
            if (debug != null) {
                debug.text(16384L, className, "X500Signer", "null parameter");
            }
            throw new IllegalArgumentException("null parameter");
        }
        this.sig = signature;
        this.agent = x500Name;
        try {
            this.algid = AlgorithmId.getAlgorithmId(signature.getAlgorithm());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(16384L, className, "X500Signer", noSuchAlgorithmException);
                debug.text(16384L, className, "X500Signer", "internal error! " + noSuchAlgorithmException.getMessage());
            }
            throw new RuntimeException("internal error! " + noSuchAlgorithmException.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, className, "X500Signer");
        }
    }
}

