/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.CRLExtensions;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.SerialNumber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public final class X509CRLEntryImpl
extends X509CRLEntry {
    private SerialNumber serialNumber = null;
    private Date revocationDate = null;
    private CRLExtensions extensions = null;
    private byte[] revokedCert = null;
    private static final boolean isExplicit = false;
    private static final long YR_2050 = 2524636800000L;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.X509CRLEntryImpl";

    private X509CRLEntryImpl() {
        if (debug != null) {
            debug.entry(16384L, className, "X509CRLEntryImpl");
            debug.exit(16384L, className, "X509CRLEntryImpl");
        }
    }

    public X509CRLEntryImpl(BigInteger bigInteger, Date date) {
        if (debug != null) {
            debug.entry(16384L, className, "X509CRLEntryImpl", bigInteger, date);
        }
        this.serialNumber = new SerialNumber(bigInteger);
        this.revocationDate = date != null ? new Date(date.getTime()) : date;
        if (debug != null) {
            debug.exit(16384L, className, "X509CRLEntryImpl");
        }
    }

    public X509CRLEntryImpl(BigInteger bigInteger, Date date, CRLExtensions cRLExtensions) {
        if (debug != null) {
            Object[] objectArray = new Object[]{bigInteger, date, cRLExtensions};
            debug.entry(16384L, (Object)className, "X509CRLEntryImpl", objectArray);
        }
        this.serialNumber = new SerialNumber(bigInteger);
        this.revocationDate = date != null ? new Date(date.getTime()) : date;
        this.extensions = cRLExtensions;
        if (debug != null) {
            debug.exit(16384L, className, "X509CRLEntryImpl");
        }
    }

    public X509CRLEntryImpl(byte[] byArray) throws CRLException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509CRLEntryImpl", (Object)byArray);
        }
        try {
            this.parse(new DerValue(byArray));
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, className, "X509CRLEntryImpl", iOException);
            }
            this.revokedCert = null;
            throw new CRLException("Parsing error: " + iOException.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CRLEntryImpl");
        }
    }

    public X509CRLEntryImpl(DerValue derValue) throws CRLException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509CRLEntryImpl", derValue);
        }
        try {
            this.parse(derValue);
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, className, "X509CRLEntryImpl", iOException);
            }
            this.revokedCert = null;
            throw new CRLException("Parsing error: " + iOException.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CRLEntryImpl");
        }
    }

    public boolean hasExtensions() {
        if (debug != null) {
            debug.entry(16384L, className, "hasExtensions");
        }
        boolean bl = false;
        if (this.extensions != null) {
            bl = true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasExtensions", new Boolean(bl));
        }
        return bl;
    }

    public void encode(DerOutputStream derOutputStream) throws CRLException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", derOutputStream);
        }
        try {
            if (this.revokedCert == null) {
                DerOutputStream derOutputStream2 = new DerOutputStream();
                this.serialNumber.encode(derOutputStream2);
                if (this.revocationDate.getTime() < 2524636800000L) {
                    derOutputStream2.putUTCTime(this.revocationDate);
                } else {
                    derOutputStream2.putGeneralizedTime(this.revocationDate);
                }
                if (this.extensions != null) {
                    this.extensions.encode(derOutputStream2, false);
                }
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.write((byte)48, derOutputStream2);
                this.revokedCert = derOutputStream3.toByteArray();
            }
            derOutputStream.write(this.revokedCert);
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, className, "encode", iOException);
            }
            throw new CRLException("Encoding error: " + iOException.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public byte[] getEncoded() throws CRLException {
        if (debug != null) {
            debug.entry(16384L, className, "getEncoded");
        }
        if (this.revokedCert == null) {
            this.encode(new DerOutputStream());
        }
        byte[] byArray = (byte[])this.revokedCert.clone();
        if (debug != null) {
            debug.exit(16384L, className, "getEncoded");
        }
        return byArray;
    }

    public BigInteger getSerialNumber() {
        if (debug != null) {
            debug.entry(16384L, className, "getSerialNumber");
            debug.exit(16384L, (Object)className, "getSerialNumber", this.serialNumber.getNumber());
        }
        return this.serialNumber.getNumber();
    }

    public Date getRevocationDate() {
        if (debug != null) {
            debug.entry(16384L, className, "getRevocationDate");
            debug.exit(16384L, (Object)className, "getRevocationDate", new Date(this.revocationDate.getTime()));
        }
        return new Date(this.revocationDate.getTime());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.serialNumber.toString());
        stringBuffer.append("  On: " + this.revocationDate.toString());
        if (this.extensions != null) {
            Collection collection = this.extensions.getAllExtensions();
            Object[] objectArray = collection.toArray();
            stringBuffer.append("\n    CRL Entry Extensions: " + objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append("\n    [" + (i + 1) + "]: ");
                Extension extension = (Extension)objectArray[i];
                try {
                    if (OIDMap.getClass(extension.getExtensionId()) == null) {
                        stringBuffer.append(extension.toString());
                        byte[] byArray = extension.getExtensionValue();
                        if (byArray == null) continue;
                        DerOutputStream derOutputStream = new DerOutputStream();
                        derOutputStream.putOctetString(byArray);
                        byArray = derOutputStream.toByteArray();
                        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                        stringBuffer.append("Extension unknown: DER encoded OCTET string =\n" + hexDumpEncoder.encodeBuffer(byArray) + "\n");
                        continue;
                    }
                    stringBuffer.append(extension.toString());
                    continue;
                }
                catch (Exception exception) {
                    stringBuffer.append(", Error parsing this extension");
                }
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public boolean hasUnsupportedCriticalExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "hasUnsupportedCriticalExtension");
        }
        boolean bl = false;
        if (this.extensions != null) {
            bl = this.extensions.hasUnsupportedCriticalExtension();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasUnsupportedCriticalExtension", new Boolean(bl));
        }
        return bl;
    }

    public Set getCriticalExtensionOIDs() {
        if (debug != null) {
            debug.entry(16384L, className, "getCriticalExtensionOIDs");
        }
        if (this.extensions == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCriticalExtensionOIDs_1", null);
            }
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>(11);
        Enumeration enumeration = this.extensions.getElements();
        while (enumeration.hasMoreElements()) {
            Extension extension = (Extension)enumeration.nextElement();
            if (!extension.isCritical()) continue;
            hashSet.add(extension.getExtensionId().toString());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCriticalExtensionOIDs", hashSet);
        }
        return hashSet;
    }

    public Set getNonCriticalExtensionOIDs() {
        if (debug != null) {
            debug.entry(16384L, className, "getNonCriticalExtensionOIDs");
        }
        if (this.extensions == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getNonCriticalExtensionOIDs_1", null);
            }
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>(11);
        Enumeration enumeration = this.extensions.getElements();
        while (enumeration.hasMoreElements()) {
            Extension extension = (Extension)enumeration.nextElement();
            if (extension.isCritical()) continue;
            hashSet.add(extension.getExtensionId().toString());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getNonCriticalExtensionOIDs", hashSet);
        }
        return hashSet;
    }

    public byte[] getExtensionValue(String string) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getExtensionValue", string);
        }
        if (this.extensions == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getExtensionValue_1", null);
            }
            return null;
        }
        try {
            Object object;
            Object object2;
            Object object3;
            String string2 = OIDMap.getName(new ObjectIdentifier(string));
            Object object4 = null;
            if (string2 == null) {
                object3 = new ObjectIdentifier(string);
                object2 = null;
                Enumeration enumeration = this.extensions.getElements();
                while (enumeration.hasMoreElements()) {
                    object2 = (Extension)enumeration.nextElement();
                    object = ((Extension)object2).getExtensionId();
                    if (!((ObjectIdentifier)object).equals((ObjectIdentifier)object3)) continue;
                    object4 = object2;
                    break;
                }
            } else {
                object4 = this.extensions.get(string2);
            }
            if (object4 == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getExtensionValue_2", null);
                }
                return null;
            }
            object3 = ((Extension)object4).getExtensionValue();
            if (object3 == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getExtensionValue_3", null);
                }
                return null;
            }
            object2 = new DerOutputStream();
            ((DerOutputStream)object2).putOctetString((byte[])object3);
            object = ((ByteArrayOutputStream)object2).toByteArray();
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getExtensionValue", object);
            }
            return object;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "getExtensionValue", exception);
                debug.exit(16384L, (Object)className, "getExtensionValue_4", null);
            }
            return null;
        }
    }

    private void parse(DerValue derValue) throws CRLException, IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "parse", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(8192L, className, "parse", "Invalid encoded RevokedCertificate, starting sequence tag missing.");
            }
            throw new CRLException("Invalid encoded RevokedCertificate, starting sequence tag missing.");
        }
        if (derValue.getData().available() == 0) {
            if (debug != null) {
                debug.text(8192L, className, "parse", "No data encoded for RevokedCertificates");
            }
            throw new CRLException("No data encoded for RevokedCertificates");
        }
        this.revokedCert = derValue.toByteArray();
        DerInputStream derInputStream = derValue.toDerInputStream();
        DerValue derValue2 = derInputStream.getDerValue();
        this.serialNumber = new SerialNumber(derValue2);
        int n = derValue.getData().peekByte();
        if ((byte)n == 23) {
            this.revocationDate = derValue.getData().getUTCTime();
        } else if ((byte)n == 24) {
            this.revocationDate = derValue.getData().getGeneralizedTime();
        } else {
            if (debug != null) {
                debug.text(8192L, className, "parse", "Invalid encoding for revocation date");
            }
            throw new CRLException("Invalid encoding for revocation date");
        }
        if (derValue.getData().available() == 0) {
            if (debug != null) {
                debug.exit(8192L, className, "parse_1");
            }
            return;
        }
        this.extensions = new CRLExtensions(derValue.toDerInputStream());
        if (debug != null) {
            debug.exit(8192L, className, "parse");
        }
    }
}

