/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public abstract class ByteToCharDBCS_EBCDIC
extends ByteToCharConverter {
    private static final int SBCS = 0;
    private static final int DBCS = 1;
    private static final int SO = 14;
    private static final int SI = 15;
    private int currentState = 0;
    private int convertType = 0;
    private boolean savedBytePresent = false;
    private byte savedByte;
    protected String singleByteToChar = null;
    private char[] singleByte = null;
    protected short[] index1;
    protected String index2;
    protected String index2a;
    protected int mask1;
    protected int mask2;
    protected int shift;
    private boolean fastSBCS = false;

    protected void setSBCS() {
        this.currentState = 0;
        this.fastSBCS = this.subMode && this.subChars.length == 1 && this.subChars[0] == '\ufffd' && this.singleByte != null;
    }

    protected void setType(int n) {
        this.convertType = n;
        if (n == 2) {
            this.currentState = 1;
            this.fastSBCS = false;
        } else {
            if (this.singleByte == null && this.singleByteToChar.length() == 256) {
                this.singleByte = this.singleByteToChar.toCharArray();
            }
            this.setSBCS();
        }
    }

    public int flush(char[] cArray, int n, int n2) throws MalformedInputException {
        if (this.savedBytePresent) {
            this.reset();
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        this.reset();
        return 0;
    }

    public int convert(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        int n5 = n;
        this.charOff = n3;
        if (this.fastSBCS && n3 + (n2 - n) <= n4) {
            while (n5 < n2) {
                int n6 = byArray[n5] & 0xFF;
                if (n6 <= 15 && n6 >= 14) break;
                cArray[this.charOff++] = this.singleByte[n6];
                ++n5;
            }
        }
        this.byteOff = n5;
        if (n5 != n2) {
            this.convertSlow(byArray, n2, cArray, n4);
        }
        return this.charOff - n3;
    }

    private void convertSlow(byte[] byArray, int n, char[] cArray, int n2) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        int n3 = 65533;
        while (this.byteOff < n) {
            int n4;
            int n5;
            if (!this.savedBytePresent) {
                n5 = byArray[this.byteOff] & 0xFF;
                n4 = 1;
            } else {
                n5 = this.savedByte;
                this.savedBytePresent = false;
                n4 = 0;
            }
            if (n5 == 14 && this.convertType == 0) {
                if (this.currentState != 0) {
                    this.badInputLength = 1;
                    throw new MalformedInputException();
                }
                this.currentState = 1;
                this.fastSBCS = false;
                this.byteOff += n4;
                continue;
            }
            if (n5 == 15 && this.convertType == 0) {
                if (this.currentState != 1) {
                    this.badInputLength = 1;
                    throw new MalformedInputException();
                }
                this.setSBCS();
                this.byteOff += n4;
                continue;
            }
            if (this.currentState == 0) {
                n3 = this.singleByte != null ? this.singleByte[n5] : this.singleByteToChar.charAt(n5);
            } else {
                if (n5 < 64 || n5 > 254) {
                    this.badInputLength = 1;
                    throw new MalformedInputException();
                }
                if (this.byteOff + n4 >= n) {
                    this.savedByte = (byte)n5;
                    this.savedBytePresent = true;
                    this.byteOff += n4;
                    break;
                }
                int n6 = byArray[this.byteOff + n4] & 0xFF;
                ++n4;
                if (!(n5 == 64 && n6 == 64 || n6 >= 65 && n6 <= 254)) {
                    this.badInputLength = 2;
                    throw new MalformedInputException();
                }
                n3 = this.getUnicode(n5 * 256 + n6);
            }
            if (n3 == 65533) {
                if (this.subMode) {
                    n3 = this.subChars[0];
                } else {
                    this.badInputLength = n4;
                    throw new UnknownCharacterException();
                }
            }
            if (this.charOff >= n2) {
                throw new ConversionBufferFullException();
            }
            cArray[this.charOff++] = n3;
            this.byteOff += n4;
        }
    }

    protected char getUnicode(int n) {
        int n2 = this.index1[(n & this.mask1) >> this.shift] + (n & this.mask2);
        char c = this.index2a == null || n2 < 15000 ? this.index2.charAt(n2) : this.index2a.charAt(n2 - 15000);
        if (c == '\u0000' && n != 0) {
            return '\ufffd';
        }
        return c;
    }

    public void reset() {
        this.byteOff = 0;
        this.charOff = 0;
        if (this.singleByte == null && this.singleByteToChar.length() == 256) {
            this.singleByte = this.singleByteToChar.toCharArray();
        }
        if (this.convertType == 0) {
            this.setSBCS();
        }
        this.savedBytePresent = false;
    }
}

