/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;

public class ByteToCharUTF8
extends ByteToCharConverter {
    private int state = 0;
    private int inputSize;
    private int value;
    public static final int[] States = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 4, 1};
    public static final int[] StateMask = new int[]{0, 0, 31, 15, 7};

    public int flush(char[] cArray, int n, int n2) throws MalformedInputException {
        if (this.state != 0) {
            this.reset();
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        this.charOff = 0;
        this.byteOff = 0;
        return 0;
    }

    private void setException(int n, int n2) {
        this.badInputLength = 1 + this.state - n;
        this.byteOff -= this.state - n;
        if (this.byteOff < n2) {
            this.byteOff += 1 + this.state - n;
            this.badInputLength = 0;
        }
        this.state = 0;
    }

    public int convert(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws MalformedInputException, ConversionBufferFullException {
        int n5 = 0;
        this.charOff = n3;
        this.byteOff = n;
        while (this.byteOff < n2) {
            if (this.state == 0) {
                while ((n5 = byArray[this.byteOff]) >= 0) {
                    if (this.charOff >= n4) {
                        throw new ConversionBufferFullException();
                    }
                    cArray[this.charOff++] = (char)n5;
                    if (++this.byteOff < n2) continue;
                    return this.charOff - n3;
                }
                ++this.byteOff;
                this.state = States[(n5 & 0xFF) >> 3];
                this.inputSize = 1;
                this.value = n5 & StateMask[this.state];
                if (this.state != 1) continue;
                this.badInputLength = 1;
                this.state = 0;
                throw new MalformedInputException();
            }
            n5 = byArray[this.byteOff] & 0xFF;
            if ((n5 & 0xC0) != 128) {
                this.setException(this.inputSize, n);
                throw new MalformedInputException();
            }
            int n6 = this.value << 6 | n5 & 0x3F;
            if (this.inputSize + 1 >= this.state) {
                if (n6 < 65536) {
                    if (this.charOff >= n4) {
                        throw new ConversionBufferFullException();
                    }
                    cArray[this.charOff++] = (char)n6;
                } else {
                    if (n6 > 0x10FFFF) {
                        this.setException(this.state, n);
                        throw new MalformedInputException();
                    }
                    if (this.charOff + 2 > n4) {
                        throw new ConversionBufferFullException();
                    }
                    cArray[this.charOff++] = (char)((n6 - 65536) / 1024 + 55296);
                    cArray[this.charOff++] = (char)((n6 - 65536) % 1024 + 56320);
                }
                this.state = 0;
            } else {
                ++this.inputSize;
                this.value = n6;
            }
            ++this.byteOff;
        }
        return this.charOff - n3;
    }

    public String getCharacterEncoding() {
        return "UTF8";
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
        this.state = 0;
    }
}

