/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.ConstructKeys;
import com.ibm.crypto.pkcs11impl.provider.DESKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Cipher;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKey;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public final class DESCipher
extends CipherSpi {
    protected int cipherMode;
    private boolean decrypting = false;
    protected static final int ECB_MODE = 0;
    protected static final int CBC_MODE = 1;
    private byte[] iv = null;
    SecureRandom random = null;
    PKCS11Cipher cipher = null;
    private int mechanism;
    public static final int DES_BLOCK_SIZE = 8;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.DESCipher";
    static /* synthetic */ Class class$javax$crypto$spec$IvParameterSpec;

    public DESCipher() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DESCipher");
        }
        IBMPKCS11Impl.verifyJceJar();
        if (!IBMPKCS11Impl.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The IBM JCE PKCS11 provider may have been tampered.");
        }
        this.cipherMode = 0;
        this.mechanism = 289;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "DESCipher");
        }
    }

    public DESCipher(String string, String string2) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DESCipher", (Object)string, (Object)string2);
        }
        IBMPKCS11Impl.verifyJceJar();
        if (!IBMPKCS11Impl.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The IBMPKCS11Impl provider may have been tampered.");
        }
        try {
            this.random = SecureRandom.getInstance("IBMSecureRandom", "IBMPKCS11Impl");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
        this.engineSetMode(string);
        this.engineSetPadding(string2);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "DESCipher");
        }
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSetMode", (Object)string);
        }
        if (string == null) {
            throw new NoSuchAlgorithmException("null mode");
        }
        String string2 = string.toUpperCase();
        if (string2.equals("ECB")) {
            this.cipherMode = 0;
            this.mechanism = 289;
        } else if (string2.equals("CBC")) {
            this.cipherMode = 1;
            this.mechanism = 290;
        } else {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineSetMode", (Throwable)new NoSuchAlgorithmException("Cipher mode: " + string + " not found"));
                debug.exit(16384L, (Object)className, "engineSetMode");
            }
            throw new NoSuchAlgorithmException("Cipher mode: " + string + " not found");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineSetMode");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        block9: {
            block10: {
                if (debug != null) {
                    debug.entry(16384L, (Object)className, "engineSetPadding", (Object)string);
                }
                if (this.mechanism != 290 && this.mechanism != 293) break block10;
                if (string == null || string.equalsIgnoreCase("NoPadding")) {
                    this.mechanism = 290;
                    break block9;
                } else if (string.equalsIgnoreCase("Pad")) {
                    this.mechanism = 293;
                    break block9;
                } else {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineSetPadding", (Throwable)new NoSuchPaddingException("Padding: " + string + " can not be verified for use. Use Pad instead."));
                        debug.exit(16384L, (Object)className, "engineSetPadding");
                    }
                    throw new NoSuchPaddingException("Padding: " + string + " can not be verified for use. Use Pad instead.");
                }
            }
            if (string != null && !string.equalsIgnoreCase("NoPadding")) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineSetPadding", (Throwable)new NoSuchPaddingException("No padding implemented for ECB mode"));
                    debug.exit(16384L, (Object)className, "engineSetPadding");
                }
                throw new NoSuchPaddingException("No padding implemented for ECB mode");
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineSetPadding");
        }
    }

    protected int engineGetBlockSize() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGetBlockSize");
            debug.exit(16384L, (Object)className, "engineGetBlockSize");
        }
        return 8;
    }

    protected int engineGetOutputSize(int n) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGetOutputSize");
            debug.exception(16384L, (Object)className, "engineGetOutputSize", (Throwable)new UnsupportedOperationException("This size can not be guaranteed."));
            debug.exit(16384L, (Object)className, "engineGetOutputSize");
        }
        throw new UnsupportedOperationException("This size can not be guaranteed.");
    }

    protected byte[] engineGetIV() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGetIV");
            debug.exit(16384L, (Object)className, "engineGetIV");
        }
        if (this.cipherMode == 0) {
            return null;
        }
        return this.iv;
    }

    protected AlgorithmParameters engineGetParameters() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGetParameters");
        }
        AlgorithmParameters algorithmParameters = null;
        if (this.cipherMode == 0) {
            return null;
        }
        IvParameterSpec ivParameterSpec = new IvParameterSpec(this.iv);
        try {
            algorithmParameters = AlgorithmParameters.getInstance("DES", "IBMPKCS11Impl");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGetParameters", (Throwable)new RuntimeException("IBMPKCS11Impl called, but not configured"));
                debug.exit(16384L, (Object)className, "engineGetParameters");
            }
            throw new RuntimeException("IBMPKCS11Impl called, but not configured");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGetParameters", (Throwable)new RuntimeException("IBMPKCS11Impl called, but not configured"));
                debug.exit(16384L, (Object)className, "engineGetParameters");
            }
            throw new RuntimeException("IBMPKCS11Impl called, but not configured");
        }
        try {
            algorithmParameters.init(ivParameterSpec);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGetParameters", (Throwable)new RuntimeException("IvParameterSpec not supported"));
                debug.exit(16384L, (Object)className, "engineGetParameters");
            }
            throw new RuntimeException("IvParameterSpec not supported");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineGetParameters");
        }
        return algorithmParameters;
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        SecureRandom secureRandom2;
        Object object;
        if (debug != null) {
            object = new Object[]{new Integer(n), key, secureRandom};
            debug.entry(16384L, (Object)className, "engineInit", object);
        }
        SecureRandom secureRandom3 = secureRandom2 = secureRandom == null ? this.random : secureRandom;
        if ((n == 2 || n == 4) && this.cipherMode != 0) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("Parameters missing"));
                debug.exit(16384L, (Object)className, "engineInit");
            }
            throw new InvalidKeyException("Parameters missing");
        }
        if (key == null) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("No key given"));
                debug.exit(16384L, (Object)className, "engineInit");
            }
            throw new InvalidKeyException("No key given");
        }
        if (!(key instanceof PKCS11SecretKey || key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("DES") && key.getFormat().equalsIgnoreCase("RAW"))) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("Key given is not a DES key."));
                debug.exit(16384L, (Object)className, "engineInit");
            }
            throw new InvalidKeyException("Key given is not a DES key.");
        }
        if (key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("DES") && key.getFormat().equalsIgnoreCase("RAW")) {
            try {
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DES", "IBMPKCS11Impl");
                object = (DESKey)secretKeyFactory.translateKey((SecretKey)key);
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("Cannot convert key: " + key + " with reason: " + exception.getMessage()));
                    debug.exit(16384L, (Object)className, "engineInit");
                }
                throw new InvalidKeyException("Cannot convert key: " + key + " with reason: " + exception.getMessage());
            }
        } else {
            object = (DESKey)key;
        }
        if (this.cipherMode == 1) {
            this.iv = new byte[8];
            secureRandom2.nextBytes(this.iv);
        }
        this.cipher = new PKCS11Cipher(this.mechanism);
        this.cipher.engineInit(n, object.getObject(), this.iv, 8);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInit");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        void var5_8;
        block19: {
            Object object;
            if (debug != null) {
                Object[] objectArray = new Object[]{new Integer(n), key, algorithmParameterSpec, secureRandom};
                debug.entry(16384L, (Object)className, "engineInit", objectArray);
            }
            if ((n == 2 || n == 4) && this.cipherMode != 0 && algorithmParameterSpec == null) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidAlgorithmParameterException("Parameters missing"));
                    debug.exit(16384L, (Object)className, "engineInit");
                }
                throw new InvalidAlgorithmParameterException("Parameters missing");
            }
            if (key == null) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("No key given"));
                    debug.exit(16384L, (Object)className, "engineInit");
                }
                throw new InvalidKeyException("No key given");
            }
            if (!(key instanceof PKCS11SecretKey || key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("DES") && key.getFormat().equalsIgnoreCase("RAW"))) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("Key given is not a DES key."));
                    debug.exit(16384L, (Object)className, "engineInit");
                }
                throw new InvalidKeyException("Key given is not a DES key.");
            }
            if (key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("DES") && key.getFormat().equalsIgnoreCase("RAW")) {
                try {
                    object = SecretKeyFactory.getInstance("DES", "IBMPKCS11Impl");
                    DESKey dESKey = (DESKey)((SecretKeyFactory)object).translateKey((SecretKey)key);
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("Cannot convert key: " + key + " with reason: " + exception.getMessage()));
                        debug.exit(16384L, (Object)className, "engineInit");
                    }
                    throw new InvalidKeyException("Cannot convert key: " + key + " with reason: " + exception.getMessage());
                }
            } else {
                DESKey dESKey = (DESKey)key;
            }
            if (this.cipherMode == 1) {
                if (algorithmParameterSpec != null) {
                    if (algorithmParameterSpec instanceof IvParameterSpec) {
                        this.iv = ((IvParameterSpec)algorithmParameterSpec).getIV();
                        break block19;
                    } else {
                        if (debug != null) {
                            debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidAlgorithmParameterException("Wrong parameter type: IV expected"));
                            debug.exit(16384L, (Object)className, "engineInit");
                        }
                        throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
                    }
                }
                if (secureRandom != null) {
                    object = new byte[8];
                    secureRandom.nextBytes((byte[])object);
                }
            }
        }
        this.cipher = new PKCS11Cipher(this.mechanism);
        this.cipher.engineInit(n, var5_8.getObject(), this.iv, 8);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInit");
        }
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{new Integer(n), key, algorithmParameters, secureRandom};
            debug.entry(16384L, (Object)className, "engineInit", objectArray);
        }
        objectArray = null;
        if (algorithmParameters != null) {
            try {
                objectArray = (Object[])algorithmParameters.getParameterSpec(class$javax$crypto$spec$IvParameterSpec == null ? (class$javax$crypto$spec$IvParameterSpec = DESCipher.class$("javax.crypto.spec.IvParameterSpec")) : class$javax$crypto$spec$IvParameterSpec);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidAlgorithmParameterException("Wrong parameter type: IV expected"));
                    debug.exit(16384L, (Object)className, "engineInit");
                }
                throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
            }
        }
        this.engineInit(n, key, (AlgorithmParameterSpec)objectArray, secureRandom);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInit");
        }
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        if (debug != null) {
            Object[] objectArray = new Object[]{byArray, new Integer(n), new Integer(n2)};
            debug.entry(16384L, (Object)className, "engineUpdate", objectArray);
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
        return this.cipher.engineUpdate(byArray, n, n2);
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        if (debug != null) {
            Object[] objectArray = new Object[]{byArray, new Integer(n), new Integer(n2), byArray2, new Integer(n3)};
            debug.entry(16384L, (Object)className, "engineUpdate", objectArray);
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
        return this.cipher.engineUpdate(byArray, n, n2, byArray2, n3);
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        if (debug != null) {
            Object[] objectArray = new Object[]{byArray, new Integer(n), new Integer(n2)};
            debug.entry(16384L, (Object)className, "engineDoFinal", objectArray);
            debug.exit(16384L, (Object)className, "engineDoFinal");
        }
        return this.cipher.engineDoFinal(byArray, n, n2);
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        if (debug != null) {
            Object[] objectArray = new Object[]{byArray, new Integer(n), new Integer(n2), byArray2, new Integer(n3)};
            debug.entry(16384L, (Object)className, "engineDoFinal", objectArray);
            debug.exit(16384L, (Object)className, "engineDoFinal");
        }
        return this.cipher.engineDoFinal(byArray, n, n2, byArray2, n3);
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGetKeySize", (Object)key);
        }
        if (!(key instanceof DESKey || key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("DES") && key.getFormat().equalsIgnoreCase("RAW"))) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "engineGetKeySize", (Object)new InvalidKeyException("Wrong key passed in."));
                debug.exit(16384L, (Object)className, "engineGetKeySize");
            }
            throw new InvalidKeyException("Wrong key passed in.");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineGetKeySize");
        }
        return 56;
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineWrap", (Object)key);
            debug.exit(16384L, (Object)className, "engineWrap");
        }
        int n = ((PKCS11Key)key).getObject().size() + 7;
        return this.cipher.engineWrap(((PKCS11Key)key).getObject(), n);
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        Object object;
        if (debug != null) {
            object = new Object[]{byArray, string, new Integer(n)};
            debug.entry(16384L, (Object)className, "engineUnwrap", object);
        }
        object = null;
        int[] nArray = null;
        Object[] objectArray = null;
        Object[] objectArray2 = new Object[2];
        PKCS11Object pKCS11Object = null;
        switch (n) {
            case 3: {
                objectArray2 = ConstructKeys.constructSecretKeyAttrs(string);
                nArray = (int[])objectArray2[0];
                objectArray = (Object[])objectArray2[1];
                pKCS11Object = this.cipher.engineUnwrap(byArray, nArray, objectArray);
                object = ConstructKeys.constructSecretKey(pKCS11Object, string);
                break;
            }
            case 2: {
                objectArray2 = ConstructKeys.constructPrivateKeyAttrs(string);
                nArray = (int[])objectArray2[0];
                objectArray = (Object[])objectArray2[1];
                pKCS11Object = this.cipher.engineUnwrap(byArray, nArray, objectArray);
                object = ConstructKeys.constructPrivateKey(pKCS11Object, string);
                break;
            }
            case 1: {
                objectArray2 = ConstructKeys.constructPublicKeyAttrs(string);
                nArray = (int[])objectArray2[0];
                objectArray = (Object[])objectArray2[1];
                pKCS11Object = this.cipher.engineUnwrap(byArray, nArray, objectArray);
                object = ConstructKeys.constructPublicKey(pKCS11Object, string);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUnwrap");
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

