/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.classloader.ClassLoaderManager;
import com.ibm.ws.classloader.CompoundClassLoader;
import com.ibm.ws.classloader.ReloadableClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class ClassLoaderDump {
    private static TraceComponent tc = Tr.register((class$com$ibm$ws$classloader$ClassLoaderDump == null ? (class$com$ibm$ws$classloader$ClassLoaderDump = ClassLoaderDump.class$("com.ibm.ws.classloader.ClassLoaderDump")) : class$com$ibm$ws$classloader$ClassLoaderDump).getName(), "Websphere ClassLoader", null);
    private static final Permission classLoaderInfoPermission = new WebSphereRuntimePermission("accessClassLoaderInfo");
    private static Map classLoaderMapToModules = Collections.synchronizedMap(new HashMap());
    private static Map classLoaderMapToApplications = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$com$ibm$ws$classloader$ClassLoaderDump;
    static /* synthetic */ Class class$com$ibm$ws$classloader$CompoundClassLoader;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public static String getClassLoaderInfo(ClassLoader classLoader, int n, boolean bl, boolean bl2, boolean bl3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassLoderInfo(ClassLoader,int,boolean,boolea,boolean)");
        }
        String string = ClassLoaderDump.getClassLoaderInfo(classLoader, n, bl, bl2, bl3, true, false, false, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassLoderInfo(ClassLoader,int,boolean,boolean,boolean)");
        }
        return string;
    }

    public static String getClassLoaderInfo(final ClassLoader classLoader, final int n, final boolean bl, final boolean bl2, final boolean bl3, final boolean bl4, final boolean bl5, final boolean bl6, final boolean bl7) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassLoderInfo(ClassLoader,int,boolean,boolea,boolean,boolean,boolean,boolean)");
        }
        ClassLoaderDump.checkPermission();
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                int n3 = n;
                ClassLoader classLoader2 = classLoader;
                ArrayList arrayList = new ArrayList();
                ClassLoaderDump.buildHierarchy(classLoader2, arrayList, bl4);
                if (n3 >= arrayList.size()) {
                    n3 = arrayList.size() - 1;
                }
                if (n3 < 0) {
                    n3 = 0;
                }
                StringBuffer stringBuffer = new StringBuffer(8192);
                stringBuffer.append("<classloaderinfo>\n");
                stringBuffer.append(" <singleServerClassLoader>").append(ClassLoaderManager.getSingleServerClassLoader()).append("</singleServerClassLoader>\n");
                int n2 = 0;
                if (bl) {
                    n2 = n3;
                }
                ClassLoaderDump.getClassLoaderInfo(stringBuffer, arrayList, n3, n2, bl2, bl3, bl5, bl6, bl7);
                stringBuffer.append("</classloaderinfo>\n");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getClassLoderInfo(ClassLoader,int,boolean,boolea,boolean,boolean,boolean,boolean)");
                }
                return stringBuffer.toString();
            }
        });
    }

    public static int getClassLoaderDepth(final ClassLoader classLoader) {
        ClassLoaderDump.checkPermission();
        Integer n = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ArrayList arrayList = new ArrayList();
                ClassLoaderDump.buildHierarchy(classLoader, arrayList, false);
                return new Integer(arrayList.size());
            }
        });
        return n;
    }

    protected static void checkPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(classLoaderInfoPermission);
        }
    }

    protected static void buildHierarchy(ClassLoader classLoader, ArrayList arrayList, boolean bl) {
        boolean bl2 = ClassLoaderDump.getDelegation(classLoader);
        ClassLoader classLoader2 = classLoader.getParent();
        if (classLoader2 == null) {
            arrayList.add(classLoader);
        } else if (!bl2 && bl) {
            arrayList.add(classLoader);
            ClassLoaderDump.buildHierarchy(classLoader2, arrayList, bl);
        } else {
            ClassLoaderDump.buildHierarchy(classLoader2, arrayList, bl);
            arrayList.add(classLoader);
        }
    }

    protected static boolean getDelegation(ClassLoader classLoader) {
        boolean bl = true;
        if (classLoader instanceof ReloadableClassLoader) {
            classLoader = ((ReloadableClassLoader)classLoader).getCurrentClassLoader();
        }
        if (classLoader instanceof CompoundClassLoader) {
            try {
                Field field = (class$com$ibm$ws$classloader$CompoundClassLoader == null ? (class$com$ibm$ws$classloader$CompoundClassLoader = ClassLoaderDump.class$("com.ibm.ws.classloader.CompoundClassLoader")) : class$com$ibm$ws$classloader$CompoundClassLoader).getDeclaredField("delegate");
                field.setAccessible(true);
                bl = field.getBoolean(classLoader);
                field.setAccessible(false);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.classloader.ClassLoaderDump.getDelegation", "97");
            }
        }
        return bl;
    }

    protected static void getClassLoaderInfo(StringBuffer stringBuffer, ArrayList arrayList, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassLoderInfo(StringBuffer,ArrayList,int,int,boolean,boolean,boolean,boolean)");
        }
        ClassLoader classLoader = (ClassLoader)arrayList.get(n2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Classloader = " + classLoader);
        }
        stringBuffer.append(" <classloader>\n");
        stringBuffer.append("   <implementation-class>");
        stringBuffer.append(classLoader.getClass().getName());
        stringBuffer.append("</implementation-class>\n");
        if (bl5) {
            stringBuffer.append("   <depth>").append(n2).append("</depth>\n");
        }
        if (bl4) {
            ClassLoaderDump.processApplications(classLoader, stringBuffer);
            ClassLoaderDump.processModules(classLoader, stringBuffer);
        }
        if (classLoader instanceof CompoundClassLoader) {
            ClassLoaderDump.processCompoundClassLoader(classLoader, stringBuffer);
        } else if (classLoader instanceof ReloadableClassLoader) {
            ClassLoaderDump.processReloadableClassLoader(classLoader, stringBuffer);
            classLoader = ((ReloadableClassLoader)classLoader).getCurrentClassLoader();
        } else if (classLoader instanceof ExtClassLoader) {
            ClassLoaderDump.processExtClassLoader(classLoader, stringBuffer);
        } else if (classLoader instanceof URLClassLoader) {
            ClassLoaderDump.processURLClassLoader(classLoader, stringBuffer);
        }
        if (bl) {
            try {
                int n3;
                Field field = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ClassLoaderDump.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getDeclaredField("classes");
                field.setAccessible(true);
                Vector vector = (Vector)field.get(classLoader);
                field.setAccessible(false);
                Object[] objectArray = new ClassData[vector.size()];
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    CodeSource codeSource;
                    Class clazz = (Class)vector.get(n3);
                    objectArray[n3] = new ClassData();
                    ((ClassData)objectArray[n3]).isInterface = clazz.isInterface();
                    ((ClassData)objectArray[n3]).className = clazz.getName();
                    ((ClassData)objectArray[n3]).codeSource = null;
                    if (!bl2) continue;
                    ((ClassData)objectArray[n3]).codeSource = "";
                    ProtectionDomain protectionDomain = clazz.getProtectionDomain();
                    if (protectionDomain == null || (codeSource = protectionDomain.getCodeSource()) == null) continue;
                    ((ClassData)objectArray[n3]).codeSource = codeSource.getLocation().toString();
                }
                Arrays.sort(objectArray);
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    stringBuffer.append("   <class>\n");
                    stringBuffer.append("      <name>");
                    stringBuffer.append(((ClassData)objectArray[n3]).className);
                    stringBuffer.append("</name>\n");
                    stringBuffer.append("      <interface>");
                    stringBuffer.append(((ClassData)objectArray[n3]).isInterface);
                    stringBuffer.append("</interface>\n");
                    if (((ClassData)objectArray[n3]).codeSource != null) {
                        stringBuffer.append("      <code-source>");
                        stringBuffer.append(((ClassData)objectArray[n3]).codeSource);
                        stringBuffer.append("</code-source>\n");
                    }
                    stringBuffer.append("   </class>\n");
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.classloader.ClassLoaderDump.getClassLoaderInfo", "180");
                throwable.printStackTrace();
            }
        }
        if (n - n2 > 0) {
            if (!bl3) {
                stringBuffer.append(" </classloader>\n");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClassLoderInfo(StringBuffer,ArrayList,int,int,boolean,boolean,boolean,boolean)");
            }
            ClassLoaderDump.getClassLoaderInfo(stringBuffer, arrayList, n, n2 + 1, bl, bl2, bl3, bl4, bl5);
        } else if (!bl3) {
            stringBuffer.append(" </classloader>\n");
        }
        if (bl3) {
            stringBuffer.append(" </classloader>\n");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ClassLoaderDump:getClassLoderInfo(StringBuffer,ArrayList,int,int,boolean,boolean,boolean,boolean)");
        }
    }

    protected static void processCompoundClassLoader(ClassLoader classLoader, StringBuffer stringBuffer) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Field field = (class$com$ibm$ws$classloader$CompoundClassLoader == null ? (class$com$ibm$ws$classloader$CompoundClassLoader = ClassLoaderDump.class$("com.ibm.ws.classloader.CompoundClassLoader")) : class$com$ibm$ws$classloader$CompoundClassLoader).getDeclaredField("providers");
            field.setAccessible(true);
            Object object = field.get(classLoader);
            field.setAccessible(false);
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                Object object2 = Array.get(object, i);
                Method method = object2.getClass().getMethod("getPath", null);
                String string = (String)method.invoke(object2, null);
                arrayList.add(string);
            }
            Field field2 = (class$com$ibm$ws$classloader$CompoundClassLoader == null ? (class$com$ibm$ws$classloader$CompoundClassLoader = ClassLoaderDump.class$("com.ibm.ws.classloader.CompoundClassLoader")) : class$com$ibm$ws$classloader$CompoundClassLoader).getDeclaredField("delegate");
            field2.setAccessible(true);
            boolean bl = field2.getBoolean(classLoader);
            field2.setAccessible(false);
            stringBuffer.append("   <delegation-mode>");
            stringBuffer.append(bl);
            stringBuffer.append("</delegation-mode>\n");
            for (int i = 0; i < arrayList.size(); ++i) {
                stringBuffer.append("   <path>");
                stringBuffer.append(arrayList.get(i));
                stringBuffer.append("</path>\n");
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.classloader.ClassLoaderDump.processCompoundClassLoader", "232");
            throwable.printStackTrace();
        }
    }

    protected static void processReloadableClassLoader(ClassLoader classLoader, StringBuffer stringBuffer) {
        CompoundClassLoader compoundClassLoader = ((ReloadableClassLoader)classLoader).getCurrentClassLoader();
        ClassLoaderDump.processCompoundClassLoader(compoundClassLoader, stringBuffer);
    }

    protected static void processExtClassLoader(ClassLoader classLoader, StringBuffer stringBuffer) {
        URL[] uRLArray = ((ExtClassLoader)classLoader)._getURLs();
        stringBuffer.append("   <delegation-mode>true");
        stringBuffer.append("</delegation-mode>\n");
        for (int i = 0; i < uRLArray.length; ++i) {
            stringBuffer.append("   <path>");
            stringBuffer.append(uRLArray[i]);
            stringBuffer.append("</path>\n");
        }
    }

    protected static void processURLClassLoader(ClassLoader classLoader, StringBuffer stringBuffer) {
        URL[] uRLArray = ((URLClassLoader)classLoader).getURLs();
        stringBuffer.append("   <delegation-mode>true");
        stringBuffer.append("</delegation-mode>\n");
        for (int i = 0; i < uRLArray.length; ++i) {
            stringBuffer.append("   <path>");
            stringBuffer.append(uRLArray[i]);
            stringBuffer.append("</path>\n");
        }
    }

    protected static void processModules(ClassLoader classLoader, StringBuffer stringBuffer) {
        ArrayList arrayList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processModules for Classloader = " + classLoader);
        }
        if ((arrayList = (ArrayList)classLoaderMapToModules.get(classLoader)) != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("   <module>").append((String)iterator.next()).append("</module>\n");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "processModules - No Modules in ArrayList for " + classLoader);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processModules");
        }
    }

    protected static void processApplications(ClassLoader classLoader, StringBuffer stringBuffer) {
        ArrayList arrayList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processApplication for Classloader = " + classLoader);
        }
        if ((arrayList = (ArrayList)classLoaderMapToApplications.get(classLoader)) != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("   <application>").append((String)iterator.next()).append("</application>\n");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "processApplications - No Application in ArrayList for " + classLoader);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processApplication");
        }
    }

    public static void addModule(String string, ClassLoader classLoader) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addModule");
        }
        ArrayList<String> arrayList = null;
        while (classLoader != null) {
            if (classLoaderMapToModules.containsKey(classLoader)) {
                arrayList = (ArrayList<String>)classLoaderMapToModules.get(classLoader);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "moduleList Array==null for " + classLoader + " creating new one");
                }
                arrayList = new ArrayList<String>();
                classLoaderMapToModules.put(classLoader, arrayList);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " adding module: " + string + " to ClassLoader " + classLoader);
            }
            arrayList.add(string);
            classLoader = classLoader.getParent();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addModule");
        }
    }

    public static void addApplication(String string, ClassLoader classLoader) {
        int n = string.lastIndexOf(92);
        if (n == -1) {
            n = string.lastIndexOf(47);
        }
        String string2 = string.substring(n + 1, string.length());
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addApplication");
        }
        ArrayList<String> arrayList = null;
        while (classLoader != null) {
            if (classLoaderMapToApplications.containsKey(classLoader)) {
                arrayList = (ArrayList<String>)classLoaderMapToApplications.get(classLoader);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "applicationList Array==null for " + classLoader + " creating new one");
                }
                arrayList = new ArrayList<String>();
                classLoaderMapToApplications.put(classLoader, arrayList);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " adding module: " + string2 + " to ClassLoader " + classLoader);
            }
            arrayList.add(string2);
            classLoader = classLoader.getParent();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addApplication");
        }
    }

    public static void removeClassLoader(ReloadableClassLoader reloadableClassLoader) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeClassLoader");
        }
        classLoaderMapToModules.remove(reloadableClassLoader);
        classLoaderMapToApplications.remove(reloadableClassLoader);
        if (tc.isDebugEnabled()) {
            ClassLoaderDump.dumpClassLoaderMap();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeClassLoader");
        }
    }

    public static void dumpClassLoaderMap() {
        if (tc.isDebugEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "dumpClassLoaderMap()");
            }
            Tr.debug(tc, "classLoaderMapToModules size = " + classLoaderMapToModules.size());
            Iterator iterator = classLoaderMapToModules.keySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                Object k = iterator.next();
                if (k == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "");
                    Tr.debug(tc, "Key = " + k);
                }
                if ((object = classLoaderMapToModules.get(k)) == null) continue;
                ArrayList arrayList = (ArrayList)object;
                for (int i = 0; i < arrayList.size(); ++i) {
                    object = arrayList.get(i);
                    if (object == null) continue;
                    String string = (String)object;
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "   ModuleName = " + string);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "dumpClassLoaderMap()");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ClassData
    implements Comparable {
        public String className;
        public String codeSource;
        boolean isInterface;

        ClassData() {
        }

        public int compareTo(Object object) {
            if (!(object instanceof ClassData)) {
                return 0;
            }
            ClassData classData = (ClassData)object;
            return this.className.compareTo(classData.className);
        }
    }
}

