/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.archive.RuntimeClasspathEntry;
import com.ibm.etools.commonarchive.Archive;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.ws.classloader.ClassGraph;
import com.ibm.ws.classloader.ClassLoaderDump;
import com.ibm.ws.classloader.ClassLoaderListener;
import com.ibm.ws.classloader.JarClassLoader;
import com.ibm.ws.classloader.ReloadableClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class ClassLoaderManager {
    private static TraceComponent tc = Tr.register((class$com$ibm$ws$classloader$ClassLoaderManager == null ? (class$com$ibm$ws$classloader$ClassLoaderManager = ClassLoaderManager.class$("com.ibm.ws.classloader.ClassLoaderManager")) : class$com$ibm$ws$classloader$ClassLoaderManager).getName(), "Websphere ClassLoader", null);
    protected static Timer classLoaderTimer = new Timer(true);
    protected ClassLoader parent = null;
    protected ReloadableClassLoader applicationClassLoader;
    protected EARFile earFile = null;
    protected HashMap moduleClassLoaderLookup = new HashMap();
    protected HashMap listenerListLookup = new HashMap();
    protected boolean disposed = false;
    protected HashSet timers = new HashSet();
    protected boolean overrideReload = false;
    protected long overrideReloadInterval = 0L;
    protected boolean processFarFiles = false;
    protected String[] serverPaths = null;
    private static boolean singleServerClassLoader = false;
    protected boolean singleWarClassLoader = false;
    private static boolean defaultDelegationMode = true;
    protected static JarClassLoader serverClassLoader = null;
    static /* synthetic */ Class class$com$ibm$ws$classloader$ClassLoaderManager;

    public static void setSingleServerClassLoader(boolean bl) {
        singleServerClassLoader = bl;
    }

    public static boolean getSingleServerClassLoader() {
        return singleServerClassLoader;
    }

    public static void setDefaultDelegationMode(boolean bl) {
        defaultDelegationMode = bl;
    }

    public static boolean getDefaultDelegationMode() {
        return defaultDelegationMode;
    }

    public ClassLoaderManager(ClassLoader classLoader, EARFile eARFile, boolean bl, String[] stringArray, boolean bl2, String string, boolean bl3, long l) {
        this(classLoader, eARFile, bl, stringArray, bl2, string, bl3, l, false);
    }

    public ClassLoaderManager(ClassLoader classLoader, EARFile eARFile, boolean bl, String[] stringArray, boolean bl2, String string, boolean bl3, long l, boolean bl4) {
        this(classLoader, eARFile, bl, stringArray, new String[0], bl2, string, bl3, l, false);
    }

    public ClassLoaderManager(ClassLoader classLoader, EARFile eARFile, boolean bl, String[] stringArray, String[] stringArray2, boolean bl2, String string, boolean bl3, long l, boolean bl4) {
        this.overrideReload = bl3;
        this.overrideReloadInterval = l;
        this.processFarFiles = bl4;
        this.initialize(classLoader, eARFile, bl, stringArray, stringArray2, bl2, string);
    }

    protected void initialize(ClassLoader classLoader, EARFile eARFile, boolean bl, String[] stringArray, String[] stringArray2, boolean bl2, String string) {
        ModuleRef moduleRef;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        this.parent = classLoader;
        this.earFile = eARFile;
        this.singleWarClassLoader = bl;
        if (singleServerClassLoader && serverClassLoader == null) {
            serverClassLoader = new JarClassLoader(new String[0], classLoader, defaultDelegationMode);
            serverClassLoader.createLoader();
        }
        ClassGraph classGraph = new ClassGraph(classLoader, stringArray, stringArray2, bl2, bl);
        Iterator iterator = eARFile.getModuleRefs().iterator();
        while (iterator.hasNext()) {
            moduleRef = (ModuleRef)iterator.next();
            classGraph.addModule(moduleRef);
        }
        if (this.processFarFiles) {
            this.processFARFiles(eARFile, classGraph);
        }
        classGraph.calculate(eARFile, string);
        iterator = eARFile.getModuleRefs().iterator();
        while (iterator.hasNext()) {
            moduleRef = (ModuleRef)iterator.next();
            ReloadableClassLoader reloadableClassLoader = classGraph.lookupClassLoader(moduleRef);
            if (reloadableClassLoader == null) continue;
            this.moduleClassLoaderLookup.put(moduleRef, reloadableClassLoader);
            if (reloadableClassLoader != serverClassLoader) {
                this.createTimer(moduleRef);
            }
            ClassLoaderDump.addModule(moduleRef.getUri(), reloadableClassLoader);
        }
        this.serverPaths = classGraph.getServerPaths();
        this.applicationClassLoader = classGraph.lookupClassLoader(null);
        this.moduleClassLoaderLookup.put(null, this.applicationClassLoader);
        this.createTimer(null);
        ClassLoaderDump.addApplication(eARFile.getURI(), this.applicationClassLoader);
        classGraph.dispose();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ClassLoaderManager");
        }
    }

    protected void processFARFiles(EARFile eARFile, ClassGraph classGraph) {
        List list = eARFile.getFARFiles();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Archive archive = (Archive)list.get(i);
            RuntimeClasspathEntry[] runtimeClasspathEntryArray = archive.getLocalRuntimeClassPath();
            for (int j = 0; j < runtimeClasspathEntryArray.length; ++j) {
                arrayList.add(runtimeClasspathEntryArray[j].getAbsolutePath());
            }
            RuntimeClasspathEntry[] runtimeClasspathEntryArray2 = archive.getDependencyClassPath();
            for (int j = 0; j < runtimeClasspathEntryArray2.length; ++j) {
                arrayList.add(runtimeClasspathEntryArray2[j].getAbsolutePath());
            }
        }
        if (arrayList.size() > 0) {
            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
            classGraph.addUtilityJars(stringArray);
        }
    }

    public void dispose() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dispose " + this.earFile.getURI());
        }
        this.disposed = true;
        this.cancelAllTimers();
        this.parent = null;
        this.earFile = null;
        Iterator iterator = this.moduleClassLoaderLookup.values().iterator();
        while (iterator.hasNext()) {
            ReloadableClassLoader reloadableClassLoader = (ReloadableClassLoader)iterator.next();
            if (reloadableClassLoader == serverClassLoader) continue;
            ClassLoaderDump.removeClassLoader(reloadableClassLoader);
            reloadableClassLoader.dispose(true);
        }
        if (serverClassLoader != null && this.serverPaths != null) {
            serverClassLoader.removePaths(this.serverPaths);
        }
        this.moduleClassLoaderLookup.clear();
        this.listenerListLookup.clear();
        this.applicationClassLoader = null;
    }

    public ReloadableClassLoader lookupClassLoader(ModuleRef moduleRef) {
        ReloadableClassLoader reloadableClassLoader;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookupClassLoader", moduleRef.getUri());
        }
        if ((reloadableClassLoader = (ReloadableClassLoader)this.moduleClassLoaderLookup.get(moduleRef)) != null && reloadableClassLoader.getRemoved()) {
            reloadableClassLoader.setRemoved(false);
            reloadableClassLoader.reload();
            this.createTimer(moduleRef);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lookupClassLoader");
        }
        return reloadableClassLoader;
    }

    public void removeClassLoader(ModuleRef moduleRef) {
        ReloadableClassLoader reloadableClassLoader = (ReloadableClassLoader)this.moduleClassLoaderLookup.get(moduleRef);
        if (reloadableClassLoader != null && reloadableClassLoader != serverClassLoader) {
            reloadableClassLoader.setRemoved(true);
            this.cancelTimer(moduleRef);
        }
    }

    public ClassLoader getApplicationClassLoader() {
        return this.applicationClassLoader;
    }

    public void setDelegationMode(ModuleRef moduleRef, boolean bl) {
        ReloadableClassLoader reloadableClassLoader;
        if (!this.singleWarClassLoader && (reloadableClassLoader = (ReloadableClassLoader)this.moduleClassLoaderLookup.get(moduleRef)) != null && reloadableClassLoader != serverClassLoader) {
            reloadableClassLoader.setDelegationMode(bl);
        }
    }

    public void addClassLoaderListener(ClassLoaderListener classLoaderListener, ModuleRef moduleRef) {
        Vector<ClassLoaderListener> vector;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addClassLoaderListener", moduleRef != null ? moduleRef.getUri() : "appClassLoader");
        }
        if ((vector = (Vector<ClassLoaderListener>)this.listenerListLookup.get(moduleRef)) == null) {
            vector = new Vector<ClassLoaderListener>();
            this.listenerListLookup.put(moduleRef, vector);
        }
        vector.addElement(classLoaderListener);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addClassLoaderListener");
        }
    }

    public void removeClassLoaderListener(ClassLoaderListener classLoaderListener, ModuleRef moduleRef) {
        Vector vector;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeClassLoaderListener", moduleRef.getUri());
        }
        if ((vector = (Vector)this.listenerListLookup.get(moduleRef)) != null) {
            vector.removeElement(classLoaderListener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeClassLoaderListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reload");
        }
        HashMap hashMap = this.moduleClassLoaderLookup;
        synchronized (hashMap) {
            Iterator iterator = this.moduleClassLoaderLookup.values().iterator();
            while (iterator.hasNext()) {
                ReloadableClassLoader reloadableClassLoader = (ReloadableClassLoader)iterator.next();
                if (reloadableClassLoader == serverClassLoader) continue;
                reloadableClassLoader.reload();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reload");
        }
    }

    public void reloadClassLoader(ModuleRef moduleRef) {
        ReloadableClassLoader reloadableClassLoader;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reloadClassLoader");
        }
        if ((reloadableClassLoader = (ReloadableClassLoader)this.moduleClassLoaderLookup.get(moduleRef)) != null && reloadableClassLoader != serverClassLoader) {
            reloadableClassLoader.reload();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reloadClassLoader");
        }
    }

    public void createTimer(ModuleRef moduleRef) {
        Object object;
        long l = 0L;
        if (this.overrideReload) {
            l = this.overrideReloadInterval * 1000L;
        } else if (moduleRef != null && moduleRef.isWeb()) {
            object = null;
            try {
                object = (WebAppExtension)moduleRef.getExtensions();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.classloader.ClassLoaderManager.createTimer", "278", this);
                Tr.error(tc, "Error loading web application extension {0}", exception);
            }
            if (object != null && object.isReloadingEnabled()) {
                l = object.getReloadInterval() * 1000;
            }
        } else {
            l = this.earFile.getExtensions().getReloadInterval() * 1000L;
        }
        if (l > 0L) {
            object = null;
            object = (ReloadableClassLoader)this.moduleClassLoaderLookup.get(moduleRef);
            if (object != serverClassLoader) {
                ((ReloadableClassLoader)object).enableReloading();
                ReloadTimerTask reloadTimerTask = new ReloadTimerTask(moduleRef, l);
                classLoaderTimer.schedule((TimerTask)reloadTimerTask, l, l);
                this.timers.add(reloadTimerTask);
            }
        }
    }

    public synchronized void cancelTimer(ModuleRef moduleRef) {
        Iterator iterator = this.timers.iterator();
        while (iterator.hasNext()) {
            ReloadTimerTask reloadTimerTask = (ReloadTimerTask)iterator.next();
            if (reloadTimerTask.moduleRef != moduleRef) continue;
            reloadTimerTask.cancel();
            this.timers.remove(reloadTimerTask);
            return;
        }
    }

    public void cancelAllTimers() {
        Iterator iterator = this.timers.iterator();
        while (iterator.hasNext()) {
            ReloadTimerTask reloadTimerTask = (ReloadTimerTask)iterator.next();
            reloadTimerTask.cancel();
        }
        this.timers.clear();
    }

    private void checkAndNotify(ReloadableClassLoader reloadableClassLoader, ModuleRef moduleRef) {
        if (reloadableClassLoader.checkForUpdate()) {
            Vector vector;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "class has chanaged");
            }
            if ((vector = (Vector)this.listenerListLookup.get(moduleRef)) != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    ClassLoaderListener classLoaderListener = (ClassLoaderListener)vector.elementAt(i);
                    classLoaderListener.classChanged(moduleRef);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ReloadTimerTask
    extends TimerTask {
        public ModuleRef moduleRef;
        public long reloadInterval;

        public ReloadTimerTask(ModuleRef moduleRef, long l) {
            this.moduleRef = moduleRef;
            this.reloadInterval = l;
        }

        public void run() {
            if (ClassLoaderManager.this.disposed) {
                return;
            }
            boolean bl = tc.isDebugEnabled();
            ReloadableClassLoader reloadableClassLoader = (ReloadableClassLoader)ClassLoaderManager.this.moduleClassLoaderLookup.get(this.moduleRef);
            ClassLoaderManager.this.checkAndNotify(reloadableClassLoader, this.moduleRef);
        }
    }

    private static class CacheEntry {
        long lastModified;
        File origin;

        public CacheEntry(File file, long l) {
            this.origin = file;
            this.lastModified = l;
        }

        public String toString() {
            return this.origin.getPath() + " lastModfied : " + this.lastModified;
        }
    }
}

