/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.classloader.ClassLoaderManager;
import com.ibm.ws.classloader.ClassProviderListener;
import com.ibm.ws.classloader.CompoundClassLoader;
import com.ibm.ws.classloader.WsClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;

public abstract class ReloadableClassLoader
extends ClassLoader
implements ClassProviderListener,
WsClassLoader {
    private static final TraceComponent tc = Tr.register(class$com$ibm$ws$classloader$ReloadableClassLoader == null ? (class$com$ibm$ws$classloader$ReloadableClassLoader = ReloadableClassLoader.class$("com.ibm.ws.classloader.ReloadableClassLoader")) : class$com$ibm$ws$classloader$ReloadableClassLoader, "Websphere ClassLoader", null);
    protected ClassLoader parent = null;
    protected CompoundClassLoader classLoader = null;
    protected boolean reloadingEnabled = false;
    protected boolean removed = false;
    protected ArrayList classProviderListeners = new ArrayList();
    protected TimerTask myTimerTask = null;
    protected boolean disposed = false;
    private HashMap classCache = new HashMap();
    protected static int resourceTimeout = 60;
    static /* synthetic */ Class class$com$ibm$ws$classloader$ReloadableClassLoader;

    public ReloadableClassLoader(ClassLoader classLoader) {
        super(classLoader);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ReloadableClassLoader");
        }
        this.parent = classLoader;
        this.initializeAlarm();
        if (this.classLoader != null) {
            this.classLoader.addClassProviderListener(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ReloadableClassLoader");
        }
    }

    public void createLoader() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createLoader");
        }
        this.classLoader = new CompoundClassLoader(this.getPaths(), this.parent, this.getDelegationMode());
        this.classLoader.addClassProviderListener(this);
        for (int i = 0; i < this.classProviderListeners.size(); ++i) {
            this.classLoader.addClassProviderListener((ClassProviderListener)this.classProviderListeners.get(i));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createLoader");
        }
    }

    public void addClassProviderListener(ClassProviderListener classProviderListener) {
        this.classProviderListeners.add(classProviderListener);
        if (this.classLoader != null) {
            this.classLoader.addClassProviderListener(classProviderListener);
        }
    }

    public void setDelegationMode(boolean bl) {
        this.classLoader.setDelegationMode(bl);
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        if (this.classLoader != null) {
            return this.classLoader.loadClass(string);
        }
        throw new ClassNotFoundException(string + ": classLoader was disposed");
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (this.classLoader != null) {
            return this.classLoader.loadClass(string, bl);
        }
        throw new ClassNotFoundException(string + ": classLoader was disposed");
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        if (this.classLoader != null) {
            return this.classLoader.loadClass(string);
        }
        throw new ClassNotFoundException(string + ": classLoader was disposed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classLoadedFromFile(File file) {
        String string;
        if (this.reloadingEnabled && this.classCache.get(string = file.getPath()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adding path to reload cache", string);
            }
            HashMap hashMap = this.classCache;
            synchronized (hashMap) {
                this.classCache.put(string, new CacheEntry(file, string, file.lastModified()));
            }
        }
    }

    protected URL findResource(String string) {
        if (this.classLoader != null) {
            return this.classLoader.getResource(string);
        }
        return null;
    }

    public URL getResource(String string) {
        if (this.classLoader != null) {
            return this.classLoader.getResource(string);
        }
        return null;
    }

    public Enumeration findResources(String string) throws IOException {
        if (this.classLoader != null) {
            return this.classLoader.findResources(string);
        }
        return null;
    }

    public InputStream getResourceAsStream(String string) {
        if (this.classLoader != null) {
            return this.classLoader.getResourceAsStream(string);
        }
        return null;
    }

    protected String findLibrary(String string) {
        if (this.classLoader != null) {
            return this.classLoader.findLibrary(string);
        }
        return null;
    }

    public void enableReloading() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "enableReloading");
        }
        this.reloadingEnabled = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "enableReloading");
        }
    }

    public void disableReloading() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "disableReloading");
        }
        this.reloadingEnabled = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "disableReloading");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reload");
        }
        HashMap hashMap = this.classCache;
        synchronized (hashMap) {
            this.classCache.clear();
        }
        this.classLoader = this.classLoader.reload();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reload");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reload");
        }
        HashMap hashMap = this.classCache;
        synchronized (hashMap) {
            this.classCache.clear();
        }
        this.classLoader = this.classLoader.reload(bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reload");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dispose");
        }
        this.disposed = true;
        if (this.myTimerTask != null) {
            this.myTimerTask.cancel();
        }
        if (this.classCache != null) {
            HashMap hashMap = this.classCache;
            synchronized (hashMap) {
                this.classCache.clear();
            }
        }
        if (this.classLoader != null) {
            this.classLoader.dispose(bl);
        }
        this.parent = null;
        this.classLoader = null;
        this.classCache = null;
        this.classProviderListeners = null;
        this.myTimerTask = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dispose");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForUpdate() {
        boolean bl = false;
        if (!this.disposed) {
            CacheEntry[] cacheEntryArray = new CacheEntry[]{};
            HashMap hashMap = this.classCache;
            synchronized (hashMap) {
                cacheEntryArray = this.classCache.values().toArray(cacheEntryArray);
            }
            for (int i = 0; i < cacheEntryArray.length; ++i) {
                if (cacheEntryArray[i].lastModified == cacheEntryArray[i].origin.lastModified()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "updated ", cacheEntryArray[i]);
                }
                bl = true;
                break;
            }
        }
        return bl;
    }

    public String toString() {
        return super.toString() + "ReloadableClassLoader : classpath[" + this.getClassPath() + "]";
    }

    public String getClassPath() {
        String string = "";
        if (this.classLoader == null) {
            String[] stringArray = this.getPaths();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    string = string + stringArray[i] + File.pathSeparator;
                }
            }
        } else {
            string = this.classLoader.getClassPath();
        }
        return string;
    }

    public boolean getDelegationMode() {
        return false;
    }

    public CompoundClassLoader getCurrentClassLoader() {
        return this.classLoader;
    }

    public void setRemoved(boolean bl) {
        this.removed = bl;
    }

    public boolean getRemoved() {
        return this.removed;
    }

    public abstract String[] getPaths();

    public void initializeAlarm() {
        if (resourceTimeout > 0) {
            this.myTimerTask = new ReloadTimerTask();
            ClassLoaderManager.classLoaderTimer.schedule(this.myTimerTask, resourceTimeout * 1000, (long)(resourceTimeout * 1000));
        }
    }

    public Map getCodeSourcePermissions() {
        return this.classLoader.getCodeSourcePermissions();
    }

    public void setCodeSourcePermissions(Map map) {
        this.classLoader.setCodeSourcePermissions(map);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            String string = System.getProperty("com.ibm.ws.classloader.badResourceTimeout");
            if (string != null) {
                resourceTimeout = Integer.valueOf(string);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.classloader.ReloadableClassLoader", "275");
        }
    }

    protected class CacheEntry {
        long lastModified;
        File origin;
        String owningPath;

        public CacheEntry(File file, String string, long l) {
            this.origin = file;
            this.lastModified = l;
            this.owningPath = string;
        }

        public String toString() {
            return this.origin.getPath() + " lastModfied : " + this.lastModified + " owningPath : " + this.owningPath;
        }
    }

    private class ReloadTimerTask
    extends TimerTask {
        private ReloadTimerTask() {
        }

        public void run() {
            if (!ReloadableClassLoader.this.disposed) {
                if (ReloadableClassLoader.this.classLoader != null) {
                    ReloadableClassLoader.this.classLoader.clearBadResourceList();
                }
            } else {
                this.cancel();
            }
        }
    }
}

