/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.classloader.ClassProviderListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketPermission;
import java.net.URL;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SinglePathClassProvider {
    private static TraceComponent tc = Tr.register((class$com$ibm$ws$classloader$SinglePathClassProvider == null ? (class$com$ibm$ws$classloader$SinglePathClassProvider = SinglePathClassProvider.class$("com.ibm.ws.classloader.SinglePathClassProvider")) : class$com$ibm$ws$classloader$SinglePathClassProvider).getName(), "Websphere ClassLoader", null);
    protected File pathFile = null;
    protected boolean pathExists = false;
    protected boolean isDirectory = false;
    protected URL url = null;
    protected String path = null;
    protected ZipFile cachedZip = null;
    protected boolean cachingEnabled = false;
    protected Manifest manifest = null;
    HashSet entriesInJar = new HashSet();
    HashSet classesInJar = new HashSet();
    static /* synthetic */ Class class$com$ibm$ws$classloader$SinglePathClassProvider;

    public SinglePathClassProvider(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SinglePathClassProvider");
        }
        this.pathFile = new File(string);
        try {
            this.path = this.pathFile.getCanonicalPath();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.classloader.SinglePathClassProvider.run", "40", this);
            this.path = string;
        }
        this.pathExists = this.pathFile.exists();
        this.isDirectory = this.pathFile.isDirectory();
        if (tc.isDebugEnabled()) {
            if (this.pathExists) {
                Tr.debug(tc, "path " + this.pathFile.getPath() + " exists");
            } else {
                Tr.debug(tc, "path " + this.pathFile.getPath() + " does not exist");
            }
            if (this.isDirectory) {
                Tr.debug(tc, "path " + this.pathFile.getPath() + " is a directory");
            }
        }
        if (this.pathExists && !this.isDirectory) {
            this.buildContentsCache();
        }
        try {
            this.url = this.pathFile.getCanonicalFile().toURL();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.classloader.SinglePathClassProvider.run", "59", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SinglePathClassProvider");
        }
    }

    public void setCaching(boolean bl) {
        this.cachingEnabled = bl;
        if (!bl && this.cachedZip != null) {
            try {
                this.cachedZip.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.classloader.SinglePathClassProvider.setCaching", "74", this);
            }
            this.cachedZip = null;
        }
    }

    protected Manifest getManifest() {
        return this.manifest;
    }

    public void reload() {
        this.pathFile = new File(this.path);
        this.pathExists = this.pathFile.exists();
        this.isDirectory = this.pathFile.isDirectory();
        this.entriesInJar.clear();
        this.classesInJar.clear();
        if (this.pathExists && !this.isDirectory) {
            this.buildContentsCache();
        }
    }

    public void dispose() {
        this.entriesInJar.clear();
        this.classesInJar.clear();
        this.cachedZip = null;
        this.pathFile = null;
        this.url = null;
        this.manifest = null;
    }

    public URL getURL() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isValid() {
        return this.pathExists;
    }

    public byte[] getClassBytes(String string, ClassProviderListener classProviderListener) {
        byte[] byArray = null;
        if (this.pathExists) {
            byArray = this.isDirectory ? this.getClassBytesFromDir(string, classProviderListener) : this.getClassBytesFromJar(string, classProviderListener);
        }
        return byArray;
    }

    protected byte[] getClassBytesFromDir(final String string, final ClassProviderListener classProviderListener) {
        return (byte[])AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public Object run() {
                File file;
                FilterInputStream filterInputStream;
                FileInputStream fileInputStream;
                block19: {
                    String string3 = string.replace('.', '/');
                    fileInputStream = null;
                    filterInputStream = null;
                    String string2 = SinglePathClassProvider.this.getRealResourcePath(string3 + ".class");
                    file = new File(string2);
                    if (file.exists()) break block19;
                    Object var6_7 = null;
                    Object var9_9 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        if (filterInputStream != null) {
                            filterInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.classloader.SinglePathClassProvider.run", "172", this);
                    }
                    return var6_7;
                }
                fileInputStream = new FileInputStream(file);
                filterInputStream = new DataInputStream(fileInputStream);
                byte[] byArray = new byte[(int)file.length()];
                ((DataInputStream)filterInputStream).readFully(byArray);
                classProviderListener.classLoadedFromFile(file);
                byte[] byArray2 = byArray;
                Object var9_10 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    if (filterInputStream != null) {
                        filterInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.classloader.SinglePathClassProvider.run", "172", this);
                }
                return byArray2;
                catch (IOException iOException) {
                    try {
                        FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.classloader.SinglePathClassProvider.run", "164", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getClassBytesFromDir", iOException);
                        }
                        Object var9_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        try {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                            if (filterInputStream != null) {
                                filterInputStream.close();
                            }
                        }
                        catch (IOException iOException2) {
                            FFDCFilter.processException((Throwable)iOException2, "com.ibm.ws.classloader.SinglePathClassProvider.run", "172", this);
                        }
                        throw throwable;
                    }
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        if (filterInputStream != null) {
                            filterInputStream.close();
                        }
                    }
                    catch (IOException iOException3) {
                        FFDCFilter.processException((Throwable)iOException3, "com.ibm.ws.classloader.SinglePathClassProvider.run", "172", this);
                    }
                }
                return null;
            }
        });
    }

    protected byte[] getClassBytesFromJar(final String string, final ClassProviderListener classProviderListener) {
        return (byte[])AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public Object run() {
                byte[] byArray;
                block38: {
                    String string2 = string;
                    byArray = null;
                    InputStream inputStream = null;
                    ByteArrayOutputStream byteArrayOutputStream = null;
                    ZipFile zipFile = SinglePathClassProvider.this.cachedZip;
                    if (SinglePathClassProvider.this.classesInJar.contains(string2)) {
                        IOException iOException2222;
                        block34: {
                            block33: {
                                ZipEntry zipEntry;
                                if (zipFile == null) {
                                    zipFile = new ZipFile(SinglePathClassProvider.this.pathFile);
                                }
                                if ((zipEntry = zipFile.getEntry((string2 = string2.replace('.', '/')) + ".class")) == null) break block33;
                                inputStream = zipFile.getInputStream(zipEntry);
                                byte[] byArray2 = new byte[4096];
                                byteArrayOutputStream = new ByteArrayOutputStream();
                                int n = 0;
                                while ((n = inputStream.read(byArray2, 0, 4096)) != -1) {
                                    byteArrayOutputStream.write(byArray2, 0, n);
                                }
                                byArray = byteArrayOutputStream.toByteArray();
                                classProviderListener.classLoadedFromFile(SinglePathClassProvider.this.pathFile);
                            }
                            Object var10_10 = null;
                            if (SinglePathClassProvider.this.cachingEnabled) {
                                SinglePathClassProvider.this.cachedZip = zipFile;
                                break block34;
                            }
                            if (zipFile == null) break block34;
                            try {
                                zipFile.close();
                            }
                            catch (IOException iOException2222) {
                                FFDCFilter.processException((Throwable)iOException2222, "com.ibm.ws.classloader.SinglePathClassProvider.run", "230", this);
                            }
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException2222) {
                                FFDCFilter.processException((Throwable)iOException2222, "com.ibm.ws.classloader.SinglePathClassProvider.run", "241", this);
                            }
                        }
                        if (byteArrayOutputStream != null) {
                            try {
                                byteArrayOutputStream.close();
                            }
                            catch (IOException iOException2222) {
                                FFDCFilter.processException((Throwable)iOException2222, "com.ibm.ws.classloader.SinglePathClassProvider.run", "252", this);
                            }
                        }
                        break block38;
                        {
                            catch (IOException iOException3) {
                                IOException iOException42222;
                                FFDCFilter.processException((Throwable)iOException3, "com.ibm.ws.classloader.SinglePathClassProvider.run", "214", this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, iOException3.toString());
                                }
                                Object var10_11 = null;
                                if (SinglePathClassProvider.this.cachingEnabled) {
                                    SinglePathClassProvider.this.cachedZip = zipFile;
                                } else if (zipFile != null) {
                                    try {
                                        zipFile.close();
                                    }
                                    catch (IOException iOException42222) {
                                        FFDCFilter.processException((Throwable)iOException42222, "com.ibm.ws.classloader.SinglePathClassProvider.run", "230", this);
                                    }
                                }
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (IOException iOException42222) {
                                        FFDCFilter.processException((Throwable)iOException42222, "com.ibm.ws.classloader.SinglePathClassProvider.run", "241", this);
                                    }
                                }
                                if (byteArrayOutputStream != null) {
                                    try {
                                        byteArrayOutputStream.close();
                                    }
                                    catch (IOException iOException42222) {
                                        FFDCFilter.processException((Throwable)iOException42222, "com.ibm.ws.classloader.SinglePathClassProvider.run", "252", this);
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            IOException iOException52222;
                            Object var10_12 = null;
                            if (SinglePathClassProvider.this.cachingEnabled) {
                                SinglePathClassProvider.this.cachedZip = zipFile;
                            } else if (zipFile != null) {
                                try {
                                    zipFile.close();
                                }
                                catch (IOException iOException52222) {
                                    FFDCFilter.processException((Throwable)iOException52222, "com.ibm.ws.classloader.SinglePathClassProvider.run", "230", this);
                                }
                            }
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException iOException52222) {
                                    FFDCFilter.processException((Throwable)iOException52222, "com.ibm.ws.classloader.SinglePathClassProvider.run", "241", this);
                                }
                            }
                            if (byteArrayOutputStream != null) {
                                try {
                                    byteArrayOutputStream.close();
                                }
                                catch (IOException iOException52222) {
                                    FFDCFilter.processException((Throwable)iOException52222, "com.ibm.ws.classloader.SinglePathClassProvider.run", "252", this);
                                }
                            }
                            throw throwable;
                        }
                    }
                }
                return byArray;
            }
        });
    }

    protected String getRealResourcePath(String string) {
        String string2;
        String string3;
        int n;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if ((n = string.lastIndexOf("/")) == -1) {
            string3 = string;
            string2 = this.pathFile.getPath();
        } else {
            string3 = string.substring(n + 1);
            string2 = string.substring(0, n);
            if (string2.startsWith("/")) {
                string2 = string2.substring(1);
            }
            string2 = string2.equals("") ? this.pathFile.getPath() : this.pathFile.getPath() + File.separator + string2;
        }
        string2 = string2.replace('/', File.separatorChar);
        return string2 + File.separator + string3;
    }

    public String toString() {
        return "SinglePathClassProvider : " + super.toString() + " classpath = " + this.pathFile.getPath();
    }

    public URL getResource(final String string) {
        URL uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                URL uRL;
                block12: {
                    String string4 = string;
                    uRL = null;
                    if (SinglePathClassProvider.this.pathExists) {
                        if (SinglePathClassProvider.this.isDirectory) {
                            try {
                                String string2 = SinglePathClassProvider.this.getRealResourcePath(string4);
                                File file = new File(string2);
                                if (!file.exists()) break block12;
                                uRL = file.getCanonicalFile().toURL();
                                if (string2.indexOf("../") > 0 && !uRL.getFile().startsWith(SinglePathClassProvider.this.url.getFile())) {
                                    return null;
                                }
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.classloader.SinglePathClassProvider.run", "324", this);
                            }
                        } else {
                            if (string4.startsWith("/")) {
                                string4 = string4.substring(1);
                            }
                            if (SinglePathClassProvider.this.entriesInJar.contains(string4)) {
                                try {
                                    ZipFile zipFile = new ZipFile(SinglePathClassProvider.this.pathFile);
                                    ZipEntry zipEntry = zipFile.getEntry(string4);
                                    if (zipEntry != null) {
                                        String string3 = SinglePathClassProvider.this.pathFile.toURL().toString();
                                        uRL = new URL(new URL("wsjar", "", -1, string3 + "!/"), string4);
                                    }
                                    zipFile.close();
                                }
                                catch (IOException iOException) {
                                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.classloader.SinglePathClassProvider.run", "350", this);
                                }
                                catch (Throwable throwable) {
                                    FFDCFilter.processException(throwable, "com.ibm.ws.classloader.SinglePathClassProvider.run", "354", this);
                                }
                            }
                        }
                    }
                }
                return uRL;
            }
        });
        if (uRL != null) {
            uRL = SinglePathClassProvider.checkURL(uRL);
        }
        return uRL;
    }

    private static URL checkURL(URL uRL) {
        try {
            SinglePathClassProvider.check(uRL);
        }
        catch (Exception exception) {
            return null;
        }
        return uRL;
    }

    private static void check(URL uRL) throws IOException {
        Permission permission;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (permission = uRL.openConnection().getPermission()) != null) {
            try {
                securityManager.checkPermission(permission);
            }
            catch (SecurityException securityException) {
                if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                    securityManager.checkRead(permission.getName());
                }
                if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
                throw securityException;
            }
        }
    }

    public InputStream getResourceAsStream(String string) {
        URL uRL = this.getResource(string);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected void buildContentsCache() {
        try {
            JarFile jarFile = new JarFile(this.path);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                String string = ((ZipEntry)enumeration.nextElement()).getName();
                this.entriesInJar.add(string);
                if (string.indexOf(".class") == -1) continue;
                StringBuffer stringBuffer = new StringBuffer(string);
                int n = stringBuffer.length();
                for (int i = 0; i < n; ++i) {
                    if (stringBuffer.charAt(i) != '/' && stringBuffer.charAt(i) != '\\') continue;
                    stringBuffer.setCharAt(i, '.');
                }
                stringBuffer.setLength(n - 6);
                this.classesInJar.add(stringBuffer.toString());
            }
            try {
                this.manifest = jarFile.getManifest();
            }
            catch (Exception exception) {
                // empty catch block
            }
            jarFile.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.classloader.SinglePathClassProvider.buildContentsCache", "453", this);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

