/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.command;

import com.ibm.etools.common.command.AbstractCommand;
import com.ibm.etools.common.command.Command;
import com.ibm.etools.common.command.CompoundCommand;
import com.ibm.etools.common.internal.CommonPlugin;
import com.ibm.etools.common.util.TraceStream;
import java.util.Collection;
import java.util.Collections;

public abstract class AbstractCommand
implements Command {
    protected boolean isPrepared;
    protected boolean isExecutable;
    protected String description;
    protected String label;

    protected AbstractCommand() {
    }

    protected AbstractCommand(String string) {
        this.label = string;
    }

    protected AbstractCommand(String string, String string2) {
        this.label = string;
        this.description = string2;
    }

    public boolean canExecute() {
        if (Trace.isEnabled) {
            Trace.out.enter("AbstractCommand.canExecute", this);
        }
        if (!this.isPrepared) {
            this.isExecutable = this.prepare();
            this.isPrepared = true;
        }
        if (Trace.isEnabled) {
            Trace.out.leave(this.isExecutable, !this.isExecutable);
        }
        return this.isExecutable;
    }

    public boolean canUndo() {
        if (Trace.isEnabled) {
            Trace.out.enter("AbstractCommand.canUndo", this);
            Trace.out.leave(true);
        }
        return true;
    }

    public Command chain(Command command) {
        class ChainedCompoundCommand
        extends CompoundCommand {
            private final /* synthetic */ AbstractCommand this$0;

            public ChainedCompoundCommand(AbstractCommand abstractCommand) {
                this.this$0 = abstractCommand;
            }

            public Command chain(Command command) {
                this.append(command);
                return this;
            }
        }
        ChainedCompoundCommand chainedCompoundCommand = new ChainedCompoundCommand(this);
        chainedCompoundCommand.append(this);
        chainedCompoundCommand.append(command);
        return chainedCompoundCommand;
    }

    public void dispose() {
    }

    public Collection getAffectedObjects() {
        return Collections.EMPTY_LIST;
    }

    public String getDescription() {
        return this.description == null ? CommonPlugin.getPlugin().getString("_UI_AbstractCommand_description") : this.description;
    }

    public String getLabel() {
        return this.label == null ? CommonPlugin.getPlugin().getString("_UI_AbstractCommand_label") : this.label;
    }

    public Collection getResult() {
        return Collections.EMPTY_LIST;
    }

    protected boolean prepare() {
        if (Trace.isEnabled) {
            Trace.out.enter("AbstractCommand.prepare", this);
            Trace.out.leave(false, true);
        }
        return false;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String toString() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        StringBuffer stringBuffer = new StringBuffer(n == -1 ? string : string.substring(n + 1));
        stringBuffer.append(" (label: " + this.label + ")");
        stringBuffer.append(" (description: " + this.description + ")");
        stringBuffer.append(" (isPrepared: " + this.isPrepared + ")");
        stringBuffer.append(" (isExecutable: " + this.isExecutable + ")");
        return stringBuffer.toString();
    }

    public void undo() {
        throw new RuntimeException(CommonPlugin.getPlugin().getString("_EXC_Method_not_implemented", this.getClass().getName() + ".undo()"));
    }

    public static class Trace {
        public static TraceStream out = TraceStream.getTraceStream(System.getProperty("EMF_TRACE_COMMAND"));
        public static boolean isEnabled = out != null;
        protected static int enableCount = isEnabled ? 1 : 0;

        public static void enable() {
            if (enableCount == 0) {
                if (out == null) {
                    out = TraceStream.getTraceStream("System.out");
                }
                isEnabled = true;
            }
            ++enableCount;
        }

        public static void disable() {
            if (--enableCount == 0) {
                isEnabled = false;
            }
        }
    }
}

