/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Stack;

public class TraceStream
extends PrintStream {
    protected static Hashtable traceStreamTable = new Hashtable();
    public static TraceStream out = TraceStream.getTraceStream("System.out");
    public static TraceStream err = TraceStream.getTraceStream("System.err");
    protected boolean isAtStartOfLine = true;
    protected Stack indentationStack = new Stack();
    protected int currentStreamIndex = 0;
    protected long logStartTime = System.currentTimeMillis();

    public TraceStream(PrintStream printStream) {
        super(printStream);
    }

    public void enter(Object object, Object object2) {
        if (!this.isAtStartOfLine) {
            super.println();
        }
        if (this.currentStreamIndex == 0) {
            super.print("Logging started: <b>" + DateFormat.getDateTimeInstance().format(new Date(this.logStartTime)) + "</b>");
            super.println();
        }
        IndentationStackRecord indentationStackRecord = this.indentationStack.empty() ? null : (IndentationStackRecord)this.indentationStack.peek();
        IndentationStackRecord indentationStackRecord2 = new IndentationStackRecord(++this.currentStreamIndex, object, object2);
        this.indentationStack.push(indentationStackRecord2);
        this.printLinePrefixHelper("<ol> <li> <pre> <!-- ", " --> ", '{');
        super.print("<b>+");
        super.print(indentationStackRecord2.startTime - this.logStartTime);
        super.print("</b> ");
        super.print(indentationStackRecord2.toForwardLinkAndBackwardAnchor());
        if (indentationStackRecord != null) {
            super.print(indentationStackRecord.toOutwardLink());
        }
        super.println();
        this.printLinePrefixHelper("<!--        --> <!-- ", " -->   ", '.');
        this.printWithHTMLIndentationHelper(indentationStackRecord2.object.toString(), '.', false);
        super.print("\t\t\t\t\t</pre></li>");
        super.println();
        this.isAtStartOfLine = true;
    }

    public static TraceStream getTraceStream(String string) {
        TraceStream traceStream;
        block7: {
            traceStream = null;
            if (string == null) break block7;
            try {
                traceStream = (TraceStream)traceStreamTable.get(string);
                if (traceStream == null) {
                    if (string.equals("out") || string.equals("System.out") || string.equals("1")) {
                        traceStream = new TraceStream(new PrintStream(System.out));
                    } else if (string.equals("err") || string.equals("System.err") || string.equals("2")) {
                        traceStream = new TraceStream(new PrintStream(System.err));
                    } else {
                        FileOutputStream fileOutputStream = new FileOutputStream(string);
                        traceStream = new TraceStream(new PrintStream(fileOutputStream));
                    }
                    traceStreamTable.put(string, traceStream);
                }
            }
            catch (Exception exception) {
                System.err.println("The TraceStream.getTraceStream(\"" + string + "\") caused an exception:");
                exception.printStackTrace();
            }
        }
        return traceStream;
    }

    public void leave() {
        this.leave(this);
    }

    public void leave(char[] cArray) {
        this.leave(cArray + "", false);
    }

    public void leave(char[] cArray, boolean bl) {
        this.leave(cArray + "", bl);
    }

    public void leave(char c) {
        this.leave(c + "", false);
    }

    public void leave(char c, boolean bl) {
        this.leave(c + "", bl);
    }

    public void leave(double d) {
        this.leave(d + "", false);
    }

    public void leave(double d, boolean bl) {
        this.leave(d + "", bl);
    }

    public void leave(float f) {
        this.leave(f + "", false);
    }

    public void leave(float f, boolean bl) {
        this.leave(f + "", bl);
    }

    public void leave(int n) {
        this.leave(n + "", false);
    }

    public void leave(int n, boolean bl) {
        this.leave(n + "", bl);
    }

    public void leave(long l) {
        this.leave(l + "", false);
    }

    public void leave(long l, boolean bl) {
        this.leave(l + "", bl);
    }

    public void leave(Object object) {
        this.leave(object, false);
    }

    public void leave(Object object, boolean bl) {
        if (!this.isAtStartOfLine) {
            this.println();
        }
        IndentationStackRecord indentationStackRecord = (IndentationStackRecord)this.indentationStack.peek();
        this.printLinePrefixHelper("     <li> <pre> <!-- ", " --> ", '}');
        long l = System.currentTimeMillis();
        super.print("<b>+");
        super.print(l - this.logStartTime);
        super.print(" [");
        super.print(l - indentationStackRecord.startTime);
        super.print("]</b> ");
        super.print(indentationStackRecord.toBackwardLinkAndFowardAnchor());
        super.println();
        this.printLinePrefixHelper("<!--        --> <!-- ", " -->   ", '.');
        this.printWithHTMLIndentationHelper(indentationStackRecord.object.toString(), '.', false);
        if (object == this) {
            super.print("\t\t\t\t\t</pre></li></li></ol>");
            super.println();
        } else {
            super.println();
            this.printLinePrefixHelper("<ul><li><!----> <!-- ", " -->   ", '-');
            this.printWithHTMLIndentationHelper(object == null ? "null" : object.toString(), '-', bl);
            super.print("\t\t\t\t\t</li></ul></pre></li></ol>");
            super.println();
        }
        this.isAtStartOfLine = true;
        this.indentationStack.pop();
    }

    public void leave(String string) {
        this.leave((Object)string, false);
    }

    public void leave(String string, boolean bl) {
        this.leave((Object)string, bl);
    }

    public void leave(boolean bl) {
        this.leave(bl + "", false);
    }

    public void leave(boolean bl, boolean bl2) {
        this.leave(bl + "", bl2);
    }

    public void print(char[] cArray) {
        if (this.isAtStartOfLine) {
            this.printLinePrefix();
        }
        if (cArray != null) {
            int n = 0;
            while (n < cArray.length) {
                this.printEncoded(cArray[n]);
                ++n;
            }
        }
        super.print(cArray);
    }

    public void print(char c) {
        if (this.isAtStartOfLine) {
            this.printLinePrefix();
        }
        this.printEncoded(c);
    }

    public void print(double d) {
        if (this.isAtStartOfLine) {
            this.printLinePrefix();
        }
        super.print(d);
    }

    public void print(float f) {
        if (this.isAtStartOfLine) {
            this.printLinePrefix();
        }
        super.print(f);
    }

    public void print(int n) {
        if (this.isAtStartOfLine) {
            this.printLinePrefix();
        }
        super.print(n);
    }

    public void print(long l) {
        if (this.isAtStartOfLine) {
            this.printLinePrefix();
        }
        super.print(l);
    }

    public void print(Object object) {
        if (this.isAtStartOfLine) {
            this.printLinePrefix();
        }
        this.printEncoded(object);
    }

    public void print(String string) {
        if (this.isAtStartOfLine) {
            this.printLinePrefix();
        }
        if (string != null) {
            int n = 0;
            while (n < string.length()) {
                this.printEncoded(string.charAt(n));
                ++n;
            }
        }
    }

    public void print(boolean bl) {
        if (this.isAtStartOfLine) {
            this.printLinePrefix();
        }
        super.print(bl);
    }

    protected void printEncoded(char c) {
        switch (c) {
            case '<': {
                super.print("&lt;");
                break;
            }
            case '&': {
                super.print("&amp;");
                break;
            }
            default: {
                super.print(c);
            }
        }
    }

    protected void printEncoded(Object object) {
        String string = object == null ? "null" : object.toString();
        this.print(string);
    }

    protected void printEnquoted(char c, String string) {
        super.print(c);
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c2 = string.charAt(n);
            if (c2 == c) {
                super.print('\\');
                super.print(c);
            } else {
                super.print(c2);
            }
            ++n;
        }
        super.print(c);
    }

    protected void printLinePrefix() {
        this.printLinePrefixHelper("<ul> <li> <pre> <!-- ", this.indentationStack.size() % 2 == 0 ? " | --> " : "   --> ", '>');
        this.isAtStartOfLine = false;
    }

    protected void printLinePrefixHelper(String string, String string2, char c) {
        super.print(string);
        int n = 0;
        int n2 = this.indentationStack.size();
        while (n < n2) {
            super.print(n % 2 == 0 ? " |" : "  ");
            ++n;
        }
        super.print(string2);
        super.print(c);
        super.print(' ');
    }

    protected void printLineSuffix() {
        super.print("\t\t\t\t\t</pre></li></ul>");
    }

    public void println() {
        if (this.isAtStartOfLine) {
            this.printLinePrefix();
        }
        this.printLineSuffix();
        super.println();
        this.isAtStartOfLine = true;
    }

    public void println(char[] cArray) {
        this.print(cArray);
        this.println();
    }

    public void println(char c) {
        this.print(c);
        this.println();
    }

    public void println(char c, String string) {
        this.println(c, string, false, true);
    }

    public void println(char c, String string, boolean bl) {
        this.println(c, string, bl, true);
    }

    public void println(char c, String string, boolean bl, boolean bl2) {
        if (bl2) {
            if (!this.isAtStartOfLine) {
                this.println();
            }
            this.printLinePrefixHelper("<ul> <li> <pre> <!-- ", " -->   ", c);
            this.printWithHTMLIndentationHelper(string, c, bl);
            this.printLineSuffix();
            super.println();
        } else {
            if (bl) {
                if (this.isAtStartOfLine) {
                    this.printLinePrefix();
                }
                super.print("<font color=\"#FF0000\">");
            }
            this.print(string);
            if (bl) {
                super.print("</font>");
            }
            this.println();
        }
    }

    public void println(double d) {
        this.print(d);
        this.println();
    }

    public void println(float f) {
        this.print(f);
        this.println();
    }

    public void println(int n) {
        this.print(n);
        this.println();
    }

    public void println(long l) {
        this.print(l);
        this.println();
    }

    public void println(Object object) {
        this.print(object);
        this.println();
    }

    public void println(String string) {
        this.print(string);
        this.println();
    }

    public void println(String string, boolean bl) {
        this.println(bl ? (char)'!' : '>', string, bl, false);
    }

    public void println(boolean bl) {
        this.print(bl);
        this.println();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void printWithHTMLIndentationHelper(String string, char c, boolean bl) {
        if (bl) {
            super.print("<font color=\"#FF0000\">");
        }
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.quoteChar(34);
        streamTokenizer.ordinaryChar(32);
        streamTokenizer.ordinaryChar(47);
        streamTokenizer.ordinaryChar(45);
        streamTokenizer.ordinaryChars(48, 57);
        int n = 0;
        boolean bl2 = false;
        try {
            block13: while (streamTokenizer.nextToken() != -1) {
                block1 : switch (streamTokenizer.ttype) {
                    case 44: {
                        super.print(',');
                        super.println();
                        this.printLinePrefixHelper("<!--        --> <!-- ", " -->   ", c);
                        int n2 = n * 2;
                        while (true) {
                            if (n2 <= 0) {
                                if (n > 0) {
                                    super.print(' ');
                                }
                                bl2 = true;
                                continue block13;
                            }
                            super.print(" ");
                            --n2;
                        }
                    }
                    case 32: {
                        if (bl2) continue block13;
                        super.print(' ');
                        continue block13;
                    }
                    case 40: 
                    case 91: 
                    case 123: {
                        super.println();
                        this.printLinePrefixHelper("<!--        --> <!-- ", " -->   ", c);
                        int n2 = ++n * 2;
                        while (true) {
                            if (n2 <= 0) {
                                super.print((char)streamTokenizer.ttype);
                                break block1;
                            }
                            super.print(" ");
                            --n2;
                        }
                    }
                    case 41: 
                    case 93: 
                    case 125: {
                        --n;
                        super.print((char)streamTokenizer.ttype);
                        break;
                    }
                    case 34: {
                        this.printEnquoted('\"', streamTokenizer.sval);
                        break;
                    }
                    case 38: {
                        super.print("&amp;");
                        break;
                    }
                    case 60: {
                        super.print("&lt;");
                        break;
                    }
                    case -2: {
                        super.print(streamTokenizer.nval);
                        break;
                    }
                    case -3: {
                        super.print(streamTokenizer.sval);
                        break;
                    }
                    default: {
                        super.print((char)streamTokenizer.ttype);
                    }
                }
                bl2 = false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (bl) {
            super.print("\t\t</font>");
        }
    }

    protected static class IndentationStackRecord {
        public int streamIndex;
        public Object tag;
        public Object object;
        public long startTime;

        public IndentationStackRecord(int n, Object object, Object object2) {
            this.streamIndex = n;
            this.tag = object;
            this.object = object2;
            this.startTime = System.currentTimeMillis();
        }

        public String toForwardLinkAndBackwardAnchor() {
            String string = Integer.toHexString(this.streamIndex);
            return this.tag + " " + this.object.getClass().getName() + "@" + Integer.toHexString(this.object.hashCode()) + " <a name=\"++" + string + "\" href=\"#--" + string + "\">FORWARD</a>";
        }

        public String toBackwardLinkAndFowardAnchor() {
            String string = Integer.toHexString(this.streamIndex);
            return this.tag + " " + this.object.getClass().getName() + "@" + Integer.toHexString(this.object.hashCode()) + " <a href=\"#++" + string + "\" name=\"--" + string + "\">BACKWARD</a>";
        }

        public String toOutwardLink() {
            String string = Integer.toHexString(this.streamIndex);
            return " <a href=\"#++" + string + "\">OUTWARD</a>";
        }

        public String toString() {
            return "IndentationStackRecord (streamIndex: " + this.streamIndex + ", tag: " + this.tag + ", object: " + this.object + ")";
        }
    }
}

