/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.resource;

import com.ibm.websphere.resource.WASResourceFactoryRegistryImpl;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class WASResourceSetImpl
extends ResourceSetImpl {
    public WASResourceSetImpl() {
        if (this.resourceFactoryRegistry == null) {
            this.resourceFactoryRegistry = WASResourceFactoryRegistryImpl.INSTANCE;
        }
    }

    private Resource getExistingResource(URI uRI) {
        URIConverter uRIConverter = this.getURIConverter();
        URI uRI2 = uRIConverter.normalize(uRI);
        EList eList = this.getResources();
        int n = eList.size();
        ArrayList arrayList = new ArrayList(n);
        arrayList.addAll(eList);
        int n2 = 0;
        while (n2 < n) {
            Resource resource = (Resource)arrayList.get(n2);
            if (uRIConverter.normalize(resource.getURI()).equals((Object)uRI2)) {
                if (resource.isLoaded()) {
                    return resource;
                }
                try {
                    this.demandLoad(resource);
                }
                catch (Resource.IOWrappedException iOWrappedException) {
                    throw new WrappedException(iOWrappedException.getWrappedException());
                }
                catch (IOException iOException) {
                    throw new WrappedException((Exception)iOException);
                }
                return resource;
            }
            ++n2;
        }
        return null;
    }

    public Resource createResource(URI uRI) {
        Resource.Factory factory = this.getResourceFactoryRegistry().getFactory(uRI);
        if (factory != null) {
            Resource resource = this.getExistingResource(uRI);
            if (resource != null) {
                return resource;
            }
            Resource resource2 = factory.createResource(uRI);
            this.getResources().add((Object)resource2);
            return resource2;
        }
        return null;
    }

    public Resource.Factory.Registry getResourceFactoryRegistry() {
        if (this.resourceFactoryRegistry == null) {
            this.resourceFactoryRegistry = WASResourceFactoryRegistryImpl.INSTANCE;
        }
        return this.resourceFactoryRegistry;
    }
}

