/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.servlet.filter;

import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.servlet.filter.ChainedResponse;
import com.ibm.websphere.servlet.request.ServletInputStreamAdapter;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.servlet.RequestUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ChainedRequest
extends HttpServletRequestWrapper {
    private ChainedResponse _resp;
    private HttpServletRequest _req;
    private ServletInputStream _in;
    private BufferedReader _reader;
    private Hashtable _parameters = new Hashtable();
    private Hashtable _headers = new Hashtable();
    private static NLS nls = new NLS("com.ibm.servlet.resources.ServletEngineNLS");

    ChainedRequest(ChainedResponse chainedResponse, HttpServletRequest httpServletRequest) throws IOException {
        super(httpServletRequest);
        this._resp = chainedResponse;
        this._req = httpServletRequest;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(chainedResponse.getOutputBuffer());
        System.out.println("Creating chained Request with buffer:\n" + new String(chainedResponse.getOutputBuffer()));
        this._in = new ServletInputStreamAdapter(byteArrayInputStream);
    }

    public Cookie[] getCookies() {
        return this._resp.getCookies();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this._in;
    }

    public BufferedReader getReader() throws IOException {
        if (this._reader == null) {
            this._reader = new BufferedReader(new InputStreamReader((InputStream)this._in, this._resp.getCharacterEncoding()));
        }
        return this._reader;
    }

    public HttpServletRequest getProxiedHttpServletRequest() {
        return this._req;
    }

    protected void setHeader(String string, String string2) {
        if (string == null) {
            return;
        }
        if (string2 == null) {
            this._headers.remove(string);
        } else {
            this._headers.put(string, string2);
        }
    }

    public Enumeration getHeaderNames() {
        return this._headers.keys();
    }

    public String getHeader(String string) {
        return (String)this._headers.get(string);
    }

    public int getIntHeader(String string) throws NumberFormatException {
        String string2 = (String)this._headers.get(string);
        if (string2 == null) {
            return -1;
        }
        return Integer.valueOf(string2);
    }

    public long getDateHeader(String string) {
        String string2 = (String)this._headers.get(string);
        if (string2 == null) {
            return -1L;
        }
        return Long.valueOf(string2);
    }

    public int getContentLength() {
        return this.getIntHeader("content-length");
    }

    public String getContentType() {
        return this.getHeader("content-type");
    }

    public String getParameter(String string) {
        String[] stringArray;
        if (this._parameters == null) {
            this.parseParameters();
        }
        if ((stringArray = (String[])this._parameters.get(string)) != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public Enumeration getParameterNames() {
        if (this._parameters == null) {
            this.parseParameters();
        }
        return this._parameters.keys();
    }

    public String[] getParameterValues(String string) {
        if (this._parameters == null) {
            this.parseParameters();
        }
        return (String[])this._parameters.get(string);
    }

    private synchronized void parseParameters() {
        if (this._parameters == null) {
            try {
                String string;
                String string2 = this.getMethod().toLowerCase();
                if (string2.equals("get")) {
                    String string3 = this.getQueryString();
                    if (string3 != null && string3.indexOf("=") != -1) {
                        this._parameters = RequestUtils.parseQueryString(this.getQueryString());
                    }
                } else if (string2.equals("post") && (string = this.getContentType()) != null && string.equals("application/x-www-form-urlencoded")) {
                    this._parameters = this.parsePostData(this.getContentLength(), this.getInputStream());
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.websphere.servlet.filter.ChainedResponse.parseParameters", (String)"286", (Object)((Object)this));
                iOException.printStackTrace();
            }
            if (this._parameters == null) {
                this._parameters = new Hashtable();
            }
        }
    }

    private Hashtable parsePostData(int n, ServletInputStream servletInputStream) {
        String string;
        byte[] byArray = null;
        if (n <= 0) {
            return null;
        }
        try {
            int n2;
            byArray = new byte[n];
            int n3 = 0;
            do {
                if ((n2 = servletInputStream.read(byArray, n3, n - n3)) > 0) continue;
                String string2 = nls.getString("post.body.contains.less.bytes.than.specified", "post body contains less bytes than specified by content-length");
                throw new IOException(string2);
            } while (n - (n3 += n2) > 0);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.websphere.servlet.filter.ChainedResponse.parsePostData", (String)"326", (Object)((Object)this));
            return new Hashtable();
        }
        try {
            string = new String(byArray, this._resp.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.websphere.servlet.filter.ChainedResponse.parsePostData", (String)"341", (Object)((Object)this));
            string = new String(byArray);
        }
        return RequestUtils.parseQueryString(string);
    }
}

