/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.servlet.filter;

import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.servlet.filter.ChainedResponse;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletChain
implements RequestDispatcher {
    Vector _dispatchers = new Vector();
    private static NLS nls = new NLS("com.ibm.servlet.resources.ServletEngineNLS");

    public ServletChain() {
    }

    public ServletChain(RequestDispatcher[] requestDispatcherArray) {
        for (int i = 0; i < requestDispatcherArray.length; ++i) {
            this.addRequestDispatcher(requestDispatcherArray[i]);
        }
    }

    public void addRequestDispatcher(RequestDispatcher requestDispatcher) {
        this._dispatchers.addElement(requestDispatcher);
    }

    public void addRequestDispatcher(int n, RequestDispatcher requestDispatcher) {
        this._dispatchers.insertElementAt(requestDispatcher, n);
    }

    public void clear() {
        this._dispatchers.removeAllElements();
    }

    public boolean containsRequestDispatcher(RequestDispatcher requestDispatcher) {
        return this._dispatchers.contains(requestDispatcher);
    }

    public Enumeration enumeration() {
        return this._dispatchers.elements();
    }

    public RequestDispatcher getRequestDispatcher(int n) {
        return (RequestDispatcher)this._dispatchers.elementAt(n);
    }

    public int indexOf(RequestDispatcher requestDispatcher) {
        return this._dispatchers.indexOf(requestDispatcher);
    }

    public boolean isEmpty() {
        return this._dispatchers.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRequestDispatcher(RequestDispatcher requestDispatcher) {
        Vector vector = this._dispatchers;
        synchronized (vector) {
            if (this._dispatchers.contains(requestDispatcher)) {
                this._dispatchers.removeElement(requestDispatcher);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestDispatcher removeRequestDispatcher(int n) {
        Vector vector = this._dispatchers;
        synchronized (vector) {
            RequestDispatcher requestDispatcher = this.getRequestDispatcher(n);
            this._dispatchers.removeElementAt(n);
            return requestDispatcher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestDispatcher setRequestDispatcher(int n, RequestDispatcher requestDispatcher) {
        Vector vector = this._dispatchers;
        synchronized (vector) {
            RequestDispatcher requestDispatcher2 = this.getRequestDispatcher(n);
            this._dispatchers.setElementAt(requestDispatcher, n);
            return requestDispatcher2;
        }
    }

    public int size() {
        return this._dispatchers.size();
    }

    public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        this.handleDispatch(servletRequest, servletResponse, false);
    }

    public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        this.handleDispatch(servletRequest, servletResponse, true);
    }

    private void handleDispatch(ServletRequest servletRequest, ServletResponse servletResponse, boolean bl) throws ServletException, IOException {
        HttpServletResponse httpServletResponse;
        HttpServletRequest httpServletRequest;
        try {
            httpServletRequest = (HttpServletRequest)servletRequest;
            httpServletResponse = (HttpServletResponse)servletResponse;
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.websphere.servlet.filter.ServletChain.handleDispatch", (String)"126", (Object)this);
            throw new ServletException(nls.getString("non-HTTP.request.or.response", "non-HTTP request or response"), (Throwable)classCastException);
        }
        Enumeration enumeration = this.enumeration();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            RequestDispatcher requestDispatcher = (RequestDispatcher)enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                ChainedResponse chainedResponse = new ChainedResponse(httpServletRequest, httpServletResponse);
                if (n == 0) {
                    Enumeration enumeration2 = httpServletRequest.getHeaderNames();
                    while (enumeration2.hasMoreElements()) {
                        String string = (String)enumeration2.nextElement();
                        String string2 = httpServletRequest.getHeader(string);
                        if (string.toLowerCase().startsWith("content")) continue;
                        chainedResponse.setAutoTransferringHeader(string, string2);
                    }
                }
                if (bl) {
                    requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)chainedResponse);
                } else {
                    requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)chainedResponse);
                }
                httpServletRequest = chainedResponse.getChainedRequest();
            } else if (bl) {
                requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            } else {
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
            ++n;
        }
    }

    public static void chainRequestDispatchers(RequestDispatcher[] requestDispatcherArray, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        for (int i = 0; i < requestDispatcherArray.length - 1; ++i) {
            ChainedResponse chainedResponse = new ChainedResponse(httpServletRequest, httpServletResponse);
            requestDispatcherArray[i].forward((ServletRequest)httpServletRequest, (ServletResponse)chainedResponse);
            httpServletRequest = chainedResponse.getChainedRequest();
        }
        requestDispatcherArray[requestDispatcherArray.length - 1].forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }
}

