/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.servlet.response;

import com.ibm.websphere.servlet.error.ServletErrorReport;
import com.ibm.websphere.servlet.response.DummyResponse;
import com.ibm.websphere.servlet.response.ResponseErrorReport;
import com.ibm.websphere.servlet.response.ServletOutputStreamAdapter;
import com.ibm.websphere.servlet.response.StoredHeader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.servlet.IncludedResponse;
import com.ibm.ws.webcontainer.srt.IExtendedResponse;
import com.ibm.ws.webcontainer.srt.IResponseOutput;
import com.ibm.ws.webcontainer.srt.SRTRequestUtils;
import com.ibm.ws.webcontainer.srt.SRTServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class StoredResponse
extends HttpServletResponseWrapper
implements HttpServletResponse,
Serializable,
IResponseOutput,
IExtendedResponse {
    private static final int DEFAULT_STATUS_CODE = 200;
    private PrintWriter _writer;
    private ServletOutputStream _out;
    private ByteArrayOutputStream _bout;
    private boolean _isFinished;
    private byte[] _outputBuffer;
    private int _statusCode = 200;
    private String _statusMessage;
    private String _redirectURI;
    private Cookie[] _cookies = new Cookie[0];
    private long _lastModified;
    private ResponseErrorReport _error;
    private StoredHeader _header = new StoredHeader();
    private boolean _writerObtained = false;
    private boolean _outputStreamObtained = false;
    private static final String _defaultEncoding = "ISO-8859-1";
    private String _encoding;
    private Locale _locale;
    private Locale _defaultLocale;
    private int bufferSize = 4096;
    private boolean isCommitted = false;

    public StoredResponse() {
        super((HttpServletResponse)new DummyResponse());
        this._bout = new ByteArrayOutputStream();
        this._out = new ServletOutputStreamAdapter(this._bout);
        this.setContentType("text/html");
        this._encoding = _defaultEncoding;
        this._locale = this._defaultLocale = Locale.getDefault();
    }

    public boolean writerObtained() {
        return this._writerObtained;
    }

    public boolean outputStreamObtained() {
        return this._outputStreamObtained;
    }

    public void addCookie(Cookie cookie) {
        Cookie[] cookieArray = new Cookie[this._cookies.length + 1];
        System.arraycopy(this._cookies, 0, cookieArray, 0, this._cookies.length);
        cookieArray[this._cookies.length] = cookie;
        this._cookies = cookieArray;
    }

    public ServletOutputStream getOutputStream() throws IllegalStateException {
        if (this._writerObtained) {
            throw new IllegalStateException("Writer as already been obtained for this Response object");
        }
        this._outputStreamObtained = true;
        return this._out;
    }

    public void setContentLength(int n) {
        this.setIntHeader("content-length", n);
    }

    public void setContentType(String string) {
        this.setHeader("content-type", string);
    }

    public void setBufferSize(int n) throws IllegalStateException {
        try {
            if (this._writer != null) {
                this._writer.flush();
            }
            if (this._out != null) {
                this._out.flush();
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.websphere.servlet.response.StoredResponse.setBufferSize", (String)"124", (Object)this);
        }
        if (this._bout.size() > 0) {
            throw new IllegalStateException("Cannot set buffer size after write");
        }
        this.bufferSize = n;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void flushBuffer() throws IOException {
        this.flushBuffer(true);
    }

    public void flushBuffer(boolean bl) throws IOException {
        if (this._writer != null) {
            this._writer.flush();
        }
        if (this._out != null) {
            this._out.flush();
        }
        this.isCommitted = true;
    }

    public boolean isCommitted() {
        return this.isCommitted;
    }

    public void reset() throws IllegalStateException {
        if (this.isCommitted) {
            throw new IllegalStateException("Response cannot be reset after it has been committed");
        }
        if (this._writer != null) {
            this._writer.flush();
        }
        if (this._bout != null) {
            this._bout.reset();
        }
        this.isCommitted = false;
    }

    public Vector[] getHeaderTable() {
        return null;
    }

    public void addSessionCookie(Cookie cookie) {
        throw new IllegalStateException("This method is not supported, use HttpServletResponse.addCookie(Cookie cookie) instead");
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
        this.setCharacterEncoding(SRTRequestUtils.getEncodingFromLocale(this._locale));
    }

    public void setCharacterEncoding(String string) {
        if (string != null) {
            if (string.startsWith("\"") || string.startsWith("'")) {
                string = string.substring(1);
            }
            if (string.endsWith("\"") || string.endsWith("'")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        this._encoding = string;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void addDateHeader(String string, long l) {
    }

    public void addHeader(String string, String string2) {
    }

    public void addIntHeader(String string, int n) {
    }

    public void setHeader(String string, String string2) {
        String string3;
        int n;
        if (string.toLowerCase().equals("content-type") && string2 != null && (n = (string3 = string2.toLowerCase()).indexOf("charset=")) != -1) {
            String string4 = string3.substring(n + 8);
            if (string4.startsWith("\"") || string4.startsWith("'")) {
                string4 = string4.substring(1);
            }
            if (string4.endsWith("\"") || string4.endsWith("'")) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            this.setCharacterEncoding(string4);
            string2 = string3.substring(0, n + 8) + string4;
        }
        this._header.setHeader(string, string2);
    }

    public void setIntHeader(String string, int n) {
        this._header.setIntHeader(string, n);
    }

    public void setDateHeader(String string, long l) {
        this._header.setDateHeader(string, l);
    }

    public boolean containsHeader(String string) {
        return this._header.containsHeader(string);
    }

    public PrintWriter getWriter() throws IOException, IllegalStateException {
        if (this._outputStreamObtained) {
            throw new IllegalStateException("OutputStream already obtained for this Response object");
        }
        if (this._writerObtained) {
            return this._writer;
        }
        OutputStreamWriter outputStreamWriter = null;
        try {
            String string = this.getCharacterEncoding();
            outputStreamWriter = string == null ? new OutputStreamWriter((OutputStream)this._out) : new OutputStreamWriter((OutputStream)this._out, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.websphere.servlet.response.StoredResponse.getWriter", (String)"248", (Object)this);
            outputStreamWriter = new OutputStreamWriter((OutputStream)this._out);
        }
        this._writer = new PrintWriter(outputStreamWriter);
        outputStreamWriter = null;
        this._writerObtained = true;
        return this._writer;
    }

    public void setStatus(int n) {
        this._statusCode = n;
    }

    public void setStatus(int n, String string) {
        this._statusCode = n;
        this._statusMessage = string;
    }

    public void sendError(int n) throws IOException {
        this._error = new ResponseErrorReport();
        this._error.setErrorCode(n);
    }

    public void sendError(int n, String string) throws IOException {
        this._error = new ResponseErrorReport(string);
        this._error.setErrorCode(n);
    }

    public String encodeURL(String string) {
        return string;
    }

    public String encodeUrl(String string) {
        return this.encodeUrl(string);
    }

    public void sendRedirect(String string) {
        this._redirectURI = string;
    }

    public String encodeRedirectURL(String string) {
        return string;
    }

    public String encodeRedirectUrl(String string) {
        return this.encodeRedirectURL(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish() throws IOException {
        if (this._isFinished) {
            return;
        }
        StoredResponse storedResponse = this;
        synchronized (storedResponse) {
            if (this._isFinished) {
                return;
            }
            if (this._writer != null) {
                this._writer.flush();
            }
            this._out.close();
            this._isFinished = true;
            this._outputBuffer = this._bout.toByteArray();
            this.setContentLength(this._outputBuffer.length);
            this._lastModified = this._header.getDateHeader("last-modified");
            this._writer = null;
            this._out = null;
            this._bout = null;
            this._writerObtained = false;
            this._outputStreamObtained = false;
        }
    }

    public void close() throws IOException {
        this.finish();
    }

    public byte[] getOutputBuffer() throws IOException {
        this.finish();
        return this._outputBuffer;
    }

    public String getOutputBufferAsString() throws IOException {
        return new String(this.getOutputBuffer(), this.getCharacterEncoding());
    }

    public Enumeration getHeaderNames() {
        return this._header.getHeaderNames();
    }

    public String getHeader(String string) {
        return this._header.getHeader(string);
    }

    public int getIntHeader(String string) {
        return this._header.getIntHeader(string);
    }

    public long getDateHeader(String string) {
        return this._header.getDateHeader(string);
    }

    public boolean containsError() {
        return this._error != null;
    }

    public ServletErrorReport getError() {
        return this._error;
    }

    public String getErrorMessage() {
        if (this.containsError()) {
            return this.getError().getMessage();
        }
        return null;
    }

    public int getErrorStatusCode() {
        if (!this.containsError()) {
            throw new IllegalStateException("sendError() was not called");
        }
        return this.getError().getErrorCode();
    }

    public int getStatusCode() {
        return this._statusCode;
    }

    public String getStatusMessage() {
        return this._statusMessage;
    }

    public String getRedirectURI() {
        if (!this.isRedirected()) {
            throw new IllegalStateException("sendRedirect() was not called");
        }
        return this._redirectURI;
    }

    public boolean isRedirected() {
        return this._redirectURI != null;
    }

    public String getCharacterEncoding() {
        return this._encoding;
    }

    public Cookie[] getCookies() {
        return this._cookies;
    }

    public long getLastModified() {
        return this._lastModified;
    }

    public boolean isExpired() {
        return false;
    }

    public void transferResponse(HttpServletResponse httpServletResponse) throws IOException {
        this.finish();
        if (this.containsError()) {
            String string = this.getErrorMessage();
            int n = this.getErrorStatusCode();
            if (string == null) {
                httpServletResponse.sendError(n);
            } else {
                httpServletResponse.sendError(n, string);
            }
        } else if (this.isRedirected()) {
            Cookie[] cookieArray = this.getCookies();
            for (int i = 0; i < cookieArray.length; ++i) {
                httpServletResponse.addCookie(cookieArray[i]);
            }
            httpServletResponse.sendRedirect(this.getRedirectURI());
        } else {
            ServletOutputStream servletOutputStream;
            if (this.getStatusMessage() == null) {
                httpServletResponse.setStatus(this.getStatusCode());
            } else {
                httpServletResponse.setStatus(this.getStatusCode(), this.getStatusMessage());
            }
            this._header.transferHeader(httpServletResponse);
            Cookie[] cookieArray = this.getCookies();
            for (int i = 0; i < cookieArray.length; ++i) {
                httpServletResponse.addCookie(cookieArray[i]);
            }
            try {
                servletOutputStream = httpServletResponse.getOutputStream();
            }
            catch (IllegalStateException illegalStateException) {
                while (!(httpServletResponse instanceof StoredResponse) && httpServletResponse instanceof HttpServletResponseWrapper) {
                    httpServletResponse = (HttpServletResponse)((HttpServletResponseWrapper)httpServletResponse).getResponse();
                }
                while (httpServletResponse instanceof IncludedResponse) {
                    httpServletResponse = ((IncludedResponse)httpServletResponse).getProxiedHttpServletResponse();
                }
                if (httpServletResponse instanceof SRTServletResponse) {
                    httpServletResponse.getWriter().write(this.getOutputBufferAsString().toCharArray());
                    return;
                }
                StoredResponse storedResponse = (StoredResponse)httpServletResponse;
                servletOutputStream = storedResponse._out;
            }
            servletOutputStream.write(this.getOutputBuffer());
        }
    }

    public void resetBuffer() {
        this._bout.reset();
    }
}

