/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.PropertyVetoException;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.runtime.component.ContainerImpl;
import com.ibm.ws.runtime.config.ContainerConfig;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectHandler;
import com.ibm.ws.runtime.metadata.MetaDataFactory;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.runtime.service.ApplicationServer;
import com.ibm.ws.runtime.service.MetaDataFactoryMgr;
import com.ibm.ws.runtime.service.RuntimeCtxImpl;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.webcontainer.WebContainerService;
import com.ibm.ws.webcontainer.exception.WebAppNotFoundException;
import com.ibm.ws.webcontainer.exception.WebAppNotLoadedException;
import com.ibm.ws.webcontainer.metadata.WebMetaDataFactory;
import com.ibm.ws.webcontainer.session.SessionRegistry;
import com.ibm.ws.webcontainer.srt.WebGroup;
import com.ibm.ws.webcontainer.webapp.collaborator.WebAppCollaborator;
import com.ibm.ws.webcontainer.webapp.collaborator.WebAppInitializationCollaborator;
import com.ibm.ws.webcontainer.webapp.collaborator.WebAppInvocationCollaborator;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextServiceProvider;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.emf.ecore.EObject;

public class WebContainerImpl
extends ContainerImpl
implements DeployedObjectHandler,
VetoableChangeListener,
WebContainerService {
    protected com.ibm.ws.webcontainer.WebContainer _webContainer = null;
    protected WebContainer _webContainerConfig = null;
    protected boolean startTransports = false;
    protected ArrayList webAppInitializationCollaboratorList;
    protected ArrayList webAppInvocationCollaboratorList;
    SessionRegistry _sessRegistry = null;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$ApplicationServer;
    static /* synthetic */ Class class$com$ibm$ws$webcontainer$WebContainerService;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$MetaDataFactoryMgr;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$ApplicationMgr;
    static /* synthetic */ Class class$com$ibm$ws$security$service$SecurityService;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$VariableMap;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$ThreadPoolMgr;

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        ContainerConfig containerConfig = (ContainerConfig)object;
        WebContainer webContainer = (WebContainer)containerConfig.getConfig();
        if (webContainer.getStateManagement() != null && webContainer.getStateManagement().getInitialState() != null && webContainer.getStateManagement().getInitialState().getValue() == 1) {
            throw new ComponentDisabledException();
        }
        this._webContainerConfig = webContainer;
        ApplicationServer applicationServer = (ApplicationServer)this.getService(class$com$ibm$ws$runtime$service$ApplicationServer == null ? (class$com$ibm$ws$runtime$service$ApplicationServer = WebContainerImpl.class$("com.ibm.ws.runtime.service.ApplicationServer")) : class$com$ibm$ws$runtime$service$ApplicationServer);
        applicationServer.addVetoableChangeListener("state", (VetoableChangeListener)this);
        this.releaseService(applicationServer);
        this.getOuterBCS().addService(class$com$ibm$ws$webcontainer$WebContainerService == null ? (class$com$ibm$ws$webcontainer$WebContainerService = WebContainerImpl.class$("com.ibm.ws.webcontainer.WebContainerService")) : class$com$ibm$ws$webcontainer$WebContainerService, (BeanContextServiceProvider)((Object)this));
        MetaDataFactoryMgr metaDataFactoryMgr = (MetaDataFactoryMgr)this.getService(class$com$ibm$ws$runtime$service$MetaDataFactoryMgr == null ? (class$com$ibm$ws$runtime$service$MetaDataFactoryMgr = WebContainerImpl.class$("com.ibm.ws.runtime.service.MetaDataFactoryMgr")) : class$com$ibm$ws$runtime$service$MetaDataFactoryMgr);
        WebMetaDataFactory.init(metaDataFactoryMgr);
        metaDataFactoryMgr.addMetaDataFactory((MetaDataFactory)new WebMetaDataFactory());
        this.releaseService(metaDataFactoryMgr);
        this.components = this.loadComponents("META-INF/ws-webcontainer-startup.xml");
        this.initializeComponents((EObject)webContainer, containerConfig.getLocators());
    }

    public void destroy() {
        this.destroyComponents();
    }

    public void start() throws RuntimeError, RuntimeWarning {
        this.startComponents();
        ApplicationMgr applicationMgr = (ApplicationMgr)this.getService(class$com$ibm$ws$runtime$service$ApplicationMgr == null ? (class$com$ibm$ws$runtime$service$ApplicationMgr = WebContainerImpl.class$("com.ibm.ws.runtime.service.ApplicationMgr")) : class$com$ibm$ws$runtime$service$ApplicationMgr);
        applicationMgr.addDeployedObjectHandler((DeployedObjectHandler)this);
        this.releaseService(applicationMgr);
    }

    public void stop() {
        if (this._webContainer != null) {
            this._webContainer.shutdown();
        }
        this.stopComponents();
    }

    public synchronized void install(DeployedObject deployedObject) throws RuntimeError, RuntimeWarning {
        this.init();
        try {
            this._webContainer.addWebApplication((DeployedModule)deployedObject);
        }
        catch (WebAppNotLoadedException webAppNotLoadedException) {
            FFDCFilter.processException((Throwable)webAppNotLoadedException, (String)"com.ibm.ws.runtime.component.WebContainerImpl.install", (String)"124", (Object)this);
            throw new RuntimeWarning((Throwable)webAppNotLoadedException);
        }
    }

    public synchronized void uninstall(DeployedObject deployedObject) {
        if (this._webContainer != null) {
            this._webContainer.removeWebApplication((DeployedModule)deployedObject);
        }
    }

    public void addWebAppCollaborator(WebAppCollaborator webAppCollaborator) {
        if (this._webContainer != null) {
            throw new IllegalStateException("Web container already initialized");
        }
        if (webAppCollaborator != null) {
            if (webAppCollaborator instanceof WebAppInvocationCollaborator) {
                if (this.webAppInvocationCollaboratorList == null) {
                    this.webAppInvocationCollaboratorList = new ArrayList();
                }
                this.webAppInvocationCollaboratorList.add(webAppCollaborator);
            }
            if (webAppCollaborator instanceof WebAppInitializationCollaborator) {
                if (this.webAppInitializationCollaboratorList == null) {
                    this.webAppInitializationCollaboratorList = new ArrayList();
                }
                this.webAppInitializationCollaboratorList.add(webAppCollaborator);
            }
        }
    }

    protected void init() throws RuntimeError {
        if (this._webContainer != null) {
            return;
        }
        this._webContainer = com.ibm.ws.webcontainer.WebContainer.getWebContainer();
        this._webContainer.setSessionRegistry(this._sessRegistry);
        WebAppInitializationCollaborator[] webAppInitializationCollaboratorArray = null;
        if (this.webAppInitializationCollaboratorList != null) {
            webAppInitializationCollaboratorArray = new WebAppInitializationCollaborator[this.webAppInitializationCollaboratorList.size()];
            webAppInitializationCollaboratorArray = this.webAppInitializationCollaboratorList.toArray(webAppInitializationCollaboratorArray);
        } else {
            webAppInitializationCollaboratorArray = new WebAppInitializationCollaborator[]{};
        }
        WebAppInvocationCollaborator[] webAppInvocationCollaboratorArray = null;
        if (this.webAppInvocationCollaboratorList != null) {
            webAppInvocationCollaboratorArray = new WebAppInvocationCollaborator[this.webAppInvocationCollaboratorList.size()];
            webAppInvocationCollaboratorArray = this.webAppInvocationCollaboratorList.toArray(webAppInvocationCollaboratorArray);
        } else {
            webAppInvocationCollaboratorArray = new WebAppInvocationCollaborator[]{};
        }
        SecurityService securityService = (SecurityService)this.getService(class$com$ibm$ws$security$service$SecurityService == null ? (class$com$ibm$ws$security$service$SecurityService = WebContainerImpl.class$("com.ibm.ws.security.service.SecurityService")) : class$com$ibm$ws$security$service$SecurityService);
        if (securityService == null) {
            // empty if block
        }
        this._webContainer.initialize(this._webContainerConfig, new RuntimeCtxImpl(this.getBeanContextServices(), (BeanContextChild)((Object)this)), this, webAppInitializationCollaboratorArray, webAppInvocationCollaboratorArray, securityService);
        this.startTransports();
        this.registerMBean();
        this._webContainerConfig = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startTransports() throws RuntimeError {
        if (this._webContainer != null && this.startTransports) {
            ThreadPoolMgr threadPoolMgr;
            block6: {
                VariableMap variableMap = null;
                threadPoolMgr = null;
                try {
                    variableMap = (VariableMap)this.getService(class$com$ibm$ws$runtime$service$VariableMap == null ? (class$com$ibm$ws$runtime$service$VariableMap = WebContainerImpl.class$("com.ibm.ws.runtime.service.VariableMap")) : class$com$ibm$ws$runtime$service$VariableMap);
                    threadPoolMgr = (ThreadPoolMgr)this.getService(class$com$ibm$ws$runtime$service$ThreadPoolMgr == null ? (class$com$ibm$ws$runtime$service$ThreadPoolMgr = WebContainerImpl.class$("com.ibm.ws.runtime.service.ThreadPoolMgr")) : class$com$ibm$ws$runtime$service$ThreadPoolMgr);
                    this._webContainer.startTransports(variableMap, threadPoolMgr);
                    Object var4_3 = null;
                    if (variableMap == null) break block6;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (variableMap != null) {
                        this.releaseService(variableMap);
                    }
                    if (threadPoolMgr != null) {
                        this.releaseService(threadPoolMgr);
                    }
                    throw throwable;
                }
                this.releaseService(variableMap);
            }
            if (threadPoolMgr != null) {
                this.releaseService(threadPoolMgr);
            }
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (propertyChangeEvent.getNewValue().equals("STARTED")) {
            this.startTransports = true;
            try {
                this.startTransports();
            }
            catch (RuntimeError runtimeError) {
                throw new PropertyVetoException(runtimeError.getMessage(), propertyChangeEvent, (Throwable)runtimeError);
            }
        }
    }

    public boolean start(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        DeployedObject deployedObject = deployedObjectEvent.getDeployedObject();
        if (deployedObject.getModuleFile().isWARFile()) {
            this.install(deployedObject);
            return true;
        }
        return false;
    }

    public void stop(DeployedObjectEvent deployedObjectEvent) {
        DeployedObject deployedObject = deployedObjectEvent.getDeployedObject();
        if (deployedObject.getModuleFile().isWARFile()) {
            this.uninstall(deployedObject);
        }
    }

    public synchronized void reload(DeployedObject deployedObject) throws RuntimeWarning {
        try {
            if (deployedObject.getModuleFile().isWARFile()) {
                this._webContainer.reload((DeployedModule)deployedObject);
            }
        }
        catch (WebAppNotLoadedException webAppNotLoadedException) {
            FFDCFilter.processException((Throwable)webAppNotLoadedException, (String)"com.ibm.ws.runtime.component.WebContainerImpl.reload", (String)"379", (Object)this);
            throw new RuntimeWarning((Throwable)webAppNotLoadedException);
        }
    }

    public synchronized void restart(DeployedObject deployedObject) throws RuntimeWarning {
        try {
            if (deployedObject.getModuleFile().isWARFile()) {
                this._webContainer.restartWebApplication((DeployedModule)deployedObject);
            }
        }
        catch (WebAppNotLoadedException webAppNotLoadedException) {
            FFDCFilter.processException((Throwable)webAppNotLoadedException, (String)"com.ibm.ws.runtime.component.WebContainerImpl.restart", (String)"398", (Object)this);
            throw new RuntimeWarning((Throwable)webAppNotLoadedException);
        }
    }

    protected void registerMBean() {
        try {
            MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
            DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator(this._webContainer, "WebContainer");
            String string = mBeanFactory.getConfigId(this._webContainerConfig);
            mBeanFactory.activateMBean("WebContainer", defaultRuntimeCollaborator, string, null);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.runtime.component.WebContainerImpl.registerMBean", (String)"419", (Object)this);
        }
    }

    public void setSessionRegistry(SessionRegistry sessionRegistry) {
        this._sessRegistry = sessionRegistry;
    }

    public ClassLoader getClassLoader(J2EEName j2EEName) {
        Enumeration enumeration = this._webContainer.getWebGroupNames();
        while (enumeration.hasMoreElements()) {
            WebGroup webGroup = null;
            try {
                webGroup = this._webContainer.getWebGroup((String)enumeration.nextElement());
            }
            catch (WebAppNotFoundException webAppNotFoundException) {
                FFDCFilter.processException((Throwable)webAppNotFoundException, (String)"com.ibm.ws.runtime.component.WebContainerImpl.getClassLoader", (String)"447", (Object)this);
            }
            J2EEName j2EEName2 = webGroup.getWebApp().getModuleMetaData().getJ2EEName();
            String string = j2EEName2.getModule();
            String string2 = j2EEName2.getApplication();
            String string3 = j2EEName.getModule();
            String string4 = j2EEName.getApplication();
            if (!(string == null ? string3 == null : string.equals(string3)) || !(string2 == null ? string4 == null : string2.equals(string4))) continue;
            return webGroup.getClassLoader();
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

