/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.VirtualHost;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.exception.WebAppNotFoundException;
import com.ibm.ws.webcontainer.srt.WebGroup;
import com.ibm.ws.webcontainer.util.REException;
import com.ibm.ws.webcontainer.util.SimpleHashtable;
import com.ibm.ws.webcontainer.util.StringMatchResult;
import com.ibm.ws.webcontainer.util.StringMatcher;

public class WebAppHost {
    protected VirtualHost _vHostCfg;
    protected WebContainer _parent;
    protected static TraceComponent tc = Tr.register((String)(class$com$ibm$ws$webcontainer$WebAppHost == null ? (class$com$ibm$ws$webcontainer$WebAppHost = WebAppHost.class$("com.ibm.ws.webcontainer.WebAppHost")) : class$com$ibm$ws$webcontainer$WebAppHost).getName(), (String)"Servlet_Engine");
    private static NLS nls = new NLS("com.ibm.servlet.resources.ServletEngineNLS");
    protected StringMatcher _URIToWebGroupNameTable;
    protected SimpleHashtable _webGroupTable;
    static /* synthetic */ Class class$com$ibm$ws$webcontainer$WebAppHost;

    public VirtualHost getConfiguration() {
        return this._vHostCfg;
    }

    public void registerWebGroup(String string) {
        String string2 = string;
        try {
            if (!string.equals("/") && !string.startsWith("*.")) {
                if (string.endsWith("/")) {
                    string = string + "*";
                } else if (!string.endsWith("/*")) {
                    string = string + "/*";
                }
            }
            this._URIToWebGroupNameTable.put(string, string2);
        }
        catch (REException rEException) {
            FFDCFilter.processException((Throwable)rEException, (String)"com.ibm.ws.webcontainer.WebAppHost.registerWebGroup", (String)"65", (Object)this);
            Tr.error((TraceComponent)tc, (String)"Failed.to.addWebGroup", (Object)new Object[]{string, rEException});
        }
    }

    public void deregisterWebGroup(WebGroup webGroup) {
        String string = webGroup.getContextPath();
        if (!string.equals("/") && !string.startsWith("*.")) {
            if (string.endsWith("/")) {
                string = string + "*";
            } else if (!string.endsWith("/*")) {
                string = string + "/*";
            }
        }
        this._URIToWebGroupNameTable.remove(string);
    }

    public synchronized WebGroup findWebGroupByURI(String string) throws WebAppNotFoundException {
        StringMatchResult stringMatchResult;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findWebGroupByURI");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Searching for group with URI: {0}", (Object)string);
        }
        if ((stringMatchResult = this._URIToWebGroupNameTable.match(string)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"findWebGroupByURI");
            }
            throw new WebAppNotFoundException(string);
        }
        String string2 = (String)stringMatchResult.getTarget();
        if (string2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"findWebGroupByURI");
            }
            throw new WebAppNotFoundException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findWebGroupByURI");
        }
        return this._parent.getWebGroup(this._vHostCfg.getName() + string2);
    }

    public void init(WebContainer webContainer, VirtualHost virtualHost) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Servlet Host Information", (Object)virtualHost);
        }
        this._vHostCfg = virtualHost;
        this._parent = webContainer;
        this._URIToWebGroupNameTable = new StringMatcher();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    public void shutdown() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"shutdown");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"shutdown");
        }
    }

    public WebContainer getParent() {
        return this._parent;
    }

    public String getMimeType(String string) {
        return this._vHostCfg.getMimeType(string);
    }

    public String getVirtualHostName() {
        return this._vHostCfg.getName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

