/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.pmi.WebAppPerf;
import com.ibm.websphere.servlet.event.ApplicationEvent;
import com.ibm.websphere.servlet.event.ApplicationListener;
import com.ibm.websphere.servlet.event.ServletContextEventSource;
import com.ibm.websphere.servlet.event.ServletErrorEvent;
import com.ibm.websphere.servlet.event.ServletErrorListener;
import com.ibm.websphere.servlet.event.ServletEvent;
import com.ibm.websphere.servlet.event.ServletInvocationEvent;
import com.ibm.websphere.servlet.event.ServletInvocationListener;
import com.ibm.websphere.servlet.event.ServletListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.server.PmiFactory;
import com.ibm.ws.runtime.deploy.ComponentCollaborator;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.deploy.WebModuleCollaborator;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.webcontainer.metadata.WebComponentMetaData;
import com.ibm.ws.webcontainer.webapp.WebApp;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class WebAppPmiListener
implements ServletListener,
ServletInvocationListener,
ServletErrorListener,
ApplicationListener {
    J2EEName _appName = null;
    boolean areAppAggregatesInited = false;
    WebAppPerf appPmi = null;
    WebModuleCollaborator collab = null;

    public void onApplicationAvailableForService(ApplicationEvent applicationEvent) {
        if (!this.areAppAggregatesInited) {
            this.InitializeAppCounters(this.getAppName());
            this.areAppAggregatesInited = true;
        }
    }

    public void onApplicationUnavailableForService(ApplicationEvent applicationEvent) {
        if (this.appPmi != null) {
            this.appPmi.onApplicationUnavailableForService();
        }
    }

    public void onApplicationStart(ApplicationEvent applicationEvent) {
        String string = (String)applicationEvent.getServletContext().getAttribute("com.ibm.websphere.servlet.application.host");
        WebApp webApp = (WebApp)applicationEvent.getSource();
        ModuleMetaData moduleMetaData = webApp.getModuleMetaData();
        this._appName = moduleMetaData.getJ2EEName();
        ServletContextEventSource servletContextEventSource = (ServletContextEventSource)applicationEvent.getServletContext().getAttribute("com.ibm.websphere.servlet.event.ServletContextEventSource");
        servletContextEventSource.addServletErrorListener((ServletErrorListener)this);
        servletContextEventSource.addServletListener((ServletListener)this);
        servletContextEventSource.addServletInvocationListener((ServletInvocationListener)this);
        if (!this.areAppAggregatesInited) {
            this.InitializeAppCounters(this.getAppName());
            this.areAppAggregatesInited = true;
        }
        DeployedModule deployedModule = webApp.getWebAppContext().getConfiguration();
        Properties properties = new Properties();
        properties.put("Server", string);
        properties.put("Application", moduleMetaData.getApplicationMetaData().getName());
        properties.put("J2EEName", this._appName.toString());
        String string2 = deployedModule.getId();
        this.collab = new WebModuleCollaborator(deployedModule);
        this.registerMBean(this.collab.getType(), (RuntimeCollaborator)this.collab, deployedModule.getName(), string2, properties);
        if (this.appPmi != null) {
            this.appPmi.onApplicationStart();
        }
    }

    public void onApplicationEnd(ApplicationEvent applicationEvent) {
        this.collab.destroy();
        this.collab = null;
        this.deregisterModuleMBeans();
        if (this.appPmi != null) {
            this.appPmi.onApplicationEnd();
            PmiFactory.removePmiModule((Object)this.appPmi);
        }
    }

    public void onServletStartService(ServletInvocationEvent servletInvocationEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletStartService(servletInvocationEvent.getServletName());
        }
    }

    public void onServletFinishService(ServletInvocationEvent servletInvocationEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletFinishService(servletInvocationEvent.getServletName(), servletInvocationEvent.getResponseTime());
        }
    }

    public void onServletStartInit(ServletEvent servletEvent) {
        WebComponentMetaData webComponentMetaData = (WebComponentMetaData)ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        J2EEName j2EEName = webComponentMetaData.getJ2EEName();
        if (this.appPmi != null) {
            this.appPmi.onServletStartInit(j2EEName.toString(), servletEvent.getServletName());
        }
    }

    public void onServletFinishInit(ServletEvent servletEvent) {
        final WebComponentMetaData webComponentMetaData = (WebComponentMetaData)ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        boolean bl = servletEvent instanceof ServletErrorEvent;
        if (!bl && webComponentMetaData.getModuleMetaData().getApplicationMetaData().createComponentMBeans()) {
            J2EEName j2EEName = webComponentMetaData.getJ2EEName();
            String string = (String)servletEvent.getServletContext().getAttribute("com.ibm.websphere.servlet.application.host");
            final String string2 = webComponentMetaData.getWebComponentType() == 1 ? "Servlet" : "JSP";
            final Properties properties = new Properties();
            properties.put("Server", string);
            properties.put("Application", j2EEName.getApplication());
            properties.put("WebModule", j2EEName.getModule());
            final String string3 = j2EEName.toString();
            properties.put("J2EEName", string3);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    WebAppPmiListener.this.registerMBean(string2, (RuntimeCollaborator)new ComponentCollaborator(), webComponentMetaData.getName(), string3, properties);
                    return null;
                }
            });
        }
        if (this.appPmi != null) {
            this.appPmi.onServletFinishInit(servletEvent.getServletName());
        }
    }

    public void onServletStartDestroy(ServletEvent servletEvent) {
        final WebComponentMetaData webComponentMetaData = (WebComponentMetaData)ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (webComponentMetaData.getModuleMetaData().getApplicationMetaData().createComponentMBeans()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    WebAppPmiListener.this.deregisterMBean(webComponentMetaData.getJ2EEName().toString());
                    return null;
                }
            });
        }
        if (this.appPmi != null) {
            this.appPmi.onServletStartDestroy(servletEvent.getServletName());
        }
    }

    public void onServletFinishDestroy(ServletEvent servletEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletFinishDestroy(servletEvent.getServletName());
        }
    }

    public void onServletUnloaded(ServletEvent servletEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletUnloaded(servletEvent.getServletName());
        }
    }

    public void onServletAvailableForService(ServletEvent servletEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletAvailableForService(servletEvent.getServletName());
        }
    }

    public void onServletUnavailableForService(ServletEvent servletEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletUnavailableForService(servletEvent.getServletName());
        }
    }

    public void onServletInitError(ServletErrorEvent servletErrorEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletInitError(servletErrorEvent.getServletName());
        }
    }

    public void onServletServiceError(ServletErrorEvent servletErrorEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletServiceError(servletErrorEvent.getServletName());
        }
    }

    public void onServletServiceDenied(ServletErrorEvent servletErrorEvent) {
        if (this.appPmi != null) {
            this.appPmi.onServletServiceDenied(servletErrorEvent.getServletName());
        }
    }

    public void onServletDestroyError(ServletErrorEvent servletErrorEvent) {
        if (servletErrorEvent != null && servletErrorEvent.getServletName() != null && this.appPmi != null) {
            this.appPmi.onServletDestroyError(servletErrorEvent.getServletName());
        }
    }

    public void InitializeAppCounters(String string) {
        this.appPmi = PmiFactory.createWebAppPerf((String)string);
    }

    public String getAppName() {
        return this._appName.toString();
    }

    protected void registerMBean(String string, RuntimeCollaborator runtimeCollaborator, String string2, String string3, Properties properties) {
        properties.put("name", string2);
        MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
        try {
            String string4 = mBeanFactory.getConfigId(string3);
            mBeanFactory.activateMBean(string, runtimeCollaborator, string4, null, properties);
        }
        catch (AdminException adminException) {
            FFDCFilter.processException((Throwable)((Object)adminException), (String)this.getClass().getName(), (String)"272");
        }
    }

    protected void deregisterModuleMBeans() {
        StringBuffer stringBuffer = new StringBuffer("WebSphere:");
        int n = stringBuffer.length();
        stringBuffer.append("WebModule=").append(this._appName.getModule()).append(",*");
        this.deactivateMBeans(stringBuffer.toString());
        stringBuffer.setLength(n);
        stringBuffer.append("*,J2EEName=").append(this._appName);
        this.deactivateMBeans(stringBuffer.toString());
    }

    protected void deactivateMBeans(String string) {
        try {
            ObjectName objectName = new ObjectName(string);
            MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
            Set<ObjectName> set = mBeanFactory.getMBeanServer().queryNames(objectName, null);
            Iterator<ObjectName> iterator = set.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName2 = iterator.next();
                try {
                    mBeanFactory.deactivateMBean(objectName2);
                }
                catch (AdminException adminException) {
                    FFDCFilter.processException((Throwable)((Object)adminException), (String)this.getClass().getName(), (String)"300");
                }
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            FFDCFilter.processException((Throwable)malformedObjectNameException, (String)this.getClass().getName(), (String)"304");
        }
    }

    protected void deregisterMBean(String string) {
        try {
            ObjectName objectName = new ObjectName("WebSphere:*,J2EEName=" + string);
            MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
            objectName = mBeanFactory.getMBeanServer().queryNames(objectName, null).iterator().next();
            AdminServiceFactory.getMBeanFactory().deactivateMBean(objectName);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            FFDCFilter.processException((Throwable)malformedObjectNameException, (String)this.getClass().getName(), (String)"315");
        }
        catch (AdminException adminException) {
            FFDCFilter.processException((Throwable)((Object)adminException), (String)this.getClass().getName(), (String)"317");
        }
    }
}

