/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer;

import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.application.WebModule;
import com.ibm.etools.archive.exception.UncontainedModuleFileException;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.applicationserver.webcontainer.HTTPTransport;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.Alias;
import com.ibm.ws.http.VirtualHost;
import com.ibm.ws.runtime.component.WebContainerImpl;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.service.MetaDataService;
import com.ibm.ws.runtime.service.RuntimeCtxImpl;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VirtualHostMgr;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.webcontainer.IRequestTransport;
import com.ibm.ws.webcontainer.WebAppHost;
import com.ibm.ws.webcontainer.WebContainerWorkloadRegulator;
import com.ibm.ws.webcontainer.cache.CacheManager;
import com.ibm.ws.webcontainer.collaborator.ConnectionHandleCollaborator;
import com.ibm.ws.webcontainer.exception.TransportException;
import com.ibm.ws.webcontainer.exception.WebAppHostNotFoundException;
import com.ibm.ws.webcontainer.exception.WebAppNotFoundException;
import com.ibm.ws.webcontainer.exception.WebAppNotLoadedException;
import com.ibm.ws.webcontainer.metadata.WebModuleMetaDataImpl;
import com.ibm.ws.webcontainer.oselistener.AppServerEntryFactory;
import com.ibm.ws.webcontainer.oselistener.api.AppServerEntry;
import com.ibm.ws.webcontainer.session.SessionRegistry;
import com.ibm.ws.webcontainer.srt.WebGroup;
import com.ibm.ws.webcontainer.util.SimpleHashtable;
import com.ibm.ws.webcontainer.util.WASSystem;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.collaborator.WebAppInitializationCollaborator;
import com.ibm.ws.webcontainer.webapp.collaborator.WebAppInvocationCollaborator;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.eclipse.emf.common.util.EList;

public class WebContainer {
    protected static WebContainer _webContainer = null;
    public static final String DEFAULT_VHOST = "default_host";
    protected static TraceComponent tc = Tr.register((String)(class$com$ibm$ws$webcontainer$WebContainer == null ? (class$com$ibm$ws$webcontainer$WebContainer = WebContainer.class$("com.ibm.ws.webcontainer.WebContainer")) : class$com$ibm$ws$webcontainer$WebContainer).getName(), (String)"Servlet_Engine");
    private com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer _webConConfig = null;
    private WebContainerImpl _webConStateObject = null;
    private RuntimeCtxImpl _runtimeContext = null;
    private SecurityService _securityService = null;
    protected static boolean _initialized = false;
    protected SimpleHashtable _hostTable;
    protected SimpleHashtable _aliasTable;
    protected ArrayList _wildAliasList;
    protected boolean _bWildAliases = false;
    private HashMap _cipherToBit = new HashMap();
    protected List _runningTransports = null;
    private boolean _transportsAvailable = false;
    protected SimpleHashtable _webGroupTable;
    public static final String urlPrefix = ";jsessionid=";
    private MetaDataService _metaDataService;
    private WebAppInitializationCollaborator[] _webAppInitializationCollaborators;
    private WebAppInvocationCollaborator[] _webAppInvocationCollaborators;
    private ConnectionHandleCollaborator _connectionHandleCollaborator;
    ThreadPool _threadPool = null;
    private static Properties _webConProperties = new Properties();
    private SessionRegistry _sessRegistry = null;
    static /* synthetic */ Class class$com$ibm$ws$webcontainer$WebContainer;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Server;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$MetaDataService;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$VirtualHostMgr;

    private WebContainer() {
    }

    public static WebContainer getWebContainer() {
        if (_webContainer == null) {
            _webContainer = new WebContainer();
        }
        return _webContainer;
    }

    public String getServerName() {
        return ((Server)this._runtimeContext.getService(class$com$ibm$ws$runtime$service$Server == null ? (class$com$ibm$ws$runtime$service$Server = WebContainer.class$("com.ibm.ws.runtime.service.Server")) : class$com$ibm$ws$runtime$service$Server)).getName();
    }

    public String getNodeName() {
        return ((Server)this._runtimeContext.getService(class$com$ibm$ws$runtime$service$Server == null ? (class$com$ibm$ws$runtime$service$Server = WebContainer.class$("com.ibm.ws.runtime.service.Server")) : class$com$ibm$ws$runtime$service$Server)).getNodeName();
    }

    public ConnectionHandleCollaborator getConnectionHandleCollaborator() {
        return this._connectionHandleCollaborator;
    }

    public void initialize(com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer webContainer, RuntimeCtxImpl runtimeCtxImpl, WebContainerImpl webContainerImpl, WebAppInitializationCollaborator[] webAppInitializationCollaboratorArray, WebAppInvocationCollaborator[] webAppInvocationCollaboratorArray, SecurityService securityService) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init");
        }
        if (!_initialized) {
            Tr.audit((TraceComponent)tc, (String)"web.container.copyright");
            Tr.audit((TraceComponent)tc, (String)"web.container.servlet.spec.level");
            Tr.audit((TraceComponent)tc, (String)"web.container.jsp.spec.level");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Web Container Configuration: {0}", (Object)this._webConConfig);
            }
            this._webConConfig = webContainer;
            this._runtimeContext = runtimeCtxImpl;
            this._webConStateObject = webContainerImpl;
            this._securityService = securityService;
            this._webAppInitializationCollaborators = webAppInitializationCollaboratorArray;
            this._webAppInvocationCollaborators = webAppInvocationCollaboratorArray;
            this._metaDataService = (MetaDataService)this._runtimeContext.getService(class$com$ibm$ws$runtime$service$MetaDataService == null ? (class$com$ibm$ws$runtime$service$MetaDataService = WebContainer.class$("com.ibm.ws.runtime.service.MetaDataService")) : class$com$ibm$ws$runtime$service$MetaDataService);
            this._hostTable = new SimpleHashtable();
            this._aliasTable = new SimpleHashtable();
            this._wildAliasList = new ArrayList();
            this._runningTransports = new ArrayList();
            this._webGroupTable = new SimpleHashtable();
            Iterator iterator = this._webConConfig.getProperties().iterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                _webConProperties.put(property.getName(), property.getValue());
            }
            this.loadServletHosts(((VirtualHostMgr)this._runtimeContext.getService(class$com$ibm$ws$runtime$service$VirtualHostMgr == null ? (class$com$ibm$ws$runtime$service$VirtualHostMgr = WebContainer.class$("com.ibm.ws.runtime.service.VirtualHostMgr")) : class$com$ibm$ws$runtime$service$VirtualHostMgr)).getVirtualHosts());
            if (this._webConConfig.isEnableServletCaching()) {
                this.initializeDynamicCache();
            }
            this.loadCipherToBit();
            this._connectionHandleCollaborator = new ConnectionHandleCollaborator();
            WebContainerWorkloadRegulator.getRegulator();
            _initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    public MetaDataService getMetaDataService() {
        return this._metaDataService;
    }

    public void shutdown() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"shutdown");
        }
        if (!_initialized) {
            return;
        }
        Enumeration enumeration = this._hostTable.keys();
        while (enumeration.hasMoreElements()) {
            WebAppHost webAppHost = (WebAppHost)this._hostTable.get((String)enumeration.nextElement());
            webAppHost.shutdown();
        }
        _webContainer = null;
        _initialized = false;
        this._hostTable.clear();
        this._webConConfig = null;
        this._aliasTable.clear();
        this._wildAliasList.clear();
        this._webGroupTable.clear();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"shutdown");
        }
    }

    public void stopTransports() {
        this._transportsAvailable = false;
        for (int i = 0; i < this._runningTransports.size(); ++i) {
            IRequestTransport iRequestTransport = (IRequestTransport)this._runningTransports.get(i);
            try {
                iRequestTransport.stopTransport();
                continue;
            }
            catch (TransportException transportException) {
                FFDCFilter.processException((Throwable)transportException, (String)"com.ibm.ws.webcontainer.WebContainer.stopTransports", (String)"261", (Object)this);
                Tr.error((TraceComponent)tc, (String)"Unabled.to.cleanly.stop.the.Transport", (Object)transportException);
            }
        }
        this._runningTransports.clear();
    }

    void loadServletHosts(VirtualHost[] virtualHostArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadServletHosts");
        }
        for (int i = 0; i < virtualHostArray.length; ++i) {
            VirtualHost virtualHost = virtualHostArray[i];
            WebAppHost webAppHost = new WebAppHost();
            webAppHost.init(this, virtualHost);
            this._hostTable.put(virtualHost.getName(), webAppHost);
            Alias[] aliasArray = virtualHost.getAliases();
            for (int j = 0; j < aliasArray.length; ++j) {
                String string;
                Object object;
                Alias alias = aliasArray[j];
                String string2 = alias.getHostname().toLowerCase();
                if (!string2.equals("*") && string2.indexOf("*") != -1) {
                    this._bWildAliases = true;
                    object = new WildAliasData();
                    ((WildAliasData)object).aliasHost = string2;
                    ((WildAliasData)object).webAppHost = webAppHost;
                    string = alias.getPort();
                    if (string != null) {
                        if (string.equals("*")) {
                            ((WildAliasData)object).aliasPort = -1;
                        } else {
                            try {
                                ((WildAliasData)object).aliasPort = Integer.parseInt(string);
                            }
                            catch (Throwable throwable) {
                                ((WildAliasData)object).aliasPort = 80;
                            }
                        }
                    } else {
                        ((WildAliasData)object).aliasPort = 80;
                    }
                    this._wildAliasList.add(object);
                    continue;
                }
                if (alias.getPort() != null) {
                    string2 = string2 + ":" + alias.getPort();
                }
                if (string2.indexOf(":") == -1) {
                    this._aliasTable.put(string2 + ":80", webAppHost);
                    if (!string2.equalsIgnoreCase("localhost")) continue;
                    object = null;
                    try {
                        object = InetAddress.getLocalHost();
                    }
                    catch (UnknownHostException unknownHostException) {
                        FFDCFilter.processException((Throwable)unknownHostException, (String)"com.ibm.ws.webcontainer.WebContainer.loadServletHosts", (String)"309", (Object)this);
                    }
                    string = ((InetAddress)object).getHostName().toLowerCase();
                    this._aliasTable.put(string + ":80", webAppHost);
                    this._aliasTable.put(((InetAddress)object).getHostAddress() + ":80", webAppHost);
                    int n = string.indexOf(".");
                    if (n == -1) continue;
                    this._aliasTable.put(string.substring(0, n) + ":80", webAppHost);
                    continue;
                }
                this._aliasTable.put(string2, webAppHost);
                object = string2.substring(0, string2.indexOf(":"));
                string = string2.substring(string2.indexOf(":"));
                if (!((String)object).equalsIgnoreCase("localhost")) continue;
                InetAddress inetAddress = null;
                try {
                    inetAddress = InetAddress.getLocalHost();
                }
                catch (UnknownHostException unknownHostException) {
                    FFDCFilter.processException((Throwable)unknownHostException, (String)"com.ibm.ws.webcontainer.WebContainer.loadServletHosts", (String)"339", (Object)this);
                }
                String string3 = inetAddress.getHostName().toLowerCase();
                this._aliasTable.put(string3 + string, webAppHost);
                this._aliasTable.put(inetAddress.getHostAddress() + string, webAppHost);
                int n = string3.indexOf(".");
                if (n == -1) continue;
                this._aliasTable.put(string3.substring(0, n) + string, webAppHost);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Host Table", (Object)this._hostTable);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Alias Table", (Object)this._aliasTable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadServletHosts");
        }
    }

    void initializeDynamicCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeDynamicCache");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Dynamic Caching Initializing");
        }
        CacheManager.initialize();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeDynamicCache");
        }
    }

    public void startTransports(VariableMap variableMap, ThreadPoolMgr threadPoolMgr) throws RuntimeError {
        String string;
        Property property;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startTransports");
        }
        int n = 5;
        int n2 = 10;
        int n3 = 5000;
        boolean bl = false;
        String string2 = "";
        String string3 = "";
        com.ibm.websphere.models.config.process.ThreadPool threadPool = this._webConConfig.getThreadPool();
        if (threadPool == null) {
            throw new RuntimeError("Thread pool is not set with web container");
        }
        this._threadPool = threadPoolMgr.getThreadPool("Servlet.Engine.Transports", threadPool);
        AppServerEntry appServerEntry = AppServerEntryFactory.getServer();
        Properties properties = new Properties();
        EList eList = this._webConConfig.getProperties();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            property = (Property)iterator.next();
            string = property.getName();
            if (!string.equalsIgnoreCase("MaxConnectBacklog") && !string.equalsIgnoreCase("MaxKeepAliveConnections") && !string.equalsIgnoreCase("MaxKeepAliveRequests") && !string.equalsIgnoreCase("ConnectionIOTimeout") && !string.equalsIgnoreCase("ConnectionKeepAliveTimeout") && !string.equalsIgnoreCase("UseSoLinger") && !string.equalsIgnoreCase("ErrorLog") && !string.equalsIgnoreCase("LogLevel") && !string.equalsIgnoreCase("AccessLog") && !string.equalsIgnoreCase("ErrorLogDisable") && !string.equalsIgnoreCase("AccessLogDisable") && !string.equalsIgnoreCase("Trusted")) continue;
            properties.setProperty(string, property.getValue());
        }
        property = this._webConConfig.getTransports();
        string = null;
        for (int i = 0; i < property.size(); ++i) {
            Object object;
            string = (Transport)property.get(i);
            Properties properties2 = new Properties();
            properties2.putAll((Map<?, ?>)properties);
            EndPoint endPoint = string.getAddress();
            if (endPoint != null) {
                if (endPoint.getPort() != 0) {
                    properties2.put("port", String.valueOf(endPoint.getPort()));
                    string3 = String.valueOf(endPoint.getPort());
                } else {
                    string3 = "UNDEFINED";
                }
                if (endPoint.getHost() != null) {
                    properties2.put("host", endPoint.getHost());
                    string2 = endPoint.getHost();
                } else {
                    string2 = "UNDEFINED";
                }
            }
            EList eList2 = string.getProperties();
            for (int j = 0; j < eList2.size(); ++j) {
                object = (Property)eList2.get(j);
                properties2.put(object.getName(), object.getValue());
            }
            Properties properties3 = new Properties();
            if (string.isSslEnabled() && (object = string.getSslConfig()) != null) {
                properties3 = this._securityService.getSecureSocketLayer((String)object);
                if (variableMap != null) {
                    String string4 = properties3.getProperty("com.ibm.ssl.trustStore");
                    if (string4 != null) {
                        properties3.setProperty("com.ibm.ssl.trustStore", variableMap.expand(string4));
                    }
                    if ((string4 = properties3.getProperty("com.ibm.ssl.keyStore")) != null) {
                        properties3.setProperty("com.ibm.ssl.keyStore", variableMap.expand(string4));
                    }
                }
            }
            object = (IRequestTransport)WASSystem.createObject("com.ibm.ws.webcontainer.http.HttpTransport");
            try {
                object.startTransport(appServerEntry, this._threadPool, properties2, (Transport)string, properties3);
                this._runningTransports.add(object);
                continue;
            }
            catch (TransportException transportException) {
                FFDCFilter.processException((Throwable)transportException, (String)"com.ibm.ws.webcontainer.WebContainer.startTransports", (String)"501", (Object)this);
                Tr.error((TraceComponent)tc, (String)"failed.to.start.transport", (Object)new Object[]{transportException, string2, string3});
                if (tc.isDebugEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"failed.to.start.transport", (Object)new Object[]{transportException, string2, string3});
                }
                throw new RuntimeError((Throwable)transportException);
            }
        }
        this._transportsAvailable = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startTransports");
        }
    }

    public WebAppHost getServletHost(String string) {
        if (string != null) {
            return (WebAppHost)this._hostTable.get(string);
        }
        WebAppHost webAppHost = (WebAppHost)this._hostTable.get(DEFAULT_VHOST);
        if (webAppHost == null) {
            Enumeration enumeration = this._hostTable.elements();
            webAppHost = (WebAppHost)enumeration.nextElement();
        }
        Tr.uncondFormattedEvent((TraceComponent)tc, (String)"virtual.host.not.specified", (Object)(webAppHost != null ? webAppHost.getConfiguration().getName() : "<null>"));
        return webAppHost;
    }

    public WebAppHost findServletHostByHostname(String string, int n) throws WebAppHostNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findServletHostByHostname");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Finding engine host by alias for {0}", (Object)new Object[]{string, new Integer(n)});
        }
        String string2 = string.toLowerCase();
        WebAppHost webAppHost = null;
        webAppHost = (WebAppHost)this._aliasTable.get(string2 + ":" + new Integer(n));
        if (webAppHost != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"findServletHostByHostname: Exact match");
            }
            return webAppHost;
        }
        int n2 = string.indexOf(".");
        if (n2 != -1 && (webAppHost = (WebAppHost)this._aliasTable.get(string2.substring(0, n2))) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"findServletHostByHostname: Short name match");
            }
            return webAppHost;
        }
        if (this._bWildAliases && (webAppHost = this.findServletHostAsWildCard(string2, n)) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"findServletHostByHostname: Wild card match");
            }
            return webAppHost;
        }
        webAppHost = (WebAppHost)this._aliasTable.get("*:" + new Integer(n));
        if (webAppHost != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("findServletHostByHostname: *:" + new Integer(n)));
            }
            return webAppHost;
        }
        webAppHost = (WebAppHost)this._aliasTable.get(string2 + ":*");
        if (webAppHost != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("findServletHostByHostname: " + string2 + ":*"));
            }
            return webAppHost;
        }
        webAppHost = (WebAppHost)this._aliasTable.get("*:*");
        if (webAppHost != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"findServletHostByHostname*:*");
            }
            return webAppHost;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findServletHostByHostname");
        }
        String string3 = n == 0 ? "80" : String.valueOf(n);
        throw new WebAppHostNotFoundException(string, string3);
    }

    public WebAppHost findServletHostAsWildCard(String string, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findServletHostAsWildCard");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Finding engine host by alias for {0}", (Object)new Object[]{string, new Integer(n)});
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = this._wildAliasList.size();
        for (int i = 0; i < n3; ++i) {
            WildAliasData wildAliasData = (WildAliasData)this._wildAliasList.get(i);
            if (wildAliasData.aliasPort != -1 && wildAliasData.aliasPort != n) continue;
            int n4 = 0;
            int n5 = 0;
            char[] cArray2 = wildAliasData.aliasHost.toCharArray();
            int n6 = cArray2.length;
            boolean bl = false;
            while (n5 < n6) {
                if (cArray2[n5] == '*') {
                    if (++n5 < n6) {
                        while (n4 < n2 && cArray[n4] != cArray2[n5]) {
                            ++n4;
                        }
                        if (n4 != n2) continue;
                        if (cArray[n4 - 1] != cArray2[n5] || n5 + 1 != n6) break;
                        bl = true;
                        break;
                    }
                    bl = true;
                    break;
                }
                if (cArray[n4++] != cArray2[n5++]) break;
                if (n4 < n2) continue;
                if (n5 < n6) break;
                bl = true;
            }
            if (!bl) continue;
            return wildAliasData.webAppHost;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findServletHostAsWildCard");
        }
        return null;
    }

    public com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer getConfiguration() {
        return this._webConConfig;
    }

    public synchronized WebGroup getWebGroup(String string) throws WebAppNotFoundException {
        WebGroup webGroup;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getWebGroup");
        }
        if ((webGroup = (WebGroup)this._webGroupTable.get(string)) == null) {
            Tr.warning((TraceComponent)tc, (String)"Web.Group.Not.Found:.{0}", (Object)string);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getWebGroup");
            }
            throw new WebAppNotFoundException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getWebGroup");
        }
        return webGroup;
    }

    public synchronized void addWebApplication(DeployedModule deployedModule) throws WebAppNotLoadedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addWebApplication", (Object)deployedModule);
        }
        String string = "";
        try {
            String string2;
            WebAppHost webAppHost;
            String string3;
            com.ibm.etools.webapplication.WebApp webApp = (com.ibm.etools.webapplication.WebApp)deployedModule.getDeploymentDescriptor();
            WebAppExtension webAppExtension = (WebAppExtension)deployedModule.getExtension();
            WebAppBinding webAppBinding = (WebAppBinding)deployedModule.getBinding();
            WebModuleMetaDataImpl webModuleMetaDataImpl = (WebModuleMetaDataImpl)deployedModule.getMetaData();
            webModuleMetaDataImpl.setDeploymentDescriptor(webApp);
            webModuleMetaDataImpl.setModuleExtension(webAppExtension);
            webModuleMetaDataImpl.setModuleBinding(webAppBinding);
            if (webApp.getDisplayName() == null || webApp.getDisplayName().equals("")) {
                webApp.setDisplayName(deployedModule.getName());
            }
            if ((string3 = webAppBinding.getVirtualHostName()) == null || string3.equals("")) {
                string3 = DEFAULT_VHOST;
            }
            if ((webAppHost = this.getServletHost(string3)) == null) {
                Tr.error((TraceComponent)tc, (String)"no.virtual.host.for.webapp", (Object)webApp.getDisplayName());
                throw new WebAppNotLoadedException(webApp.getDisplayName());
            }
            ModuleDeployment moduleDeployment = deployedModule.getModuleDeployment();
            WebModule webModule = (WebModule)((EARFile)deployedModule.getDeployedApplication().getModuleFile()).getModule(moduleDeployment.getUri(), moduleDeployment.getAltDD());
            String string4 = webModule.getContextRoot();
            if (!string4.startsWith("/")) {
                string4 = "/" + string4;
            }
            if (string4.endsWith("/") && !string4.equals("/")) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            if (this._webGroupTable.get(string2 = string3 + string4) != null) {
                String string5 = webApp.getDisplayName();
                Tr.error((TraceComponent)tc, (String)"context.root.already.in.use", (Object)new Object[]{string5, string4, ((WebGroup)this._webGroupTable.get(string2)).getWebAppName(), string5});
                throw new WebAppNotLoadedException(string5);
            }
            webModuleMetaDataImpl.setGroupIndex(string2);
            WebGroup webGroup = new WebGroup();
            Tr.audit((TraceComponent)tc, (String)"loading.web.module", (Object)webApp.getDisplayName());
            string = string2;
            this._webGroupTable.put(string2, webGroup);
            webGroup.init(this, webAppHost, deployedModule, this._webAppInitializationCollaborators, this._webAppInvocationCollaborators);
        }
        catch (WebAppNotLoadedException webAppNotLoadedException) {
            this._webGroupTable.remove(string);
            throw webAppNotLoadedException;
        }
        catch (UncontainedModuleFileException uncontainedModuleFileException) {
            FFDCFilter.processException((Throwable)uncontainedModuleFileException, (String)"com.ibm.ws.webcontainer.WebContainer.addWebApplication", (String)"676", (Object)this);
            Tr.error((TraceComponent)tc, (String)"error.referencing.module.resource");
            throw new WebAppNotLoadedException(deployedModule.getDeployedApplication().getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addWebApplication");
        }
    }

    public synchronized void removeWebApplication(DeployedModule deployedModule) {
        try {
            WebModuleMetaDataImpl webModuleMetaDataImpl = (WebModuleMetaDataImpl)deployedModule.getMetaData();
            String string = webModuleMetaDataImpl.getGroupIndex();
            WebGroup webGroup = (WebGroup)this._webGroupTable.get(string);
            this._webGroupTable.remove(string);
            String string2 = webModuleMetaDataImpl.getDeploymentDescriptor().getDisplayName();
            if (string2 == null || string2.equals("")) {
                string2 = deployedModule.getName();
            }
            Tr.audit((TraceComponent)tc, (String)"stopping.web.module", (Object)string2);
            webGroup.shutdown();
        }
        catch (UncontainedModuleFileException uncontainedModuleFileException) {
            FFDCFilter.processException((Throwable)uncontainedModuleFileException, (String)"com.ibm.ws.webcontainer.WebContainer.removeWebApplication", (String)"721", (Object)this);
            Tr.error((TraceComponent)tc, (String)"error.referencing.module.resource");
        }
    }

    public synchronized void reload(DeployedModule deployedModule) throws WebAppNotLoadedException {
        WebModuleMetaDataImpl webModuleMetaDataImpl = (WebModuleMetaDataImpl)deployedModule.getMetaData();
        String string = webModuleMetaDataImpl.getGroupIndex();
        WebGroup webGroup = (WebGroup)this._webGroupTable.get(string);
        if (webGroup != null) {
            webGroup.reload(deployedModule);
        }
    }

    public synchronized void restartWebApplication(DeployedModule deployedModule) throws WebAppNotLoadedException {
        WebModuleMetaDataImpl webModuleMetaDataImpl = (WebModuleMetaDataImpl)deployedModule.getMetaData();
        String string = webModuleMetaDataImpl.getDeploymentDescriptor().getDisplayName();
        if (string == null) {
            string = deployedModule.getName();
        }
        Tr.audit((TraceComponent)tc, (String)"Restarting group: {0}", (Object)string);
        this.removeWebApplication(deployedModule);
        this.addWebApplication(deployedModule);
    }

    public synchronized void restartWebApplication(String string) {
        String string2 = "";
        try {
            DeployedModule deployedModule = this.getWebModuleConfig(string);
            string2 = ((com.ibm.etools.webapplication.WebApp)deployedModule.getDeploymentDescriptor()).getDisplayName();
            Tr.audit((TraceComponent)tc, (String)"Restarting group: {0}", (Object)string2);
            this.restartWebApplication(deployedModule);
        }
        catch (WebAppNotFoundException webAppNotFoundException) {
            FFDCFilter.processException((Throwable)webAppNotFoundException, (String)"com.ibm.ws.webcontainer.WebContainer.restartWebApplication", (String)"793", (Object)this);
            Tr.error((TraceComponent)tc, (String)"unable.to.restart.webapp", (Object)string2);
        }
        catch (WebAppNotLoadedException webAppNotLoadedException) {
            // empty catch block
        }
    }

    public synchronized DeployedModule getWebModuleConfig(String string) throws WebAppNotFoundException {
        WebGroup webGroup = this.getWebGroup(string);
        return webGroup.getConfiguration();
    }

    public Enumeration getWebGroupNames() {
        return this._webGroupTable.keys();
    }

    private void loadCipherToBit() {
        Properties properties = new Properties();
        try {
            String string = System.getProperty("server.root") + File.separator + "properties" + File.separator + "sslbitsizes.properties";
            properties.load(new FileInputStream(string));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.WebContainer.loadCipherToBit", (String)"825", (Object)this);
        }
        this._cipherToBit.putAll(properties);
    }

    public Integer getKeySize(String string) {
        String string2 = (String)this._cipherToBit.get(string);
        if (string2 == null || string2.equals("") || string2.equals("0") || string2.equals("-1")) {
            return null;
        }
        return new Integer(string2);
    }

    public boolean areTransportsAvailable() {
        return this._transportsAvailable;
    }

    public int getHTTPSport(ServletContext servletContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getHTTPSPort");
        }
        if (servletContext instanceof WebApp) {
            WebGroup webGroup = (WebGroup)((WebApp)servletContext).getWebAppContext();
            WebAppHost webAppHost = webGroup.getVirtualHost();
            VirtualHost virtualHost = webAppHost._vHostCfg;
            List list = this._runningTransports;
            for (int i = 0; i < list.size(); ++i) {
                int n;
                Transport transport = (Transport)list.get(i);
                HTTPTransport hTTPTransport = (HTTPTransport)transport;
                if (!hTTPTransport.isSslEnabled() || (n = hTTPTransport.getAddress().getPort()) == 0) continue;
                Alias[] aliasArray = virtualHost.getAliases();
                for (int j = 0; j < aliasArray.length; ++j) {
                    Alias alias = aliasArray[j];
                    String string = alias.getPort();
                    int n2 = Integer.parseInt(string);
                    if (n2 != n) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Found HTTPS port " + n));
                    }
                    return n;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getHTTPSPort: SSL port not found");
        }
        return -1;
    }

    public boolean areRequestsOutstanding() {
        boolean bl = false;
        Enumeration enumeration = this._webGroupTable.elements();
        while (enumeration.hasMoreElements()) {
            WebGroup webGroup = (WebGroup)enumeration.nextElement();
            if (!webGroup.areRequestsActive()) continue;
            return true;
        }
        return false;
    }

    public String getCellName() {
        return ((Server)this._runtimeContext.getService(class$com$ibm$ws$runtime$service$Server == null ? (class$com$ibm$ws$runtime$service$Server = WebContainer.class$("com.ibm.ws.runtime.service.Server")) : class$com$ibm$ws$runtime$service$Server)).getCellName();
    }

    public void setSessionRegistry(SessionRegistry sessionRegistry) {
        this._sessRegistry = sessionRegistry;
    }

    public SessionRegistry getSessionRegistry() {
        return this._sessRegistry;
    }

    public static Properties getWebContainerProperties() {
        return _webConProperties;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class WildAliasData {
        public String aliasHost;
        public int aliasPort;
        public WebAppHost webAppHost;

        private WildAliasData() {
        }
    }
}

