/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.debug;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.util.ExProperties;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Properties;

public class DebugSupport {
    public static final String copyright = "(C) Copyright IBM Corp. 1996, 1997, All rights reserved.";
    protected static boolean debugMode;
    private static String PSWDCHARS;

    public static boolean setupOutputRedirection(ExProperties exProperties) {
        try {
            String string = exProperties.getProperty("debug.java.stderr.file");
            String string2 = exProperties.getProperty("debug.java.stdout.file");
            FileOutputStream fileOutputStream = null;
            if (string2 != null) {
                fileOutputStream = new FileOutputStream(string2);
                System.setOut(new PrintStream(fileOutputStream));
            }
            if (string != null) {
                if (string2 != null && string2.equals(string)) {
                    System.setErr(new PrintStream(fileOutputStream));
                } else if (string != null) {
                    FileOutputStream fileOutputStream2 = new FileOutputStream(string);
                    System.setErr(new PrintStream(fileOutputStream2));
                }
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.debug.DebugSupport.setupOutputRedirection", (String)"56");
            DebugSupport.logException(iOException);
            return false;
        }
        return true;
    }

    private static String cookieToString(int n) {
        int n2;
        int n3 = PSWDCHARS.length();
        int n4 = 0;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(32);
        while (n > 0) {
            if (n < n3) {
                stringBuffer.append(PSWDCHARS.charAt(n));
                n = 0;
            } else {
                n2 = n % n3;
                n /= n3;
                stringBuffer.append(PSWDCHARS.charAt(n2));
            }
            ++n4;
        }
        if (n4 > 0) {
            n2 = stringBuffer.length();
            char[] cArray = new char[n2];
            int n5 = 0;
            while (n2-- > 0) {
                cArray[n2] = stringBuffer.charAt(n5++);
            }
            return String.valueOf(cArray);
        }
        return "0";
    }

    public static String getDebugPassword(int n) {
        if (n > 65535) {
            System.err.println("Invalid port number (" + n + ")????");
            return "Invalid Port Number";
        }
        int n2 = (int)(Math.round(Math.random() * 2048.0) % 2048L);
        int n3 = 0;
        int n4 = 3;
        for (int i = 0; i < 8; ++i) {
            int n5 = (n & n4) << i + 1;
            int n6 = (n2 & 1 << i) << i * 2;
            n3 |= n5 | n6;
            n4 <<= 2;
        }
        return DebugSupport.cookieToString(n3 |= (n2 & 0x700) << 16);
    }

    public static void setupRemoteDebug(Properties properties) {
        block4: {
            debugMode = Boolean.valueOf(properties.getProperty("java.debug")) == true;
            try {
                if (properties.getProperty("java.debug").equalsIgnoreCase("true")) {
                    String string = properties.getProperty("java.debug.port");
                    if (string != null) {
                        PrintWriter printWriter = new PrintWriter(new FileWriter("debug.password"));
                        String string2 = DebugSupport.getDebugPassword(Integer.parseInt(string));
                        printWriter.println("Remote Debug (Agent) Password: " + string2);
                        printWriter.flush();
                        printWriter.close();
                    }
                    break block4;
                }
                return;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.debug.DebugSupport.setupRemoteDebug", (String)"159");
                DebugSupport.logException("Failed to setup Remote Debug Support", exception);
            }
        }
    }

    public static boolean getDebugMode() {
        return debugMode;
    }

    public static void logException(Throwable throwable) {
        DebugSupport.logException("WebSphere Exception", throwable);
    }

    public static void logException(String string, Throwable throwable) {
        System.err.println(string + ": " + throwable.getMessage());
        throwable.printStackTrace();
    }

    public static void logErrorMsg(String string) {
        System.err.println(string);
    }

    static {
        PSWDCHARS = "23456789abcdefghijkmnpqrstuvwxyz";
    }
}

