/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.filter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.etools.webapplication.Filter;
import com.ibm.etools.webapplication.FilterMapping;
import com.ibm.etools.webapplication.InitParam;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.filter.FilterChainContents;
import com.ibm.ws.webcontainer.filter.FilterInstanceWrapper;
import com.ibm.ws.webcontainer.filter.WebAppFilterChain;
import com.ibm.ws.webcontainer.filter.WebAppFilterConfig;
import com.ibm.ws.webcontainer.servlet.ServletReference;
import com.ibm.ws.webcontainer.util.LRUCache;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppNameSpaceCollaborator;
import java.beans.Beans;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.ServletException;
import org.eclipse.emf.common.util.EList;

public class WebAppFilterManager {
    private Hashtable _filterWrappers = new Hashtable();
    private LRUCache _chains = new LRUCache(50, 600);
    private ArrayList _uriFilterMappings = new ArrayList();
    private ArrayList _servletFilterMappings = new ArrayList();
    public boolean _filtersDefined = false;
    static final int FMI_MAPPING_SINGLE_SLASH = 0;
    static final int FMI_MAPPING_PATH_MATCH = 1;
    static final int FMI_MAPPING_EXTENSION_MATCH = 2;
    static final int FMI_MAPPING_EXACT_MATCH = 3;
    private static TraceComponent tc = Tr.register((String)(class$com$ibm$ws$webcontainer$filter$WebAppFilterManager == null ? (class$com$ibm$ws$webcontainer$filter$WebAppFilterManager = WebAppFilterManager.class$("com.ibm.ws.webcontainer.filter.WebAppFilterManager")) : class$com$ibm$ws$webcontainer$filter$WebAppFilterManager).getName(), (String)"Servlet_Engine");
    private static NLS nls = new NLS("com.ibm.servlet.resources.ServletEngineNLS");
    private boolean _entryEnabled = tc.isEntryEnabled();
    com.ibm.etools.webapplication.WebApp _webModuleDD;
    WebApp _webApp;
    private WebAppNameSpaceCollaborator _webAppNameSpaceCollaborator;
    static /* synthetic */ Class class$com$ibm$ws$webcontainer$filter$WebAppFilterManager;

    public WebAppFilterManager(com.ibm.etools.webapplication.WebApp webApp, WebApp webApp2) {
        this._webModuleDD = webApp;
        this._webApp = webApp2;
        this._webAppNameSpaceCollaborator = this._webApp.getWebAppNameSpaceCollaborator();
    }

    public void init() {
        EList eList = this._webModuleDD.getFilterMappings();
        if (!eList.isEmpty()) {
            this._filtersDefined = true;
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                FilterMapping filterMapping = (FilterMapping)iterator.next();
                FilterMappingInfo filterMappingInfo = new FilterMappingInfo();
                String string = filterMapping.getUrlPattern();
                if (string != null) {
                    filterMappingInfo.setFilterName(filterMapping.getFilter().getName());
                    filterMappingInfo.setFilterURI(string);
                    this._uriFilterMappings.add(filterMappingInfo);
                    continue;
                }
                filterMappingInfo.setFilterName(filterMapping.getFilter().getName());
                filterMappingInfo.setFilterServlet(filterMapping.getServletName());
                this._servletFilterMappings.add(filterMappingInfo);
            }
        }
    }

    public FilterInstanceWrapper getFilterInstanceWrapper(String string) throws ServletException {
        if (this._entryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"getFilterInstance");
        }
        try {
            FilterInstanceWrapper filterInstanceWrapper = (FilterInstanceWrapper)this._filterWrappers.get(string);
            if (filterInstanceWrapper != null) {
                return filterInstanceWrapper;
            }
            return this.loadFilter(string);
        }
        catch (ServletException servletException) {
            FFDCFilter.processException((Throwable)servletException, (String)"com.ibm.ws.webcontainer.filter.WebAppFilterManager.getFilterInstanceWrapper", (String)"166", (Object)this);
            throw servletException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.filter.WebAppFilterManager.getFilterInstanceWrapper", (String)"172", (Object)this);
            throw new ServletException(MessageFormat.format("Filter [{0}]: could not be loaded", string), throwable);
        }
    }

    public synchronized WebAppFilterChain getFilterChain(String string, ServletReference servletReference) throws ServletException {
        FilterChainContents filterChainContents = this.getFilterChainContents(string, servletReference.getServletName());
        WebAppFilterChain webAppFilterChain = new WebAppFilterChain();
        if (filterChainContents._hasFilters) {
            ArrayList arrayList = filterChainContents.getFilterNames();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                webAppFilterChain.addFilter(this.getFilterInstanceWrapper((String)arrayList.get(i)));
            }
        }
        webAppFilterChain.setRequestedServlet(servletReference);
        return webAppFilterChain;
    }

    public void shutdown() {
        Enumeration enumeration = this._filterWrappers.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((FilterInstanceWrapper)enumeration.nextElement()).destroy();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.filter.WebAppFilterManager.shutdown", (String)"237", (Object)this);
            }
        }
        this._filterWrappers = null;
        this._chains = null;
    }

    private FilterInstanceWrapper loadFilter(String string) throws ServletException {
        if (this._entryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"createFilterInstance");
        }
        FilterInstanceWrapper filterInstanceWrapper = null;
        try {
            javax.servlet.Filter filter;
            String string2;
            Filter filter2 = this._webModuleDD.getFilterNamed(string);
            EList eList = filter2.getInitParams();
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                string2 = (InitParam)iterator.next();
                hashtable.put(string2.getParamName(), string2.getParamValue());
            }
            string2 = filter2.getFilterClassName();
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Instantiating Filter Class: {0}", (Object)string2);
            }
            try {
                filter = (javax.servlet.Filter)Beans.instantiate(this._webApp.getClassLoader(), string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", (String)"298", (Object)this);
                throw new ServletException(MessageFormat.format(nls.getString("Could.not.find.required.filter.class", "Filter [{0}]: Could not find required filter class - {1}.class"), string, string2), (Throwable)classNotFoundException);
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", (String)"303", (Object)this);
                throw new ServletException(MessageFormat.format(nls.getString("Filter.not.a.filter.class", "Filter [{0}]: not a filter class"), string), (Throwable)classCastException);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                FFDCFilter.processException((Throwable)noClassDefFoundError, (String)"com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", (String)"308", (Object)this);
                throw new ServletException(MessageFormat.format(nls.getString("Filter.was.found.but.is.missing.another.required.class", "Filter [{0}]: {1} was found, but is missing another required class.\n"), string, string2), (Throwable)noClassDefFoundError);
            }
            catch (ClassFormatError classFormatError) {
                FFDCFilter.processException((Throwable)classFormatError, (String)"com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", (String)"313", (Object)this);
                throw new ServletException(MessageFormat.format(nls.getString("Filter.found.but.corrupt", "Filter [{0}]: {1} was found, but is corrupt:\n"), string, string2), (Throwable)classFormatError);
            }
            filterInstanceWrapper = new FilterInstanceWrapper(string, filter);
            WebAppFilterConfig webAppFilterConfig = new WebAppFilterConfig(string, hashtable, this._webApp);
            filterInstanceWrapper.init(webAppFilterConfig);
            this._filterWrappers.put(string, filterInstanceWrapper);
        }
        catch (ServletException servletException) {
            FFDCFilter.processException((Throwable)servletException, (String)"com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", (String)"380", (Object)this);
            throw servletException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", (String)"385", (Object)this);
            throw new ServletException(MessageFormat.format("Filter [{0}]: could not be loaded", string), throwable);
        }
        if (this._entryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"loadFilter");
        }
        return filterInstanceWrapper;
    }

    private FilterChainContents getFilterChainContents(String string, String string2) {
        int n = string.indexOf("?");
        String string3 = null;
        string3 = n > 0 ? string.substring(0, n) : string;
        FilterChainContents filterChainContents = (FilterChainContents)this._chains.get(string3);
        if (filterChainContents == null) {
            FilterMappingInfo filterMappingInfo;
            int n2;
            filterChainContents = new FilterChainContents();
            int n3 = this._uriFilterMappings.size();
            for (n2 = 0; n2 < n3; ++n2) {
                filterMappingInfo = (FilterMappingInfo)this._uriFilterMappings.get(n2);
                if (!this.uriMatch(string3, filterMappingInfo)) continue;
                filterChainContents.addFilter(filterMappingInfo._filterName);
            }
            n3 = this._servletFilterMappings.size();
            for (n2 = 0; n2 < n3; ++n2) {
                filterMappingInfo = (FilterMappingInfo)this._servletFilterMappings.get(n2);
                if (!string2.equals(filterMappingInfo._filterServlet)) continue;
                filterChainContents.addFilter(filterMappingInfo._filterName);
            }
            this._chains.put((Object)string3, filterChainContents);
        }
        return filterChainContents;
    }

    private boolean uriMatch(String string, FilterMappingInfo filterMappingInfo) {
        boolean bl = false;
        switch (filterMappingInfo._mappingType) {
            case 0: {
                if (!string.equals("/")) break;
                bl = true;
                break;
            }
            case 1: {
                if (!string.startsWith(filterMappingInfo._filterURI)) break;
                bl = true;
                break;
            }
            case 2: {
                String string2 = filterMappingInfo._filterURI.substring(2);
                int n = string.lastIndexOf(46);
                if (n == -1 || !string2.equals(string.substring(n + 1))) break;
                bl = true;
                break;
            }
            case 3: {
                if (!string.equals(filterMappingInfo._filterURI)) break;
                bl = true;
                break;
            }
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class FilterMappingInfo {
        String _filterName;
        String _filterURI;
        String _filterServlet;
        int _mappingType;

        protected FilterMappingInfo() {
        }

        public void setFilterName(String string) {
            this._filterName = string;
        }

        public void setFilterURI(String string) {
            if (string.equals("/")) {
                this._mappingType = 0;
            } else if (string.startsWith("/") && string.endsWith("/*")) {
                this._mappingType = 1;
                string = string.substring(0, string.length() - 2);
            } else {
                this._mappingType = string.startsWith("*.") ? 2 : 3;
            }
            this._filterURI = string;
        }

        public void setFilterServlet(String string) {
            this._filterServlet = string;
        }
    }
}

