/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.jsp;

import com.ibm.ws.classloader.CompoundClassLoader;
import com.ibm.ws.classloader.ReloadableClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ExtendedDocumentRootUtils;
import com.ibm.ws.webcontainer.jsp.compiler.IBMDebugJavaCompiler;
import com.ibm.ws.webcontainer.jsp.compiler.IBMJspCompiler;
import com.ibm.ws.webcontainer.webapp.WebApp;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JavaCompiler;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.SunJavaCompiler;

public class JspEngineContext
implements JspCompilationContext {
    JspReader reader;
    ServletWriter writer;
    ServletContext context;
    ClassLoader loader;
    String classpath;
    boolean isErrPage;
    String jspFile;
    String outDir;
    String servletClassName;
    String servletPackageName = "org.apache.jsp";
    String servletJavaFileName;
    String contentType;
    Options options;
    HttpServletRequest req;
    HttpServletResponse res;
    HashMap looseLibs = null;
    String webinfClassDir;
    boolean debugEnabled = false;

    public JspEngineContext(ClassLoader classLoader, String string, ServletContext servletContext, String string2, String string3, boolean bl, Options options, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl2) {
        this.loader = classLoader;
        this.classpath = string;
        this.context = servletContext;
        this.jspFile = string2;
        this.outDir = string3;
        this.isErrPage = bl;
        this.options = options;
        this.req = httpServletRequest;
        this.res = httpServletResponse;
        this.webinfClassDir = servletContext.getRealPath("/WEB-INF/classes") + string2.substring(0, string2.lastIndexOf("/") + 1);
        this.debugEnabled = bl2;
    }

    public HttpServletRequest getRequest() {
        return this.req;
    }

    public HttpServletResponse getResponse() {
        return this.res;
    }

    public void setLooseLibs(HashMap hashMap) {
        this.looseLibs = hashMap;
    }

    public HashMap getLooseLibs() {
        return this.looseLibs;
    }

    public String getClassPath() {
        if (this.loader instanceof ReloadableClassLoader) {
            return ((ReloadableClassLoader)this.loader).getClassPath();
        }
        if (this.loader instanceof CompoundClassLoader) {
            return ((CompoundClassLoader)this.loader).getClassPath();
        }
        if (this.loader instanceof URLClassLoader) {
            URL[] uRLArray = ((URLClassLoader)this.loader).getURLs();
            StringBuffer stringBuffer = new StringBuffer();
            String string = System.getProperty("path.separator");
            for (int i = 0; i < uRLArray.length; ++i) {
                if (!uRLArray[i].getProtocol().equals("file")) continue;
                stringBuffer.append(uRLArray[i].getFile() + string);
            }
            return stringBuffer.toString() + this.classpath;
        }
        return "";
    }

    public JspReader getReader() {
        return this.reader;
    }

    public ServletWriter getWriter() {
        return this.writer;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public boolean isErrorPage() {
        return this.isErrPage;
    }

    public String getOutputDir() {
        return this.outDir;
    }

    public String getJavacOutputDir() {
        return null;
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public String getServletClassName() {
        return this.servletClassName;
    }

    public String getServletPackageName() {
        return this.servletPackageName;
    }

    public String getServletJavaFileName() {
        return this.servletJavaFileName;
    }

    public boolean keepGenerated() {
        return this.options.getKeepGenerated();
    }

    public String getContentType() {
        return this.contentType;
    }

    public Options getOptions() {
        return this.options;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public void setReader(JspReader jspReader) {
        this.reader = jspReader;
    }

    public void setWriter(ServletWriter servletWriter) {
        this.writer = servletWriter;
    }

    public void setServletClassName(String string) {
        this.servletClassName = string;
    }

    public void setServletPackageName(String string) {
        this.servletPackageName = string;
    }

    public void setServletJavaFileName(String string) {
        this.servletJavaFileName = string;
    }

    public void setErrorPage(boolean bl) {
        this.isErrPage = bl;
    }

    public Compiler createCompiler() throws JasperException {
        JavaCompiler javaCompiler;
        String string = this.options.getJspCompilerPath();
        Class clazz = this.options.getJspCompilerPlugin();
        if (clazz != null) {
            try {
                javaCompiler = (JavaCompiler)clazz.newInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.jsp.JspEngineContext.createCompiler", (String)"261", (Object)this);
                Constants.message("jsp.warning.compiler.class.cantcreate", new Object[]{clazz, exception}, Integer.MIN_VALUE);
                javaCompiler = new SunJavaCompiler();
            }
        } else {
            javaCompiler = this.debugEnabled ? new IBMDebugJavaCompiler(this) : new SunJavaCompiler();
        }
        if (string != null) {
            javaCompiler.setCompilerPath(string);
        }
        IBMJspCompiler iBMJspCompiler = new IBMJspCompiler(this, this.debugEnabled);
        iBMJspCompiler.setJavaCompiler(javaCompiler);
        return iBMJspCompiler;
    }

    public String resolveRelativeUri(String string) {
        if (string.charAt(0) == '/') {
            return string;
        }
        String string2 = null;
        string2 = this.req != null ? this.req.getServletPath() : this.jspFile;
        String string3 = string2.substring(0, string2.lastIndexOf(47));
        return string3 + '/' + string;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = this.context.getResourceAsStream(string);
        if (inputStream == null) {
            inputStream = this.getClass().getResourceAsStream(string);
        }
        return inputStream;
    }

    public URL getResource(String string) throws MalformedURLException {
        return this.context.getResource(string);
    }

    public String getRealPath(String string) {
        if (this.context != null) {
            WebApp webApp;
            URL uRL;
            String string2 = this.context.getRealPath(string);
            if (!new File(string2).exists() && (uRL = (webApp = (WebApp)this.context).getClassLoader().getResource(string)) != null) {
                string2 = uRL.getFile();
            }
            return string2;
        }
        return string;
    }

    public String[] getTldLocation(String string) throws JasperException {
        String[] stringArray = this.options.getTldLocationsCache().getLocation(string);
        return stringArray;
    }

    public String getWebinfClassDir() {
        return this.webinfClassDir;
    }

    public ExtendedDocumentRootUtils getExtendedDocumentRootUtils() {
        String string = this.getOptions().getExtendedDocumentRoot();
        if (string != null) {
            String string2 = this.getRealPath("/../");
            return new ExtendedDocumentRootUtils(string2, string);
        }
        return null;
    }
}

