/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.jsp.compiler.ibmdebug;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.jsp.compiler.ibmdebug.SourceToByteCodeData;
import com.ibm.ws.webcontainer.jsp.compiler.ibmdebug.SourceToSourceData;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Vector;

public class ClassLineModifier {
    String generatedFileName;
    String jspFileName;
    String classFileName;
    String newClassFileName;
    DataInputStream classFileInput = null;
    RandomAccessFile classFileOutput = null;
    Vector srcToByteLines = new Vector();
    Vector srcToSrcLines = new Vector();
    int classFileIndex;
    int srcFileIndex;
    String[] constantPoolStrings;
    int[] constantPoolFileOffsets;
    public static int[] typeOffsets = new int[]{0, 0, 0, 4, 4, 8, 8, 2, 2, 4, 4, 4, 4};
    public static int CONSTANT_Utf8 = 1;
    public static int CONSTANT_Long = 5;
    public static int CONSTANT_Double = 6;

    public ClassLineModifier(String string, String string2) {
        this.generatedFileName = string;
        string2 = string2.replace('\\', '/');
        int n = string2.lastIndexOf(47);
        this.jspFileName = n != -1 ? string2.substring(n + 1) : string2;
        this.classFileName = string.substring(0, string.lastIndexOf(46)) + ".class";
        this.newClassFileName = this.classFileName + "WASNew";
    }

    public ClassLineModifier(String string, String string2, String string3) {
        this.generatedFileName = string;
        string3 = string3.replace('\\', '/');
        int n = string3.lastIndexOf(47);
        this.jspFileName = n != -1 ? string3.substring(n + 1) : string3;
        this.classFileName = string2;
        this.newClassFileName = this.classFileName + "WASNew";
    }

    public boolean prepareClassFileForDebug() {
        boolean bl = false;
        try {
            if (this.createSourceToSourceVector()) {
                this.classFileInput = new DataInputStream(new BufferedInputStream(new FileInputStream(this.classFileName)));
                this.classFileOutput = new RandomAccessFile(this.newClassFileName, "rw");
                if (this.generateNewClassFile(this.classFileInput, this.classFileOutput)) {
                    this.modifySourceSpecifier(this.classFileOutput);
                    bl = true;
                    this.classFileInput.close();
                    this.classFileOutput.close();
                    File file = new File(this.classFileName);
                    file.delete();
                    file = new File(this.newClassFileName);
                    file.renameTo(new File(this.classFileName));
                } else {
                    this.classFileInput.close();
                    this.classFileOutput.close();
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.jsp.compiler.ibmdebug.ClassLineModifier.prepareClassFileForDebug", (String)"117", (Object)this);
            System.out.println("Exception caught processing class file:");
            exception.printStackTrace();
        }
        return bl;
    }

    private boolean createSourceToSourceVector() {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(this.generatedFileName));
            int n = 0;
            while ((string = bufferedReader.readLine()) != null) {
                ++n;
                if (string.indexOf("##DEBUG##") == -1) continue;
                bl3 = false;
                bl4 = false;
                bl5 = false;
                if (string.indexOf("##SCRIPTLET##") != -1) {
                    bl3 = true;
                }
                if (string.indexOf("##DECLARATION##") != -1) {
                    bl4 = true;
                }
                boolean bl6 = false;
                if (string.indexOf("##TAGLIB##") != -1) {
                    bl6 = true;
                }
                bl2 = true;
                int n2 = string.indexOf(44);
                if (n2 == -1) continue;
                int n3 = n2;
                int n4 = n2 - 1;
                while (string.charAt(n4 - 1) != ' ') {
                    --n4;
                }
                int n5 = Integer.parseInt(string.substring(n4, n3));
                n4 = n3 = n2 + 1;
                while (string.charAt(n3) != '-') {
                    ++n3;
                }
                int n6 = Integer.parseInt(string.substring(n4, n3));
                n4 = n3 = string.lastIndexOf("LineMapIndex:");
                while (string.charAt(n3 - 1) == ' ') {
                    --n3;
                }
                while (string.charAt(n4 - 1) != ',') {
                    --n4;
                }
                int n7 = Integer.parseInt(string.substring(n4, n3));
                n4 = string.length() - 1;
                while (string.charAt(n4 - 1) != ':') {
                    --n4;
                }
                int n8 = Integer.parseInt(string.substring(n4));
                if (n5 <= 0) continue;
                bufferedReader.mark(2048);
                string = bufferedReader.readLine();
                if (string.trim().equals("{")) {
                    bl6 = true;
                }
                if (string.indexOf("bsf.exec(") != -1) {
                    bl5 = true;
                }
                bufferedReader.reset();
                while (bufferedReader.readLine().equals("\r\n")) {
                    ++n;
                }
                ++n;
                if (bl6) {
                    this.addSrcToSrcLineEntry(n8, n6, n7, n + 1);
                } else {
                    this.addSrcToSrcLineEntry(n8, n6, n7, n);
                }
                while (bl2 && (bl3 || bl4)) {
                    string = bufferedReader.readLine();
                    if (string.equals("\r\n")) {
                        ++n;
                        ++n8;
                        continue;
                    }
                    if (string.indexOf("// end") != -1) {
                        bl2 = false;
                        ++n;
                        continue;
                    }
                    if (string.trim().length() != 0) {
                        ++n8;
                        ++n;
                        if (bl5) continue;
                        this.addSrcToSrcLineEntry(n8, n6, n7, n);
                        continue;
                    }
                    ++n;
                    ++n8;
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.jsp.compiler.ibmdebug.ClassLineModifier.createSourceToSourceVector", (String)"239", (Object)this);
            System.out.println("Exception caught processing generated file " + this.generatedFileName + ".");
            System.out.flush();
            exception.printStackTrace(System.out);
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            bl = false;
        }
        return bl;
    }

    private void addSrcToSrcLineEntry(int n, int n2, int n3, int n4) {
        SourceToSourceData sourceToSourceData = new SourceToSourceData(n, n2, n3, n4);
        this.srcToSrcLines.addElement(sourceToSourceData);
    }

    private boolean generateNewClassFile(DataInputStream dataInputStream, RandomAccessFile randomAccessFile) {
        try {
            int n;
            int n2;
            int n3;
            short s;
            int n4;
            int n5;
            this.transferBytes(8);
            this.classFileIndex += 8;
            int n6 = dataInputStream.readShort();
            randomAccessFile.writeShort(n6);
            this.classFileIndex += 2;
            this.constantPoolStrings = new String[--n6 + 1];
            this.constantPoolFileOffsets = new int[n6 + 1];
            for (n5 = 0; n5 < n6; ++n5) {
                n4 = dataInputStream.readByte();
                randomAccessFile.writeByte(n4);
                ++this.classFileIndex;
                if (n4 == CONSTANT_Utf8) {
                    dataInputStream.mark(n6);
                    s = dataInputStream.readShort();
                    dataInputStream.reset();
                    this.constantPoolStrings[n5 + 1] = dataInputStream.readUTF();
                    randomAccessFile.writeUTF(this.constantPoolStrings[n5 + 1]);
                    this.constantPoolFileOffsets[n5 + 1] = this.classFileIndex;
                    this.classFileIndex += s + 2;
                    continue;
                }
                this.transferBytes(typeOffsets[n4]);
                this.classFileIndex += typeOffsets[n4];
                if (n4 != CONSTANT_Long && n4 != CONSTANT_Double) continue;
                ++n5;
            }
            this.transferBytes(6);
            this.classFileIndex += 6;
            short s2 = dataInputStream.readShort();
            randomAccessFile.writeShort(s2);
            s = (short)(s2 * 2);
            this.classFileIndex += 2;
            if (s > 0) {
                this.transferBytes(s);
                this.classFileIndex += s;
            }
            s = dataInputStream.readShort();
            randomAccessFile.writeShort(s);
            this.classFileIndex += 2;
            for (n5 = 0; n5 < s; ++n5) {
                this.transferBytes(6);
                this.classFileIndex += 6;
                n3 = dataInputStream.readShort();
                randomAccessFile.writeShort(n3);
                this.classFileIndex += 2;
                if (n3 <= 0) continue;
                for (n2 = 0; n2 < n3; ++n2) {
                    this.transferBytes(2);
                    n = dataInputStream.readInt();
                    randomAccessFile.writeInt(n);
                    if (n <= 0) continue;
                    this.transferBytes(n);
                }
            }
            s = dataInputStream.readShort();
            randomAccessFile.writeShort(s);
            this.classFileIndex += 2;
            for (n5 = 0; n5 < s; ++n5) {
                n = 1;
                this.transferBytes(6);
                this.classFileIndex += 6;
                n3 = dataInputStream.readShort();
                randomAccessFile.writeShort(n3);
                this.classFileIndex += 2;
                for (n2 = 0; n2 < n3; ++n2) {
                    int n7 = dataInputStream.readShort();
                    randomAccessFile.writeShort(n7);
                    this.classFileIndex += 2;
                    if (this.constantPoolStrings[n7].equals("Exceptions")) {
                        n4 = dataInputStream.readInt();
                        randomAccessFile.writeInt(n4);
                        this.transferBytes(n4);
                        this.classFileIndex += n4 + 4;
                        continue;
                    }
                    if (this.constantPoolStrings[n7].equals("Synthetic")) {
                        n4 = dataInputStream.readInt();
                        randomAccessFile.writeInt(n4);
                        this.classFileIndex += n4;
                        continue;
                    }
                    if (this.constantPoolStrings[n7].equals("ConstantValue")) {
                        this.transferBytes(6);
                        this.classFileIndex += 6;
                        continue;
                    }
                    if (this.constantPoolStrings[n7].equals("Code")) {
                        int n8 = dataInputStream.readInt();
                        long l = randomAccessFile.getFilePointer();
                        randomAccessFile.writeInt(n8);
                        this.classFileIndex += 4;
                        this.transferBytes(4);
                        this.classFileIndex += 4;
                        int n9 = dataInputStream.readInt();
                        randomAccessFile.writeInt(n9);
                        this.classFileIndex += 4;
                        if (n9 > 0) {
                            this.transferBytes(n9);
                            this.classFileIndex += n9;
                        }
                        short s3 = dataInputStream.readShort();
                        randomAccessFile.writeShort(s3);
                        n7 = (short)(s3 * 8);
                        this.classFileIndex += 2;
                        if (n7 > 0) {
                            this.transferBytes(n7);
                            this.classFileIndex += n7;
                        }
                        n7 = dataInputStream.readShort();
                        randomAccessFile.writeShort(n7);
                        this.classFileIndex += 2;
                        for (int i = 0; i < n7; ++i) {
                            int n10;
                            int n11 = dataInputStream.readShort();
                            randomAccessFile.writeShort(n11);
                            this.classFileIndex += 2;
                            if (this.constantPoolStrings[n11].equals("LineNumberTable")) {
                                int n12;
                                n10 = dataInputStream.readInt();
                                long l2 = randomAccessFile.getFilePointer();
                                randomAccessFile.writeInt(n10);
                                this.classFileIndex += 4;
                                n11 = dataInputStream.readShort();
                                randomAccessFile.writeShort(n11);
                                this.classFileIndex += 2;
                                if (n11 <= 0) continue;
                                int n13 = 0;
                                for (int j = 0; j < n11; ++j) {
                                    short s4 = dataInputStream.readShort();
                                    n12 = dataInputStream.readShort();
                                    short s5 = (short)this.findJSPSrcForGenSrc((short)n12);
                                    this.classFileIndex += 4;
                                    if (s5 == -1) continue;
                                    if (n != 0) {
                                        randomAccessFile.writeShort(0);
                                        randomAccessFile.writeShort(0);
                                        n = 0;
                                        n13 = (short)(n13 + 1);
                                    }
                                    randomAccessFile.writeShort(s4);
                                    randomAccessFile.writeShort(s5);
                                    n13 = (short)(n13 + 1);
                                }
                                long l3 = randomAccessFile.getFilePointer();
                                randomAccessFile.seek(l);
                                n12 = n8 - 4 * n11 + 4 * n13;
                                randomAccessFile.writeInt(n12);
                                randomAccessFile.seek(l2);
                                randomAccessFile.writeInt(4 * n13 + 2);
                                randomAccessFile.writeShort(n13);
                                randomAccessFile.seek(l3);
                                continue;
                            }
                            if (this.constantPoolStrings[n11].equals("LocalVariableTable")) {
                                this.transferBytes(4);
                                this.classFileIndex += 4;
                                n10 = dataInputStream.readShort();
                                randomAccessFile.writeShort(n10);
                                n11 = (short)(n10 * 10);
                                this.classFileIndex += 2;
                                if (n11 <= 0) continue;
                                this.transferBytes(n11);
                                this.classFileIndex += n11;
                                continue;
                            }
                            System.out.println("Code attribute " + this.constantPoolStrings[n11] + " not recognized.");
                            return false;
                        }
                        continue;
                    }
                    n4 = dataInputStream.readInt();
                    randomAccessFile.writeInt(n4);
                    this.transferBytes(n4);
                    this.classFileIndex += n4 + 4;
                }
            }
            s = dataInputStream.readShort();
            randomAccessFile.writeShort(s);
            this.classFileIndex += 2;
            for (n5 = 0; n5 < s; ++n5) {
                n3 = dataInputStream.readShort();
                randomAccessFile.writeShort(n3);
                this.classFileIndex += 2;
                if (this.constantPoolStrings[n3].equals("SourceFile")) {
                    this.transferBytes(4);
                    this.classFileIndex += 4;
                    n3 = dataInputStream.readShort();
                    randomAccessFile.writeShort(n3);
                    this.srcFileIndex = n3;
                    this.classFileIndex += 2;
                    continue;
                }
                System.out.println("Top level attribute " + this.constantPoolStrings[n3] + " not recognized.");
                return false;
            }
            n = 0;
            while (true) {
                n = dataInputStream.readByte();
                randomAccessFile.writeByte(n);
            }
        }
        catch (EOFException eOFException) {
            FFDCFilter.processException((Throwable)eOFException, (String)"com.ibm.ws.webcontainer.jsp.compiler.ibmdebug.ClassLineModifier.generateNewClassFile", (String)"574", (Object)this);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.jsp.compiler.ibmdebug.ClassLineModifier.generateNewClassFile", (String)"577", (Object)this);
            System.out.println("Problem reading/closing class file: " + this.classFileName);
            return false;
        }
        return true;
    }

    private void transferBytes(int n) {
        try {
            for (int i = 0; i < n; ++i) {
                this.classFileOutput.writeByte(this.classFileInput.readByte());
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.jsp.compiler.ibmdebug.ClassLineModifier.transferBytes", (String)"596", (Object)this);
            System.out.println("Exception caught while writing new class file: ");
            System.out.flush();
            exception.printStackTrace(System.out);
        }
    }

    private int findJSPSrcForGenSrc(short s) {
        int n = -1;
        Enumeration enumeration = this.srcToSrcLines.elements();
        while (enumeration.hasMoreElements()) {
            SourceToSourceData sourceToSourceData = (SourceToSourceData)enumeration.nextElement();
            if (sourceToSourceData.getGeneratedSourceLine() != s) continue;
            n = sourceToSourceData.getJSPSourceLine();
        }
        return n;
    }

    private void modifySourceSpecifier(RandomAccessFile randomAccessFile) {
        try {
            int n = this.constantPoolStrings[this.srcFileIndex].length();
            StringBuffer stringBuffer = new StringBuffer(n);
            stringBuffer.append(this.jspFileName);
            for (int i = 0; i < n - this.jspFileName.length(); ++i) {
                stringBuffer.append(' ');
            }
            randomAccessFile.seek(this.constantPoolFileOffsets[this.srcFileIndex]);
            randomAccessFile.writeUTF(stringBuffer.toString());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.jsp.compiler.ibmdebug.ClassLineModifier.modifySourceSpecifier", (String)"651", (Object)this);
            System.out.println("Exception caught while modifying source file specifier.");
            exception.printStackTrace();
        }
    }

    private String getCommentFileName(String string) {
        int n = (string = string.replace('\\', '/')).lastIndexOf(47);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        String string2 = string;
        string2 = string2.substring(0, string2.indexOf(34));
        return string2;
    }

    private void printStrings() {
        for (int i = 0; i < this.constantPoolStrings.length; ++i) {
            System.out.println("String at index " + i + ": " + this.constantPoolStrings[i]);
        }
    }

    private void printSrcToByteCode() {
        Enumeration enumeration = this.srcToByteLines.elements();
        while (enumeration.hasMoreElements()) {
            SourceToByteCodeData sourceToByteCodeData = (SourceToByteCodeData)enumeration.nextElement();
            System.out.println("At file index " + sourceToByteCodeData.getOffset() + " the bco is " + sourceToByteCodeData.getByteCodeIndex() + " and the src line is " + sourceToByteCodeData.getSourceLine());
        }
    }

    private void printSrcToSrc() {
        Enumeration enumeration = this.srcToSrcLines.elements();
        while (enumeration.hasMoreElements()) {
            SourceToSourceData sourceToSourceData = (SourceToSourceData)enumeration.nextElement();
            System.out.println("For JSP line " + sourceToSourceData.getJSPSourceLine() + " from " + sourceToSourceData.getJSPStartOffset() + " to " + sourceToSourceData.getJSPStopOffset() + " the Generated line is " + sourceToSourceData.getGeneratedSourceLine());
        }
    }
}

