/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.jsp.compiler.ibmdebug;

import com.ibm.ws.webcontainer.jsp.compiler.ibmdebug.DebugFileMapEntry;
import com.ibm.ws.webcontainer.jsp.compiler.ibmdebug.DebugLineMapEntry;
import java.util.ArrayList;
import java.util.ListIterator;
import org.apache.jasper.compiler.ServletWriter;

public class LineNumberTablesManager {
    private ArrayList debugFileMap = null;
    private ArrayList debugLineMap = null;
    private int fileMapCount = -1;
    private int lineMapCount = -1;

    public void addInitialEntries(String string) {
        ++this.lineMapCount;
        ++this.fileMapCount;
        this.addDebugFileMapEntry(string, this.lineMapCount);
        this.addDebugLineMapEntry(this.fileMapCount, 1);
    }

    public int addTableEntry(String string, int n, int n2) {
        ++this.lineMapCount;
        int n3 = this.lineMapCount;
        int n4 = this.findFilename(string);
        if (n4 == -1) {
            ++this.fileMapCount;
            n4 = this.fileMapCount;
            this.addDebugFileMapEntry(string, this.lineMapCount);
        }
        this.addDebugLineMapEntry(n4, n);
        for (int i = 0; i < n2 - n; ++i) {
            ++this.lineMapCount;
            this.addDebugLineMapEntry(n4, n + i + 1);
        }
        return n3;
    }

    private int findFilename(String string) {
        int n = -1;
        if (this.debugFileMap != null) {
            ListIterator listIterator = this.debugFileMap.listIterator();
            int n2 = 0;
            DebugFileMapEntry debugFileMapEntry = null;
            while (listIterator.hasNext()) {
                debugFileMapEntry = (DebugFileMapEntry)listIterator.next();
                if (string.equals(debugFileMapEntry.getFilename())) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        return n;
    }

    private void addDebugFileMapEntry(String string, int n) {
        if (this.debugFileMap == null) {
            this.debugFileMap = new ArrayList();
        }
        DebugFileMapEntry debugFileMapEntry = new DebugFileMapEntry();
        debugFileMapEntry.setFilename(string);
        debugFileMapEntry.setlineMapTableIndex(n);
        this.debugFileMap.add(debugFileMapEntry);
    }

    private void addDebugLineMapEntry(int n, int n2) {
        if (this.debugLineMap == null) {
            this.debugLineMap = new ArrayList();
        }
        DebugLineMapEntry debugLineMapEntry = new DebugLineMapEntry();
        debugLineMapEntry.setFileMapTableIndex(n);
        debugLineMapEntry.setJspSourceLineNumber(n2);
        this.debugLineMap.add(debugLineMapEntry);
    }

    public void generateSrcTables(ServletWriter servletWriter) {
        Object object;
        ListIterator listIterator;
        if (this.debugFileMap != null) {
            servletWriter.println("public static String[][] _jspx_debug_FileMapping = {");
            listIterator = this.debugFileMap.listIterator();
            object = null;
            servletWriter.println("{");
            while (listIterator.hasNext()) {
                object = (DebugFileMapEntry)listIterator.next();
                servletWriter.println(((DebugFileMapEntry)object).getQuotedFilename() + ", ");
            }
            servletWriter.println("},");
            listIterator = this.debugFileMap.listIterator();
            servletWriter.println("{");
            while (listIterator.hasNext()) {
                object = (DebugFileMapEntry)listIterator.next();
                servletWriter.println(((DebugFileMapEntry)object).getQuotedlineMapTableIndex() + ", ");
            }
            servletWriter.println("},");
            servletWriter.println("};");
        }
        if (this.debugLineMap != null) {
            servletWriter.println("public static String[][] _jspx_debug_LineMapping = {");
            listIterator = this.debugLineMap.listIterator();
            object = null;
            servletWriter.println("{");
            while (listIterator.hasNext()) {
                object = (DebugLineMapEntry)listIterator.next();
                servletWriter.println(((DebugLineMapEntry)object).getQuotedFileMapTableIndex() + ", ");
            }
            servletWriter.println("},");
            listIterator = this.debugLineMap.listIterator();
            servletWriter.println("{");
            while (listIterator.hasNext()) {
                object = (DebugLineMapEntry)listIterator.next();
                servletWriter.println(((DebugLineMapEntry)object).getQuotedJspSourceLineNumber() + ", ");
            }
            servletWriter.println("},");
            servletWriter.println("};");
        }
    }

    public String toString() {
        Object object;
        ListIterator listIterator;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.debugFileMap != null) {
            stringBuffer.append("FileMap: [");
            listIterator = this.debugFileMap.listIterator();
            object = null;
            while (listIterator.hasNext()) {
                object = (DebugFileMapEntry)listIterator.next();
                stringBuffer.append(((DebugFileMapEntry)object).toString());
                stringBuffer.append(", ");
            }
            stringBuffer.append("]");
        }
        if (this.debugLineMap != null) {
            stringBuffer.append("LineMap: [");
            listIterator = this.debugLineMap.listIterator();
            object = null;
            while (listIterator.hasNext()) {
                object = (DebugLineMapEntry)listIterator.next();
                stringBuffer.append(((DebugLineMapEntry)object).toString());
                stringBuffer.append(", ");
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }
}

