/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.jsp.compiler.ibmtools;

import com.ibm.websphere.models.config.process.Server;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.Component;
import com.ibm.ws.runtime.component.VariableMapImpl;
import com.ibm.ws.runtime.service.ComponentManagerImpl;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryImpl;
import com.ibm.ws.webcontainer.jsp.IBMConstants;
import com.ibm.ws.webcontainer.jsp.compiler.ibmtools.BatchC;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServicesSupport;
import org.apache.jasper.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class JspBatchCompiler {
    private String[] cmdArgs;
    private String _configRoot = null;
    private String _cell = null;
    private String _node = null;
    private String _process = null;
    private String _enterpriseApp = null;
    private String _webModule = null;
    private String _filename = null;
    private Boolean _keepGenerated = null;
    private Boolean _verbose = null;
    private Boolean _deprecation = null;
    private boolean _classloaderParentFirst = true;
    private boolean _classloaderSingleWarClassloader = true;
    public static String WEBMODULE_COMPILEALL = "Compile all web modules";
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Repository;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$ComponentManager;
    static /* synthetic */ Class class$com$ibm$ws$webcontainer$jsp$compiler$ibmtools$BatchC;

    public JspBatchCompiler(String[] stringArray) {
        this.cmdArgs = stringArray;
        this.setLogger();
    }

    public boolean start() {
        boolean bl = false;
        boolean bl2 = false;
        if (!this.parseCmdLine(this.cmdArgs)) {
            this.usage();
            return false;
        }
        IBMConstants.message("jsp.batchcompiler.initializing.server", new Object[]{this._process}, 3);
        RepositoryImpl repositoryImpl = new RepositoryImpl("ws-server", this._configRoot, this._cell, this._node, this._process);
        BeanContextServicesSupport beanContextServicesSupport = new BeanContextServicesSupport();
        beanContextServicesSupport.addService(class$com$ibm$ws$runtime$service$Repository == null ? (class$com$ibm$ws$runtime$service$Repository = JspBatchCompiler.class$("com.ibm.ws.runtime.service.Repository")) : class$com$ibm$ws$runtime$service$Repository, (BeanContextServiceProvider)repositoryImpl);
        VariableMapImpl variableMapImpl = new VariableMapImpl();
        beanContextServicesSupport.add(variableMapImpl);
        variableMapImpl.initialize(null);
        Server server = this.readConfig((Repository)repositoryImpl, this._cell);
        if (!bl2 && server != null) {
            ComponentManagerImpl componentManagerImpl = null;
            try {
                componentManagerImpl = new ComponentManagerImpl("META-INF/ws-server-components.xml", Thread.currentThread().getContextClassLoader());
                beanContextServicesSupport.addService(class$com$ibm$ws$runtime$service$ComponentManager == null ? (class$com$ibm$ws$runtime$service$ComponentManager = JspBatchCompiler.class$("com.ibm.ws.runtime.service.ComponentManager")) : class$com$ibm$ws$runtime$service$ComponentManager, (BeanContextServiceProvider)componentManagerImpl);
            }
            catch (ConfigurationError configurationError) {
                FFDCFilter.processException((Throwable)configurationError, (String)"com.ibm.ws.webcontainer.jsp.compiler.ibmtools.JspBatchCompiler.start", (String)"73", (Object)this);
                System.out.println(configurationError.getMessage());
                bl2 = true;
            }
            if (componentManagerImpl != null) {
                Component component = (Component)componentManagerImpl.getComponent((EObject)server);
                beanContextServicesSupport.add(component);
                BatchC batchC = new BatchC(this._configRoot, this._cell, this._node, this._process, this._enterpriseApp, this._webModule, this._filename, this._keepGenerated, this._verbose, this._deprecation, this._classloaderParentFirst, this._classloaderSingleWarClassloader);
                beanContextServicesSupport.addService(class$com$ibm$ws$webcontainer$jsp$compiler$ibmtools$BatchC == null ? (class$com$ibm$ws$webcontainer$jsp$compiler$ibmtools$BatchC = JspBatchCompiler.class$("com.ibm.ws.webcontainer.jsp.compiler.ibmtools.BatchC")) : class$com$ibm$ws$webcontainer$jsp$compiler$ibmtools$BatchC, (BeanContextServiceProvider)((Object)batchC));
                BatchC batchC2 = batchC;
                beanContextServicesSupport.add(batchC2);
                try {
                    batchC2.initialize((Object)batchC);
                }
                catch (ConfigurationWarning configurationWarning) {
                    FFDCFilter.processException((Throwable)configurationWarning, (String)"com.ibm.ws.webcontainer.jsp.compiler.ibmtools.JspBatchCompiler.start", (String)"127", (Object)this);
                    bl = true;
                }
                catch (ConfigurationError configurationError) {
                    FFDCFilter.processException((Throwable)configurationError, (String)"com.ibm.ws.webcontainer.jsp.compiler.ibmtools.JspBatchCompiler.start", (String)"131", (Object)this);
                    bl2 = true;
                }
                catch (ComponentDisabledException componentDisabledException) {
                    FFDCFilter.processException((Throwable)componentDisabledException, (String)"com.ibm.ws.webcontainer.jsp.compiler.ibmtools.JspBatchCompiler.start", (String)"135", (Object)this);
                    bl2 = true;
                }
                if (batchC.run() > 0) {
                    bl2 = true;
                }
            }
        } else {
            bl2 = true;
            IBMConstants.message("jsp.batchcompiler.unable.to.initialize.server", new Object[]{this._process}, 1);
        }
        return !bl2;
    }

    protected Server readConfig(Repository repository, String string) {
        Server server = null;
        try {
            Resource resource = repository.getConfigRoot().getResource(4, "server.xml");
            EList eList = resource.getContents();
            for (int i = 0; server == null && i < eList.size(); ++i) {
                Object e = eList.get(i);
                if (!(e instanceof Server)) continue;
                server = (Server)e;
            }
            if (server == null) {
                IBMConstants.message("jsp.batchcompiler.rootdomain.not.found", new Object[]{string}, 1);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.jsp.compiler.ibmtools.JspBatchCompiler.readConfig", (String)"175", (Object)this);
            System.out.println(throwable.getClass().getName() + "  Error encountered reading " + throwable.getMessage());
            return null;
        }
        return server;
    }

    private void usage() {
        IBMConstants.message("jsp.batchcompiler.error.usage", 1);
    }

    private boolean parseCmdLine(String[] stringArray) {
        try {
            this._configRoot = stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                if ("-enterpriseapp.name".equals(stringArray[i])) {
                    if (++i >= stringArray.length) continue;
                    this._enterpriseApp = stringArray[i];
                    continue;
                }
                if ("-webmodule.name".equals(stringArray[i])) {
                    if (++i >= stringArray.length) continue;
                    this._webModule = stringArray[i];
                    continue;
                }
                if ("-cell.name".equals(stringArray[i])) {
                    if (++i >= stringArray.length) continue;
                    this._cell = stringArray[i];
                    continue;
                }
                if ("-node.name".equals(stringArray[i])) {
                    if (++i >= stringArray.length) continue;
                    this._node = stringArray[i];
                    continue;
                }
                if ("-server.name".equals(stringArray[i])) {
                    if (++i >= stringArray.length) continue;
                    this._process = stringArray[i];
                    continue;
                }
                if ("-filename".equals(stringArray[i])) {
                    if (++i >= stringArray.length) continue;
                    this._filename = stringArray[i];
                    continue;
                }
                if ("-keepgenerated".equals(stringArray[i])) {
                    if (++i >= stringArray.length) continue;
                    this._keepGenerated = Boolean.valueOf(stringArray[i]);
                    continue;
                }
                if ("-verbose".equals(stringArray[i])) {
                    if (++i >= stringArray.length) continue;
                    this._verbose = Boolean.valueOf(stringArray[i]);
                    continue;
                }
                if ("-deprecation".equals(stringArray[i])) {
                    if (++i >= stringArray.length) continue;
                    this._deprecation = Boolean.valueOf(stringArray[i]);
                    continue;
                }
                if ("-classloader.parentFirst".equals(stringArray[i])) {
                    if (++i >= stringArray.length) continue;
                    this._classloaderParentFirst = "true".equals(stringArray[i]);
                    continue;
                }
                if ("-classloader.singleWarClassloader".equals(stringArray[i])) {
                    if (++i >= stringArray.length) continue;
                    this._classloaderSingleWarClassloader = "true".equals(stringArray[i]);
                    continue;
                }
                IBMConstants.message("jsp.batchcompiler.unknown.argument", new Object[]{stringArray[i]}, 1);
                return false;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.jsp.compiler.ibmtools.JspBatchCompiler.parseCmdLine", (String)"236", (Object)this);
            exception.printStackTrace();
            return false;
        }
        if (this._configRoot != null && this._enterpriseApp != null) {
            System.out.println(" ");
            if (this._cell == null) {
                IBMConstants.message("jsp.batchcompiler.using.default.cell.name", new Object[]{"BaseApplicationServerCell"}, 3);
                this._cell = "BaseApplicationServerCell";
            }
            if (this._node == null) {
                IBMConstants.message("jsp.batchcompiler.using.default.node.name", new Object[]{"DefaultNode"}, 3);
                this._node = "DefaultNode";
            }
            if (this._process == null) {
                IBMConstants.message("jsp.batchcompiler.using.default.server.name", new Object[]{"server1"}, 3);
                this._process = "server1";
            }
            if (this._webModule == null) {
                IBMConstants.message("jsp.batchcompiler.compiling.all.webmodules", 3);
                this._webModule = WEBMODULE_COMPILEALL;
            }
            IBMConstants.message("jsp.batchcompiler.initializing.with", 3);
            IBMConstants.message("jsp.batchcompiler.config.root", new Object[]{this._configRoot}, 3);
            IBMConstants.message("jsp.batchcompiler.cellname", new Object[]{this._cell}, 3);
            IBMConstants.message("jsp.batchcompiler.nodename", new Object[]{this._node}, 3);
            IBMConstants.message("jsp.batchcompiler.servername", new Object[]{this._process}, 3);
            IBMConstants.message("jsp.batchcompiler.enterpriseappname", new Object[]{this._enterpriseApp}, 3);
            IBMConstants.message("jsp.batchcompiler.webmodulename", new Object[]{this._webModule}, 3);
            if (this._filename != null) {
                IBMConstants.message("jsp.batchcompiler.jspfilename", new Object[]{this._filename}, 3);
            }
            if (this._keepGenerated != null) {
                IBMConstants.message("jsp.batchcompiler.keepgenerated", new Object[]{this._keepGenerated}, 3);
            }
            if (this._verbose != null) {
                IBMConstants.message("jsp.batchcompiler.verbose", new Object[]{this._verbose}, 3);
            }
            if (this._deprecation != null) {
                IBMConstants.message("jsp.batchcompiler.deprecation", new Object[]{this._deprecation}, 3);
            }
            System.out.println(" ");
            System.out.println(" ");
            return true;
        }
        return false;
    }

    private void setLogger() {
        IBMConstants.jasperLog = Logger.getDefaultLogger();
        IBMConstants.jasperLog.setVerbosityLevel(3);
    }

    public static void main(String[] stringArray) {
        JspBatchCompiler jspBatchCompiler = new JspBatchCompiler(stringArray);
        if (jspBatchCompiler.start()) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

