/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.jsp.compiler.ibmtools;

import com.ibm.ejs.models.base.extensions.webappext.JSPAttribute;
import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.webapplication.TagLibRef;
import com.ibm.ws.classloader.WsClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.jsp.IBMConstants;
import com.ibm.ws.webcontainer.jsp.compiler.ibmtools.JasperUtil;
import com.ibm.ws.webcontainer.jsp.compiler.ibmtools.JasperUtilContext;
import com.ibm.ws.webcontainer.jsp.compiler.ibmtools.JasperUtilOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JspCompiler;
import org.apache.jasper.logging.Logger;
import org.eclipse.emf.common.util.EList;

public class JspModC {
    private String _appDir;
    private String _tmpDir;
    private String _classpath;
    private ClassLoader _loader;
    private ClassLoader origClassLoader = null;
    private int returnCode = 0;
    private boolean forceCompilation = true;
    private JasperUtilContext context;

    public JspModC() {
        this(null, null);
    }

    public JspModC(String string, String string2) {
        this._appDir = string;
        this._tmpDir = string2;
        IBMConstants.jasperLog = Logger.getDefaultLogger();
        IBMConstants.jasperLog.setVerbosityLevel(2);
    }

    public JspModC(String[] stringArray) {
        IBMConstants.jasperLog = Logger.getDefaultLogger();
        IBMConstants.jasperLog.setVerbosityLevel(2);
        this.parseCmdLine(stringArray);
    }

    private void parseCmdLine(String[] stringArray) {
        block7: {
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    if ("-appDir".equals(stringArray[i])) {
                        this._appDir = stringArray[++i];
                        continue;
                    }
                    if ("-tmpDir".equals(stringArray[i])) {
                        this._tmpDir = stringArray[++i];
                        continue;
                    }
                    if (this.returnCode != 0) continue;
                    this.usage();
                }
                if (this.returnCode > 0) {
                    return;
                }
                if (this._appDir == null || this._tmpDir == null) {
                    this.usage();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.jsp.compiler.ibmtools.JspModC.parseCmdLine", (String)"61", (Object)this);
                if (this.returnCode != 0) break block7;
                this.usage();
            }
        }
    }

    public int compileApp(String string, String string2) {
        this._appDir = string;
        this._tmpDir = string2;
        return this.compileApp();
    }

    public int compileApp() {
        if (this.returnCode > 0) {
            return this.returnCode;
        }
        this._loader = this.createClassLoader(this._appDir);
        this._classpath = this.constructClasspath(this._appDir);
        JasperUtil jasperUtil = null;
        try {
            jasperUtil = new JasperUtil(this._classpath, this._tmpDir, new Properties());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.jsp.compiler.ibmtools.JspModC.compileDir", (String)"108", (Object)this);
            IBMConstants.message("jsp.batchcompiler.unable.create.jasperutil", 1);
            exception.printStackTrace();
            return 1;
        }
        int n = this.compileDir(this._appDir, this._tmpDir, jasperUtil);
        if (this.origClassLoader != null) {
            Thread.currentThread().setContextClassLoader(this.origClassLoader);
        }
        return n;
    }

    private ClassLoader createClassLoader(String string) {
        try {
            Serializable serializable;
            int n;
            File[] fileArray;
            File file;
            Vector<URL> vector = new Vector<URL>();
            File file2 = new File(string + "/WEB-INF/classes");
            if (file2.exists()) {
                vector.add(file2.toURL());
            }
            if ((file = new File(string + "/WEB-INF/lib")).exists()) {
                fileArray = file.listFiles(new JarFilenameFilter());
                for (int i = 0; i < fileArray.length; ++i) {
                    vector.add(fileArray[i].toURL());
                }
            }
            fileArray = this.getManifestPaths(string);
            URL[] uRLArray = new URL[fileArray.size() + vector.size()];
            int n2 = -1;
            for (n = 0; n < fileArray.size(); ++n) {
                URL uRL;
                serializable = new File((String)fileArray.get(n));
                uRLArray[n] = uRL = serializable.toURL();
                ++n2;
            }
            for (n = 1; n <= vector.size(); ++n) {
                serializable = (URL)vector.elementAt(n - 1);
                uRLArray[n + n2] = serializable;
            }
            return new URLClassLoader(uRLArray, this.getClass().getClassLoader());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.jsp.compiler.ibmtools.JspModC.createClassLoader", (String)"123", (Object)this);
            exception.printStackTrace();
            this.returnCode = 1;
            return null;
        }
    }

    private String constructClasspath(String string) {
        int n;
        URL[] uRLArray;
        Object object;
        String string2 = System.getProperty("path.separator");
        StringBuffer stringBuffer = new StringBuffer();
        this.origClassLoader = Thread.currentThread().getContextClassLoader();
        if (this.origClassLoader instanceof WsClassLoader) {
            object = (WsClassLoader)((Object)this.origClassLoader);
            stringBuffer.append(object.getClassPath());
            stringBuffer.append(string2);
        } else if (this.origClassLoader instanceof URLClassLoader) {
            object = (URLClassLoader)this.origClassLoader;
            uRLArray = ((URLClassLoader)object).getURLs();
            for (n = 0; n < uRLArray.length; ++n) {
                stringBuffer.append(uRLArray[n].getPath());
                stringBuffer.append(string2);
            }
        } else {
            return null;
        }
        object = new StringBuffer();
        uRLArray = ((URLClassLoader)this._loader).getURLs();
        for (n = 0; n < uRLArray.length; ++n) {
            try {
                File file = new File(uRLArray[n].getFile());
                ((StringBuffer)object).append(file.getCanonicalPath());
                if (n == uRLArray.length - 1) continue;
                ((StringBuffer)object).append(File.pathSeparator);
                continue;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.jsp.compiler.ibmtools.JspModC.constructClasspath", (String)"165", (Object)this);
            }
        }
        stringBuffer.append(((StringBuffer)object).toString());
        return stringBuffer.toString();
    }

    private int compileDir(String string, String string2, JasperUtil jasperUtil) {
        File[] fileArray;
        File file = new File(string);
        Properties properties = null;
        EList eList = null;
        if (!file.exists()) {
            IBMConstants.message("jsp.jspmodc.directory.not.found", new Object[]{string}, 1);
            this.returnCode = 1;
            return this.returnCode;
        }
        if (!file.isDirectory()) {
            IBMConstants.message("jsp.jspmodc.not.directory", new Object[]{string}, 1);
            this.returnCode = 1;
            return this.returnCode;
        }
        File[] fileArray2 = file.listFiles(new JspFilenameFilter());
        try {
            Thread.currentThread().setContextClassLoader(this._loader);
            WARFile wARFile = CommonarchiveFactoryImpl.getActiveFactory().openWARFile(this._appDir);
            fileArray = wARFile.getDeploymentDescriptor();
            eList = fileArray.getTagLibs();
            properties = new Properties();
            try {
                WebAppExtension webAppExtension = wARFile.getExtensions();
                Iterator iterator = webAppExtension.getJspAttributes().iterator();
                while (iterator.hasNext()) {
                    JSPAttribute jSPAttribute = (JSPAttribute)iterator.next();
                    properties.put(jSPAttribute.getName(), jSPAttribute.getValue());
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.jsp.compiler.ibmtools.JspModC.compileDir", (String)"223", (Object)this);
            }
            jasperUtil.setOptions(properties);
            jasperUtil.setClassLoader(this._loader);
            jasperUtil.setTagLibs((List)eList);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.jsp.compiler.ibmtools.JspModC.compileDir", (String)"231", (Object)this);
            IBMConstants.message("jsp.batchcompiler.unable.create.jasperutil", 1);
            exception.printStackTrace();
            this.returnCode = 1;
            return this.returnCode;
        }
        if (this.forceCompilation) {
            this.deleteClassfiles(fileArray2, properties, (List)eList, string);
        }
        int n = jasperUtil.compileDir(this._appDir, string, fileArray2, false);
        if (this.returnCode == 0) {
            this.returnCode = n;
        }
        fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory() || "META-INF".equals(fileArray[i].getName())) continue;
            IBMConstants.message("jsp.batchcompiler.compile.path", new Object[]{fileArray[i].getPath()}, 3);
            n = this.compileDir(fileArray[i].getPath(), string2, jasperUtil);
            if (this.returnCode != 0) continue;
            this.returnCode = n;
        }
        return this.returnCode;
    }

    protected ArrayList getManifestPaths(String string) {
        ArrayList arrayList = new ArrayList();
        File file = new File(string);
        if (file.exists()) {
            if (file.isDirectory()) {
                File file2 = new File(string + File.separator + "META-INF" + File.separator + "MANIFEST.MF");
                if (file2.exists()) {
                    try {
                        Manifest manifest = new Manifest(new FileInputStream(file2));
                        arrayList = this.getManifestClassPaths(manifest, file.getParent());
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.jsp.compiler.ibmtools.JspModC.getManifestPaths", (String)"270", (Object)this);
                    }
                }
            } else {
                try {
                    JarFile jarFile = new JarFile(file);
                    Manifest manifest = jarFile.getManifest();
                    if (manifest != null) {
                        arrayList = this.getManifestClassPaths(manifest, file.getParent());
                    }
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.jsp.compiler.ibmtools.JspModC.getManifestPaths", (String)"280", (Object)this);
                }
            }
        }
        return arrayList;
    }

    protected ArrayList getManifestClassPaths(Manifest manifest, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Attributes attributes = manifest.getMainAttributes();
        String string2 = attributes.getValue(Attributes.Name.CLASS_PATH);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = string + File.separator + stringTokenizer.nextToken();
                if (!new File(string3).exists()) continue;
                arrayList.add(string3);
            }
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        JspModC jspModC = new JspModC(stringArray);
        System.exit(jspModC.compileApp());
    }

    private void usage() {
        IBMConstants.message("jsp.jspmodc.usage", 1);
        this.returnCode = 1;
    }

    private void deleteClassfiles(File[] fileArray, Properties properties, List list, String string) {
        try {
            JasperUtilOptions jasperUtilOptions = new JasperUtilOptions(properties);
            for (int i = 0; i < fileArray.length; ++i) {
                String string2 = fileArray[i].getPath();
                String string3 = string2.substring(File.separator.length() + this._appDir.length());
                if (string3.charAt(0) != '/') {
                    string3 = "/" + string3;
                }
                String string4 = this._tmpDir.replace('\\', '/');
                string3 = string3.replace('\\', '/');
                int n = 0;
                if (string4.endsWith("/")) {
                    n = 1;
                }
                string4 = string4 + string3.substring(n, string3.lastIndexOf("/") + 1);
                File file = new File(string4);
                if (this.context == null) {
                    this.context = new JasperUtilContext(string3, file.toString() + File.separator, this._classpath, jasperUtilOptions, this.createTagLibs(list), string, this._appDir);
                } else {
                    this.context.init(string3, file.toString() + File.separator, string);
                }
                this.context.setClassLoader(this._loader);
                Compiler compiler = this.context.createCompilerJustParse();
                if (!(compiler instanceof JspCompiler)) continue;
                String string5 = ((JspCompiler)compiler).getClassFileName().replace('\\', '/');
                File file2 = new File(string5);
                String string6 = file2.toString().substring(0, file2.toString().lastIndexOf("."));
                string6 = string6 + ".dat";
                File file3 = new File(string6);
                if (file2.exists()) {
                    file2.delete();
                }
                if (!file3.exists()) continue;
                file3.delete();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.jsp.compiler.ibmtools.JspModC.deleteClassfiles", (String)"608", (Object)this);
            exception.printStackTrace();
        }
    }

    private Hashtable createTagLibs(List list) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < list.size(); ++i) {
            String string;
            TagLibRef tagLibRef = (TagLibRef)list.get(i);
            String string2 = tagLibRef.getTaglibLocation();
            if (string2 != null) {
                string2 = string2.trim();
            }
            if ((string = tagLibRef.getTaglibURI()) != null) {
                string = string.trim();
            }
            hashtable.put(string, string2);
        }
        return hashtable;
    }

    public boolean isForceCompilation() {
        return this.forceCompilation;
    }

    public void setForceCompilation(boolean bl) {
        this.forceCompilation = bl;
    }

    private class JarFilenameFilter
    implements FilenameFilter {
        private JarFilenameFilter() {
        }

        public boolean accept(File file, String string) {
            try {
                String string2 = string.substring(string.lastIndexOf(".") + 1);
                if ("jar".equalsIgnoreCase(string2)) {
                    return true;
                }
                return "zip".equalsIgnoreCase(string2);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.jsp.compiler.ibmtools.JspModC.accept", (String)"347", (Object)this);
                return false;
            }
        }
    }

    private class JspFilenameFilter
    implements FilenameFilter {
        private JspFilenameFilter() {
        }

        public boolean accept(File file, String string) {
            try {
                String string2;
                int n = string.lastIndexOf(".");
                return n > -1 && "jsp".equals(string2 = string.substring(string.lastIndexOf(".") + 1));
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.jsp.compiler.ibmtools.JspModC.accept", (String)"329", (Object)this);
                return false;
            }
        }
    }
}

