/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.jsp.tsx.tag;

import com.ibm.ws.webcontainer.jsp.tsx.tag.DefinedIndexManager;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Stack;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class RepeatTag
extends BodyTagSupport {
    private String index = "";
    private int start = 0;
    private int end = Integer.MAX_VALUE;
    private int currentIteration = 0;

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String string) {
        this.index = string;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int n) {
        this.start = n > 0 ? n : 0;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int n) {
        this.end = n >= this.start ? n : Integer.MAX_VALUE;
    }

    public int doStartTag() throws JspException {
        Hashtable<String, Integer> hashtable;
        Stack<String> stack;
        DefinedIndexManager definedIndexManager = (DefinedIndexManager)this.pageContext.getAttribute("TSXDefinedIndexManager", 1);
        if (definedIndexManager == null) {
            definedIndexManager = new DefinedIndexManager();
            this.pageContext.setAttribute("TSXDefinedIndexManager", (Object)definedIndexManager, 1);
        }
        if ((stack = (Stack<String>)this.pageContext.getAttribute("TSXRepeatStack", 1)) == null) {
            stack = new Stack<String>();
            this.pageContext.setAttribute("TSXRepeatStack", stack, 1);
        }
        if ((hashtable = (Hashtable<String, Integer>)this.pageContext.getAttribute("TSXRepeatLookup", 1)) == null) {
            hashtable = new Hashtable<String, Integer>();
            this.pageContext.setAttribute("TSXRepeatLookup", hashtable, 1);
        }
        if (this.index == null || this.index.equals("")) {
            this.index = definedIndexManager.getNextIndex();
        } else {
            if (definedIndexManager.exists(this.index)) {
                throw new JspException("Index specified in <tsx:repeat> tag has already been defined. index =[" + this.index + "]");
            }
            definedIndexManager.addIndex(this.index);
        }
        if (this.start > 0) {
            this.currentIteration = this.start;
        }
        stack.push(this.index);
        hashtable.put(this.index, new Integer(this.currentIteration++));
        if (this.end < 0) {
            this.end = Integer.MAX_VALUE;
        }
        return 2;
    }

    public int doAfterBody() throws JspException {
        Hashtable hashtable = (Hashtable)this.pageContext.getAttribute("TSXRepeatLookup", 1);
        Boolean bl = (Boolean)this.pageContext.findAttribute("TSXBreakRepeat");
        if (bl != null) {
            return 0;
        }
        if (this.currentIteration <= this.end) {
            hashtable.put(this.index, new Integer(this.currentIteration++));
            return 2;
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        Stack stack = (Stack)this.pageContext.getAttribute("TSXRepeatStack", 1);
        this.index = (String)stack.pop();
        this.currentIteration = 0;
        String string = this.getBodyContent().getString();
        JspWriter jspWriter = this.pageContext.getOut();
        try {
            jspWriter.write(string);
        }
        catch (IOException iOException) {
            throw new JspException("Unable to write <tsx:repeat> tag output " + iOException.getMessage());
        }
        finally {
            this.pageContext.removeAttribute("TSXBreakRepeat", 2);
        }
        DefinedIndexManager definedIndexManager = (DefinedIndexManager)this.pageContext.getAttribute("TSXDefinedIndexManager", 1);
        if (definedIndexManager != null) {
            definedIndexManager.removeIndex(this.index);
        }
        return 6;
    }

    public void release() {
        super.release();
        this.index = "";
        this.start = 0;
        this.end = Integer.MAX_VALUE;
    }
}

