/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.oselistener.api;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.debug.DebugSupport;
import com.ibm.ws.webcontainer.oselistener.AppServerEntryFactory;
import com.ibm.ws.webcontainer.oselistener.api.AppServerEntry;
import com.ibm.ws.webcontainer.oselistener.api.IOSEConnection;
import com.ibm.ws.webcontainer.oselistener.stamarshal.ThreadMarshalServerRequestConnection;
import com.ibm.ws.webcontainer.oselistener.stamarshal.ThreadMarshalServiceThread;
import com.ibm.ws.webcontainer.util.ExProperties;
import java.io.IOException;

public abstract class ServerEntry {
    private static ServerEntry m_theEntry = null;
    private ExProperties bootStrapProps;
    private AppServerEntry engine;

    public ServerEntry() {
        m_theEntry = this;
        try {
            this.bootStrapProps = new ExProperties();
            this.engine = null;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.oselistener.api.ServerEntry.ServerEntry", (String)"47", (Object)this);
            DebugSupport.logException(throwable);
        }
    }

    public abstract int init(long var1);

    public int init() {
        try {
            try {
                String string = this.getBootStrapFileName();
                this.bootStrapProps.load(string);
                this.bootStrapProps.setProperty("bootstrap.filename", string);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.oselistener.api.ServerEntry.init", (String)"75", (Object)this);
                DebugSupport.logException("Failed to read in bootstrap properties file", iOException);
                return -1;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.oselistener.api.ServerEntry.init", (String)"80", (Object)this);
                DebugSupport.logException("Error getting initialization data", exception);
                return -1;
            }
            this.engine = AppServerEntryFactory.getServer();
            try {
                this.engine.init();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.oselistener.api.ServerEntry.init", (String)"91", (Object)this);
                DebugSupport.logException("Error initializing the engine", exception);
                return -1;
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.oselistener.api.ServerEntry.init", (String)"98", (Object)this);
            DebugSupport.logException(throwable);
            return -1;
        }
        return 0;
    }

    public abstract int service(long var1, long var3, int var5, String var6, String var7);

    public int service(IOSEConnection iOSEConnection) {
        if (!iOSEConnection.isThreadSafe()) {
            ThreadMarshalServiceThread threadMarshalServiceThread = ThreadMarshalServiceThread.startThreadMarshalServiceThread(iOSEConnection, this);
            threadMarshalServiceThread.service();
            int n = threadMarshalServiceThread.getMarshleConn().realThreadServerLoop();
            return n;
        }
        try {
            if (iOSEConnection.isServletInvoke()) {
                try {
                    this.engine.invokeServlet(iOSEConnection.getServletName(), iOSEConnection.getServletCode(), iOSEConnection.getServletCodeBase(), iOSEConnection.getServletInitProperties(), iOSEConnection);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.oselistener.api.ServerEntry.service", (String)"144", (Object)this);
                    DebugSupport.logException("Error executing request", iOException);
                    return -2;
                }
            }
            try {
                this.engine.service(iOSEConnection);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.oselistener.api.ServerEntry.service", (String)"156", (Object)this);
                DebugSupport.logException(iOException);
                return -2;
            }
            if (iOSEConnection instanceof ThreadMarshalServerRequestConnection) {
                iOSEConnection = ((ThreadMarshalServerRequestConnection)iOSEConnection).getProxyConn();
            }
            return 0;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.oselistener.api.ServerEntry.service", (String)"170", (Object)this);
            DebugSupport.logException(throwable);
            return -1;
        }
    }

    public synchronized int destroy() {
        if (null == this.engine) {
            return 0;
        }
        try {
            try {
                this.engine.destroy(null);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.oselistener.api.ServerEntry.destroy", (String)"200", (Object)this);
                DebugSupport.logException("Failure during shutdown of the engine", exception);
                return -1;
            }
            this.bootStrapProps = null;
            this.engine = null;
            return 0;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.oselistener.api.ServerEntry.destroy", (String)"211", (Object)this);
            DebugSupport.logException(throwable);
            return -1;
        }
    }

    public boolean isThreadSafe() {
        return true;
    }

    protected abstract String getBootStrapFileName() throws Exception;

    protected abstract String getConnectionClassName();
}

