/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.oselistener.outofproc;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.debug.DebugSupport;
import com.ibm.ws.webcontainer.oselistener.outofproc.HostData;
import com.ibm.ws.webcontainer.oselistener.outofproc.MessageDataExtractor;
import com.ibm.ws.webcontainer.oselistener.outofproc.ServerMessage;
import com.ibm.ws.webcontainer.oselistener.outofproc.ServerQueueException;
import com.ibm.ws.webcontainer.oselistener.outofproc.SingleHost;
import java.io.PrintStream;

public class OOPInitData
extends MessageDataExtractor {
    protected boolean m_isThreadSafe;
    protected String m_bootProps;
    protected int m_defaultPort;
    protected String m_defaultServerName;
    protected String m_defaultServerSoftware;
    protected HostData m_aliases = new HostData();
    protected HostData m_mime = new HostData();
    private static final OOPInitData m_data = new OOPInitData();

    private OOPInitData() {
    }

    public static OOPInitData getInitData() {
        return m_data;
    }

    public void readMsg() throws ServerQueueException {
        try {
            this.m_msg = this.getServerMessage();
            if (this.m_msg.getTypeOfMessage() != ServerMessage.INIT_MESSAGE_TYPE) {
                this.signalError();
                throw new ServerQueueException("Error : waiting for init and got " + this.m_msg.getTypeOfMessage());
            }
            byte[] byArray = this.m_msg.getNextFieldAsByteArray();
            this.parseAttribs(byArray);
            this.parseAliasData();
            this.parseMimeData();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.oselistener.outofproc.OOPInitData.readMsg", (String)"52", (Object)this);
            DebugSupport.logException(throwable);
            throw new ServerQueueException();
        }
    }

    public String getBootStrapFileName() {
        return this.m_bootProps;
    }

    protected void nullAll() {
        this.m_isThreadSafe = false;
        this.m_bootProps = null;
        this.m_defaultPort = 0;
        this.m_defaultServerName = null;
        this.m_defaultServerSoftware = null;
    }

    protected void parseAttribs(byte[] byArray) throws ServerQueueException {
        int n = 0;
        int n2 = byArray.length;
        if (byArray[0] - 48 != MessageDataExtractor.OSE_CURRENT_VERSION || byArray[1] != 0) {
            throw new ServerQueueException("Unsupported ose version");
        }
        int n3 = n = 2;
        while (byArray[n3] != 0) {
            ++n3;
        }
        n3 = n = n3 + 1;
        while (byArray[n3] != 0) {
            ++n3;
        }
        n = n3 + 1;
        this.m_isThreadSafe = false;
        if (byArray[n] != 48) {
            this.m_isThreadSafe = true;
        }
        n3 = n += 2;
        while (byArray[n3] != 0) {
            ++n3;
        }
        if (n3 > n) {
            this.m_bootProps = new String(byArray, n, n3 - n);
        }
        n = n3 + 1;
        this.m_defaultPort = 0;
        n3 = n;
        while (byArray[n3] != 0) {
            this.m_defaultPort *= 10;
            this.m_defaultPort += byArray[n3] - 48;
            ++n3;
        }
        n3 = n = n3 + 1;
        while (byArray[n3] != 0) {
            ++n3;
        }
        if (n3 > n) {
            this.m_defaultServerName = new String(byArray, n, n3 - n);
        }
        n3 = n = n3 + 1;
        while (byArray[n3] != 0) {
            ++n3;
        }
        if (n3 > n) {
            this.m_defaultServerSoftware = new String(byArray, n, n3 - n);
        }
        if (byArray[n = n3 + 1] - 48 != MessageDataExtractor.OSE_CURRENT_VERSION || byArray[n + 1] != 0) {
            throw new ServerQueueException("Unsupported ose version");
        }
        this.m_aliases.m_isEnough = false;
        if (byArray[n += 2] != 48) {
            this.m_aliases.m_isEnough = true;
        }
        this.m_aliases.m_length = 0;
        n3 = n += 2;
        while (byArray[n3] != 0) {
            this.m_aliases.m_length *= 10;
            this.m_aliases.m_length += byArray[n3] - 48;
            ++n3;
        }
        n = n3 + 1;
        this.m_aliases.m_version = MessageDataExtractor.OSE_CURRENT_VERSION;
        if (byArray[n] - 48 != MessageDataExtractor.OSE_CURRENT_VERSION || byArray[n + 1] != 0) {
            throw new ServerQueueException("Unsupported ose version");
        }
        this.m_mime.m_isEnough = false;
        if (byArray[n += 2] != 48) {
            this.m_aliases.m_isEnough = true;
        }
        this.m_mime.m_length = 0;
        n3 = n += 2;
        while (byArray[n3] != 0) {
            this.m_mime.m_length *= 10;
            this.m_mime.m_length += byArray[n3] - 48;
            ++n3;
        }
        n = n3 + 1;
        this.m_mime.m_version = MessageDataExtractor.OSE_CURRENT_VERSION;
    }

    protected void parseAliasData() throws ServerQueueException {
        try {
            if (this.m_aliases.m_length > 0) {
                this.m_aliases.m_hosts = new SingleHost[this.m_aliases.m_length];
                for (int i = 0; i < this.m_aliases.m_length; ++i) {
                    int n = this.m_msg.getNextFieldAsInt(-1);
                    int n2 = this.m_msg.getNextFieldAsInt(-1);
                    if (n2 < 0) {
                        throw new ServerQueueException("parseAliasData negative alias list length");
                    }
                    this.m_aliases.m_hosts[i] = new SingleHost();
                    this.m_aliases.m_hosts[i].val1 = new String[n2];
                    this.m_aliases.m_hosts[i].val2 = new String[n2];
                    this.m_aliases.m_hosts[i].m_id = n;
                    for (int j = 0; j < n2; ++j) {
                        this.m_aliases.m_hosts[i].val1[j] = this.m_msg.getNextFieldAsString().trim();
                        this.m_aliases.m_hosts[i].val2[j] = this.m_msg.getNextFieldAsString().trim();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.oselistener.outofproc.OOPInitData.parseAliasData", (String)"208", (Object)this);
            DebugSupport.logException(throwable);
            throw new ServerQueueException("Error : parseAliasData");
        }
    }

    protected void parseMimeData() throws ServerQueueException {
        try {
            if (this.m_mime.m_length > 0) {
                this.m_mime.m_hosts = new SingleHost[this.m_mime.m_length];
                for (int i = 0; i < this.m_mime.m_length; ++i) {
                    int n = this.m_msg.getNextFieldAsInt(-1);
                    int n2 = this.m_msg.getNextFieldAsInt(-1);
                    if (n2 < 0) {
                        throw new ServerQueueException("parseMimeData negative mime list length");
                    }
                    this.m_mime.m_hosts[i] = new SingleHost();
                    this.m_mime.m_hosts[i].val1 = new String[n2];
                    this.m_mime.m_hosts[i].val2 = new String[n2];
                    this.m_mime.m_hosts[i].m_id = n;
                    for (int j = 0; j < n2; ++j) {
                        this.m_mime.m_hosts[i].val1[j] = this.m_msg.getNextFieldAsString().trim();
                        this.m_mime.m_hosts[i].val2[j] = this.m_msg.getNextFieldAsString().trim();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.oselistener.outofproc.OOPInitData.parseMimeData", (String)"243", (Object)this);
            DebugSupport.logException(throwable);
            throw new ServerQueueException("Error : parseMimeData");
        }
    }

    void dump(PrintStream printStream) {
        int n;
        SingleHost singleHost;
        int n2;
        printStream.println("m_isThreadSafe           = " + this.m_isThreadSafe);
        printStream.println("m_bootProps              = " + this.m_bootProps);
        printStream.println("m_defaultPort            = " + this.m_defaultPort);
        printStream.println("m_defaultServerName      = " + this.m_defaultServerName);
        printStream.println("m_defaultServerSoftware  = " + this.m_defaultServerSoftware);
        printStream.println("m_aliases.m_length       = " + this.m_aliases.m_length);
        printStream.println("m_aliases.m_isEnough     = " + this.m_aliases.m_isEnough);
        for (n2 = 0; n2 < this.m_aliases.m_length; ++n2) {
            singleHost = this.m_aliases.m_hosts[n2];
            printStream.println("m_aliases.m_hosts[" + n2 + "].id = " + singleHost.m_id);
            for (n = 0; n < singleHost.val1.length; ++n) {
                printStream.println("Alias : " + singleHost.val1[n] + " = " + singleHost.val2[n]);
            }
        }
        printStream.println("m_mime.m_length          = " + this.m_mime.m_length);
        printStream.println("m_mime.m_isEnough        = " + this.m_mime.m_isEnough);
        for (n2 = 0; n2 < this.m_mime.m_length; ++n2) {
            singleHost = this.m_mime.m_hosts[n2];
            printStream.println("m_mime.m_hosts[" + n2 + "].id = " + singleHost.m_id);
            for (n = 0; n < singleHost.val1.length; ++n) {
                printStream.println("Mimes : " + singleHost.val1[n] + " = " + singleHost.val2[n]);
            }
        }
    }
}

