/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.oselistener.outofproc;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.debug.DebugSupport;
import com.ibm.ws.webcontainer.oselistener.AppServerEntryFactory;
import com.ibm.ws.webcontainer.oselistener.Transport;
import com.ibm.ws.webcontainer.oselistener.TransportFactory;
import com.ibm.ws.webcontainer.oselistener.api.AppServerEntry;
import com.ibm.ws.webcontainer.oselistener.api.IRunnableThreadPool;
import com.ibm.ws.webcontainer.oselistener.api.SQInitDataImp;
import com.ibm.ws.webcontainer.oselistener.api.ServerEntry;
import com.ibm.ws.webcontainer.oselistener.outofproc.OutOfProcThread;
import com.ibm.ws.webcontainer.oselistener.serverqueue.SQException;
import com.ibm.ws.webcontainer.util.ExProperties;
import java.net.Socket;

public class OutOfProcEngine {
    public static int ERROR_EXIT_CODE = -1;
    public static int OK_EXIT_CODE = 0;
    public static String BOOT_FILE = "-bootfile";
    public static String NATIVE_LOG_FILE = "-nativelogfile";
    public static String NATIVE_LOG_LEVEL = "-nativeloglevel";
    public static String LINK_TYPE = "-linktype";
    public static String INET_PORT = "-port";
    public static String QUEUE_NAME = "-queuename";
    public static String STUB_LIB = "-stublib";
    public static String SERVER_LIB = "-serverlib";
    public static String CLONE_INDEX = "-clnindex";
    public static String LB_MODE = "-lbmode";
    public static String THREAD_COUNT = "-threadcnt";
    public static String PUSH_MODE = "push";
    public static String INET_LINK = "remote";
    public static String JAVA_LINK = "remote_java";
    protected boolean m_finish = false;
    protected String m_bootFile = null;
    protected int m_threadCount = 10;
    private static boolean m_outOfProcIsOn = false;
    ServerEntry serverEntry;

    public static final boolean isOutOfProcIsOn() {
        return m_outOfProcIsOn;
    }

    public static void main(String[] stringArray) {
        OutOfProcEngine outOfProcEngine = new OutOfProcEngine(stringArray);
        outOfProcEngine.waitForDone();
        outOfProcEngine.doShutdown();
        System.exit(OK_EXIT_CODE);
    }

    void runQueueLoop(AppServerEntry appServerEntry, IRunnableThreadPool iRunnableThreadPool, SQInitDataImp sQInitDataImp) throws SQException {
        Transport transport = TransportFactory.getTransport();
        transport.initialize(sQInitDataImp, iRunnableThreadPool, appServerEntry);
        System.out.println("Init is done !!!");
        while (true) {
            try {
                while (true) {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.oselistener.outofproc.OutOfProcEngine.runQueueLoop", (String)"102", (Object)this);
                continue;
            }
            break;
        }
    }

    public OutOfProcEngine(String[] stringArray) {
        try {
            for (int i = 0; i < stringArray.length; ++i) {
            }
            this.doStartup(stringArray);
            SQInitDataImp sQInitDataImp = this.parseCmdLine(stringArray);
            ExProperties exProperties = new ExProperties();
            exProperties.load(this.m_bootFile);
            exProperties.setProperty("bootstrap.filename", this.m_bootFile);
            AppServerEntry appServerEntry = AppServerEntryFactory.getServer();
            appServerEntry.init();
            OutOfProcThread.startServerWorkerThreads(this.m_threadCount);
            this.runQueueLoop(appServerEntry, OutOfProcThread.getRunneableThreadPool(), sQInitDataImp);
        }
        catch (SQException sQException) {
            FFDCFilter.processException((Throwable)sQException, (String)"com.ibm.ws.webcontainer.oselistener.outofproc.OutOfProcEngine.OutOfProcEngine", (String)"130", (Object)this);
            sQException.printStackTrace();
            DebugSupport.logException("Caught thrown error, can not initialize server queue", sQException);
            System.exit(ERROR_EXIT_CODE);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.oselistener.outofproc.OutOfProcEngine.OutOfProcEngine", (String)"135", (Object)this);
            throwable.printStackTrace();
            DebugSupport.logException("Caught thrown exception", throwable);
            System.exit(ERROR_EXIT_CODE);
        }
    }

    synchronized void done() {
        this.m_finish = true;
        this.notify();
    }

    protected synchronized void waitForDone() {
        while (!this.m_finish) {
            try {
                this.wait();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.oselistener.outofproc.OutOfProcEngine.waitForDone", (String)"154", (Object)this);
            }
        }
    }

    protected SQInitDataImp parseCmdLine(String[] stringArray) {
        SQInitDataImp sQInitDataImp = new SQInitDataImp();
        sQInitDataImp.setQueueType(2);
        for (int i = 0; i < stringArray.length - 1; i += 2) {
            if (stringArray[i].equalsIgnoreCase(BOOT_FILE)) {
                this.m_bootFile = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(THREAD_COUNT)) {
                try {
                    this.m_threadCount = Integer.parseInt(stringArray[i + 1]);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.oselistener.outofproc.OutOfProcEngine.parseCmdLine", (String)"176", (Object)this);
                    DebugSupport.logException("Error : " + stringArray[i + 1] + " is not a log level", throwable);
                }
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(NATIVE_LOG_FILE)) {
                sQInitDataImp.setNativeQueueLogFile(stringArray[i + 1]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(NATIVE_LOG_LEVEL)) continue;
            if (stringArray[i].equalsIgnoreCase(LINK_TYPE)) {
                if (stringArray[i + 1].equalsIgnoreCase(INET_LINK)) {
                    sQInitDataImp.setQueueType(3);
                    continue;
                }
                if (!stringArray[i + 1].equalsIgnoreCase(JAVA_LINK)) continue;
                sQInitDataImp.setQueueType(4);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(INET_PORT)) {
                try {
                    sQInitDataImp.setQueueInetPort(Integer.parseInt(stringArray[i + 1]));
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.oselistener.outofproc.OutOfProcEngine.parseCmdLine", (String)"192", (Object)this);
                    DebugSupport.logException("Error : " + stringArray[i + 1] + " is not a port number", throwable);
                }
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(QUEUE_NAME)) {
                sQInitDataImp.setQueueName(stringArray[i + 1]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(STUB_LIB)) {
                sQInitDataImp.setStubDLLFullPath(stringArray[i + 1]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(SERVER_LIB)) {
                sQInitDataImp.setNativeQueueDLLFullPath(stringArray[i + 1]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(LB_MODE)) {
                if (!stringArray[i + 1].equalsIgnoreCase(PUSH_MODE)) continue;
                sQInitDataImp.isPushLbMode(true);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(CLONE_INDEX)) {
                try {
                    sQInitDataImp.setCloneIndex(Integer.parseInt(stringArray[i + 1]));
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.oselistener.outofproc.OutOfProcEngine.parseCmdLine", (String)"209", (Object)this);
                    DebugSupport.logException("Error : " + stringArray[i + 1] + " is not a port number", throwable);
                }
                continue;
            }
            System.err.println("Error : no such command line option " + stringArray[i]);
        }
        return sQInitDataImp;
    }

    protected void doStartup(String[] stringArray) {
        try {
            Socket socket = new Socket("localhost", 8080);
            socket.close();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.oselistener.outofproc.OutOfProcEngine.doStartup", (String)"230", (Object)this);
        }
    }

    public void doShutdown() {
        if (null != this.serverEntry && null != this.serverEntry) {
            this.serverEntry.destroy();
        }
    }
}

