/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.oselistener.serverqueue;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.oselistener.api.IInetSQInitData;
import com.ibm.ws.webcontainer.oselistener.api.IOopNativeSQInitData;
import com.ibm.ws.webcontainer.oselistener.api.ISQEventSource;
import com.ibm.ws.webcontainer.oselistener.api.ISQInitData;
import com.ibm.ws.webcontainer.oselistener.api.IServerQueue;
import com.ibm.ws.webcontainer.oselistener.api.ISslSQInitData;
import com.ibm.ws.webcontainer.oselistener.outofproc.OutOfProcThread;
import com.ibm.ws.webcontainer.oselistener.outofproc.OutQueueData;
import com.ibm.ws.webcontainer.oselistener.outofproc.ServerQueueException;
import com.ibm.ws.webcontainer.oselistener.outofproc.ServerQueueFactory;
import com.ibm.ws.webcontainer.oselistener.serverqueue.InProcSQEventSource;
import com.ibm.ws.webcontainer.oselistener.serverqueue.JSQWrapperEventSource;
import com.ibm.ws.webcontainer.oselistener.serverqueue.NSQWrapperEventSource;
import com.ibm.ws.webcontainer.oselistener.serverqueue.SQException;
import com.ibm.ws.webcontainer.oselistener.serverqueue.SQWrapperEventSource;

class SQFactoryImp {
    private static TraceComponent tc = Tr.register((String)(class$com$ibm$ws$webcontainer$oselistener$serverqueue$SQFactoryImp == null ? (class$com$ibm$ws$webcontainer$oselistener$serverqueue$SQFactoryImp = SQFactoryImp.class$("com.ibm.ws.webcontainer.oselistener.serverqueue.SQFactoryImp")) : class$com$ibm$ws$webcontainer$oselistener$serverqueue$SQFactoryImp).getName(), (String)"Servlet_Transport");
    int theQueueType;
    ISQEventSource theQueueImplementation;
    static /* synthetic */ Class class$com$ibm$ws$webcontainer$oselistener$serverqueue$SQFactoryImp;

    SQFactoryImp() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SQFactoryImp");
        }
        this.theQueueType = -1;
        this.theQueueImplementation = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SQFactoryImp");
        }
    }

    void checkParametes(ISQInitData iSQInitData) throws SQException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkParametes");
        }
        if (null == iSQInitData || null == iSQInitData.getQueueName()) {
            throw new SQException("null ISQInitData input.");
        }
        if (null != this.theQueueImplementation && this.theQueueType != iSQInitData.getQueueType()) {
            throw new SQException("Error, already constructed a queue of a different type.");
        }
        switch (iSQInitData.getQueueType()) {
            case 1: {
                break;
            }
            case 2: {
                if (iSQInitData instanceof IOopNativeSQInitData) break;
                throw new SQException("Wrong ISQInitData input, does not provides all the needed parameters.");
            }
            case 3: {
                if (iSQInitData instanceof IInetSQInitData && iSQInitData instanceof IOopNativeSQInitData) break;
                throw new SQException("Wrong ISQInitData input, does not provides all the needed parameters.");
            }
            case 4: {
                if (iSQInitData instanceof IInetSQInitData) break;
                throw new SQException("Wrong ISQInitData input, does not provides all the needed parameters.");
            }
            case 5: {
                if (iSQInitData instanceof ISslSQInitData && iSQInitData instanceof IInetSQInitData) break;
                throw new SQException("Wrong ISQInitData input, does not provides all the needed parameters.");
            }
            default: {
                throw new SQException("Error, wrong engine type.");
            }
        }
        this.checkLibrariesPresent(iSQInitData);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkParametes");
        }
    }

    void checkLibrariesPresent(ISQInitData iSQInitData) throws SQException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkLibrariesPresent");
        }
        if ((iSQInitData.getQueueType() == 1 || iSQInitData.getQueueType() == 2 || iSQInitData.getQueueType() == 3) && null == (string = iSQInitData.getStubDLLFullPath())) {
            throw new SQException("Error, missing stub dll.");
        }
        if ((iSQInitData.getQueueType() == 2 || iSQInitData.getQueueType() == 3) && null == (string = ((IOopNativeSQInitData)iSQInitData).getNativeQueueDLLFullPath())) {
            throw new SQException("Error, missing stub dll.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkLibrariesPresent");
        }
    }

    ISQEventSource createQueue(ISQInitData iSQInitData) throws SQException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createQueue");
        }
        if (null != this.theQueueImplementation) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createQueue");
            }
            return this.theQueueImplementation;
        }
        this.loadStubLibrary(iSQInitData);
        switch (iSQInitData.getQueueType()) {
            case 1: {
                return this.createINPROCqueue(iSQInitData);
            }
            case 2: {
                return this.createLOCALqueue(iSQInitData);
            }
            case 3: {
                return this.createINETqueue(iSQInitData);
            }
            case 4: {
                return this.createINETJAVAqueue(iSQInitData);
            }
            case 5: {
                return this.createSSLqueue(iSQInitData);
            }
        }
        throw new SQException("Error, wrong engine type.");
    }

    void loadStubLibrary(ISQInitData iSQInitData) throws SQException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadStubLibrary");
        }
        if (iSQInitData.getQueueType() == 1 || iSQInitData.getQueueType() == 2 || iSQInitData.getQueueType() == 3) {
            String string = iSQInitData.getStubDLLFullPath();
            try {
                System.load(string);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.oselistener.serverqueue.SQFactoryImp.loadStubLibrary", (String)"157", (Object)this);
                throw new SQException("Error, missing stub dll.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadStubLibrary");
        }
    }

    ISQEventSource createINPROCqueue(ISQInitData iSQInitData) throws SQException {
        InProcSQEventSource inProcSQEventSource;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createINPROCqueue");
        }
        if (null == (inProcSQEventSource = InProcSQEventSource.getEventSource())) {
            throw new SQException("Error, InProcSQEventSource was not created yet");
        }
        inProcSQEventSource.javaInit(iSQInitData);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createINPROCqueue");
        }
        return inProcSQEventSource;
    }

    ISQEventSource createLOCALqueue(ISQInitData iSQInitData) throws SQException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createLOCALqueue");
        }
        ISQEventSource iSQEventSource = null;
        IServerQueue iServerQueue = null;
        try {
            OutQueueData outQueueData = this.buildLOCALoutData(iSQInitData);
            try {
                iServerQueue = ServerQueueFactory.create(outQueueData);
            }
            catch (ServerQueueException serverQueueException) {
                FFDCFilter.processException((Throwable)serverQueueException, (String)"com.ibm.ws.webcontainer.oselistener.serverqueue.SQFactoryImp.createLOCALqueue", (String)"196", (Object)this);
                serverQueueException.printStackTrace();
                throw new SQException("Error, failed to generate new ServerQeueue Object.");
            }
            iSQEventSource = this.wrapServerQueueWithEventSource(iServerQueue, iSQInitData);
            this.theQueueType = iSQInitData.getQueueType();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createLOCALqueue");
            }
            ISQEventSource iSQEventSource2 = iSQEventSource;
            return iSQEventSource2;
        }
        catch (SQException sQException) {
            FFDCFilter.processException((Throwable)sQException, (String)"com.ibm.ws.webcontainer.oselistener.serverqueue.SQFactoryImp.createLOCALqueue", (String)"209", (Object)this);
            if (null != iServerQueue) {
                try {
                    iServerQueue.close();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.oselistener.serverqueue.SQFactoryImp.createLOCALqueue", (String)"214", (Object)this);
                }
            }
            throw sQException;
        }
        finally {
            this.theQueueImplementation = iSQEventSource;
        }
    }

    ISQEventSource createINETqueue(ISQInitData iSQInitData) throws SQException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createINETqueue");
        }
        ISQEventSource iSQEventSource = null;
        IServerQueue iServerQueue = null;
        try {
            OutQueueData outQueueData = this.buildINEToutData(iSQInitData);
            try {
                iServerQueue = ServerQueueFactory.create(outQueueData);
            }
            catch (ServerQueueException serverQueueException) {
                FFDCFilter.processException((Throwable)serverQueueException, (String)"com.ibm.ws.webcontainer.oselistener.serverqueue.SQFactoryImp.createINETqueue", (String)"236", (Object)this);
                serverQueueException.printStackTrace();
                throw new SQException("Error, failed to generate new ServerQeueue Object.");
            }
            iSQEventSource = this.wrapServerQueueWithEventSource(iServerQueue, iSQInitData);
            this.theQueueType = iSQInitData.getQueueType();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createINETqueue");
            }
            ISQEventSource iSQEventSource2 = iSQEventSource;
            return iSQEventSource2;
        }
        catch (SQException sQException) {
            FFDCFilter.processException((Throwable)sQException, (String)"com.ibm.ws.webcontainer.oselistener.serverqueue.SQFactoryImp.createINETqueue", (String)"249", (Object)this);
            if (null != iServerQueue) {
                try {
                    iServerQueue.close();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.oselistener.serverqueue.SQFactoryImp.createINETqueue", (String)"254", (Object)this);
                }
            }
            throw sQException;
        }
        finally {
            this.theQueueImplementation = iSQEventSource;
        }
    }

    ISQEventSource createINETJAVAqueue(ISQInitData iSQInitData) throws SQException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createINETJAVAqueue");
        }
        ISQEventSource iSQEventSource = null;
        IServerQueue iServerQueue = null;
        try {
            OutQueueData outQueueData = this.buildJINEToutData(iSQInitData);
            try {
                iServerQueue = ServerQueueFactory.create(outQueueData);
            }
            catch (ServerQueueException serverQueueException) {
                FFDCFilter.processException((Throwable)serverQueueException, (String)"com.ibm.ws.webcontainer.oselistener.serverqueue.SQFactoryImp.createINETJAVAqueue", (String)"277", (Object)this);
                serverQueueException.printStackTrace();
                throw new SQException("Error, failed to generate new ServerQeueue Object.");
            }
            iSQEventSource = this.wrapServerQueueWithEventSource(iServerQueue, iSQInitData);
            this.theQueueType = iSQInitData.getQueueType();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createINETJAVAqueue");
            }
            ISQEventSource iSQEventSource2 = iSQEventSource;
            return iSQEventSource2;
        }
        catch (SQException sQException) {
            FFDCFilter.processException((Throwable)sQException, (String)"com.ibm.ws.webcontainer.oselistener.serverqueue.SQFactoryImp.createINETJAVAqueue", (String)"290", (Object)this);
            if (null != iServerQueue) {
                try {
                    iServerQueue.close();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.oselistener.serverqueue.SQFactoryImp.createINETJAVAqueue", (String)"295", (Object)this);
                }
            }
            throw sQException;
        }
        finally {
            this.theQueueImplementation = iSQEventSource;
        }
    }

    ISQEventSource createSSLqueue(ISQInitData iSQInitData) throws SQException {
        throw new SQException("SSL queue is not implemented yet.");
    }

    OutQueueData buildLOCALoutData(ISQInitData iSQInitData) throws SQException {
        OutQueueData outQueueData = new OutQueueData();
        if (iSQInitData.isPushLbMode()) {
            if (iSQInitData.getCloneIndex() <= 0) {
                throw new SQException("Error, wrong input, clone index must be bigger then 0.");
            }
            outQueueData.m_name = iSQInitData.getQueueName() + iSQInitData.getCloneIndex();
        } else {
            outQueueData.m_name = iSQInitData.getQueueName();
        }
        outQueueData.m_type = 0;
        outQueueData.m_port = 8081;
        outQueueData.m_serverLib = ((IOopNativeSQInitData)iSQInitData).getNativeQueueDLLFullPath();
        outQueueData.m_stubLib = iSQInitData.getStubDLLFullPath();
        outQueueData.m_bootFile = null;
        outQueueData.m_logFile = ((IOopNativeSQInitData)iSQInitData).getNativeQueueLogFile();
        outQueueData.m_logMask = ((IOopNativeSQInitData)iSQInitData).getNativeQueueLogMask();
        return outQueueData;
    }

    OutQueueData buildINEToutData(ISQInitData iSQInitData) throws SQException {
        OutQueueData outQueueData = new OutQueueData();
        outQueueData.m_name = iSQInitData.getQueueName();
        outQueueData.m_type = 1;
        outQueueData.m_port = ((IInetSQInitData)((Object)iSQInitData)).getQueueInetPort();
        outQueueData.m_serverLib = ((IOopNativeSQInitData)iSQInitData).getNativeQueueDLLFullPath();
        outQueueData.m_stubLib = iSQInitData.getStubDLLFullPath();
        outQueueData.m_bootFile = null;
        outQueueData.m_logFile = ((IOopNativeSQInitData)iSQInitData).getNativeQueueLogFile();
        outQueueData.m_logMask = ((IOopNativeSQInitData)iSQInitData).getNativeQueueLogMask();
        return outQueueData;
    }

    OutQueueData buildJINEToutData(ISQInitData iSQInitData) throws SQException {
        OutQueueData outQueueData = new OutQueueData();
        outQueueData.m_name = iSQInitData.getQueueName();
        outQueueData.m_type = 2;
        outQueueData.m_port = ((IInetSQInitData)((Object)iSQInitData)).getQueueInetPort();
        outQueueData.m_bootFile = null;
        outQueueData.m_logFile = ((IOopNativeSQInitData)iSQInitData).getNativeQueueLogFile();
        outQueueData.m_logMask = ((IOopNativeSQInitData)iSQInitData).getNativeQueueLogMask();
        return outQueueData;
    }

    ISQEventSource wrapServerQueueWithEventSource(IServerQueue iServerQueue, ISQInitData iSQInitData) throws SQException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"wrapServerQueueWithEventSource");
        }
        SQWrapperEventSource sQWrapperEventSource = null;
        if (iSQInitData.getQueueType() == 2 || iSQInitData.getQueueType() == 3) {
            sQWrapperEventSource = new NSQWrapperEventSource(iServerQueue, iSQInitData, OutOfProcThread.getRunneableThreadPool());
        } else if (iSQInitData.getQueueType() == 4) {
            sQWrapperEventSource = new JSQWrapperEventSource(iServerQueue, iSQInitData, OutOfProcThread.getRunneableThreadPool());
        } else {
            throw new SQException("Error, no Event source implementation found for this type of queue.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"wrapServerQueueWithEventSource");
        }
        return sQWrapperEventSource;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

