/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.servlet.ResponseBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Observer;
import javax.servlet.ServletOutputStream;

public class BufferedServletOutputStream
extends ServletOutputStream
implements ResponseBuffer {
    protected OutputStream out;
    protected byte[] buf = new byte[0];
    protected int count;
    protected int total;
    protected int limit;
    protected int length = -1;
    protected Observer obs;
    protected IOException except;
    protected boolean committed;
    protected int countedLength = 0;
    private int bufferSize;
    private static TraceComponent tc = Tr.register((String)(class$com$ibm$ws$webcontainer$servlet$BufferedServletOutputStream == null ? (class$com$ibm$ws$webcontainer$servlet$BufferedServletOutputStream = BufferedServletOutputStream.class$("com.ibm.ws.webcontainer.servlet.BufferedServletOutputStream")) : class$com$ibm$ws$webcontainer$servlet$BufferedServletOutputStream).getName(), (String)"Servlet_Engine");
    private boolean closeOnClose = false;
    private static NLS nls = new NLS("com.ibm.servlet.resources.ServletEngineNLS");
    static /* synthetic */ Class class$com$ibm$ws$webcontainer$servlet$BufferedServletOutputStream;

    public BufferedServletOutputStream(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"Constructor", (Object)String.valueOf(n));
        }
        this.buf = new byte[n];
        this.bufferSize = n;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"Constructor");
        }
    }

    public BufferedServletOutputStream() {
        this(1024);
    }

    public void init(OutputStream outputStream, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init", (Object)outputStream);
        }
        this.initNewBuffer(outputStream, n);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    void initNewBuffer(OutputStream outputStream, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initNewBuffer", (Object)new Object[]{outputStream, new Integer(n)});
        }
        this.out = outputStream;
        if (n != this.buf.length) {
            this.bufferSize = n;
            this.buf = new byte[this.bufferSize];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initNewBuffer");
        }
    }

    public void finish() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"finish");
        }
        if (this.length == -1 && this.countedLength != 0) {
            this.length = this.countedLength;
        }
        this.flush();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"finish");
        }
    }

    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reset");
        }
        this.out = null;
        this.obs = null;
        this.count = 0;
        this.total = 0;
        this.limit = -1;
        this.length = -1;
        this.committed = false;
        this.countedLength = 0;
        this.except = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reset");
        }
    }

    public int getTotal() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTotal");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getTotal: " + this.total));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTotal");
        }
        return this.total;
    }

    public void setObserver(Observer observer) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setObserver", (Object)observer);
        }
        this.obs = observer;
        this.limit = -1;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setObserver");
        }
    }

    public boolean isCommitted() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isCommitted");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isCommitted: " + this.committed));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isCommitted");
        }
        return this.committed;
    }

    protected void check(int n) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"check", (Object)String.valueOf(n));
        }
        if (this.except != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"check");
            }
            throw this.except;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"check");
        }
    }

    public void write(int n) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"write", (Object)new Integer(n));
        }
        if (this.total >= this.limit) {
            this.check(1);
        }
        if (this.count == this.buf.length) {
            this.flushBytes();
        }
        this.buf[this.count++] = (byte)n;
        ++this.total;
        ++this.countedLength;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"write");
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"write", (Object)new Object[]{this.buf, new Integer(n), new Integer(n2)});
        }
        if (n2 < 0) {
            Tr.error((TraceComponent)tc, (String)"Illegal Argument: Trying to write < 0 bytes");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"write");
            }
            throw new IllegalArgumentException();
        }
        if (this.total + n2 > this.limit) {
            this.check(n2);
        }
        if (n2 >= this.buf.length) {
            this.flushBytes();
            this.total += n2;
            this.writeOut(byArray, n, n2);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"write");
            }
            return;
        }
        int n3 = this.buf.length - this.count;
        if (n2 > n3) {
            this.flushBytes();
        }
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count += n2;
        this.total += n2;
        this.countedLength += n2;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"write");
        }
    }

    public void flush() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"flush");
        }
        if (this.limit < 0) {
            this.check(0);
        }
        this.flushBytes();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"flush");
        }
    }

    protected void flushBytes() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"flushBytes");
        }
        if (!this.committed && this.obs != null) {
            this.obs.update(null, this);
        }
        this.committed = true;
        if (this.count > 0) {
            this.writeOut(this.buf, 0, this.count);
            this.out.flush();
            this.count = 0;
        } else if (this.count == 0 && this.out != null) {
            this.out.flush();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"flushBytes");
        }
    }

    public void print(String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"print", (Object)string);
        }
        if (string != null) {
            int n = string.length();
            if (this.total + n > this.limit) {
                this.check(n);
            }
            int n2 = 0;
            while (n > 0) {
                int n3 = this.buf.length - this.count;
                if (n3 == 0) {
                    this.flushBytes();
                    n3 = this.buf.length - this.count;
                }
                if (n3 > n) {
                    n3 = n;
                }
                string.getBytes(n2, n2 + n3, this.buf, this.count);
                this.count += n3;
                this.total += n3;
                n2 += n3;
                n -= n3;
                this.countedLength += n3;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"print");
        }
    }

    public void close() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"close");
        }
        this.finish();
        try {
            this.out.close();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.servlet.BufferedServletOutputStream.close", (String)"392", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"close");
        }
    }

    protected void writeOut(byte[] byArray, int n, int n2) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeOut", (Object)new Object[]{byArray, new Integer(n), new Integer(n2)});
        }
        this.out.write(byArray, n, n2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeOut");
        }
    }

    public int getBufferSize() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getBufferSize");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getBufferSize");
        }
        return this.bufferSize;
    }

    public void setBufferSize(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setBufferSize", (Object)new Integer(n));
        }
        if (this.countedLength > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setBufferSize(): illegal state--> already wrote " + this.countedLength + " bytes"));
            }
            throw new IllegalStateException(nls.getString("Cannot.set.buffer.size.after.data", "Can't set buffer size after data has been written to stream"));
        }
        this.initNewBuffer(this.out, n);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setBufferSize");
        }
    }

    public void clearBuffer() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"clearBuffer");
        }
        if (this.isCommitted()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"clearBuffer(): illegal state--> stream is committed ");
            }
            throw new IllegalStateException();
        }
        this.total = 0;
        this.countedLength = 0;
        this.count = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"clearBuffer");
        }
    }

    public void flushBuffer() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"flushBuffer");
        }
        this.flush();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"flushBuffer");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

