/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import sun.io.ByteToCharConverter;

public class RequestUtils {
    private static String SYSTEM_CLIENT_ENCODING;
    private static String SYSTEM_FILE_ENCODING;
    public static final String SYS_PROP_FILE_ENCODING = "file.encoding";
    public static final String SYS_PROP_DFLT_CLIENT_ENCODING = "default.client.encoding";
    private static NLS nls;
    public static final String ACCEPT_CHARSET_HEADER = "Accept-Charset";
    public static final String ACCEPT_LANGUAGE_HEADER = "Accept-Language";
    public static final String DEFAULT_CLIENT_ENCODING = "iso-8859-1";
    public static final String HEADER_SEPARATOR = ",";
    public static final String LANG_CHINESE_S = "zh-cn";
    public static final String LANG_CHINESE = "zh";
    public static final String LANG_CHINESE_T = "zh-tw";
    public static final String LANG_EN = "en";
    public static final String LANG_KOREA = "ko";
    public static final String LANG_JAPAN1 = "ja";
    public static final String LANG_JAPAN2 = "jp";
    public static final String ENC_CHINESE_S = "Cp1381";
    public static final String ENC_CHINESE_T = "Cp950";
    public static final String ENC_ENGLISH = "iso-8859-1";
    public static final String ENC_KOREA = "KSC5601";
    public static final String ENC_JAPAN = "Shift_JIS";
    private static final String SHORT_ASCII = "8859";
    private static final String SHORT_ENGLISH = "8859_1";
    private static final String ACCEPT_ALL_VAL = "*";
    private static final String CP1047_ENCODING = "Cp1047";
    private static final String ISO8859_1_ENCODING = "8859_1";
    private static final String CP939_ENCODING = "Cp939";
    private static final String SJIS_ENCODING = "SJIS";

    public static String getClientEncoding(HttpServletRequest httpServletRequest) {
        StringTokenizer stringTokenizer;
        String string = null;
        if (SYSTEM_CLIENT_ENCODING != null) {
            string = SYSTEM_CLIENT_ENCODING;
            return string;
        }
        String string2 = httpServletRequest.getHeader(ACCEPT_CHARSET_HEADER);
        if (string2 != null && (string = (stringTokenizer = new StringTokenizer(string2, HEADER_SEPARATOR)).nextToken().trim()).equals(ACCEPT_ALL_VAL)) {
            string = "iso-8859-1";
        }
        if (string2 == null || string2.indexOf(SHORT_ASCII) != -1) {
            string = RequestUtils.getLanguage(httpServletRequest);
            return string;
        }
        try {
            ByteToCharConverter.getConverter((String)string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.servlet.RequestUtils.getClientEncoding", (String)"112");
            string = RequestUtils.getLanguage(httpServletRequest);
            return string;
        }
        return string;
    }

    public static String getEncodingFromLanguage(String string) {
        if (string.startsWith(LANG_EN)) {
            return "iso-8859-1";
        }
        if (string.equals(LANG_JAPAN1) || string.equals(LANG_JAPAN2)) {
            return ENC_JAPAN;
        }
        if (string.equals(LANG_CHINESE_T)) {
            return ENC_CHINESE_T;
        }
        if (string.equals(LANG_KOREA)) {
            return ENC_KOREA;
        }
        if (string.equals(LANG_CHINESE_S) || string.equals(LANG_CHINESE)) {
            return ENC_CHINESE_S;
        }
        return "iso-8859-1";
    }

    public static String getLanguage(HttpServletRequest httpServletRequest) {
        String string = null;
        String string2 = httpServletRequest.getHeader(ACCEPT_LANGUAGE_HEADER);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, HEADER_SEPARATOR);
            String string3 = stringTokenizer.nextToken().trim().toLowerCase();
            string = RequestUtils.getEncodingFromLanguage(string3);
        } else {
            string = SYSTEM_FILE_ENCODING != null ? (SYSTEM_FILE_ENCODING.equals(CP1047_ENCODING) ? "8859_1" : (SYSTEM_FILE_ENCODING.equals(CP939_ENCODING) ? SJIS_ENCODING : "iso-8859-1")) : "iso-8859-1";
        }
        try {
            ByteToCharConverter.getConverter((String)string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.servlet.RequestUtils.getLanguage", (String)"196");
            string = SYSTEM_FILE_ENCODING == null ? "iso-8859-1" : SYSTEM_FILE_ENCODING;
        }
        return string;
    }

    public static Hashtable parseQueryString(String string) {
        return RequestUtils.parseQueryString(string, "8859_1");
    }

    public static Hashtable parseQueryString(String string, String string2) {
        String[] stringArray;
        String string3;
        String string4;
        String[] stringArray2 = null;
        if (string == null) {
            throw new IllegalArgumentException("query string or post data is null");
        }
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        boolean bl = true;
        if (string2.indexOf("8859_1") == -1 & string2.indexOf("8859-1") == -1) {
            bl = false;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            if (cArray[n3] != '&') continue;
            for (n5 = n2; n5 < n3 && cArray[n5] != '='; ++n5) {
            }
            if (n5 < n3) {
                string4 = RequestUtils.parseName(cArray, n2, n5);
                string3 = RequestUtils.parseName(cArray, n5 + 1, n3);
                if (!bl) {
                    try {
                        string4 = new String(string4.getBytes("8859_1"), string2);
                        string3 = new String(string3.getBytes("8859_1"), string2);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        unsupportedEncodingException.printStackTrace();
                        throw new IllegalArgumentException();
                    }
                }
                if (hashtable.containsKey(string4)) {
                    stringArray = (String[])hashtable.get(string4);
                    stringArray2 = new String[stringArray.length + 1];
                    for (n4 = 0; n4 < stringArray.length; ++n4) {
                        stringArray2[n4] = stringArray[n4];
                    }
                    stringArray2[stringArray.length] = string3;
                } else {
                    stringArray2 = new String[]{string3};
                }
                hashtable.put(string4, stringArray2);
            }
            n2 = n3 + 1;
        }
        for (n5 = n2; n5 < n3 && cArray[n5] != '='; ++n5) {
        }
        if (n5 < n3) {
            string4 = RequestUtils.parseName(cArray, n2, n5);
            string3 = RequestUtils.parseName(cArray, n5 + 1, n3);
            if (!bl) {
                try {
                    string4 = new String(string4.getBytes("8859_1"), string2);
                    string3 = new String(string3.getBytes("8859_1"), string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                    throw new IllegalArgumentException();
                }
            }
            if (hashtable.containsKey(string4)) {
                stringArray = (String[])hashtable.get(string4);
                stringArray2 = new String[stringArray.length + 1];
                for (n4 = 0; n4 < stringArray.length; ++n4) {
                    stringArray2[n4] = stringArray[n4];
                }
                stringArray2[stringArray.length] = string3;
            } else {
                stringArray2 = new String[]{string3};
            }
            hashtable.put(string4, stringArray2);
        }
        return hashtable;
    }

    public static Hashtable lazyParseQueryString(String string) {
        String[] stringArray;
        String string2;
        String string3;
        String[] stringArray2 = null;
        if (string == null) {
            throw new IllegalArgumentException("query string or post data is null");
        }
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            if (cArray[n3] != '&') continue;
            for (n5 = n2; n5 < n3 && cArray[n5] != '='; ++n5) {
            }
            if (n5 < n3) {
                string3 = string.substring(n2, n5);
                string2 = string.substring(n5 + 1, n3);
                if (hashtable.containsKey(string3)) {
                    stringArray = (String[])hashtable.get(string3);
                    stringArray2 = new String[stringArray.length + 1];
                    for (n4 = 0; n4 < stringArray.length; ++n4) {
                        stringArray2[n4] = stringArray[n4];
                    }
                    stringArray2[stringArray.length] = string2;
                } else {
                    stringArray2 = new String[]{string2};
                }
                hashtable.put(string3, stringArray2);
            }
            n2 = n3 + 1;
        }
        for (n5 = n2; n5 < n3 && cArray[n5] != '='; ++n5) {
        }
        if (n5 < n3) {
            string3 = string.substring(n2, n5);
            string2 = string.substring(n5 + 1, n3);
            if (hashtable.containsKey(string3)) {
                stringArray = (String[])hashtable.get(string3);
                stringArray2 = new String[stringArray.length + 1];
                for (n4 = 0; n4 < stringArray.length; ++n4) {
                    stringArray2[n4] = stringArray[n4];
                }
                stringArray2[stringArray.length] = string2;
            } else {
                stringArray2 = new String[]{string2};
            }
            hashtable.put(string3, stringArray2);
        }
        return hashtable;
    }

    private static String parseName(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        int n5 = n2;
        char[] cArray2 = cArray;
        char[] cArray3 = new char[n5 - n4];
        block4: for (int i = n4; i < n5; ++i) {
            switch (cArray2[i]) {
                case '+': {
                    cArray3[n3++] = 32;
                    continue block4;
                }
                case '%': {
                    if (i + 2 < n5) {
                        int n6 = Character.digit(cArray2[++i], 16);
                        int n7 = Character.digit(cArray2[++i], 16);
                        if (n6 == -1 || n7 == -1) {
                            throw new IllegalArgumentException();
                        }
                        cArray3[n3++] = (char)(n6 << 4 | n7);
                        continue block4;
                    }
                    while (i < n5) {
                        cArray3[n3++] = cArray2[i];
                        ++i;
                    }
                    continue block4;
                }
                default: {
                    cArray3[n3++] = cArray2[i];
                }
            }
        }
        return new String(cArray3, 0, n3);
    }

    private static String parseName(String string, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        int n = string.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '+': {
                    stringBuffer.append(' ');
                    continue block7;
                }
                case '%': {
                    try {
                        stringBuffer.append((char)Integer.parseInt(string.substring(i + 1, i + 3), 16));
                        i += 2;
                        continue block7;
                    }
                    catch (NumberFormatException numberFormatException) {
                        FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.webcontainer.servlet.RequestUtils.parseName", (String)"337");
                        throw new IllegalArgumentException("Unable to parse query string name or value  [" + string + "] ");
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        FFDCFilter.processException((Throwable)stringIndexOutOfBoundsException, (String)"com.ibm.ws.webcontainer.servlet.RequestUtils.parseName", (String)"342");
                        String string2 = string.substring(i);
                        stringBuffer.append(string2);
                        if (string2.length() != 2) continue block7;
                        ++i;
                        continue block7;
                    }
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static Hashtable parsePostData(int n, ServletInputStream servletInputStream, String string) {
        String string2;
        byte[] byArray = null;
        if (n <= 0) {
            return null;
        }
        if (servletInputStream == null) {
            throw new IllegalArgumentException("post data inputstream is null");
        }
        try {
            int n2;
            byArray = new byte[n];
            int n3 = 0;
            do {
                if ((n2 = servletInputStream.read(byArray, n3, n - n3)) > 0) continue;
                String string3 = nls.getString("post.body.contains.less.bytes.than.specified", "post body contains less bytes than specified by content-length");
                throw new IOException(string3);
            } while (n - (n3 += n2) > 0);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.servlet.RequestUtils.parsePostData", (String)"398");
            return null;
        }
        try {
            string2 = new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.webcontainer.servlet.RequestUtils.parsePostData", (String)"411");
            string2 = new String(byArray);
        }
        return RequestUtils.parseQueryString(string2, string);
    }

    static {
        nls = new NLS("com.ibm.servlet.resources.ServletEngineNLS");
        SYSTEM_FILE_ENCODING = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(RequestUtils.SYS_PROP_FILE_ENCODING);
            }
        });
        SYSTEM_CLIENT_ENCODING = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(RequestUtils.SYS_PROP_DFLT_CLIENT_ENCODING);
            }
        });
    }
}

