/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.servlet.event.ServletErrorEvent;
import com.ibm.websphere.servlet.event.ServletEvent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.webcontainer.cache.CacheManager;
import com.ibm.ws.webcontainer.metadata.WebComponentMetaDataImpl;
import com.ibm.ws.webcontainer.servlet.ServletInstanceReference;
import com.ibm.ws.webcontainer.servlet.ServletReference;
import com.ibm.ws.webcontainer.servlet.ServletReferenceListener;
import com.ibm.ws.webcontainer.servlet.SingleThreadModelServlet;
import com.ibm.ws.webcontainer.servlet.StrictServletInstance;
import com.ibm.ws.webcontainer.webapp.WebAppEventSource;
import com.ibm.ws.webcontainer.webapp.WebAppServletInvocationEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletInstance
extends GenericServlet {
    StrictServletInstance _servletInstance;
    String _servletName;
    String _servletClassname;
    String _jspFile = null;
    ComponentMetaData _compMetaData;
    Vector _outstandingReferences = new Vector();
    WebAppEventSource _evtSource;
    private ServletEvent _event;
    private static TraceComponent tc = Tr.register((String)(class$com$ibm$ws$webcontainer$servlet$ServletInstance == null ? (class$com$ibm$ws$webcontainer$servlet$ServletInstance = ServletInstance.class$("com.ibm.ws.webcontainer.servlet.ServletInstance")) : class$com$ibm$ws$webcontainer$servlet$ServletInstance).getName(), (String)"Servlet_Engine");
    private static NLS nls = new NLS("com.ibm.servlet.resources.ServletEngineNLS");
    private long _unavailableUntil = -1L;
    private String _unavailableMessage;
    private boolean _permanentlyUnavailable = false;
    static int disableServletAuditLogging = -1;
    static /* synthetic */ Class class$com$ibm$ws$webcontainer$servlet$ServletInstance;

    public ServletInstance(String string, Servlet servlet, WebAppEventSource webAppEventSource, String string2) {
        this(string, servlet, webAppEventSource, (ComponentMetaData)null);
        this._jspFile = string2;
    }

    public ServletInstance(String string, Servlet servlet, WebAppEventSource webAppEventSource) {
        this(string, servlet, webAppEventSource, (ComponentMetaData)null);
    }

    public ServletInstance(String string, Servlet servlet, WebAppEventSource webAppEventSource, ComponentMetaData componentMetaData, String string2) {
        this(string, servlet, webAppEventSource, componentMetaData);
        this._jspFile = string2;
    }

    public ServletInstance(String string, Servlet object, WebAppEventSource webAppEventSource, ComponentMetaData componentMetaData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"constructor", (Object)new Object[]{string, object, webAppEventSource});
        }
        this._compMetaData = componentMetaData;
        if (object instanceof SingleThreadModel) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"servlet is single thread model {0}", (Object)string);
            }
            object = CacheManager.cacheEnabled ? CacheManager.getSingleThreadModelWrapper((Servlet)object) : new SingleThreadModelServlet(object.getClass());
        }
        this._servletName = string;
        this._servletInstance = new StrictServletInstance(string, (Servlet)object);
        this._servletClassname = object.getClass().getName();
        if (this._compMetaData != null) {
            ((WebComponentMetaDataImpl)this._compMetaData).setImplementationClass(this._servletClassname);
            ((WebComponentMetaDataImpl)this._compMetaData).setWebComponentVersion("Servlet 2.3");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("servlet class name = " + this._servletClassname));
        }
        this._evtSource = webAppEventSource;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"constructor");
        }
    }

    private void invalidateReferences() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"invalidateReferences");
        }
        Enumeration enumeration = this._outstandingReferences.elements();
        while (enumeration.hasMoreElements()) {
            ServletInstanceReference servletInstanceReference = (ServletInstanceReference)enumeration.nextElement();
            servletInstanceReference.invalidate();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invalidateReferences");
        }
    }

    public ComponentMetaData getComponentMetaData() {
        return this._compMetaData;
    }

    ServletReference getServletReference(ServletReferenceListener servletReferenceListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServletReference", (Object)servletReferenceListener);
        }
        ServletInstanceReference servletInstanceReference = new ServletInstanceReference(this);
        servletInstanceReference.addServletReferenceListener(servletReferenceListener);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("get servlet reference:" + this.getServletName()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServletReference");
        }
        return servletInstanceReference;
    }

    void releaseServletReference(ServletInstanceReference servletInstanceReference) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"releaseServletReference", (Object)servletInstanceReference);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("release servlet reference:" + this.getServletName()));
        }
        this._outstandingReferences.removeElement(servletInstanceReference);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"releaseServletReference");
        }
    }

    public void init() throws ServletException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init");
        }
        try {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Loading.servlet:.{0}", (Object)this.getServletName());
            }
            this._evtSource.onServletStartInit(this.getServletEvent());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"enter Servlet.init(): {0}", (Object)this.getServletName());
            }
            this._servletInstance.init(this.getServletConfig());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"exit Servlet.init(): {0}", (Object)this.getServletName());
            }
            this._evtSource.onServletFinishInit(this.getServletEvent());
            this.setAvailable();
        }
        catch (ServletException servletException) {
            FFDCFilter.processException((Throwable)servletException, (String)"com.ibm.ws.webcontainer.servlet.ServletInstance.init", (String)"172", (Object)((Object)this));
            Tr.error((TraceComponent)tc, (String)"Uncaught init() exception thrown by servlet {0}: {1}", (Object)new Object[]{this.getServletName(), servletException});
            ServletErrorEvent servletErrorEvent = new ServletErrorEvent((Object)this, this.getServletContext(), this.getServletName(), this.getServletClassName(), (Throwable)servletException);
            this._evtSource.onServletInitError(servletErrorEvent);
            this._evtSource.onServletFinishInit((ServletEvent)servletErrorEvent);
            this._evtSource.onServletUnloaded((ServletEvent)servletErrorEvent);
            throw servletException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.servlet.ServletInstance.init", (String)"181", (Object)((Object)this));
            Tr.error((TraceComponent)tc, (String)"Uncaught init() exception thrown by servlet {0}: {1}", (Object)new Object[]{this.getServletName(), throwable});
            ServletErrorEvent servletErrorEvent = new ServletErrorEvent((Object)this, this.getServletContext(), this.getServletName(), this.getServletClassName(), throwable);
            this._evtSource.onServletInitError(servletErrorEvent);
            this._evtSource.onServletFinishInit((ServletEvent)servletErrorEvent);
            this._evtSource.onServletUnloaded((ServletEvent)servletErrorEvent);
            throw new ServletException(nls.getString("Uncaught.initialization.exception.thrown.by.servlet", "Uncaught initialization exception thrown by servlet"), throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"service", (Object)new Object[]{servletRequest, servletResponse});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Servlet.service(): servlet classname = ", (Object)this.getServletClassName());
        }
        WebAppServletInvocationEvent webAppServletInvocationEvent = new WebAppServletInvocationEvent((Object)this, this.getServletContext(), this.getServletName(), this.getServletClassName(), (HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
        this.service(servletRequest, servletResponse, webAppServletInvocationEvent);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"service", (Object)new Object[]{servletRequest, servletResponse});
        }
    }

    void service(ServletRequest servletRequest, ServletResponse servletResponse, WebAppServletInvocationEvent webAppServletInvocationEvent) throws ServletException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"service", (Object)new Object[]{servletRequest, servletResponse, webAppServletInvocationEvent});
        }
        if (this._permanentlyUnavailable) {
            throw new UnavailableException((Servlet)this._servletInstance, this._unavailableMessage);
        }
        if (this._unavailableUntil != -1L) {
            long l = System.currentTimeMillis();
            long l2 = this._unavailableUntil - l;
            if (l2 <= 0L) {
                this.setAvailable();
            } else {
                int n = (int)l2 / 1000;
                if (n == 0) {
                    n = 1;
                }
                throw new UnavailableException(n, (Servlet)this._servletInstance, this._unavailableMessage);
            }
        }
        boolean bl = this._evtSource.hasServletInvocationListeners();
        try {
            if (bl && webAppServletInvocationEvent != null) {
                this._evtSource.onServletStartService(webAppServletInvocationEvent);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"enter Servlet.service(): {0}", (Object)this.getServletName());
            }
            long l = System.currentTimeMillis();
            this._servletInstance.service(servletRequest, servletResponse);
            long l3 = System.currentTimeMillis();
            if (bl && webAppServletInvocationEvent != null) {
                webAppServletInvocationEvent.setResponseTime(l3 - l);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"exit Servlet.service(): {0}", (Object)this.getServletName());
            }
            if (bl && webAppServletInvocationEvent != null) {
                this._evtSource.onServletFinishService(webAppServletInvocationEvent);
            }
        }
        catch (UnavailableException unavailableException) {
            FFDCFilter.processException((Throwable)unavailableException, (String)"com.ibm.ws.webcontainer.servlet.ServletInstance.service", (String)"259", (Object)((Object)this));
            this.handleUnavailableException(unavailableException);
            ServletErrorEvent servletErrorEvent = new ServletErrorEvent((Object)this, this.getServletContext(), this.getServletName(), this.getServletClassName(), (Throwable)unavailableException);
            this._evtSource.onServletServiceError(servletErrorEvent);
            this._evtSource.onServletFinishService(webAppServletInvocationEvent);
            throw unavailableException;
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.servlet.ServletInstance.service", (String)"266", (Object)((Object)this));
            ServletErrorEvent servletErrorEvent = new ServletErrorEvent((Object)this, this.getServletContext(), this.getServletName(), this.getServletClassName(), (Throwable)iOException);
            this._evtSource.onServletServiceError(servletErrorEvent);
            this._evtSource.onServletFinishService(webAppServletInvocationEvent);
            throw iOException;
        }
        catch (ServletException servletException) {
            FFDCFilter.processException((Throwable)servletException, (String)"com.ibm.ws.webcontainer.servlet.ServletInstance.service", (String)"276", (Object)((Object)this));
            ServletErrorEvent servletErrorEvent = new ServletErrorEvent((Object)this, this.getServletContext(), this.getServletName(), this.getServletClassName(), (Throwable)servletException);
            this._evtSource.onServletServiceError(servletErrorEvent);
            this._evtSource.onServletFinishService(webAppServletInvocationEvent);
            throw servletException;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            FFDCFilter.processException((Throwable)unsatisfiedLinkError, (String)"com.ibm.ws.webcontainer.servlet.ServletInstance.service", (String)"282", (Object)((Object)this));
            Tr.error((TraceComponent)tc, (String)"Place your servlet's class on classpath of the application server {0}: {1}", (Object)new Object[]{this.getServletName(), unsatisfiedLinkError});
            ServletErrorEvent servletErrorEvent = new ServletErrorEvent((Object)this, this.getServletContext(), this.getServletName(), this.getServletClassName(), (Throwable)unsatisfiedLinkError);
            this._evtSource.onServletServiceError(servletErrorEvent);
            this._evtSource.onServletFinishService(webAppServletInvocationEvent);
            throw new ServletException((Throwable)unsatisfiedLinkError);
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.webcontainer.servlet.ServletInstance.service", (String)"2821", (Object)((Object)this));
            ServletErrorEvent servletErrorEvent = new ServletErrorEvent((Object)this, this.getServletContext(), this.getServletName(), this.getServletClassName(), (Throwable)runtimeException);
            this._evtSource.onServletServiceError(servletErrorEvent);
            this._evtSource.onServletFinishService(webAppServletInvocationEvent);
            throw runtimeException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.servlet.ServletInstance.service", (String)"290", (Object)((Object)this));
            this._evtSource.onServletFinishService(webAppServletInvocationEvent);
            ServletErrorEvent servletErrorEvent = new ServletErrorEvent((Object)this, this.getServletContext(), this.getServletName(), this.getServletClassName(), throwable);
            this._evtSource.onServletServiceError(servletErrorEvent);
            throw new ServletException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"service");
        }
    }

    public void setAvailable() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setAvailable");
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Servlet.available.for.service:.{0}", (Object)this.getServletName());
        }
        this._evtSource.onServletAvailableForService(this.getServletEvent());
        this._unavailableMessage = null;
        this._unavailableUntil = -1L;
        this._permanentlyUnavailable = false;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setAvailable");
        }
    }

    public void setUnavailable() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setUnavailable");
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Servlet.has.become.permanently.unavailable.for.service:.{0}", (Object)this.getServletName());
        }
        this._permanentlyUnavailable = true;
        this._evtSource.onServletUnavailableForService(this.getServletEvent());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setUnavailable");
        }
    }

    public void setUnavailableUntil(long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setUnavailableUntil", (Object)new Long(l));
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Servlet.has.become.temporarily.unavailable.for.service:.{0}", (Object)this.getServletName());
        }
        this._permanentlyUnavailable = false;
        this._unavailableUntil = l;
        this._evtSource.onServletUnavailableForService(this.getServletEvent());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setUnavailableUntil");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy");
        }
        try {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Servlet.unload.initiated:.{0}", (Object)this.getServletName());
            }
            this.setUnavailable();
            this.invalidateReferences();
            this._evtSource.onServletStartDestroy(this.getServletEvent());
            for (int i = 0; !this._servletInstance.isIdle() && i < 60; ++i) {
                try {
                    if (i == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"servlet is still servicing...will wait up to 60 seconds for servlet to become idle: {0}", (Object)this.getServletName());
                        }
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Waiting.servlet.to.finish.servicing.requests:.{0}", (Object)this.getServletName());
                        }
                    }
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.webcontainer.servlet.ServletInstance.destroy", (String)"377", (Object)((Object)this));
                }
            }
            if (this._servletInstance.isIdle()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"enter Servlet.destroy(): {0}", (Object)this.getServletName());
                }
                this._servletInstance.destroy();
            } else {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Servlet.wait.for.destroy.timeout.has.expired,.destroy.will.be.forced:.{0}", (Object)this.getServletName());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"enter Servlet.destroy(): {0}", (Object)this.getServletName());
                }
                this._servletInstance.forceDestroy();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"exit Servlet.destroy(): {0}", (Object)this.getServletName());
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.servlet.ServletInstance.destroy", (String)"403", (Object)((Object)this));
            Tr.error((TraceComponent)tc, (String)"Uncaught destroy() exception thrown by servlet {0}: {1}", (Object)new Object[]{this.getServletName(), throwable});
            this._evtSource.onServletDestroyError(new ServletErrorEvent((Object)this, this.getServletContext(), this.getServletName(), this.getServletClassName(), throwable));
            this._servletInstance.getServletConfig().getServletContext().log("Error occurred while destroying servlet", throwable);
        }
        this._evtSource.onServletFinishDestroy(this.getServletEvent());
        this._evtSource.onServletUnloaded(this.getServletEvent());
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Servlet.unloaded:.{0}", (Object)this.getServletName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    public boolean isIdle() {
        return this._servletInstance.isIdle();
    }

    public String getServletName() {
        return this._servletName;
    }

    public boolean isJspType() {
        return this._jspFile != null;
    }

    public String getJspFileName() {
        return this._jspFile;
    }

    String getServletClassName() {
        return this._servletClassname;
    }

    private synchronized void handleUnavailableException(UnavailableException unavailableException) throws UnavailableException {
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleUnavailableException", (Object)((Object)unavailableException));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("UnavailableException was thrown by servlet: " + this.getServletName() + " reason:" + unavailableException.getMessage()));
        }
        if (this._permanentlyUnavailable) {
            throw new UnavailableException((Servlet)this._servletInstance, this._unavailableMessage);
        }
        if (unavailableException.isPermanent()) {
            this._unavailableMessage = unavailableException.getMessage();
            this.destroy();
        } else {
            long l;
            int n = unavailableException.getUnavailableSeconds();
            if (n > 0 && (l = System.currentTimeMillis() + (long)(n * 1000)) > this._unavailableUntil) {
                this._unavailableMessage = unavailableException.getMessage();
                this.setUnavailableUntil(l);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleUnavailableException");
        }
    }

    private ServletEvent getServletEvent() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServletEvent");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("servlet classname = " + this.getServletClassName()));
        }
        if (this._event == null) {
            this._event = new ServletEvent((Object)this, this.getServletContext(), this.getServletName(), this.getServletClassName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServletEvent");
        }
        return this._event;
    }

    public void info(String string, String string2) {
        if (ServletInstance.isDisableServletAuditLogging()) {
            Tr.debug((TraceComponent)tc, (String)string, (Object)string2);
        } else {
            Tr.uncondFormattedEvent((TraceComponent)tc, (String)string, (Object)string2);
        }
    }

    public void log(String string) {
    }

    public static boolean isDisableServletAuditLogging() {
        if (disableServletAuditLogging == -1) {
            String string = System.getProperty("com.ibm.servlet.engine.disableServletAuditLogging");
            disableServletAuditLogging = string != null && string.toLowerCase().equals("true") ? 1 : 0;
        }
        return disableServletAuditLogging == 1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

