/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.event.ServletErrorListener;
import com.ibm.websphere.servlet.event.ServletInvocationListener;
import com.ibm.websphere.servlet.event.ServletListener;
import com.ibm.ws.webcontainer.cache.CacheManager;
import com.ibm.ws.webcontainer.servlet.DefaultServletConfig;
import com.ibm.ws.webcontainer.servlet.ServletInstance;
import com.ibm.ws.webcontainer.servlet.ServletReference;
import com.ibm.ws.webcontainer.servlet.ServletReferenceListener;
import com.ibm.ws.webcontainer.servlet.exception.ServletNotFoundException;
import com.ibm.ws.webcontainer.webapp.WebAppEventSource;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class ServletManager {
    protected Hashtable _servlets = new Hashtable();
    private ServletContext _context;
    protected WebAppEventSource _evtSource = new WebAppEventSource();
    private static TraceComponent tc = Tr.register((String)(class$com$ibm$ws$webcontainer$servlet$ServletManager == null ? (class$com$ibm$ws$webcontainer$servlet$ServletManager = ServletManager.class$("com.ibm.ws.webcontainer.servlet.ServletManager")) : class$com$ibm$ws$webcontainer$servlet$ServletManager).getName(), (String)"Servlet_Engine");
    static /* synthetic */ Class class$com$ibm$ws$webcontainer$servlet$ServletManager;

    public ServletManager(ServletContext servletContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"constructor", (Object)servletContext);
        }
        this._context = servletContext;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"constructor");
        }
    }

    public ServletReference getServletReference(String string, ServletReferenceListener servletReferenceListener) throws ServletException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServletReference", (Object)new Object[]{string, servletReferenceListener});
        }
        ServletInstance servletInstance = this.getServlet(string);
        ServletReference servletReference = null;
        if (servletInstance == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getServletReference");
            }
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"unable to find servlet {0}", (Object)string);
            }
            throw new ServletNotFoundException(string);
        }
        servletReference = servletInstance.getServletReference(servletReferenceListener);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"found servlet {0}", (Object)string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServletReference");
        }
        return servletReference;
    }

    public synchronized void addServlet(String string, Servlet servlet, Properties properties) throws ServletException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addServlet", (Object)new Object[]{string, servlet, properties});
        }
        if (CacheManager.cacheEnabled) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("addServlet+" + string + ", cacheEnabled=" + CacheManager.cacheEnabled));
            }
            servlet = CacheManager.getProxiedServlet(servlet);
        }
        ServletInstance servletInstance = new ServletInstance(string, servlet, this._evtSource);
        servletInstance.init(this.getServletConfig(string, properties, this.getServletContext()));
        this._servlets.put(string, servletInstance);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addServlet");
        }
    }

    public synchronized void addJspServlet(String string, Servlet servlet, Properties properties, String string2) throws ServletException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addJspServlet", (Object)new Object[]{string, servlet, properties});
        }
        if (CacheManager.cacheEnabled) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("addJspServlet+" + string + ", cacheEnabled=" + CacheManager.cacheEnabled));
            }
            servlet = CacheManager.getProxiedServlet(servlet);
        }
        ServletInstance servletInstance = new ServletInstance(string, servlet, this._evtSource, string2);
        servletInstance.init(this.getServletConfig(string, properties, this.getServletContext()));
        this._servlets.put(string, servletInstance);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addServlet");
        }
    }

    public synchronized Enumeration getServletNames() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServletNames");
        }
        Enumeration enumeration = this._servlets.keys();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServletNames");
        }
        return enumeration;
    }

    public synchronized void removeServlet(String string) {
        ServletInstance servletInstance;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeServlet", (Object)string);
        }
        if ((servletInstance = this.getServlet(string)) != null) {
            this._servlets.remove(string);
            servletInstance.destroy();
        } else if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"servlet not found for removal {0}", (Object)string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeServlet");
        }
    }

    public synchronized void removeAllServlets() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeAllServlets");
        }
        Enumeration enumeration = this.getServletNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ServletInstance servletInstance = this.getServlet(string);
            this.removeServlet(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeAllServlets");
        }
    }

    public void addServletListener(ServletListener servletListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addServletListener", (Object)servletListener);
        }
        this._evtSource.addServletListener(servletListener);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addServletListener");
        }
    }

    public void removeServletListener(ServletListener servletListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeServletListener", (Object)servletListener);
        }
        this._evtSource.removeServletListener(servletListener);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeServletListener");
        }
    }

    public void addServletErrorListener(ServletErrorListener servletErrorListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addServletErrorListener", (Object)servletErrorListener);
        }
        this._evtSource.addServletErrorListener(servletErrorListener);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addServletErrorListener");
        }
    }

    public void removeServletErrorListener(ServletErrorListener servletErrorListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeServletErrorListener", (Object)servletErrorListener);
        }
        this._evtSource.removeServletErrorListener(servletErrorListener);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeServletErrorListener");
        }
    }

    public void addServletInvocationListener(ServletInvocationListener servletInvocationListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addServletInvocationListener", (Object)servletInvocationListener);
        }
        this._evtSource.addServletInvocationListener(servletInvocationListener);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addServletInvocationListener");
        }
    }

    public void removeServletInvocationListener(ServletInvocationListener servletInvocationListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeServletInvocationListener", (Object)servletInvocationListener);
        }
        this._evtSource.removeServletInvocationListener(servletInvocationListener);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeServletInvocationListener");
        }
    }

    protected ServletInstance getServlet(String string) {
        ServletInstance servletInstance;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServlet", (Object)string);
        }
        if ((servletInstance = (ServletInstance)((Object)this._servlets.get(string))) == null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"servlet instance not found: {0}", (Object)string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServlet");
        }
        return servletInstance;
    }

    protected ServletConfig getServletConfig(String string, Properties properties, ServletContext servletContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServletConfig", (Object)new Object[]{string, properties, servletContext});
        }
        DefaultServletConfig defaultServletConfig = new DefaultServletConfig(string, properties, servletContext);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServletConfig");
        }
        return defaultServletConfig;
    }

    public ServletContext getServletContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServletContext");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServletContext");
        }
        return this._context;
    }

    public boolean hasServlet(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"hasServlet", (Object)string);
        }
        boolean bl = this._servlets.containsKey(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("hasServlet - " + bl));
        }
        return bl;
    }

    public boolean isLoadedServlet(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isLoadedServlet", (Object)string);
        }
        boolean bl = this._servlets.containsKey(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isLoadedServlet - " + bl));
        }
        return bl;
    }

    public boolean areRequestsActive() {
        Iterator iterator = this._servlets.values().iterator();
        try {
            while (iterator.hasNext()) {
                ServletInstance servletInstance = (ServletInstance)((Object)iterator.next());
                if (servletInstance.isIdle()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"areRequestsActive: --return true");
                }
                return true;
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"areRequestsActive: ConcurrentModException --return true");
            }
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

