/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ExtendedDocumentRootUtils;
import com.ibm.ws.util.FileSystem;
import com.ibm.ws.webcontainer.webapp.WebApp;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SimpleFileServlet
extends HttpServlet {
    public static final String PARAM_DEFAULT_PAGE = "default.page";
    public static final String PARAM_BUFFER_SIZE = "bufferSize";
    public static final String WEB_INF_DIR = "WEB-INF";
    public static final String META_INF_DIR = "META-INF";
    private static NLS nls = new NLS("com.ibm.servlet.resources.ServletEngineNLS");
    private int defaultBufferSize = 4096;
    private String esiControl = null;
    String extendedDocumentRoot = null;
    private boolean redirectToWelcomeFile = false;

    public void init() throws ServletException {
        String string = this.getInitParameter(PARAM_BUFFER_SIZE);
        if (string != null) {
            try {
                int n;
                this.defaultBufferSize = n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.webcontainer.servlet.SimpleFileServlet.init", (String)"65", (Object)((Object)this));
            }
        }
        this.extendedDocumentRoot = this.getInitParameter("extendedDocumentRoot");
        String string2 = System.getProperties().getProperty("com.ibm.servlet.file.esi.timeOut", "300");
        if (!string2.equals("0")) {
            this.esiControl = "max-age=" + string2 + "," + "cacheid=\"URL\"";
        }
        this.esiControl = System.getProperties().getProperty("com.ibm.servlet.file.esi.control", this.esiControl);
        String string3 = this.getInitParameter("redirectToWelcomeFile");
        if (string3 != null) {
            this.redirectToWelcomeFile = string3.equalsIgnoreCase("true");
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            Object object;
            Object object2;
            File file;
            boolean bl = false;
            ServletContext servletContext = this.getServletContext();
            String string = null;
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = null;
            String string3 = null;
            if (httpServletRequest.getAttribute("javax.servlet.include.request_uri") != null) {
                bl = true;
                string2 = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
                string3 = (String)httpServletRequest.getAttribute("javax.servlet.include.path_info");
            } else {
                string2 = httpServletRequest.getServletPath();
                string3 = httpServletRequest.getPathInfo();
            }
            stringBuffer.append(string2);
            if (string3 != null) {
                stringBuffer.append(string3);
                if (string3.indexOf(WEB_INF_DIR) == 0 || string3.indexOf(META_INF_DIR) == 0) {
                    httpServletResponse.sendError(403, MessageFormat.format(nls.getString("File.not.found", "File not found: {0}"), stringBuffer.toString()));
                    return;
                }
            }
            if (!(string = servletContext.getRealPath(stringBuffer.toString())).endsWith(File.separator)) {
                string = string + File.separator;
            }
            if (!(file = new File(string)).exists()) {
                ExtendedDocumentRootUtils extendedDocumentRootUtils = new ExtendedDocumentRootUtils(this.getServletContext(), this.extendedDocumentRoot);
                if (!extendedDocumentRootUtils.searchPathExists()) {
                    throw new FileNotFoundException(file.getAbsolutePath());
                }
                extendedDocumentRootUtils.handleExtendedDocumentRoots(stringBuffer.toString());
                boolean bl2 = true;
                if (!bl) {
                    bl2 = this.setResponseHeaders(httpServletRequest, httpServletResponse, extendedDocumentRootUtils.getMatchedFile(), extendedDocumentRootUtils.useContentLength());
                }
                if (bl2) {
                    this.writeResponseToClient(httpServletResponse, extendedDocumentRootUtils.getInputStream());
                }
                return;
            }
            if (file.isDirectory()) {
                Object object3;
                String string4 = this.getURLWithRequestURIEncoded(httpServletRequest).toString();
                if (!string4.endsWith("/") && !bl) {
                    String string5 = string4 + "/";
                    String string6 = httpServletRequest.getQueryString();
                    if (string6 != null) {
                        string5 = string5 + "?" + string6;
                    }
                    httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(string5));
                    return;
                }
                Vector vector = ((WebApp)servletContext).getWelcomeFileList();
                if (vector != null && vector.size() != 0) {
                    object3 = vector.elements();
                    String string7 = null;
                    File file2 = null;
                    while (object3.hasMoreElements()) {
                        string7 = (String)object3.nextElement();
                        if (string7.charAt(0) == '/') {
                            string7 = string7.substring(1);
                        }
                        if (!(file2 = new File(string + string7)).exists()) continue;
                        if (this.redirectToWelcomeFile) {
                            String string8;
                            String string9 = "";
                            if (httpServletRequest.getQueryString() != null) {
                                string9 = "?" + httpServletRequest.getQueryString();
                            }
                            if ((string8 = this.removeLeadingSlashes(stringBuffer.toString())) == null) {
                                string8 = "";
                            }
                            httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(string8 + string7 + string9));
                        } else {
                            servletContext.getRequestDispatcher(stringBuffer.toString() + string7).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                        }
                        return;
                    }
                }
                if ((object3 = servletContext.getNamedDispatcher("DirectoryBrowsingServlet")) != null) {
                    httpServletRequest.setAttribute("com.ibm.servlet.engine.webapp.dir.browsing.path", (Object)string);
                    httpServletRequest.setAttribute("com.ibm.servlet.engine.webapp.dir.browsing.uri", (Object)httpServletRequest.getRequestURI());
                    object3.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                    return;
                }
                httpServletResponse.sendError(404, nls.getString("File.not.found", "File not found"));
                return;
            }
            String string10 = stringBuffer.toString();
            if (stringBuffer.charAt(stringBuffer.length() - 1) == '/') {
                object2 = string10.substring(string10.lastIndexOf(46) + 1);
                object2 = ((String)object2).substring(0, ((String)object2).indexOf(47)).toLowerCase();
                object = new StringBuffer();
                for (int i = 0; i < ((String)object2).length() && ((String)object2).charAt(i) > ' '; ++i) {
                    ((StringBuffer)object).append(((String)object2).charAt(i));
                }
                object2 = ((StringBuffer)object).toString();
                if (((String)object2).equals("jsp") || ((String)object2).equals("jsv") || ((String)object2).equals("jsw")) {
                    httpServletResponse.sendError(403, nls.getString("Serving.JSP.Not.Allowed", "Serving contents of JSP files is not allowed."));
                    return;
                }
            }
            if (string10.lastIndexOf("..") != -1 && !string10.startsWith("/...") || string10.endsWith("\\") || httpServletRequest.getRequestURI().endsWith(".")) {
                httpServletResponse.sendError(403, MessageFormat.format(nls.getString("File.not.found", "File not found: {0}"), httpServletRequest.getPathInfo()));
                return;
            }
            if (FileSystem.isCaseInsensitive && !FileSystem.uriCaseCheck((File)(object2 = new File(string)), (String)stringBuffer.toString())) {
                throw new FileNotFoundException(stringBuffer.toString());
            }
            boolean bl3 = true;
            if (!bl) {
                bl3 = this.setResponseHeaders(httpServletRequest, httpServletResponse, file, true);
            }
            if (bl3) {
                object = new FileInputStream(file);
                this.writeResponseToClient(httpServletResponse, (InputStream)object);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException((Throwable)fileNotFoundException, (String)"com.ibm.ws.webcontainer.servlet.SimpleFileServlet.doGet", (String)"312", (Object)((Object)this));
            httpServletResponse.sendError(404, MessageFormat.format(nls.getString("File.not.found", "File not found: {0}"), httpServletRequest.getPathInfo()));
        }
    }

    private boolean setResponseHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, File file, boolean bl) {
        httpServletResponse.setDateHeader("Date", System.currentTimeMillis());
        String string = httpServletRequest.getRequestURI();
        String string2 = this.getServletContext().getMimeType(string);
        if (string2 != null) {
            httpServletResponse.setContentType(string2);
        } else if (string.endsWith(".html") || string.endsWith(".htm")) {
            httpServletResponse.setContentType("text/html");
        } else {
            httpServletResponse.setContentType("text/plain");
        }
        if (this.esiControl != null && httpServletRequest.getHeader("Surrogate-Capability") != null && httpServletRequest.getAttribute("com.ibm.servlet.engine.webapp.dispatch_nested") == null && !httpServletResponse.containsHeader("Surrogate-Control") && httpServletRequest.getAuthType() == null) {
            httpServletResponse.addHeader("Surrogate-Control", this.esiControl);
        }
        long l = -1L;
        try {
            l = httpServletRequest.getDateHeader("If-Modified-Since") / 1000L;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            l = -1L;
        }
        long l2 = file.lastModified();
        httpServletResponse.setDateHeader("last-modified", l2);
        if (l == l2 / 1000L) {
            httpServletResponse.setStatus(304);
            return false;
        }
        if (bl) {
            httpServletResponse.setContentLength(new Long(file.length()).intValue());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponseToClient(HttpServletResponse httpServletResponse, InputStream inputStream) throws ServletException, IOException {
        try {
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            byte[] byArray = new byte[this.defaultBufferSize];
            int n = inputStream.read(byArray);
            while (n != -1) {
                servletOutputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.webcontainer.servlet.SimpleFileServlet.writeResponseToClient", (String)"282", (Object)((Object)this));
            PrintWriter printWriter = httpServletResponse.getWriter();
            char[] cArray = new char[this.defaultBufferSize];
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            int n = inputStreamReader.read(cArray);
            try {
                while (n != -1) {
                    printWriter.write(cArray, 0, n);
                    n = inputStreamReader.read(cArray);
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.servlet.SimpleFileServlet.writeResponseToClient", (String)"298", (Object)((Object)this));
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.servlet.SimpleFileServlet.writeResponseToClient", (String)"304", (Object)((Object)this));
        }
        finally {
            inputStream.close();
        }
    }

    public String removeLeadingSlashes(String string) {
        String string2 = null;
        int n = 0;
        boolean bl = false;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        while (!bl && n < n2) {
            if (string.charAt(n) == '/') {
                ++n;
                continue;
            }
            bl = true;
        }
        if (bl) {
            string2 = string.substring(n);
        }
        return string2;
    }

    private StringBuffer getURLWithRequestURIEncoded(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = httpServletRequest.getScheme();
        int n = httpServletRequest.getServerPort();
        String string2 = null;
        try {
            string2 = new String(httpServletRequest.getRequestURI().getBytes("utf-8"), "iso-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = httpServletRequest.getRequestURI();
        }
        stringBuffer.append(string);
        stringBuffer.append("://");
        stringBuffer.append(httpServletRequest.getServerName());
        if (string.equals("http") && n != 80 || string.equals("https") && n != 443) {
            stringBuffer.append(':');
            stringBuffer.append(httpServletRequest.getServerPort());
        }
        stringBuffer.append(string2);
        return stringBuffer;
    }
}

