/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.servlet.AvailableForServiceState;
import com.ibm.ws.webcontainer.servlet.DestroyedServletState;
import com.ibm.ws.webcontainer.servlet.DestroyingServletState;
import com.ibm.ws.webcontainer.servlet.ErrorServletState;
import com.ibm.ws.webcontainer.servlet.IdleServletState;
import com.ibm.ws.webcontainer.servlet.InitializingServletState;
import com.ibm.ws.webcontainer.servlet.PermanentlyUnavailableForServiceState;
import com.ibm.ws.webcontainer.servlet.PreInitializedServletState;
import com.ibm.ws.webcontainer.servlet.STMServicingServletState;
import com.ibm.ws.webcontainer.servlet.ServicingServletState;
import com.ibm.ws.webcontainer.servlet.ServletServicingState;
import com.ibm.ws.webcontainer.servlet.ServletState;
import com.ibm.ws.webcontainer.servlet.UnavailableForServiceState;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;

public abstract class StrictLifecycleServlet
implements Servlet {
    static final ServletState PRE_INITIALIZED_STATE = PreInitializedServletState.instance();
    static final ServletState INITIALIZING_STATE = InitializingServletState.instance();
    static final ServletState IDLE_STATE = IdleServletState.instance();
    static final ServletState SERVICING_STATE = ServicingServletState.instance();
    static final ServletState STM_SERVICING_STATE = STMServicingServletState.instance();
    static final ServletState DESTROYING_STATE = DestroyingServletState.instance();
    static final ServletState DESTROYED_STATE = DestroyedServletState.instance();
    static final ServletState ERROR_STATE = ErrorServletState.instance();
    static final ServletServicingState AVAILABLE_FOR_SERVICE_STATE = AvailableForServiceState.instance();
    static final ServletServicingState UNAVAILABLE_FOR_SERVICE_STATE = UnavailableForServiceState.instance();
    static final ServletServicingState PERMANENTLY_UNAVAILABLE_FOR_SERVICE_STATE = PermanentlyUnavailableForServiceState.instance();
    private ServletState _state = PRE_INITIALIZED_STATE;
    private ServletServicingState _servicingState = AVAILABLE_FOR_SERVICE_STATE;
    private long _unavailableUntil = -1L;
    private ServletConfig _config;
    private boolean _implementsSTM;
    private int servicingCount = 0;
    private Object syncObject = new Object();

    protected StrictLifecycleServlet() {
        this._implementsSTM = this instanceof SingleThreadModel;
    }

    protected void doInit() throws ServletException {
    }

    protected void doService(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
    }

    protected void doDestroy() {
    }

    public final synchronized void init(ServletConfig servletConfig) throws ServletException {
        this._state.init(this, servletConfig);
    }

    public final void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        this._state.service(this, servletRequest, servletResponse);
    }

    public final synchronized void destroy() {
        this._state.destroy(this);
    }

    public ServletContext getServletContext() {
        return this.getServletConfig().getServletContext();
    }

    public ServletConfig getServletConfig() {
        return this._config;
    }

    public String getServletInfo() {
        return this.getClass().getName();
    }

    synchronized void setState(ServletState servletState) {
        this._state = servletState;
    }

    synchronized void setServicingState(ServletServicingState servletServicingState) {
        this._servicingState = servletServicingState;
    }

    void _init(ServletConfig servletConfig) throws ServletException {
        try {
            this.setState(INITIALIZING_STATE);
            this._config = servletConfig;
            this.doInit();
            this.setState(IDLE_STATE);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.servlet.StrictLifecycleServlet._init", (String)"150", (Object)this);
            this.setState(ERROR_STATE);
            if (throwable instanceof ServletException) {
                throw (ServletException)throwable;
            }
            throw new ServletException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void _service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        IOException iOException;
        Object object;
        block28: {
            if (this._implementsSTM) {
                this.setState(STM_SERVICING_STATE);
            } else {
                this.setState(SERVICING_STATE);
            }
            object = this.syncObject;
            // MONITORENTER : object
            ++this.servicingCount;
            // MONITOREXIT : object
            object = null;
            iOException = null;
            try {
                try {
                    this._servicingState.service(this, servletRequest, servletResponse);
                    this.doService(servletRequest, servletResponse);
                }
                catch (UnavailableException unavailableException) {
                    FFDCFilter.processException((Throwable)unavailableException, (String)"com.ibm.ws.webcontainer.servlet.StrictLifecycleServlet._service", (String)"176", (Object)this);
                    if (unavailableException.isPermanent()) {
                        this.setPermanentlyUnavailable();
                    } else {
                        int n = unavailableException.getUnavailableSeconds();
                        if (n > 0) {
                            this.setUnavailableUntil(System.currentTimeMillis() + (long)(n * 1000));
                        }
                    }
                    object = unavailableException;
                    Object var8_6 = null;
                    Object object2 = this.syncObject;
                    // MONITORENTER : object2
                    --this.servicingCount;
                    // MONITOREXIT : object2
                    if (this.servicingCount == 0) {
                        this.setState(IDLE_STATE);
                    }
                    break block28;
                }
                catch (IOException iOException2) {
                    FFDCFilter.processException((Throwable)iOException2, (String)"com.ibm.ws.webcontainer.servlet.StrictLifecycleServlet._service", (String)"187", (Object)this);
                    iOException = iOException2;
                    Object var8_7 = null;
                    Object object4 = this.syncObject;
                    // MONITORENTER : object4
                    --this.servicingCount;
                    // MONITOREXIT : object4
                    if (this.servicingCount == 0) {
                        this.setState(IDLE_STATE);
                    }
                    break block28;
                }
                catch (ServletException servletException) {
                    FFDCFilter.processException((Throwable)servletException, (String)"com.ibm.ws.webcontainer.servlet.StrictLifecycleServlet._service", (String)"190", (Object)this);
                    object = servletException;
                    Object var8_8 = null;
                    Object object5 = this.syncObject;
                    // MONITORENTER : object5
                    --this.servicingCount;
                    // MONITOREXIT : object5
                    if (this.servicingCount == 0) {
                        this.setState(IDLE_STATE);
                    }
                    break block28;
                }
                catch (RuntimeException runtimeException) {
                    FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.webcontainer.servlet.StrictLifecycleServlet._service", (String)"1901", (Object)this);
                    throw runtimeException;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.servlet.StrictLifecycleServlet._service", (String)"193", (Object)this);
                    object = new ServletException(throwable);
                    Object var8_9 = null;
                    Object object6 = this.syncObject;
                    // MONITORENTER : object6
                    --this.servicingCount;
                    // MONITOREXIT : object6
                    if (this.servicingCount == 0) {
                        this.setState(IDLE_STATE);
                    }
                }
                Object var8_5 = null;
                Object object2 = this.syncObject;
                // MONITORENTER : object2
                --this.servicingCount;
                // MONITOREXIT : object2
                if (this.servicingCount == 0) {
                    this.setState(IDLE_STATE);
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                Object object7 = this.syncObject;
                // MONITORENTER : object7
                --this.servicingCount;
                // MONITOREXIT : object7
                if (this.servicingCount != 0) throw throwable;
                this.setState(IDLE_STATE);
                throw throwable;
            }
        }
        if (object != null) {
            throw object;
        }
        if (iOException == null) return;
        throw iOException;
    }

    void _destroy() {
        this.setState(DESTROYING_STATE);
        this.doDestroy();
        this.setState(DESTROYED_STATE);
    }

    long getUnavailableUntil() {
        return this._unavailableUntil;
    }

    synchronized void setUnavailableUntil(long l) {
        this.setServicingState(UNAVAILABLE_FOR_SERVICE_STATE);
        this._unavailableUntil = l;
    }

    synchronized void setPermanentlyUnavailable() {
        this.setServicingState(PERMANENTLY_UNAVAILABLE_FOR_SERVICE_STATE);
    }

    synchronized void setAvailable() {
        this.setServicingState(AVAILABLE_FOR_SERVICE_STATE);
        this._unavailableUntil = -1L;
    }

    boolean isIdle() {
        return this.servicingCount == 0;
    }
}

