/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.srp.ISRPConnection;
import com.ibm.ws.webcontainer.srt.IOutputStreamObserver;
import com.ibm.ws.webcontainer.srt.ResponseBuffer;
import com.ibm.ws.webcontainer.srt.WriteBeyondContentLengthException;
import java.io.IOException;
import java.io.Writer;

public class BufferedWriter
extends Writer
implements ResponseBuffer {
    protected Writer out;
    protected char[] buf = new char[0];
    protected int count;
    protected int total;
    protected int limit;
    protected ISRPConnection connection;
    protected int length = -1;
    protected IOutputStreamObserver obs;
    protected boolean _hasWritten;
    protected boolean _hasFlushed;
    protected IOException except;
    protected boolean committed;
    private int bufferSize;
    private static TraceComponent tc = Tr.register((String)(class$com$ibm$ws$webcontainer$srt$BufferedWriter == null ? (class$com$ibm$ws$webcontainer$srt$BufferedWriter = BufferedWriter.class$("com.ibm.ws.webcontainer.srt.BufferedWriter")) : class$com$ibm$ws$webcontainer$srt$BufferedWriter).getName(), (String)"Servlet_Engine");
    private boolean closeOnClose = false;
    private static NLS nls = new NLS("com.ibm.servlet.resources.ServletEngineNLS");
    static /* synthetic */ Class class$com$ibm$ws$webcontainer$srt$BufferedWriter;

    public BufferedWriter(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"Constructor", (Object)String.valueOf(n));
        }
        this.buf = new char[n];
        this.bufferSize = n;
        this._hasWritten = false;
        this._hasFlushed = false;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"Constructor");
        }
    }

    public BufferedWriter() {
        this(1024);
    }

    public void init(Writer writer, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init", (Object)writer);
        }
        this.initNewBuffer(writer, n);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    void initNewBuffer(Writer writer, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initNewBuffer", (Object)new Object[]{writer, new Integer(n)});
        }
        this.out = writer;
        if (this.buf.length != n) {
            this.bufferSize = n;
            this.buf = new char[this.bufferSize];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initNewBuffer");
        }
    }

    public void finish() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"finish");
        }
        if (this.length == -1 && this.total != 0) {
            this.length = this.total;
        }
        this.flush();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"finish");
        }
    }

    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reset");
        }
        this.out = null;
        this.count = 0;
        this.total = 0;
        this.limit = -1;
        this.length = -1;
        this.committed = false;
        this._hasWritten = false;
        this._hasFlushed = false;
        this.connection = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reset");
        }
    }

    public int getTotal() {
        return this.total;
    }

    public void setObserver(IOutputStreamObserver iOutputStreamObserver) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setObserver", (Object)iOutputStreamObserver);
        }
        this.obs = iOutputStreamObserver;
        this.limit = -1;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setObserver");
        }
    }

    public boolean isCommitted() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isCommitted");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isCommitted: " + this.committed));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isCommitted");
        }
        return this.committed;
    }

    protected void check() throws IOException {
        if (this.except != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"check");
            }
            this.flush();
            throw this.except;
        }
    }

    public void write(int n) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"write", (Object)new Integer(n));
        }
        if (!this._hasWritten && this.obs != null) {
            this._hasWritten = true;
            this.obs.alertFirstWrite();
        }
        if (this.limit > -1 && this.total >= this.limit) {
            throw new WriteBeyondContentLengthException();
        }
        if (this.count == this.buf.length) {
            this.connection.setFlushMode(false);
            this.flushChars();
            this.connection.setFlushMode(true);
        }
        this.buf[this.count++] = (char)n;
        ++this.total;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"write");
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"write", (Object)new Object[]{this.buf, new Integer(n), new Integer(n2)});
        }
        if (n2 < 0) {
            Tr.error((TraceComponent)tc, (String)"Illegal.Argument.Trying.to.write.chars");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"write");
            }
            throw new IllegalArgumentException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"total: {0}, length: {1}, limit: {2}, buf.length: {3}, count: {4}", (Object)new Object[]{String.valueOf(this.total), String.valueOf(n2), String.valueOf(this.limit), String.valueOf(this.buf.length), String.valueOf(this.count)});
        }
        if (!this._hasWritten && this.obs != null) {
            this._hasWritten = true;
            this.obs.alertFirstWrite();
        }
        if (this.limit > -1 && this.total + n2 > this.limit) {
            n2 = this.limit - this.total;
            this.except = new WriteBeyondContentLengthException();
        }
        if (n2 >= this.buf.length) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"len >= buf.length");
            }
            this.connection.setFlushMode(false);
            this.flushChars();
            this.total += n2;
            this.writeOut(cArray, n, n2);
            this.out.flush();
            this.connection.setFlushMode(true);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"write");
            }
            this.check();
            return;
        }
        int n3 = this.buf.length - this.count;
        if (n2 > n3) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"len >= avail");
            }
            this.connection.setFlushMode(false);
            this.flushChars();
            this.connection.setFlushMode(true);
        }
        System.arraycopy(cArray, n, this.buf, this.count, n2);
        this.count += n2;
        this.total += n2;
        this.check();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"write");
        }
    }

    public void flush() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"flush");
        }
        this.flushChars();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"flush");
        }
    }

    protected void flushChars() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"flushChars");
        }
        if (!this.committed && !this._hasFlushed && this.obs != null) {
            this._hasFlushed = true;
            this.obs.alertFirstFlush();
        }
        this.committed = true;
        if (this.count > 0) {
            try {
                this.writeOut(this.buf, 0, this.count);
                this.out.flush();
                this.count = 0;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.srt.BufferedWriter.flushChars", (String)"409", (Object)this);
                this.count = 0;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"IOException occurred in flushChars method, observer alerting close.");
                }
                this.obs.alertClose();
                this.obs.alertException();
                throw iOException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"flushChars");
        }
    }

    public void print(String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"print", (Object)string);
        }
        int n = string.length();
        if (this.limit > -1 && this.total + n > this.limit) {
            n = this.limit - this.total;
            this.except = new WriteBeyondContentLengthException();
        }
        int n2 = 0;
        while (n > 0) {
            int n3 = this.buf.length - this.count;
            if (n3 == 0) {
                this.connection.setFlushMode(false);
                this.flushChars();
                this.connection.setFlushMode(true);
                n3 = this.buf.length - this.count;
            }
            if (n3 > n) {
                n3 = n;
            }
            string.getChars(n2, n2 + n3, this.buf, this.count);
            this.count += n3;
            this.total += n3;
            n2 += n3;
            n -= n3;
        }
        this.check();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"print");
        }
    }

    public void close() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"close");
        }
        this.finish();
        try {
            this.obs.alertClose();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.srt.BufferedWriter.close", (String)"397", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"close");
        }
    }

    public void setLimit(int n) {
        this.limit = n;
    }

    public void setConnection(ISRPConnection iSRPConnection) {
        this.connection = iSRPConnection;
    }

    protected void writeOut(char[] cArray, int n, int n2) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeOut", (Object)new Object[]{cArray, new Integer(n), new Integer(n2)});
        }
        try {
            this.out.write(cArray, n, n2);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.srt.BufferedWriter.writeOut", (String)"416", (Object)this);
            this.count = 0;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"IOException occurred in writeOut method, observer alerting close.");
            }
            this.obs.alertClose();
            this.obs.alertException();
            throw iOException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeOut");
        }
    }

    public int getBufferSize() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getBufferSize");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getBufferSize");
        }
        return this.bufferSize;
    }

    public void setBufferSize(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setBufferSize", (Object)new Integer(n));
        }
        if (this.total > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setBufferSize(): illegal state--> already wrote " + this.total + " bytes"));
            }
            throw new IllegalStateException(nls.getString("Cannot.set.buffer.size.after.data", "Can't set buffer size after data has been written to stream"));
        }
        this.initNewBuffer(this.out, n);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setBufferSize");
        }
    }

    public void clearBuffer() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"clearBuffer");
        }
        if (this.isCommitted()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"clearBuffer(): illegal state--> stream is committed ");
            }
            throw new IllegalStateException();
        }
        this.total = 0;
        this.count = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"clearBuffer");
        }
    }

    public void flushBuffer() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"flushBuffer");
        }
        this.flush();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"flushBuffer");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

